/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.text.DecimalFormat;
import java.util.Collection;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.ValidadorMaximoDigitosInteiros;

public class Valor
extends Informacao {
    protected int maximoDigitosParteInteira = ConstantesGlobais.TAMANHO_VALOR - ConstantesGlobais.TAMANHO_VALOR_PARTE_DECIMAL;
    protected String msgErroEstourodigitos = "O valor m\u00e1ximo para o tipo do campo foi excedido.";
    protected byte severidadeValidacaoMaximoDigitos = (byte)3;
    protected Long conteudo = new Long(0L);
    protected int casasDecimais = ConstantesGlobais.TAMANHO_VALOR_PARTE_DECIMAL;
    protected boolean porcentagem = false;
    private DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance(ConstantesGlobais.LOCALIDADE);
    private boolean campoCalculado = false;
    public static int ARREDONDA = 1;
    public static int TRUNCA = 0;
    private int tratamentocasasDecimais = TRUNCA;
    private int pisoArredondamento = 5;

    public Valor() {
        this.addValidador(new ValidadorMaximoDigitosInteiros(this.severidadeValidacaoMaximoDigitos));
    }

    public Valor(Long l) {
        this(l.toString());
    }

    public Valor(String string) {
        String string2 = "";
        if (string.lastIndexOf(44) != -1) {
            string2 = string.substring(string.lastIndexOf(44) + 1, string.length());
        } else if (string.lastIndexOf(46) != -1 && string.indexOf(46) == string.lastIndexOf(46)) {
            string = string.replaceAll("[.]", ",");
            string2 = string.substring(string.lastIndexOf(44) + 1, string.length());
        }
        if (string2.length() > 0) {
            this.setCasasDecimais(string2.length());
            this.setConteudo(string);
        } else {
            this.setCasasDecimais(0);
            this.setConteudo(string);
        }
        this.addValidador(new ValidadorMaximoDigitosInteiros(this.severidadeValidacaoMaximoDigitos));
    }

    public Valor(ObjetoNegocio objetoNegocio, String string) {
        super(objetoNegocio, string);
        this.addValidador(new ValidadorMaximoDigitosInteiros(this.severidadeValidacaoMaximoDigitos));
    }

    public Valor(ObjetoNegocio objetoNegocio, String string, int n, int n2) {
        super(objetoNegocio, string);
        this.addValidador(new ValidadorMaximoDigitosInteiros(this.severidadeValidacaoMaximoDigitos));
        this.setMaximoDigitosParteInteira(n);
        this.setCasasDecimais(n2);
    }

    public Valor(ObjetoNegocio objetoNegocio, String string, boolean bl) {
        super(objetoNegocio, string);
        this.setReadOnly(bl);
        this.addValidador(new ValidadorMaximoDigitosInteiros(this.severidadeValidacaoMaximoDigitos));
    }

    public void converte(Valor valor) {
        this.converteQtdCasasDecimais(valor.getCasasDecimais());
        this.setMaximoDigitosParteInteira(valor.getMaximoDigitosParteInteira());
        this.setTratamentocasasDecimais(valor.getTratamentocasasDecimais());
    }

    public String getParteInteira() {
        long l = this.conteudo;
        long l2 = 1L;
        int n = 0;
        while (n < this.casasDecimais) {
            l2 *= 10L;
            ++n;
        }
        return String.valueOf(Math.abs(l / l2));
    }

    public Long getParteInteiraAsLong() {
        return new Long(this.getParteInteira());
    }

    public String getParteDecimal() {
        if (this.casasDecimais == 0) {
            return "";
        }
        long l = this.conteudo;
        long l2 = 1L;
        String string = "";
        int n = 0;
        while (n < this.casasDecimais) {
            l2 *= 10L;
            string = String.valueOf(string) + "0";
            ++n;
        }
        this.df.applyLocalizedPattern(string);
        return this.df.format(Math.abs(l % l2));
    }

    public String getConteudoFormatado() {
        this.df.applyLocalizedPattern("###.###.##0");
        String string = "";
        String string2 = this.df.format(new Long(this.getParteInteira()));
        String string3 = this.getParteDecimal();
        if (this.conteudo < 0L) {
            string = String.valueOf(string) + "-";
        }
        if (string3.trim().length() == 0) {
            return String.valueOf(string) + string2;
        }
        return String.valueOf(string) + string2 + "," + string3;
    }

    public int getCasasDecimais() {
        return this.casasDecimais;
    }

    public void setCasasDecimais(int n) {
        this.casasDecimais = n;
    }

    public Long getConteudo() {
        return this.conteudo;
    }

    public void setConteudo(Long l) {
        String string = this.asString();
        this.clearRetornosValidacoes();
        this.conteudo = l;
        if (!this.inicializouUltimoConteudoValido) {
            this.inicializouUltimoConteudoValido = true;
            this.setUltimoConteudoValido(this.asString());
        }
        if (this.isVazio()) {
            this.setUltimoConteudoValido("");
        }
        this.disparaObservadores(string);
    }

    public Long getConteudoAbsoluto() {
        return new Long(Math.abs(this.conteudo));
    }

    public boolean isPorcentagem() {
        return this.porcentagem;
    }

    public void setPorcentagem(boolean bl) {
        this.porcentagem = bl;
    }

    public void setConteudo(String string) {
        String string2 = "";
        if (string.lastIndexOf(44) == -1) {
            int n = 0;
            while (n < this.getCasasDecimais()) {
                string2 = String.valueOf(string2) + "0";
                ++n;
            }
        } else {
            String string3 = string.substring(string.lastIndexOf(44) + 1, string.length());
            int n = string3.length();
            while (n < this.getCasasDecimais()) {
                string2 = String.valueOf(string2) + "0";
                ++n;
            }
        }
        String string4 = string.replaceAll("[.,]", "");
        Long l = null;
        try {
            l = new Long(String.valueOf(string4) + string2);
        }
        catch (Exception exception) {
            l = new Long(0L);
        }
        this.setConteudo(l);
    }

    public void setConteudo(Valor valor) {
        Valor valor2 = new Valor(valor.asString());
        valor2.converte(this);
        this.setConteudo(valor2.getConteudo());
    }

    public void clear() {
        this.setConteudo(new Long(0L));
    }

    public boolean isVazio() {
        return this.conteudo == 0L;
    }

    public void converteQtdCasasDecimais(int n) {
        if (this.getCasasDecimais() != n) {
            long l = this.conteudo;
            long l2 = 1L;
            int n2 = Math.abs(this.getCasasDecimais() - n);
            int n3 = 0;
            while (n3 < n2) {
                l2 *= 10L;
                ++n3;
            }
            l = this.getCasasDecimais() < n ? (l *= l2) : (l /= l2);
            this.setCasasDecimais(n);
            this.setConteudo(new Long(l));
        }
    }

    public int compareTo(Object object) {
        if (!(object instanceof Valor)) {
            return -1;
        }
        int n = 0;
        Valor valor = (Valor)object;
        int n2 = valor.getCasasDecimais();
        int n3 = this.getCasasDecimais();
        if (valor.getCasasDecimais() > this.getCasasDecimais()) {
            this.converteQtdCasasDecimais(valor.getCasasDecimais());
        } else {
            valor.converteQtdCasasDecimais(this.getCasasDecimais());
        }
        if (this.conteudo > valor.getConteudo()) {
            n = 1;
        } else if (this.conteudo < valor.getConteudo()) {
            n = -1;
        }
        this.converteQtdCasasDecimais(n3);
        valor.converteQtdCasasDecimais(n2);
        return n;
    }

    public void arredonda(int n, int n2) {
        this.getParteInteira();
        if (this.getParteDecimal().length() > n) {
            int n3;
            if (n > 0) {
                this.getParteDecimal().substring(0, n - 1);
            }
            if ((n3 = Integer.parseInt(this.getParteDecimal().substring(n, n + 1))) >= n2 && n3 <= 9) {
                Valor valor = new Valor();
                valor.setCasasDecimais(n);
                valor.setConteudo(new Long(1L));
                this.setConteudo(this.soma(valor));
            }
            this.converteQtdCasasDecimais(n);
        }
    }

    private Valor soma(Valor valor) {
        Valor valor2 = new Valor();
        int n = valor.getCasasDecimais();
        int n2 = this.getCasasDecimais();
        if (valor.getCasasDecimais() > this.getCasasDecimais()) {
            this.converteQtdCasasDecimais(valor.getCasasDecimais());
        } else {
            valor.converteQtdCasasDecimais(this.getCasasDecimais());
        }
        valor2.setCasasDecimais(this.getCasasDecimais());
        long l = this.getConteudo() + valor.getConteudo();
        valor2.setConteudo(new Long(l));
        this.converteQtdCasasDecimais(n2);
        valor.converteQtdCasasDecimais(n);
        if (this.getTratamentocasasDecimais() == ARREDONDA) {
            valor2.arredonda(this.getCasasDecimais(), this.getPisoArredondamento());
        }
        return valor2;
    }

    private Valor soma(Long l) {
        Valor valor = new Valor();
        valor.converte(this);
        valor.setConteudo(l);
        return this.soma(valor);
    }

    private Valor soma(String string) {
        Valor valor = new Valor();
        valor.converte(this);
        valor.setConteudo(string);
        return this.soma(valor);
    }

    private Valor subtrai(Valor valor) {
        Valor valor2 = new Valor();
        int n = valor.getCasasDecimais();
        int n2 = this.getCasasDecimais();
        if (valor.getCasasDecimais() > this.getCasasDecimais()) {
            this.converteQtdCasasDecimais(valor.getCasasDecimais());
        } else {
            valor.converteQtdCasasDecimais(this.getCasasDecimais());
        }
        valor2.setCasasDecimais(this.getCasasDecimais());
        long l = this.getConteudo() - valor.getConteudo();
        valor2.setConteudo(new Long(l));
        this.converteQtdCasasDecimais(n2);
        valor.converteQtdCasasDecimais(n);
        if (this.getTratamentocasasDecimais() == ARREDONDA) {
            valor2.arredonda(this.getCasasDecimais(), this.getPisoArredondamento());
        }
        return valor2;
    }

    private Valor subtrai(Long l) {
        Valor valor = new Valor();
        valor.converte(this);
        valor.setConteudo(l);
        return this.subtrai(valor);
    }

    private Valor subtrai(String string) {
        Valor valor = new Valor();
        valor.converte(this);
        valor.setConteudo(string);
        return this.subtrai(valor);
    }

    private Valor multiplica(Valor valor) {
        Valor valor2 = new Valor();
        long l = this.getConteudo() * valor.getConteudo();
        valor2.setCasasDecimais(this.getCasasDecimais() + valor.getCasasDecimais());
        valor2.setConteudo(new Long(l));
        if (this.getTratamentocasasDecimais() == ARREDONDA) {
            valor2.arredonda(this.getCasasDecimais(), this.getPisoArredondamento());
        } else {
            valor2.converteQtdCasasDecimais(this.getCasasDecimais());
        }
        return valor2;
    }

    private Valor multiplica(Long l) {
        Valor valor = new Valor();
        valor.converte(this);
        valor.setConteudo(l);
        return this.multiplica(valor);
    }

    private Valor divide(Valor valor) {
        Valor valor2 = new Valor();
        int n = valor.getCasasDecimais();
        int n2 = this.getCasasDecimais();
        if (valor.getCasasDecimais() > this.getCasasDecimais()) {
            this.converteQtdCasasDecimais(valor.getCasasDecimais());
        } else {
            valor.converteQtdCasasDecimais(this.getCasasDecimais());
        }
        long l = 0L;
        if (valor.getConteudo() != 0L) {
            long l2;
            long l3 = this.getConteudo();
            if (l3 < (l2 = valor.getConteudo().longValue())) {
                valor2.converteQtdCasasDecimais(this.getCasasDecimais() + 2);
                l = this.efetuaDivisaoComDividendoMaior(l3, l2, this.getCasasDecimais() + 2);
            } else {
                valor2.converteQtdCasasDecimais(this.getCasasDecimais());
                l = this.efetuaDivisaoComDividendoMenor(l3, l2);
            }
        }
        valor2.setConteudo(new Long(l));
        this.converteQtdCasasDecimais(n2);
        valor.converteQtdCasasDecimais(n);
        if (this.getTratamentocasasDecimais() == ARREDONDA) {
            valor2.arredonda(this.getCasasDecimais(), this.getPisoArredondamento());
        } else {
            valor2.converteQtdCasasDecimais(this.getCasasDecimais());
        }
        return valor2;
    }

    protected long efetuaDivisaoComDividendoMenor(long l, long l2) {
        long l3 = 1L;
        int n = 0;
        while (n < this.getCasasDecimais()) {
            l3 *= 10L;
            ++n;
        }
        return (l *= l3) / l2;
    }

    protected long efetuaDivisaoComDividendoMaior(long l, long l2, int n) {
        long l3 = 0L;
        long l4 = l;
        int n2 = n - 1;
        int n3 = 1;
        while (n3 <= n) {
            l4 = l * this.elevaPotencia(10L, n3);
            l3 = l4 / l2 * this.elevaPotencia(10L, n2);
            l4 %= l2;
            --n2;
            ++n3;
        }
        return l3;
    }

    protected long elevaPotencia(long l, int n) {
        long l2 = 1L;
        int n2 = 1;
        while (n2 <= n) {
            l2 *= l;
            ++n2;
        }
        return l2;
    }

    private Valor divide(Long l) {
        Valor valor = new Valor();
        valor.converte(this);
        valor.setConteudo(l);
        return this.divide(valor);
    }

    private Valor resto(Valor valor) {
        Valor valor2 = new Valor();
        int n = valor.getCasasDecimais();
        int n2 = this.getCasasDecimais();
        if (valor.getCasasDecimais() > this.getCasasDecimais()) {
            this.converteQtdCasasDecimais(valor.getCasasDecimais());
        } else {
            valor.converteQtdCasasDecimais(this.getCasasDecimais());
        }
        valor2.setCasasDecimais(this.getCasasDecimais());
        long l = 0L;
        if (valor.getConteudo() != 0L) {
            l = this.getConteudo();
            l %= valor.getConteudo().longValue();
        }
        valor2.setConteudo(new Long(l));
        this.converteQtdCasasDecimais(n2);
        valor.converteQtdCasasDecimais(n);
        if (this.getTratamentocasasDecimais() == ARREDONDA) {
            valor2.arredonda(this.getCasasDecimais(), this.getPisoArredondamento());
        }
        return valor2;
    }

    private boolean isMaior(Valor valor) {
        return this.compareTo(valor) == 1;
    }

    private boolean isMaiorOuIgual(Valor valor) {
        return this.compareTo(valor) == 1 || this.compareTo(valor) == 0;
    }

    private boolean isMenor(Valor valor) {
        return this.compareTo(valor) == -1;
    }

    public String asString() {
        String string = "";
        if (this.conteudo < 0L) {
            string = String.valueOf(string) + "-";
        }
        String string2 = this.getParteInteira();
        String string3 = this.getParteDecimal();
        if (!string3.trim().equals("")) {
            string3 = "," + string3;
        }
        return String.valueOf(string) + string2 + string3;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    private boolean isMenorOuIgual(Valor valor) {
        return this.compareTo(valor) == -1 || this.compareTo(valor) == 0;
    }

    public Valor operacao(char c, String string) {
        Valor valor = new Valor(string);
        valor.converte(this);
        return this.operacao(c, valor);
    }

    public Valor operacao(char c, Valor valor) {
        Valor valor2 = null;
        valor.setObservadoresAtivos(false);
        valor.setValidadoresAtivos(false);
        switch (c) {
            case '+': {
                valor2 = this.soma(valor);
                break;
            }
            case '-': {
                valor2 = this.subtrai(valor);
                break;
            }
            case '*': {
                valor2 = this.multiplica(valor);
                break;
            }
            case '/': {
                valor2 = this.divide(valor);
                break;
            }
            case '%': {
                valor2 = this.resto(valor);
                break;
            }
            default: {
                throw new IllegalArgumentException("Sinal de Opera\u00e7\u00e3o" + c + " inv\u00e1lido!!!");
            }
        }
        valor.setObservadoresAtivos(true);
        valor.setValidadoresAtivos(true);
        return valor2;
    }

    public boolean comparacao(String string, Valor valor) {
        boolean bl = false;
        this.setObservadoresAtivos(false);
        this.setValidadoresAtivos(false);
        valor.setObservadoresAtivos(false);
        valor.setValidadoresAtivos(false);
        if (string.equals(">")) {
            bl = this.isMaior(valor);
        } else if (string.equals(">=")) {
            bl = this.isMaiorOuIgual(valor);
        } else if (string.equals("<")) {
            bl = this.isMenor(valor);
        } else if (string.equals("<=")) {
            bl = this.isMenorOuIgual(valor);
        } else if (string.equals("=")) {
            bl = this.equals(valor);
        } else if (string.equals("!=") || string.equals("<>")) {
            bl = !this.equals(valor);
        }
        this.setObservadoresAtivos(true);
        this.setValidadoresAtivos(true);
        this.setValidadoresAtivos(true);
        valor.setObservadoresAtivos(true);
        valor.setValidadoresAtivos(true);
        return bl;
    }

    public boolean comparacao(String string, String string2) {
        Valor valor = new Valor(string2);
        return this.comparacao(string, valor);
    }

    public void append(char c, Valor valor) {
        Valor valor2 = this.operacao(c, valor);
        this.setConteudo(valor2);
    }

    public void append(char c, String string) {
        this.setConteudo(this.operacao(c, string));
    }

    public String asTxt() {
        String string = "";
        if (this.conteudo < 0L) {
            string = String.valueOf(string) + "-";
        }
        return String.valueOf(string) + this.getParteInteira() + this.getParteDecimal();
    }

    public Valor getValorAbsoluto() {
        Valor valor = new Valor();
        valor.setCasasDecimais(this.getCasasDecimais());
        valor.setConteudo(new Long(Math.abs(this.conteudo)));
        return valor;
    }

    public static void main(String[] stringArray) {
        Valor valor = new Valor("23,55");
        Valor valor2 = new Valor("100,00");
        valor.setTratamentocasasDecimais(ARREDONDA);
        System.out.println("r->" + valor.operacao('/', valor2).getConteudoFormatado());
    }

    public static Valor soma(Collection collection, int n) {
        Valor valor = new Valor();
        valor.setCasasDecimais(n);
        for (Valor valor2 : collection) {
            valor.setConteudo(valor.soma(valor2));
        }
        return valor;
    }

    public boolean isCampoCalculado() {
        return this.campoCalculado;
    }

    public void setCampoCalculado(boolean bl) {
        this.campoCalculado = bl;
    }

    public int getMaximoDigitosParteInteira() {
        return this.maximoDigitosParteInteira;
    }

    public void setMaximoDigitosParteInteira(int n) {
        this.maximoDigitosParteInteira = n;
    }

    public String getMsgErroEstourodigitos() {
        return this.msgErroEstourodigitos;
    }

    public void setMsgErroEstourodigitos(String string) {
        this.msgErroEstourodigitos = string;
    }

    public byte getSeveridadeValidacaoMaximoDigitos() {
        return this.severidadeValidacaoMaximoDigitos;
    }

    public void setSeveridadeValidacaoMaximoDigitos(byte by) {
        this.severidadeValidacaoMaximoDigitos = by;
    }

    public int getTratamentocasasDecimais() {
        return this.tratamentocasasDecimais;
    }

    public void setTratamentocasasDecimais(int n) {
        this.tratamentocasasDecimais = n;
    }

    public int getPisoArredondamento() {
        return this.pisoArredondamento;
    }

    public void setPisoArredondamento(int n) {
        this.pisoArredondamento = n;
    }
}

