/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.contribuinte;

import java.util.List;
import java.util.Vector;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.contribuinte.ObservadorCEPMunicipio;
import serpro.ppgd.irpf.contribuinte.ValidadorCampoEndereco;
import serpro.ppgd.irpf.contribuinte.ValidadorCepMunicipio;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CEP;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCEP;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorData;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNIT;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorTituloEleitor;

public class Contribuinte
extends ObjetoNegocio {
    public static final String CODIGO_NATUREZA_OCUPACAO_CAPITALISTA = "13";
    public static final String CODIGO_NATUREZA_OCUPACAO_APOSENTADO = "61";
    public static final String CODIGO_NATUREZA_OCUPACAO_APOSENTADO_PORTADOR_MOLESTIA = "62";
    public static final String CODIGO_NATUREZA_OCUPACAO_PENSAO_ALIMENTICIA_JUDICIAL = "71";
    public static final String CODIGO_NATUREZA_OCUPACAO_BOLSISTA = "72";
    public static final String CODIGO_NATUREZA_ESPOLIO = "81";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private Data dataNascimento = new Data(this, "Data de Nascimento");
    private Alfa tituloEleitor = new Alfa(this, "T\u00edtulo de Eleitor", 10);
    private Alfa exterior = new Alfa(this, "Exterior?", 2);
    private Codigo tipoLogradouro = new Codigo(this, "Tipo de Logradouro", CadastroTabelasIRPF.recuperarTiposLogradouro());
    private Alfa logradouro = new Alfa(this, "Logradouro", 40);
    private Alfa logradouroExt = new Alfa(this, "Logradouro", 40);
    private Alfa numero = new Alfa(this, "N\u00famero", 6);
    private Alfa numeroExt = new Alfa(this, "N\u00famero", 6);
    private Alfa complemento = new Alfa(this, "Complemento", 21);
    private Alfa complementoExt = new Alfa(this, "Complemento", 21);
    private Alfa bairro = new Alfa(this, "Bairro", 19);
    private Alfa bairroExt = new Alfa(this, "Bairro", 19);
    private Codigo pais = new Codigo(this, "Pa\u00eds", CadastroTabelasIRPF.recuperarPaises());
    private Codigo codigoExterior = new Codigo(this, "Cod. EX", CadastroTabelasIRPF.recuperarRepresentacoes());
    private Codigo uf = new Codigo(this, "UF", CadastroTabelasIRPF.recuperarUFs(1));
    private Codigo municipio = new Codigo(this, "Munic\u00edpio", new Vector());
    private Alfa cidade = new Alfa(this, "Cidade", 40);
    private CEP cep = new CEP(this, "CEP");
    private CEP cepExt = new CEP(this, "ZIP");
    private Alfa email = new Alfa(this, "Email", 90);
    private Alfa ddd = new Alfa(this, "DDD", 2);
    private Alfa telefone = new Alfa(this, "Telefone", 9);
    private Alfa dddCelular = new Alfa(this, "DDD Celular", 2);
    private Alfa celular = new Alfa(this, "Telefone Celular", 9);
    private CPF cpfConjuge = new CPF(this, "CPF do C\u00f4njuge");
    private Alfa NitPisPasep = new Alfa(this, "NIT/PIS/PASEP de Pessoa F\u00edsica no exterior");
    private Codigo naturezaOcupacao = new Codigo(this, "Natureza da Ocup.", CadastroTabelasIRPF.recuperarNaturezasOcupacao());
    private Codigo ocupacaoPrincipal = new Codigo(this, "Ocup. Principal", CadastroTabelasIRPF.recuperarOcupacoesPrincipal());
    private Logico doencaDeficiencia = new Logico(this, "Portador de Mol\u00e9stia Grave ou Defici\u00eancia");
    private Alfa registroProfissional = new Alfa(this, "Registro profissional");

    public Contribuinte(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.getPais().setConteudo("105");
        this.getPais().setColunaFiltro(1);
        this.getExterior().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object2, Object object3) {
                if (Contribuinte.this.getExterior().asString().equals(Logico.NAO)) {
                    Contribuinte.this.pais.setConteudo("105");
                    Contribuinte.this.ddd.setMaximoCaracteres(2);
                } else {
                    Contribuinte.this.pais.clear();
                    Contribuinte.this.ddd.setMaximoCaracteres(4);
                }
            }
        });
        this.getExterior().setConteudo(Logico.NAO);
        this.getPais().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getExterior().asString().equals(Logico.SIM) && Contribuinte.this.getPais().isVazio()) {
                    return new RetornoValidacao(tab.msg("hint_pais"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getDdd().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getExterior().asString().equals(Logico.NAO) && Contribuinte.this.getDdd().getConteudoFormatado().trim().length() == 1) {
                    return new RetornoValidacao(tab.msg("ddd_um_digito"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getDddCelular().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getExterior().asString().equals(Logico.NAO) && Contribuinte.this.getDddCelular().getConteudoFormatado().trim().length() == 1) {
                    return new RetornoValidacao(tab.msg("ddd_um_digito"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getUf().setColunaFiltro(1);
        this.getUf().addValidador(new ValidadorNaoNulo(3, this.tab.msg("hint_uf_invalida")){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getExterior().asString().equals("1")) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getUf().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object2, Object object3) {
                if (Contribuinte.this.uf.isVazio() || Contribuinte.this.uf.asString().equals("EX")) {
                    Contribuinte.this.municipio.setColecaoElementoTabela(new Vector());
                } else {
                    String string2 = Contribuinte.this.uf.getConteudoAtual(0);
                    Contribuinte.this.municipio.setColecaoElementoTabela(CadastroTabelasIRPF.recuperarMunicipios(string2, 1));
                }
            }
        });
        this.getDataNascimento().addValidador(new ValidadorNaoNulo(3));
        this.getDataNascimento().addValidador(new ValidadorData(3));
        this.getTituloEleitor().addValidador(new ValidadorNaoNulo(2, "N\u00famero do T\u00edtulo Eleitoral em branco. Informe-o, se houver."));
        this.getTituloEleitor().addValidador(new ValidadorTituloEleitor(2));
        this.getTipoLogradouro().setColunaFiltro(1);
        this.getTipoLogradouro().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getExterior().getConteudoFormatado().equals(Logico.SIM)) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getLogradouro().addValidador(new ValidadorCampoEndereco(3));
        this.getLogradouroExt().addValidador(new ValidadorCampoEndereco(3));
        this.getNumero().addValidador(new ValidadorCampoEndereco(3));
        this.getNumeroExt().addValidador(new ValidadorCampoEndereco(3));
        this.getComplemento().addValidador(new ValidadorCampoEndereco(3));
        this.getBairro().addValidador(new ValidadorCampoEndereco(3));
        this.getMunicipio().addValidador(new ValidadorCampoEndereco(3));
        this.getMunicipio().addObservador(new ObservadorCEPMunicipio(this.municipio, this.uf, this.pais, this.cep));
        this.getMunicipio().setColunaFiltro(1);
        this.getMunicipio().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.getConteudoFormatado().equals(Logico.SIM)) {
                    return null;
                }
                this.setMensagemValidacao(tab.msg("municipio"));
                RetornoValidacao retornoValidacao = super.validarImplementado();
                return retornoValidacao;
            }
        });
        this.getCidade().addValidador(new ValidadorCampoEndereco(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.getConteudoFormatado().equals(Logico.NAO)) {
                    return null;
                }
                RetornoValidacao retornoValidacao = super.validarImplementado();
                return retornoValidacao;
            }
        });
        this.getCidade().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.getConteudoFormatado().equals(Logico.NAO)) {
                    return null;
                }
                String string = "Endere\u00e7o  inv\u00e1lido. Falta nome da cidade";
                RetornoValidacao retornoValidacao = super.validarImplementado();
                if (retornoValidacao != null) {
                    retornoValidacao.setMensagemValidacao(string);
                }
                return retornoValidacao;
            }
        });
        this.getCodigoExterior().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.getConteudoFormatado().equals(Logico.NAO)) {
                    return null;
                }
                String string = "C\u00f3digo do Exterior em branco/inv\u00e1lido.";
                RetornoValidacao retornoValidacao = super.validarImplementado();
                if (retornoValidacao != null) {
                    retornoValidacao.setMensagemValidacao(string);
                }
                return retornoValidacao;
            }
        });
        this.getCep().addValidador(new ValidadorNaoNulo(3, this.tab.msg("hint_cep")){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.getConteudoFormatado().equals(Logico.SIM)) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getCep().addValidador(new ValidadorCepMunicipio(2, this.pais, this.municipio, this.cep, "CEP n\u00e3o pertence ao munic\u00edpio"){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.getConteudoFormatado().equals(Logico.SIM)) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getCep().addValidador(new ValidadorCEP(3){

            public RetornoValidacao validarImplementado() {
                if (!Contribuinte.this.pais.getConteudoFormatado().equals("105")) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getNaturezaOcupacao().setColunaFiltro(1);
        this.getNaturezaOcupacao().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.naturezaOcupacao.isVazio() || Contribuinte.this.naturezaOcupacao.getIndiceElementoTabela() == -1) {
                    return new RetornoValidacao(tab.msg("natureza_ocup"), 3);
                }
                return super.validarImplementado();
            }
        });
        this.getNaturezaOcupacao().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object2, Object object3) {
                Contribuinte.this.ocupacaoPrincipal.setHabilitado(true);
                String string2 = Contribuinte.this.naturezaOcupacao.asString();
                if (string2.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_CAPITALISTA) || string2.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO) || string2.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO_PORTADOR_MOLESTIA) || string2.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_PENSAO_ALIMENTICIA_JUDICIAL) || string2.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_BOLSISTA)) {
                    Contribuinte.this.ocupacaoPrincipal.sinalizaValidoEdit();
                } else if (string2.equals(Contribuinte.CODIGO_NATUREZA_ESPOLIO)) {
                    Contribuinte.this.ocupacaoPrincipal.clear();
                    Contribuinte.this.ocupacaoPrincipal.setHabilitado(false);
                }
            }
        });
        this.getNaturezaOcupacao().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object2, Object object3) {
                if (Contribuinte.this.getNaturezaOcupacao().getConteudoFormatado().trim().length() == 1) {
                    String string2 = Contribuinte.this.getNaturezaOcupacao().getConteudoFormatado().trim();
                    string2 = "0" + string2;
                    Contribuinte.this.getNaturezaOcupacao().setConteudo(string2);
                }
            }
        });
        this.getOcupacaoPrincipal().setColunaFiltro(1);
        this.getOcupacaoPrincipal().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                String string = Contribuinte.this.naturezaOcupacao.asString();
                if (string.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_CAPITALISTA) || string.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO) || string.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO_PORTADOR_MOLESTIA) || string.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_PENSAO_ALIMENTICIA_JUDICIAL) || string.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_BOLSISTA) || string.equals(Contribuinte.CODIGO_NATUREZA_ESPOLIO)) {
                    return null;
                }
                if (Contribuinte.this.ocupacaoPrincipal.isVazio() || Contribuinte.this.ocupacaoPrincipal.getIndiceElementoTabela() == -1) {
                    return new RetornoValidacao(tab.msg("ocup_principal"), 3);
                }
                return null;
            }
        });
        this.getNaturezaOcupacao().addValidador(new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                String string;
                if (!Contribuinte.this.getOcupacaoPrincipal().isVazio() && ((string = Contribuinte.this.naturezaOcupacao.asString()).equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_CAPITALISTA) || string.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO) || string.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO_PORTADOR_MOLESTIA) || string.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_PENSAO_ALIMENTICIA_JUDICIAL) || string.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_BOLSISTA))) {
                    return new RetornoValidacao(tab.msg("ocup_desnecessaria"), 2);
                }
                return null;
            }
        });
        this.getOcupacaoPrincipal().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object2, Object object3) {
                if (Contribuinte.this.getOcupacaoPrincipal().getConteudoFormatado().trim().length() == 1) {
                    String string2 = Contribuinte.this.getOcupacaoPrincipal().getConteudoFormatado().trim();
                    string2 = "0" + string2;
                    Contribuinte.this.getOcupacaoPrincipal().setConteudo(string2);
                }
            }
        });
        this.getNumeroReciboDecAnterior().addValidador(new ValidadorDefault(2){

            public RetornoValidacao validarImplementado() {
                if (Validador.validarNrRecibo(this.getInformacao().asString())) {
                    return null;
                }
                return new RetornoValidacao(tab.msg("num_recibo_ano_anterior_invalido", new String[]{ConstantesGlobais.EXERCICIO_ANTERIOR}), this.getSeveridade());
            }
        });
        this.getDeclaracaoRetificadora().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object2, Object object3) {
                String string2 = (String)object2;
                String string3 = (String)object3;
                if (Logico.SIM.equals(string3) && Logico.NAO.equals(string2)) {
                    Contribuinte.this.getNumReciboDecRetif().clear();
                    Contribuinte.this.getNumeroReciboDecAnterior().clear();
                } else if (Logico.NAO.equals(string3) && Logico.SIM.equals(string2)) {
                    Contribuinte.this.getNumReciboDecRetif().clear();
                    Contribuinte.this.getNumeroReciboDecAnterior().clear();
                }
            }
        });
        this.getLogradouro().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.getConteudoFormatado().equals(Logico.NAO) && Contribuinte.this.logradouro.isVazio() && Contribuinte.this.complemento.isVazio()) {
                    return new RetornoValidacao(tab.msg("endereco_invalido"), 3);
                }
                return null;
            }
        });
        this.getLogradouroExt().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (!Contribuinte.this.exterior.getConteudoFormatado().equals(Logico.NAO) && Contribuinte.this.logradouroExt.isVazio() && Contribuinte.this.complementoExt.isVazio()) {
                    return new RetornoValidacao(tab.msg("endereco_invalido"), 3);
                }
                return null;
            }
        });
        this.getUf().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.getConteudoFormatado().equals(Logico.SIM)) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        ValidadorCPF validadorCPF = new ValidadorCPF(3);
        validadorCPF.setMensagemValidacao(this.tab.msg("conjuge_cpf_invalido"));
        this.getCpfConjuge().addValidador(validadorCPF);
        this.getCpfConjuge().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getCpfConjuge().asString().equals(Contribuinte.this.identificadorDeclaracao.getCpf().asString())) {
                    return new RetornoValidacao(tab.msg("conjuge_cpf"), 3);
                }
                return null;
            }
        });
        this.getNitPisPasep().addValidador(new ValidadorNIT(3, this.tab.msg("contribuinte_NIT")){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getNitPisPasep().asString().trim() != "") {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.setFicha("Identifica\u00e7\u00e3o do Contribuinte");
    }

    public Alfa getRegistroProfissional() {
        return this.registroProfissional;
    }

    public Alfa getNitPisPasep() {
        return this.NitPisPasep;
    }

    public CPF getCpfConjuge() {
        return this.cpfConjuge;
    }

    public Codigo getCodigoExterior() {
        return this.codigoExterior;
    }

    public Codigo getPais() {
        return this.pais;
    }

    public Alfa getBairro() {
        return this.bairro;
    }

    public CEP getCep() {
        return this.cep;
    }

    public Alfa getComplemento() {
        return this.complemento;
    }

    public Data getDataNascimento() {
        return this.dataNascimento;
    }

    public Alfa getDdd() {
        return this.ddd;
    }

    public Alfa getDddCelular() {
        return this.dddCelular;
    }

    public Alfa getDeclaracaoRetificadora() {
        return this.identificadorDeclaracao.getDeclaracaoRetificadora();
    }

    public Alfa getEnderecoDiferente() {
        return this.identificadorDeclaracao.getEnderecoDiferente();
    }

    public Alfa getExterior() {
        return this.exterior;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public Codigo getNaturezaOcupacao() {
        return this.naturezaOcupacao;
    }

    public Alfa getNumero() {
        return this.numero;
    }

    public Alfa getNumeroReciboDecAnterior() {
        return this.identificadorDeclaracao.getNumeroReciboDecAnterior();
    }

    public Codigo getOcupacaoPrincipal() {
        return this.ocupacaoPrincipal;
    }

    public Alfa getEmail() {
        return this.email;
    }

    public Alfa getTelefone() {
        return this.telefone;
    }

    public Alfa getCelular() {
        return this.celular;
    }

    public Codigo getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public Alfa getTituloEleitor() {
        return this.tituloEleitor;
    }

    public Alfa getLogradouro() {
        return this.logradouro;
    }

    public Codigo getUf() {
        return this.uf;
    }

    protected List recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        list.add(this.identificadorDeclaracao.getCpf());
        list.add(this.identificadorDeclaracao.getNome());
        list.add(this.identificadorDeclaracao.getNumeroReciboDecAnterior());
        list.add(this.identificadorDeclaracao.getDeclaracaoRetificadora());
        list.add(this.identificadorDeclaracao.getNumReciboDecRetif());
        list.add(this.identificadorDeclaracao.getEnderecoDiferente());
        return list;
    }

    public Alfa getCidade() {
        return this.cidade;
    }

    public Alfa getNumReciboDecRetif() {
        return this.identificadorDeclaracao.getNumReciboDecRetif();
    }

    public void setLogradouroExt(Alfa alfa) {
        this.logradouroExt = alfa;
    }

    public Alfa getLogradouroExt() {
        return this.logradouroExt;
    }

    public void setNumeroExt(Alfa alfa) {
        this.numeroExt = alfa;
    }

    public Alfa getNumeroExt() {
        return this.numeroExt;
    }

    public void setComplementoExt(Alfa alfa) {
        this.complementoExt = alfa;
    }

    public Alfa getComplementoExt() {
        return this.complementoExt;
    }

    public void setBairroExt(Alfa alfa) {
        this.bairroExt = alfa;
    }

    public Alfa getBairroExt() {
        return this.bairroExt;
    }

    public void setCepExt(CEP cEP) {
        this.cepExt = cEP;
    }

    public CEP getCepExt() {
        return this.cepExt;
    }

    public Logico getDoencaDeficiencia() {
        return this.doencaDeficiencia;
    }
}

