/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalScrollButton;

class PlasticArrowButton
extends MetalScrollButton {
    private Color shadowColor = UIManager.getColor("ScrollBar.darkShadow");
    private Color highlightColor = UIManager.getColor("ScrollBar.highlight");
    protected boolean isFreeStanding;

    public PlasticArrowButton(int n, int n2, boolean bl) {
        super(n, n2, bl);
        this.isFreeStanding = bl;
    }

    public void setFreeStanding(boolean bl) {
        super.setFreeStanding(bl);
        this.isFreeStanding = bl;
    }

    public void paint(Graphics graphics) {
        boolean bl = PlasticUtils.isLeftToRight(this);
        boolean bl2 = this.getParent().isEnabled();
        boolean bl3 = this.getModel().isPressed();
        ColorUIResource colorUIResource = bl2 ? PlasticLookAndFeel.getControlInfo() : PlasticLookAndFeel.getControlDisabled();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n;
        int n4 = n2;
        int n5 = this.calculateArrowHeight(n2, n);
        int n6 = this.calculateArrowOffset();
        boolean bl4 = this.isPaintingNorthBottom();
        graphics.setColor(bl3 ? PlasticLookAndFeel.getControlShadow() : this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        if (this.getDirection() == 1) {
            this.paintNorth(graphics, bl, bl2, colorUIResource, bl3, n, n2, n3, n4, n5, n6, bl4);
        } else if (this.getDirection() == 5) {
            this.paintSouth(graphics, bl, bl2, colorUIResource, bl3, n, n2, n3, n4, n5, n6);
        } else if (this.getDirection() == 3) {
            this.paintEast(graphics, bl2, colorUIResource, bl3, n, n2, n3, n4, n5);
        } else if (this.getDirection() == 7) {
            this.paintWest(graphics, bl2, colorUIResource, bl3, n, n2, n3, n4, n5);
        }
        if (PlasticUtils.is3D("ScrollBar.")) {
            this.paint3D(graphics);
        }
    }

    protected int calculateArrowHeight(int n, int n2) {
        return (n + 1) / 4;
    }

    protected int calculateArrowOffset() {
        return 0;
    }

    protected boolean isPaintingNorthBottom() {
        return false;
    }

    private void paintWest(Graphics graphics, boolean bl, Color color, boolean bl2, int n, int n2, int n3, int n4, int n5) {
        if (!this.isFreeStanding) {
            n2 += 2;
            ++n;
            graphics.translate(-1, 0);
        }
        graphics.setColor(color);
        int n6 = (n3 + 1 - n5) / 2;
        int n7 = n4 / 2;
        int n8 = 0;
        while (n8 < n5) {
            graphics.drawLine(n6 + n8, n7 - n8, n6 + n8, n7 + n8 + 1);
            ++n8;
        }
        if (bl) {
            graphics.setColor(this.highlightColor);
            if (!bl2) {
                graphics.drawLine(1, 1, n - 1, 1);
                graphics.drawLine(1, 1, 1, n2 - 3);
            }
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(0, 0, 0, n2 - 2);
            graphics.drawLine(1, n2 - 2, n - 1, n2 - 2);
        } else {
            PlasticUtils.drawDisabledBorder(graphics, 0, 0, n + 1, n2);
        }
        if (!this.isFreeStanding) {
            n2 -= 2;
            --n;
            graphics.translate(1, 0);
        }
    }

    private void paintEast(Graphics graphics, boolean bl, Color color, boolean bl2, int n, int n2, int n3, int n4, int n5) {
        if (!this.isFreeStanding) {
            n2 += 2;
            ++n;
        }
        graphics.setColor(color);
        int n6 = (n3 + 1 - n5) / 2 + n5 - 1;
        int n7 = n4 / 2;
        int n8 = 0;
        while (n8 < n5) {
            graphics.drawLine(n6 - n8, n7 - n8, n6 - n8, n7 + n8 + 1);
            ++n8;
        }
        if (bl) {
            graphics.setColor(this.highlightColor);
            if (!bl2) {
                graphics.drawLine(0, 1, n - 3, 1);
                graphics.drawLine(0, 1, 0, n2 - 3);
            }
            graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(0, 0, n - 2, 0);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 2);
            graphics.drawLine(0, n2 - 2, n - 2, n2 - 2);
        } else {
            PlasticUtils.drawDisabledBorder(graphics, -1, 0, n + 1, n2);
        }
        if (!this.isFreeStanding) {
            n2 -= 2;
            --n;
        }
    }

    protected void paintSouth(Graphics graphics, boolean bl, boolean bl2, Color color, boolean bl3, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.isFreeStanding) {
            ++n2;
            if (!bl) {
                ++n;
                graphics.translate(-1, 0);
            } else {
                n += 2;
            }
        }
        graphics.setColor(color);
        int n7 = (n4 + 0 - n5) / 2 + n5 - 1;
        int n8 = n3 / 2;
        int n9 = 0;
        while (n9 < n5) {
            graphics.fillRect(n8 - n9 - n6, n7 - n9, 2 * (n9 + 1), 1);
            ++n9;
        }
        if (bl2) {
            graphics.setColor(this.highlightColor);
            if (!bl3) {
                graphics.drawLine(1, 0, n - 3, 0);
                graphics.drawLine(1, 0, 1, n2 - 3);
            }
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(0, 0, 0, n2 - 2);
            graphics.drawLine(n - 2, 0, n - 2, n2 - 2);
            graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
        } else {
            PlasticUtils.drawDisabledBorder(graphics, 0, -1, n, n2 + 1);
        }
        if (!this.isFreeStanding) {
            --n2;
            if (!bl) {
                --n;
                graphics.translate(1, 0);
            } else {
                n -= 2;
            }
        }
    }

    protected void paintNorth(Graphics graphics, boolean bl, boolean bl2, Color color, boolean bl3, int n, int n2, int n3, int n4, int n5, int n6, boolean bl4) {
        if (!this.isFreeStanding) {
            ++n2;
            graphics.translate(0, -1);
            if (!bl) {
                ++n;
                graphics.translate(-1, 0);
            } else {
                n += 2;
            }
        }
        graphics.setColor(color);
        int n7 = (n4 + 1 - n5) / 2;
        int n8 = n3 / 2;
        int n9 = 0;
        while (n9 < n5) {
            graphics.fillRect(n8 - n9 - n6, n7 + n9, 2 * (n9 + 1), 1);
            ++n9;
        }
        if (bl2) {
            graphics.setColor(this.highlightColor);
            if (!bl3) {
                graphics.drawLine(1, 1, n - 3, 1);
                graphics.drawLine(1, 1, 1, n2 - 1);
            }
            graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(0, 0, n - 2, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 1);
            if (bl4) {
                graphics.fillRect(0, n2 - 1, n - 1, 1);
            }
        } else {
            PlasticUtils.drawDisabledBorder(graphics, 0, 0, n, n2 + 1);
            if (bl4) {
                graphics.setColor(PlasticLookAndFeel.getControlShadow());
                graphics.fillRect(0, n2 - 1, n - 1, 1);
            }
        }
        if (!this.isFreeStanding) {
            --n2;
            graphics.translate(0, 1);
            if (!bl) {
                --n;
                graphics.translate(1, 0);
            } else {
                n -= 2;
            }
        }
    }

    private void paint3D(Graphics graphics) {
        ButtonModel buttonModel = this.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.getDirection() == 3) {
            n -= 2;
        } else if (this.getDirection() == 5) {
            n2 -= 2;
        }
        Rectangle rectangle = new Rectangle(1, 1, n, n2);
        boolean bl = this.getDirection() == 3 || this.getDirection() == 7;
        PlasticUtils.addLight3DEffekt(graphics, rectangle, bl);
    }
}

