/* CalculosRendPJTitular - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.calculos;
import java.util.Hashtable;
import java.util.Iterator;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendPJComExigibilidadeTitular extends Observador
{
  private ColecaoRendPJComExigibilidadeTitular colecaoRendPJ = null;
  private DeclaracaoIRPF declaracaoIRPF;
  
  public CalculosRendPJComExigibilidadeTitular (ColecaoRendPJComExigibilidadeTitular colecao, DeclaracaoIRPF dec)
  {
    colecaoRendPJ = colecao;
    declaracaoIRPF = dec;
  }
  
  public void notifica (Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo)
  {
    if (nomePropriedade != null)
      {
	if (nomePropriedade.equals ("ObjetoInserido"))
	  {
	    RendPJComExigibilidadeTitular rendPJ = (RendPJComExigibilidadeTitular) valorNovo;
	    rendPJ.addObservador (this);
	    calculaTotaisRendExigSuspensa ();
	    calculaTotaisDepositoJudicial ();
	  }
	else if (nomePropriedade.equals ("ObjetoRemovido"))
	  {
	    RendPJComExigibilidadeTitular rendPJ = (RendPJComExigibilidadeTitular) valorNovo;
	    rendPJ.removeObservador (this);
	    calculaTotaisRendExigSuspensa ();
	    calculaTotaisDepositoJudicial ();
	  }
	else if (nomePropriedade.equals ("Rend. com Exigibilidade Suspensa"))
	  calculaTotaisRendExigSuspensa ();
	else if (nomePropriedade.equals ("Depósito Judicial"))
	  calculaTotaisDepositoJudicial ();
      }
  }
  
  private void calculaTotaisDepositoJudicial ()
  {
    Valor total = new Valor ();
    Iterator itRend = colecaoRendPJ.recuperarLista ().iterator ();
    while (itRend.hasNext ())
      {
	RendPJComExigibilidadeTitular rendAtual = (RendPJComExigibilidadeTitular) itRend.next ();
	total.append ('+', rendAtual.getDepositoJudicial ());
      }
    colecaoRendPJ.getTotaisDepositoJudicial ().setConteudo (total);
  }
  
  private void calculaTotaisRendExigSuspensa ()
  {
    Valor total = new Valor ();
    Iterator itRend = colecaoRendPJ.recuperarLista ().iterator ();
    while (itRend.hasNext ())
      {
	RendPJComExigibilidadeTitular rendAtual = (RendPJComExigibilidadeTitular) itRend.next ();
	total.append ('+', rendAtual.getRendExigSuspensa ());
      }
    colecaoRendPJ.getTotaisRendRecebidoPJ ().setConteudo (total);
  }
}
