/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class MessageSend
extends Expression
implements InvocationSite {
    public Expression receiver;
    public char[] selector;
    public Expression[] arguments;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    MethodBinding syntheticAccessor;
    public TypeBinding expectedType;
    public long nameSourcePosition;
    public TypeBinding actualReceiverType;
    public TypeBinding valueCast;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean bl = !this.binding.isStatic();
        flowInfo = this.receiver.analyseCode(blockScope, flowContext, flowInfo, bl).unconditionalInits();
        if (bl) {
            this.receiver.checkNPE(blockScope, flowContext, flowInfo);
        }
        if (this.arguments != null) {
            int n = this.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                flowInfo = this.arguments[n2].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                ++n2;
            }
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, flowInfo.copy(), blockScope);
        }
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        return flowInfo;
    }

    public void computeConversion(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == null || typeBinding2 == null) {
            return;
        }
        if (this.binding != null && this.binding.isValidBinding()) {
            MethodBinding methodBinding = this.binding.original();
            TypeBinding typeBinding3 = methodBinding.returnType;
            if (methodBinding != this.binding && typeBinding3 != this.binding.returnType && typeBinding.id != 1 && (typeBinding3.tagBits & 0x20000000L) != 0L) {
                TypeBinding typeBinding4 = !typeBinding2.isBaseType() && typeBinding.isBaseType() ? typeBinding2 : typeBinding;
                this.valueCast = typeBinding3.genericCast(typeBinding4);
            } else if (this.actualReceiverType.isArrayType() && typeBinding.id != 1 && this.binding.parameters == Binding.NO_PARAMETERS && scope.compilerOptions().complianceLevel >= 0x310000L && CharOperation.equals(this.binding.selector, CLONE)) {
                this.valueCast = typeBinding;
            }
        }
        super.computeConversion(scope, typeBinding, typeBinding2);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        boolean bl2 = this.codegenBinding.isStatic();
        if (!bl2 && (this.bits & 0x1FE0) != 0 && this.receiver.isImplicitThis()) {
            ReferenceBinding referenceBinding = blockScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
            Object[] objectArray = blockScope.getEmulationPath(referenceBinding, true, false);
            codeStream.generateOuterAccess(objectArray, this, referenceBinding, blockScope);
        } else {
            this.receiver.generateCode(blockScope, codeStream, !bl2);
            codeStream.recordPositionsFrom(n, this.sourceStart);
        }
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        if (this.syntheticAccessor == null) {
            if (bl2) {
                codeStream.invokestatic(this.codegenBinding);
            } else if (this.receiver.isSuper() || this.codegenBinding.isPrivate()) {
                codeStream.invokespecial(this.codegenBinding);
            } else if (this.codegenBinding.declaringClass.isInterface()) {
                codeStream.invokeinterface(this.codegenBinding);
            } else {
                codeStream.invokevirtual(this.codegenBinding);
            }
        } else {
            codeStream.invokestatic(this.syntheticAccessor);
        }
        if (bl) {
            if (this.valueCast != null) {
                codeStream.checkcast(this.valueCast);
            }
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            switch (this.binding.returnType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n, (int)(this.nameSourcePosition >>> 32));
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        Object object;
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        this.codegenBinding = this.binding.original();
        if (this.binding.isPrivate()) {
            if (blockScope.enclosingSourceType() != this.codegenBinding.declaringClass) {
                this.syntheticAccessor = ((SourceTypeBinding)this.codegenBinding.declaringClass).addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                blockScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                this.syntheticAccessor = sourceTypeBinding.addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                blockScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                object = blockScope.enclosingSourceType();
                if (this.codegenBinding.declaringClass.getPackage() != ((ReferenceBinding)object).getPackage()) {
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)((ReferenceBinding)object).enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    this.syntheticAccessor = sourceTypeBinding.addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                    return;
                }
            }
        }
        if (this.binding.declaringClass != this.actualReceiverType && !this.actualReceiverType.isArrayType()) {
            object = blockScope.compilerOptions();
            if (!((((CompilerOptions)object).targetJDK < 0x2E0000L || ((CompilerOptions)object).complianceLevel < 0x300000L && this.receiver.isImplicitThis() && this.codegenBinding.isStatic() || this.binding.declaringClass.id == 1) && this.binding.declaringClass.canBeSeenBy(blockScope))) {
                this.codegenBinding = blockScope.enclosingSourceType().getUpdatedMethodBinding(this.codegenBinding, (ReferenceBinding)this.actualReceiverType.erasure());
            }
        }
    }

    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    public TypeBinding postConversionType(Scope scope) {
        TypeBinding typeBinding = this.resolvedType;
        if (this.valueCast != null) {
            typeBinding = this.valueCast;
        }
        int n = (this.implicitConversion & 0xFF) >> 4;
        switch (n) {
            case 5: {
                typeBinding = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                typeBinding = TypeBinding.BYTE;
                break;
            }
            case 4: {
                typeBinding = TypeBinding.SHORT;
                break;
            }
            case 2: {
                typeBinding = TypeBinding.CHAR;
                break;
            }
            case 10: {
                typeBinding = TypeBinding.INT;
                break;
            }
            case 9: {
                typeBinding = TypeBinding.FLOAT;
                break;
            }
            case 7: {
                typeBinding = TypeBinding.LONG;
                break;
            }
            case 8: {
                typeBinding = TypeBinding.DOUBLE;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            typeBinding = scope.environment().computeBoxingType(typeBinding);
        }
        return typeBinding;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        if (!this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, stringBuffer).append('.');
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            int n3 = 0;
            while (n3 < n2) {
                this.typeArguments[n3].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n3;
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        stringBuffer.append(this.selector).append('(');
        if (this.arguments != null) {
            n2 = 0;
            while (n2 < this.arguments.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
                ++n2;
            }
        }
        return stringBuffer.append(')');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        int n;
        boolean bl;
        boolean bl2;
        this.constant = Constant.NotAConstant;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.receiver instanceof CastExpression) {
            this.receiver.bits |= 0x20;
            bl3 = true;
        }
        this.actualReceiverType = this.receiver.resolveType(blockScope);
        boolean bl5 = bl2 = this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0;
        if (bl3 && this.actualReceiverType != null && ((CastExpression)this.receiver).expression.resolvedType == this.actualReceiverType) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)this.receiver);
        }
        if (this.typeArguments != null) {
            int n2 = this.typeArguments.length;
            bl = false;
            this.genericTypeArguments = new TypeBinding[n2];
            n = 0;
            while (n < n2) {
                this.genericTypeArguments[n] = this.typeArguments[n].resolveType(blockScope, true);
                if (this.genericTypeArguments[n] == null) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                return null;
            }
        }
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            bl = false;
            n = this.arguments.length;
            typeBindingArray = new TypeBinding[n];
            int n3 = 0;
            while (n3 < n) {
                Expression expression = this.arguments[n3];
                if (expression instanceof CastExpression) {
                    expression.bits |= 0x20;
                    bl4 = true;
                }
                if ((typeBindingArray[n3] = expression.resolveType(blockScope)) == null) {
                    bl = true;
                }
                ++n3;
            }
            if (bl) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    MethodBinding methodBinding;
                    TypeBinding[] typeBindingArray2 = new TypeBinding[n];
                    int n4 = n;
                    while (--n4 >= 0) {
                        TypeBinding typeBinding = typeBindingArray2[n4] = typeBindingArray[n4] == null ? this.actualReceiverType : typeBindingArray[n4];
                    }
                    MethodBinding methodBinding2 = this.binding = this.receiver.isImplicitThis() ? blockScope.getImplicitMethod(this.selector, typeBindingArray2, this) : blockScope.findMethod((ReferenceBinding)this.actualReceiverType, this.selector, typeBindingArray2, this);
                    if (this.binding != null && !this.binding.isValidBinding() && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                        this.binding = methodBinding;
                        if ((methodBinding.isPrivate() || methodBinding.declaringClass.isLocalType()) && !blockScope.isDefinedInMethod(methodBinding)) {
                            methodBinding.original().modifiers |= 0x8000000;
                        }
                    }
                }
                return null;
            }
        }
        if (this.actualReceiverType == null) {
            return null;
        }
        if (this.actualReceiverType.isBaseType()) {
            blockScope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, typeBindingArray);
            return null;
        }
        MethodBinding methodBinding = this.binding = this.receiver.isImplicitThis() ? blockScope.getImplicitMethod(this.selector, typeBindingArray, this) : blockScope.getMethod(this.actualReceiverType, this.selector, typeBindingArray, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                } else {
                    blockScope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, typeBindingArray);
                    return null;
                }
            }
            blockScope.problemReporter().invalidMethod(this, this.binding);
            MethodBinding methodBinding3 = ((ProblemMethodBinding)this.binding).closestMatch;
            switch (this.binding.problemId()) {
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    if (methodBinding3 == null) break;
                    this.resolvedType = methodBinding3.returnType;
                }
            }
            if (methodBinding3 != null) {
                this.binding = methodBinding3;
                if ((methodBinding3.isPrivate() || methodBinding3.declaringClass.isLocalType()) && !blockScope.isDefinedInMethod(methodBinding3)) {
                    methodBinding3.original().modifiers |= 0x8000000;
                }
            }
            return this.resolvedType;
        }
        if (!this.binding.isStatic()) {
            if (bl2) {
                blockScope.problemReporter().mustUseAStaticMethod(this, this.binding);
                if (this.actualReceiverType.isRawType() && (this.receiver.bits & 0x40000000) == 0 && blockScope.compilerOptions().getSeverity(0x200000000000L) != -1) {
                    blockScope.problemReporter().rawTypeReference(this.receiver, this.actualReceiverType);
                }
            } else {
                TypeBinding typeBinding = this.actualReceiverType.erasure();
                if (typeBinding instanceof ReferenceBinding && typeBinding.findSuperTypeWithSameErasure(this.binding.declaringClass) == null) {
                    this.actualReceiverType = this.binding.declaringClass;
                }
                this.receiver.computeConversion(blockScope, this.actualReceiverType, this.actualReceiverType);
            }
        } else {
            if (!(this.receiver.isImplicitThis() || this.receiver.isSuper() || bl2)) {
                blockScope.problemReporter().nonStaticAccessToStaticMethod(this, this.binding);
            }
            if (!this.receiver.isImplicitThis() && this.binding.declaringClass != this.actualReceiverType) {
                blockScope.problemReporter().indirectAccessToStaticMethod(this, this.binding);
            }
        }
        MessageSend.checkInvocationArguments(blockScope, this.receiver, this.actualReceiverType, this.binding, this.arguments, typeBindingArray, bl4, this);
        if (this.binding.isAbstract() && this.receiver.isSuper()) {
            blockScope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, blockScope, true)) {
            blockScope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.actualReceiverType.isArrayType() && this.binding.parameters == Binding.NO_PARAMETERS && blockScope.compilerOptions().complianceLevel >= 0x310000L && CharOperation.equals(this.binding.selector, CLONE)) {
            this.resolvedType = this.actualReceiverType;
        } else {
            TypeBinding typeBinding = this.binding.returnType;
            if (typeBinding != null) {
                typeBinding = typeBinding.capture(blockScope, this.sourceEnd);
            }
            this.resolvedType = typeBinding;
        }
        return this.resolvedType;
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
        if (referenceBinding == null) {
            return;
        }
        this.actualReceiverType = referenceBinding;
    }

    public void setDepth(int n) {
        this.bits &= 0xFFFFE01F;
        if (n > 0) {
            this.bits |= (n & 0xFF) << 5;
        }
    }

    public void setExpectedType(TypeBinding typeBinding) {
        this.expectedType = typeBinding;
    }

    public void setFieldIndex(int n) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            this.receiver.traverse(aSTVisitor, blockScope);
            if (this.typeArguments != null) {
                n2 = 0;
                n = this.typeArguments.length;
                while (n2 < n) {
                    this.typeArguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                n = 0;
                while (n < n2) {
                    this.arguments[n].traverse(aSTVisitor, blockScope);
                    ++n;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

