/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.design;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.collections.SequencedHashMap;

public class JRDesignCrosstab
extends JRDesignElement
implements JRCrosstab {
    private static final long serialVersionUID = 10200L;
    protected List parametersList;
    protected Map parametersMap;
    protected Map variablesList;
    protected JRExpression parametersMapExpression;
    protected JRDesignCrosstabDataset dataset;
    protected List rowGroups;
    protected List columnGroups;
    protected List measures;
    protected Map rowGroupsMap;
    protected Map columnGroupsMap;
    protected Map measuresMap;
    protected int columnBreakOffset = 10;
    protected boolean repeatColumnHeaders = true;
    protected boolean repeatRowHeaders = true;
    protected List cellsList;
    protected Map cellsMap;
    protected JRDesignCrosstabCell[][] crossCells;
    protected JRDesignCellContents whenNoDataCell;
    protected JRDesignCellContents headerCell;
    private PropertyChangeListener measureClassChangeListener = new MeasureClassChangeListener();
    private static final Object[] BUILT_IN_PARAMETERS = new Object[]{"REPORT_PARAMETERS_MAP", Map.class, "REPORT_LOCALE", Locale.class, "REPORT_RESOURCE_BUNDLE", ResourceBundle.class, "REPORT_TIME_ZONE", TimeZone.class, "REPORT_DATE_FORMAT_FACTORY", FormatFactory.class, "REPORT_CLASS_LOADER", ClassLoader.class, "REPORT_URL_HANDLER_FACTORY", URLStreamHandlerFactory.class};
    private static final Object[] BUILT_IN_VARIABLES = new Object[]{"ROW_COUNT", Integer.class, "COLUMN_COUNT", Integer.class};

    public JRDesignCrosstab(JRDefaultStyleProvider jRDefaultStyleProvider) {
        super(jRDefaultStyleProvider);
        this.parametersList = new ArrayList();
        this.parametersMap = new HashMap();
        this.rowGroupsMap = new HashMap();
        this.rowGroups = new ArrayList();
        this.columnGroupsMap = new HashMap();
        this.columnGroups = new ArrayList();
        this.measuresMap = new HashMap();
        this.measures = new ArrayList();
        this.cellsMap = new HashMap();
        this.cellsList = new ArrayList();
        this.addBuiltinParameters();
        this.variablesList = new SequencedHashMap();
        this.addBuiltinVariables();
        this.dataset = new JRDesignCrosstabDataset();
    }

    private void addBuiltinParameters() {
        int n = 0;
        while (n < BUILT_IN_PARAMETERS.length) {
            JRDesignCrosstabParameter jRDesignCrosstabParameter = new JRDesignCrosstabParameter();
            jRDesignCrosstabParameter.setName((String)BUILT_IN_PARAMETERS[n++]);
            jRDesignCrosstabParameter.setValueClass((Class)BUILT_IN_PARAMETERS[n]);
            jRDesignCrosstabParameter.setSystemDefined(true);
            try {
                this.addParameter(jRDesignCrosstabParameter);
            }
            catch (JRException jRException) {}
            ++n;
        }
    }

    private void addBuiltinVariables() {
        int n = 0;
        while (n < BUILT_IN_VARIABLES.length) {
            JRDesignVariable jRDesignVariable = new JRDesignVariable();
            jRDesignVariable.setName((String)BUILT_IN_VARIABLES[n]);
            jRDesignVariable.setValueClass((Class)BUILT_IN_VARIABLES[++n]);
            jRDesignVariable.setCalculation((byte)8);
            jRDesignVariable.setSystemDefined(true);
            this.addVariable(jRDesignVariable);
            ++n;
        }
    }

    public JRDesignCrosstab() {
        this(null);
    }

    public int getId() {
        return 0;
    }

    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    public JRDesignCrosstabDataset getDesignDataset() {
        return this.dataset;
    }

    public JRCrosstabRowGroup[] getRowGroups() {
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = new JRCrosstabRowGroup[this.rowGroups.size()];
        this.rowGroups.toArray(jRCrosstabRowGroupArray);
        return jRCrosstabRowGroupArray;
    }

    public JRCrosstabColumnGroup[] getColumnGroups() {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = new JRCrosstabColumnGroup[this.columnGroups.size()];
        this.columnGroups.toArray(jRCrosstabColumnGroupArray);
        return jRCrosstabColumnGroupArray;
    }

    public JRCrosstabMeasure[] getMeasures() {
        JRCrosstabMeasure[] jRCrosstabMeasureArray = new JRCrosstabMeasure[this.measures.size()];
        this.measures.toArray(jRCrosstabMeasureArray);
        return jRCrosstabMeasureArray;
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getCrosstab(this);
    }

    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeCrosstab(this);
    }

    public void setDataset(JRDesignCrosstabDataset jRDesignCrosstabDataset) {
        this.dataset = jRDesignCrosstabDataset;
    }

    public void addRowGroup(JRDesignCrosstabRowGroup jRDesignCrosstabRowGroup) throws JRException {
        String string = jRDesignCrosstabRowGroup.getName();
        if (this.rowGroupsMap.containsKey(string) || this.columnGroupsMap.containsKey(string) || this.measuresMap.containsKey(string)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.rowGroupsMap.put(string, new Integer(this.rowGroups.size()));
        this.rowGroups.add(jRDesignCrosstabRowGroup);
        this.addRowGroupVars(jRDesignCrosstabRowGroup);
    }

    protected void addRowGroupVars(JRDesignCrosstabRowGroup jRDesignCrosstabRowGroup) {
        this.addVariable(jRDesignCrosstabRowGroup.getVariable());
        for (JRCrosstabMeasure jRCrosstabMeasure : this.measures) {
            this.addTotalVar(jRCrosstabMeasure, jRDesignCrosstabRowGroup, null);
            for (JRCrosstabColumnGroup jRCrosstabColumnGroup : this.columnGroups) {
                this.addTotalVar(jRCrosstabMeasure, jRDesignCrosstabRowGroup, jRCrosstabColumnGroup);
            }
        }
    }

    public void addColumnGroup(JRDesignCrosstabColumnGroup jRDesignCrosstabColumnGroup) throws JRException {
        String string = jRDesignCrosstabColumnGroup.getName();
        if (this.rowGroupsMap.containsKey(string) || this.columnGroupsMap.containsKey(string) || this.measuresMap.containsKey(string)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.columnGroupsMap.put(string, new Integer(this.columnGroups.size()));
        this.columnGroups.add(jRDesignCrosstabColumnGroup);
        this.addColGroupVars(jRDesignCrosstabColumnGroup);
    }

    protected void addColGroupVars(JRDesignCrosstabColumnGroup jRDesignCrosstabColumnGroup) {
        this.addVariable(jRDesignCrosstabColumnGroup.getVariable());
        for (JRCrosstabMeasure jRCrosstabMeasure : this.measures) {
            this.addTotalVar(jRCrosstabMeasure, null, jRDesignCrosstabColumnGroup);
            for (JRCrosstabRowGroup jRCrosstabRowGroup : this.rowGroups) {
                this.addTotalVar(jRCrosstabMeasure, jRCrosstabRowGroup, jRDesignCrosstabColumnGroup);
            }
        }
    }

    public void addMeasure(JRDesignCrosstabMeasure jRDesignCrosstabMeasure) throws JRException {
        String string = jRDesignCrosstabMeasure.getName();
        if (this.rowGroupsMap.containsKey(string) || this.columnGroupsMap.containsKey(string) || this.measuresMap.containsKey(string)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        jRDesignCrosstabMeasure.addPropertyChangeListener("valueClassName", this.measureClassChangeListener);
        this.measuresMap.put(string, new Integer(this.measures.size()));
        this.measures.add(jRDesignCrosstabMeasure);
        this.addMeasureVars(jRDesignCrosstabMeasure);
    }

    protected void addMeasureVars(JRDesignCrosstabMeasure jRDesignCrosstabMeasure) {
        this.addVariable(jRDesignCrosstabMeasure.getVariable());
        for (JRCrosstabGroup jRCrosstabGroup : this.columnGroups) {
            this.addTotalVar(jRDesignCrosstabMeasure, null, (JRCrosstabColumnGroup)jRCrosstabGroup);
        }
        for (JRCrosstabGroup jRCrosstabGroup : this.rowGroups) {
            this.addTotalVar(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, null);
            for (JRCrosstabColumnGroup jRCrosstabColumnGroup : this.columnGroups) {
                this.addTotalVar(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, jRCrosstabColumnGroup);
            }
        }
    }

    protected void addTotalVar(JRCrosstabMeasure jRCrosstabMeasure, JRCrosstabRowGroup jRCrosstabRowGroup, JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        JRDesignVariable jRDesignVariable = new JRDesignVariable();
        jRDesignVariable.setCalculation((byte)8);
        jRDesignVariable.setSystemDefined(true);
        jRDesignVariable.setName(JRDesignCrosstab.getTotalVariableName(jRCrosstabMeasure, jRCrosstabRowGroup, jRCrosstabColumnGroup));
        jRDesignVariable.setValueClassName(jRCrosstabMeasure.getValueClassName());
        this.addVariable(jRDesignVariable);
    }

    protected void removeTotalVar(JRCrosstabMeasure jRCrosstabMeasure, JRCrosstabRowGroup jRCrosstabRowGroup, JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        String string = JRDesignCrosstab.getTotalVariableName(jRCrosstabMeasure, jRCrosstabRowGroup, jRCrosstabColumnGroup);
        this.removeVariable(string);
    }

    public static String getTotalVariableName(JRCrosstabMeasure jRCrosstabMeasure, JRCrosstabRowGroup jRCrosstabRowGroup, JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(jRCrosstabMeasure.getName());
        if (jRCrosstabRowGroup != null) {
            stringBuffer.append('_');
            stringBuffer.append(jRCrosstabRowGroup.getName());
        }
        if (jRCrosstabColumnGroup != null) {
            stringBuffer.append('_');
            stringBuffer.append(jRCrosstabColumnGroup.getName());
        }
        stringBuffer.append("_ALL");
        return stringBuffer.toString();
    }

    public JRCrosstabRowGroup removeRowGroup(String string) {
        JRCrosstabRowGroup jRCrosstabRowGroup = null;
        Integer n = (Integer)this.rowGroupsMap.remove(string);
        if (n != null) {
            Object object;
            jRCrosstabRowGroup = (JRCrosstabRowGroup)this.rowGroups.remove(n);
            Iterator iterator = this.rowGroups.listIterator(n);
            while (iterator.hasNext()) {
                object = (JRCrosstabRowGroup)iterator.next();
                this.rowGroupsMap.put(object.getName(), new Integer(iterator.previousIndex()));
            }
            iterator = this.cellsList.iterator();
            while (iterator.hasNext()) {
                object = (JRCrosstabCell)iterator.next();
                String string2 = object.getRowTotalGroup();
                if (string2 == null || !string2.equals(string)) continue;
                iterator.remove();
                this.cellsMap.remove(new Pair(string2, object.getColumnTotalGroup()));
            }
            this.removeRowGroupVars(jRCrosstabRowGroup);
        }
        return jRCrosstabRowGroup;
    }

    protected void removeRowGroupVars(JRCrosstabRowGroup jRCrosstabRowGroup) {
        this.removeVariable(jRCrosstabRowGroup.getVariable());
        for (JRCrosstabMeasure jRCrosstabMeasure : this.measures) {
            this.removeTotalVar(jRCrosstabMeasure, jRCrosstabRowGroup, null);
            for (JRCrosstabColumnGroup jRCrosstabColumnGroup : this.columnGroups) {
                this.removeTotalVar(jRCrosstabMeasure, jRCrosstabRowGroup, jRCrosstabColumnGroup);
            }
        }
    }

    public JRCrosstabRowGroup removeRowGroup(JRCrosstabRowGroup jRCrosstabRowGroup) {
        return this.removeRowGroup(jRCrosstabRowGroup.getName());
    }

    public JRCrosstabColumnGroup removeColumnGroup(String string) {
        JRCrosstabColumnGroup jRCrosstabColumnGroup = null;
        Integer n = (Integer)this.columnGroupsMap.remove(string);
        if (n != null) {
            Object object;
            jRCrosstabColumnGroup = (JRCrosstabColumnGroup)this.columnGroups.remove(n);
            Iterator iterator = this.columnGroups.listIterator(n);
            while (iterator.hasNext()) {
                object = (JRCrosstabColumnGroup)iterator.next();
                this.columnGroupsMap.put(object.getName(), new Integer(iterator.previousIndex()));
            }
            iterator = this.cellsList.iterator();
            while (iterator.hasNext()) {
                object = (JRCrosstabCell)iterator.next();
                String string2 = object.getColumnTotalGroup();
                if (string2 == null || !string2.equals(string)) continue;
                iterator.remove();
                this.cellsMap.remove(new Pair(object.getRowTotalGroup(), string2));
            }
            this.removeColGroupVars(jRCrosstabColumnGroup);
        }
        return jRCrosstabColumnGroup;
    }

    protected void removeColGroupVars(JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        this.removeVariable(jRCrosstabColumnGroup.getVariable());
        for (JRCrosstabMeasure jRCrosstabMeasure : this.measures) {
            this.removeTotalVar(jRCrosstabMeasure, null, jRCrosstabColumnGroup);
            for (JRCrosstabRowGroup jRCrosstabRowGroup : this.rowGroups) {
                this.removeTotalVar(jRCrosstabMeasure, jRCrosstabRowGroup, jRCrosstabColumnGroup);
            }
        }
    }

    public JRCrosstabColumnGroup removeColumnGroup(JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        return this.removeColumnGroup(jRCrosstabColumnGroup.getName());
    }

    public JRCrosstabMeasure removeMeasure(String string) {
        JRDesignCrosstabMeasure jRDesignCrosstabMeasure = null;
        Integer n = (Integer)this.measuresMap.remove(string);
        if (n != null) {
            jRDesignCrosstabMeasure = (JRDesignCrosstabMeasure)this.measures.remove(n);
            ListIterator listIterator = this.measures.listIterator(n);
            while (listIterator.hasNext()) {
                JRCrosstabMeasure jRCrosstabMeasure = (JRCrosstabMeasure)listIterator.next();
                this.measuresMap.put(jRCrosstabMeasure.getName(), new Integer(listIterator.previousIndex()));
            }
            this.removeMeasureVars(jRDesignCrosstabMeasure);
            jRDesignCrosstabMeasure.removePropertyChangeListener("valueClassName", this.measureClassChangeListener);
        }
        return jRDesignCrosstabMeasure;
    }

    protected void removeMeasureVars(JRDesignCrosstabMeasure jRDesignCrosstabMeasure) {
        this.removeVariable(jRDesignCrosstabMeasure.getVariable());
        for (JRCrosstabGroup jRCrosstabGroup : this.columnGroups) {
            this.removeTotalVar(jRDesignCrosstabMeasure, null, (JRCrosstabColumnGroup)jRCrosstabGroup);
        }
        for (JRCrosstabGroup jRCrosstabGroup : this.rowGroups) {
            this.removeTotalVar(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, null);
            for (JRCrosstabColumnGroup jRCrosstabColumnGroup : this.columnGroups) {
                this.removeTotalVar(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, jRCrosstabColumnGroup);
            }
        }
    }

    public JRCrosstabMeasure removeMeasure(JRCrosstabMeasure jRCrosstabMeasure) {
        return this.removeMeasure(jRCrosstabMeasure.getName());
    }

    public boolean isRepeatColumnHeaders() {
        return this.repeatColumnHeaders;
    }

    public void setRepeatColumnHeaders(boolean bl) {
        this.repeatColumnHeaders = bl;
    }

    public boolean isRepeatRowHeaders() {
        return this.repeatRowHeaders;
    }

    public void setRepeatRowHeaders(boolean bl) {
        this.repeatRowHeaders = bl;
    }

    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    public List getCellsList() {
        return this.cellsList;
    }

    public void addCell(JRDesignCrosstabCell jRDesignCrosstabCell) throws JRException {
        String string = jRDesignCrosstabCell.getRowTotalGroup();
        if (string != null && !this.rowGroupsMap.containsKey(string)) {
            throw new JRException("Row group " + string + " does not exist.");
        }
        String string2 = jRDesignCrosstabCell.getColumnTotalGroup();
        if (string2 != null && !this.columnGroupsMap.containsKey(string2)) {
            throw new JRException("Row group " + string2 + " does not exist.");
        }
        Pair pair = new Pair(string, string2);
        if (this.cellsMap.containsKey(pair)) {
            throw new JRException("Duplicate cell in crosstab.");
        }
        this.cellsMap.put(pair, jRDesignCrosstabCell);
        this.cellsList.add(jRDesignCrosstabCell);
    }

    public JRCrosstabCell removeCell(String string, String string2) {
        Pair pair = new Pair(string, string2);
        JRCrosstabCell jRCrosstabCell = (JRCrosstabCell)this.cellsMap.remove(pair);
        if (jRCrosstabCell != null) {
            this.cellsList.remove(jRCrosstabCell);
        }
        return jRCrosstabCell;
    }

    public JRCrosstabCell removeCell(JRCrosstabCell jRCrosstabCell) {
        Pair pair = new Pair(jRCrosstabCell.getRowTotalGroup(), jRCrosstabCell.getColumnTotalGroup());
        JRCrosstabCell jRCrosstabCell2 = (JRCrosstabCell)this.cellsMap.remove(pair);
        if (jRCrosstabCell2 != null) {
            this.cellsList.remove(jRCrosstabCell2);
        }
        return jRCrosstabCell2;
    }

    public JRCrosstabParameter[] getParameters() {
        JRCrosstabParameter[] jRCrosstabParameterArray = new JRCrosstabParameter[this.parametersList.size()];
        this.parametersList.toArray(jRCrosstabParameterArray);
        return jRCrosstabParameterArray;
    }

    public List getParametersList() {
        return this.parametersList;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public void addParameter(JRCrosstabParameter jRCrosstabParameter) throws JRException {
        if (this.parametersMap.containsKey(jRCrosstabParameter.getName()) && this.parametersMap.containsKey(jRCrosstabParameter.getName())) {
            throw new JRException("Duplicate declaration of parameter : " + jRCrosstabParameter.getName());
        }
        this.parametersMap.put(jRCrosstabParameter.getName(), jRCrosstabParameter);
        this.parametersList.add(jRCrosstabParameter);
    }

    public JRCrosstabParameter removeParameter(String string) {
        JRCrosstabParameter jRCrosstabParameter = (JRCrosstabParameter)this.parametersMap.remove(string);
        if (jRCrosstabParameter != null) {
            this.parametersList.remove(jRCrosstabParameter);
        }
        return jRCrosstabParameter;
    }

    public JRCrosstabParameter removeParameter(JRCrosstabParameter jRCrosstabParameter) {
        return this.removeParameter(jRCrosstabParameter.getName());
    }

    public void setParametersMapExpression(JRExpression jRExpression) {
        this.parametersMapExpression = jRExpression;
    }

    public Map getVariablesMap() {
        JRVariable[] jRVariableArray = this.getVariables();
        HashMap<String, JRVariable> hashMap = new HashMap<String, JRVariable>();
        int n = 0;
        while (n < jRVariableArray.length) {
            hashMap.put(jRVariableArray[n].getName(), jRVariableArray[n]);
            ++n;
        }
        return hashMap;
    }

    public JRVariable[] getVariables() {
        JRVariable[] jRVariableArray = new JRVariable[this.variablesList.size()];
        this.variablesList.values().toArray(jRVariableArray);
        return jRVariableArray;
    }

    public int getColumnBreakOffset() {
        return this.columnBreakOffset;
    }

    public void setColumnBreakOffset(int n) {
        this.columnBreakOffset = n;
    }

    public void preprocess() {
        this.setGroupVariablesClass(this.rowGroups);
        this.setGroupVariablesClass(this.columnGroups);
        this.calculateSizes();
    }

    protected void setGroupVariablesClass(List list) {
        for (JRDesignCrosstabGroup jRDesignCrosstabGroup : list) {
            JRExpression jRExpression;
            JRCrosstabBucket jRCrosstabBucket = jRDesignCrosstabGroup.getBucket();
            if (jRCrosstabBucket == null || (jRExpression = jRCrosstabBucket.getExpression()) == null) continue;
            jRDesignCrosstabGroup.designVariable.setValueClassName(jRExpression.getValueClassName());
        }
    }

    protected void calculateSizes() {
        this.setWhenNoDataCellSize();
        this.createCellMatrix();
        int n = this.calculateRowHeadersSizes();
        int n2 = this.calculateColumnHeadersSizes();
        if (this.headerCell != null) {
            this.headerCell.setWidth(n);
            this.headerCell.setHeight(n2);
        }
    }

    protected void setWhenNoDataCellSize() {
        if (this.whenNoDataCell != null) {
            this.whenNoDataCell.setWidth(this.getWidth());
            this.whenNoDataCell.setHeight(this.getHeight());
        }
    }

    protected void createCellMatrix() {
        this.crossCells = new JRDesignCrosstabCell[this.rowGroups.size() + 1][this.columnGroups.size() + 1];
        for (JRDesignCrosstabCell jRDesignCrosstabCell : this.cellsList) {
            int n;
            String string;
            int n2;
            JRDesignCellContents jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabCell.getContents();
            String string2 = jRDesignCrosstabCell.getRowTotalGroup();
            n2 = string2 == null ? (n2 = this.rowGroups.size()) : (Integer)this.rowGroupsMap.get(string2);
            Integer n3 = jRDesignCrosstabCell.getWidth();
            if (n3 != null) {
                jRDesignCellContents.setWidth(n3);
            }
            n = (string = jRDesignCrosstabCell.getColumnTotalGroup()) == null ? (n = this.columnGroups.size()) : (Integer)this.columnGroupsMap.get(string);
            Integer n4 = jRDesignCrosstabCell.getHeight();
            if (n4 != null) {
                jRDesignCellContents.setHeight(n4);
            }
            this.crossCells[n2][n] = jRDesignCrosstabCell;
        }
        this.inheritCells();
    }

    protected JRDesignCrosstabRowGroup getRowGroup(int n) {
        return (JRDesignCrosstabRowGroup)this.rowGroups.get(n);
    }

    protected JRDesignCrosstabColumnGroup getColumnGroup(int n) {
        return (JRDesignCrosstabColumnGroup)this.columnGroups.get(n);
    }

    protected void inheritCells() {
        int n = this.rowGroups.size();
        while (n >= 0) {
            int n2 = this.columnGroups.size();
            while (n2 >= 0) {
                boolean bl;
                boolean bl2 = bl = !(n != this.rowGroups.size() && !this.getRowGroup(n).hasTotal() || n2 != this.columnGroups.size() && !this.getColumnGroup(n2).hasTotal());
                if (bl) {
                    if (this.crossCells[n][n2] == null) {
                        this.inheritCell(n, n2);
                        if (this.crossCells[n][n2] == null) {
                            this.crossCells[n][n2] = this.emptyCell(n, n2);
                            this.inheritCellSize(n, n2);
                        }
                    } else {
                        this.inheritCellSize(n, n2);
                    }
                } else {
                    this.crossCells[n][n2] = null;
                }
                --n2;
            }
            --n;
        }
    }

    private JRDesignCrosstabCell emptyCell(int n, int n2) {
        JRDesignCrosstabCell jRDesignCrosstabCell = new JRDesignCrosstabCell();
        if (n < this.rowGroups.size()) {
            jRDesignCrosstabCell.setRowTotalGroup(((JRCrosstabRowGroup)this.rowGroups.get(n)).getName());
        }
        if (n2 < this.columnGroups.size()) {
            jRDesignCrosstabCell.setColumnTotalGroup(((JRCrosstabColumnGroup)this.columnGroups.get(n2)).getName());
        }
        return jRDesignCrosstabCell;
    }

    protected void inheritCellSize(int n, int n2) {
        JRDesignCrosstabCell jRDesignCrosstabCell;
        JRDesignCrosstabCell jRDesignCrosstabCell2 = this.crossCells[n][n2];
        JRDesignCellContents jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabCell2.getContents();
        if (jRDesignCellContents.getWidth() == Integer.MIN_VALUE) {
            if (n < this.rowGroups.size()) {
                jRDesignCrosstabCell = this.crossCells[this.rowGroups.size()][n2];
                if (jRDesignCrosstabCell != null) {
                    jRDesignCellContents.setWidth(jRDesignCrosstabCell.getContents().getWidth());
                }
            } else {
                int n3 = n2 + 1;
                while (n3 <= this.columnGroups.size()) {
                    if (this.crossCells[n][n3] != null) {
                        jRDesignCellContents.setWidth(this.crossCells[n][n3].getContents().getWidth());
                        break;
                    }
                    ++n3;
                }
            }
        }
        if (jRDesignCellContents.getHeight() == Integer.MIN_VALUE) {
            if (n2 < this.columnGroups.size()) {
                jRDesignCrosstabCell = this.crossCells[n][this.columnGroups.size()];
                if (jRDesignCrosstabCell != null) {
                    jRDesignCellContents.setHeight(jRDesignCrosstabCell.getContents().getHeight());
                }
            } else {
                int n4 = n + 1;
                while (n4 <= this.rowGroups.size()) {
                    if (this.crossCells[n4][n2] != null) {
                        jRDesignCellContents.setHeight(this.crossCells[n4][n2].getContents().getHeight());
                    }
                    ++n4;
                }
            }
        }
    }

    protected void inheritCell(int n, int n2) {
        JRDesignCellContents jRDesignCellContents;
        JRDesignCrosstabCell jRDesignCrosstabCell;
        int n3;
        JRDesignCellContents jRDesignCellContents2;
        JRDesignCrosstabCell jRDesignCrosstabCell2;
        JRDesignCrosstabCell jRDesignCrosstabCell3 = null;
        if (n2 < this.columnGroups.size()) {
            jRDesignCrosstabCell2 = this.crossCells[this.rowGroups.size()][n2];
            jRDesignCellContents2 = jRDesignCrosstabCell2 == null ? null : (JRDesignCellContents)jRDesignCrosstabCell2.getContents();
            n3 = n2 + 1;
            while (jRDesignCrosstabCell3 == null && n3 <= this.columnGroups.size()) {
                jRDesignCrosstabCell = this.crossCells[n][n3];
                if (jRDesignCrosstabCell != null) {
                    jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabCell.getContents();
                    if (jRDesignCellContents2 == null || jRDesignCellContents.getWidth() == jRDesignCellContents2.getWidth()) {
                        jRDesignCrosstabCell3 = jRDesignCrosstabCell;
                    }
                }
                ++n3;
            }
        }
        if (jRDesignCrosstabCell3 == null && n < this.rowGroups.size()) {
            jRDesignCrosstabCell2 = this.crossCells[n][this.columnGroups.size()];
            jRDesignCellContents2 = jRDesignCrosstabCell2 == null ? null : (JRDesignCellContents)jRDesignCrosstabCell2.getContents();
            n3 = n + 1;
            while (jRDesignCrosstabCell3 == null && n3 <= this.rowGroups.size()) {
                jRDesignCrosstabCell = this.crossCells[n3][n2];
                if (jRDesignCrosstabCell != null) {
                    jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabCell.getContents();
                    if (jRDesignCellContents2 == null || jRDesignCellContents.getHeight() == jRDesignCellContents2.getHeight()) {
                        jRDesignCrosstabCell3 = jRDesignCrosstabCell;
                    }
                }
                ++n3;
            }
        }
        this.crossCells[n][n2] = jRDesignCrosstabCell3;
    }

    protected int calculateRowHeadersSizes() {
        int n = 0;
        int n2 = this.rowGroups.size() - 1;
        int n3 = 0;
        while (n2 >= 0) {
            JRDesignCrosstabRowGroup jRDesignCrosstabRowGroup = (JRDesignCrosstabRowGroup)this.rowGroups.get(n2);
            n += jRDesignCrosstabRowGroup.getWidth();
            JRDesignCrosstabCell jRDesignCrosstabCell = this.crossCells[n2 + 1][this.columnGroups.size()];
            if (jRDesignCrosstabCell != null) {
                n3 += jRDesignCrosstabCell.getContents().getHeight();
            }
            JRDesignCellContents jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabRowGroup.getHeader();
            jRDesignCellContents.setHeight(n3);
            jRDesignCellContents.setWidth(jRDesignCrosstabRowGroup.getWidth());
            if (jRDesignCrosstabRowGroup.hasTotal()) {
                JRDesignCellContents jRDesignCellContents2 = (JRDesignCellContents)jRDesignCrosstabRowGroup.getTotalHeader();
                jRDesignCellContents2.setWidth(n);
                JRDesignCrosstabCell jRDesignCrosstabCell2 = this.crossCells[n2][this.columnGroups.size()];
                if (jRDesignCrosstabCell2 != null) {
                    jRDesignCellContents2.setHeight(jRDesignCrosstabCell2.getContents().getHeight());
                }
            }
            --n2;
        }
        return n;
    }

    protected int calculateColumnHeadersSizes() {
        int n = 0;
        int n2 = this.columnGroups.size() - 1;
        int n3 = 0;
        while (n2 >= 0) {
            JRDesignCrosstabColumnGroup jRDesignCrosstabColumnGroup = (JRDesignCrosstabColumnGroup)this.columnGroups.get(n2);
            n += jRDesignCrosstabColumnGroup.getHeight();
            JRDesignCrosstabCell jRDesignCrosstabCell = this.crossCells[this.rowGroups.size()][n2 + 1];
            if (jRDesignCrosstabCell != null) {
                n3 += jRDesignCrosstabCell.getContents().getWidth();
            }
            JRDesignCellContents jRDesignCellContents = (JRDesignCellContents)jRDesignCrosstabColumnGroup.getHeader();
            jRDesignCellContents.setHeight(jRDesignCrosstabColumnGroup.getHeight());
            jRDesignCellContents.setWidth(n3);
            if (jRDesignCrosstabColumnGroup.hasTotal()) {
                JRDesignCellContents jRDesignCellContents2 = (JRDesignCellContents)jRDesignCrosstabColumnGroup.getTotalHeader();
                jRDesignCellContents2.setHeight(n);
                JRDesignCrosstabCell jRDesignCrosstabCell2 = this.crossCells[this.rowGroups.size()][n2];
                if (jRDesignCrosstabCell2 != null) {
                    jRDesignCellContents2.setWidth(jRDesignCrosstabCell2.getContents().getWidth());
                }
            }
            --n2;
        }
        return n;
    }

    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public void setWhenNoDataCell(JRDesignCellContents jRDesignCellContents) {
        this.whenNoDataCell = jRDesignCellContents;
    }

    public JRElement getElementByKey(String string) {
        return JRBaseCrosstab.getElementByKey(this, string);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    public void setHeaderCell(JRDesignCellContents jRDesignCellContents) {
        this.headerCell = jRDesignCellContents;
    }

    protected void measureClassChanged(JRDesignCrosstabMeasure jRDesignCrosstabMeasure, String string) {
        for (JRCrosstabGroup jRCrosstabGroup : this.columnGroups) {
            this.setTotalVarClass(jRDesignCrosstabMeasure, null, (JRCrosstabColumnGroup)jRCrosstabGroup, string);
        }
        for (JRCrosstabGroup jRCrosstabGroup : this.rowGroups) {
            this.setTotalVarClass(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, null, string);
            for (JRCrosstabColumnGroup jRCrosstabColumnGroup : this.columnGroups) {
                this.setTotalVarClass(jRDesignCrosstabMeasure, (JRCrosstabRowGroup)jRCrosstabGroup, jRCrosstabColumnGroup, string);
            }
        }
    }

    protected void setTotalVarClass(JRCrosstabMeasure jRCrosstabMeasure, JRCrosstabRowGroup jRCrosstabRowGroup, JRCrosstabColumnGroup jRCrosstabColumnGroup, String string) {
        JRDesignVariable jRDesignVariable = this.getVariable(JRDesignCrosstab.getTotalVariableName(jRCrosstabMeasure, jRCrosstabRowGroup, jRCrosstabColumnGroup));
        jRDesignVariable.setValueClassName(string);
    }

    private void addVariable(JRVariable jRVariable) {
        this.variablesList.put(jRVariable.getName(), jRVariable);
    }

    private void removeVariable(JRVariable jRVariable) {
        this.removeVariable(jRVariable.getName());
    }

    private void removeVariable(String string) {
        this.variablesList.remove(string);
    }

    private JRDesignVariable getVariable(String string) {
        return (JRDesignVariable)this.variablesList.get(string);
    }

    private class MeasureClassChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 10200L;

        private MeasureClassChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JRDesignCrosstab.this.measureClassChanged((JRDesignCrosstabMeasure)propertyChangeEvent.getSource(), (String)propertyChangeEvent.getNewValue());
        }
    }

    private static class Pair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Object o1;
        final Object o2;

        Pair(Object object, Object object2) {
            this.o1 = object;
            this.o2 = object2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !(object instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)object;
            return (pair.o1 == null ? this.o1 == null : this.o1 != null && pair.o1.equals(this.o1)) && (pair.o2 == null ? this.o2 == null : this.o2 != null && pair.o2.equals(this.o2));
        }

        public int hashCode() {
            int n = this.o1 == null ? 0 : this.o1.hashCode();
            n *= 31;
            return n += this.o2 == null ? 0 : this.o2.hashCode();
        }
    }
}

