/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;

public class PushbuttonField
extends BaseField {
    public static final int LAYOUT_LABEL_ONLY = 1;
    public static final int LAYOUT_ICON_ONLY = 2;
    public static final int LAYOUT_ICON_TOP_LABEL_BOTTOM = 3;
    public static final int LAYOUT_LABEL_TOP_ICON_BOTTOM = 4;
    public static final int LAYOUT_ICON_LEFT_LABEL_RIGHT = 5;
    public static final int LAYOUT_LABEL_LEFT_ICON_RIGHT = 6;
    public static final int LAYOUT_LABEL_OVER_ICON = 7;
    public static final int SCALE_ICON_ALWAYS = 1;
    public static final int SCALE_ICON_NEVER = 2;
    public static final int SCALE_ICON_IS_TOO_BIG = 3;
    public static final int SCALE_ICON_IS_TOO_SMALL = 4;
    private int layout = 1;
    private Image image;
    private PdfTemplate template;
    private int scaleIcon = 1;
    private boolean proportionalIcon = true;
    private float iconVerticalAdjustment = 0.5f;
    private float iconHorizontalAdjustment = 0.5f;
    private boolean iconFitToBounds;
    private PdfTemplate tp;
    private PRIndirectReference iconReference;

    public PushbuttonField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        super(pdfWriter, rectangle, string);
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int n) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Layout out of bounds.");
        }
        this.layout = n;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.template = null;
    }

    public PdfTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(PdfTemplate pdfTemplate) {
        this.template = pdfTemplate;
        this.image = null;
    }

    public int getScaleIcon() {
        return this.scaleIcon;
    }

    public void setScaleIcon(int n) {
        if (n < 1 || n > 4) {
            n = 1;
        }
        this.scaleIcon = n;
    }

    public boolean isProportionalIcon() {
        return this.proportionalIcon;
    }

    public void setProportionalIcon(boolean bl) {
        this.proportionalIcon = bl;
    }

    public float getIconVerticalAdjustment() {
        return this.iconVerticalAdjustment;
    }

    public void setIconVerticalAdjustment(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.iconVerticalAdjustment = f;
    }

    public float getIconHorizontalAdjustment() {
        return this.iconHorizontalAdjustment;
    }

    public void setIconHorizontalAdjustment(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.iconHorizontalAdjustment = f;
    }

    private float calculateFontSize(float f, float f2) throws IOException, DocumentException {
        BaseFont baseFont = this.getRealFont();
        float f3 = this.fontSize;
        if (f3 == 0.0f) {
            float f4 = baseFont.getWidthPoint(this.text, 1.0f);
            f3 = f4 == 0.0f ? 12.0f : f / f4;
            float f5 = f2 / (1.0f - baseFont.getFontDescriptor(3, 1.0f));
            if ((f3 = Math.min(f3, f5)) < 4.0f) {
                f3 = 4.0f;
            }
        }
        return f3;
    }

    public PdfAppearance getAppearance() throws IOException, DocumentException {
        float f;
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        Rectangle rectangle = new Rectangle(pdfAppearance.getBoundingBox());
        if ((this.text == null || this.text.length() == 0) && (this.layout == 1 || this.image == null && this.template == null && this.iconReference == null)) {
            return pdfAppearance;
        }
        if (this.layout == 2 && this.image == null && this.template == null && this.iconReference == null) {
            return pdfAppearance;
        }
        BaseFont baseFont = this.getRealFont();
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        rectangle.height();
        float f2 = this.borderWidth;
        if (bl) {
            f2 *= 2.0f;
        }
        float f3 = bl ? 2.0f * this.borderWidth : this.borderWidth;
        f3 = Math.max(f3, 1.0f);
        float f4 = Math.min(f2, f3);
        this.tp = null;
        float f5 = Float.NaN;
        float f6 = 0.0f;
        float f7 = this.fontSize;
        float f8 = rectangle.width() - 2.0f * f4 - 2.0f;
        float f9 = rectangle.height() - 2.0f * f4;
        float f10 = this.iconFitToBounds ? 0.0f : f4 + 1.0f;
        int n = this.layout;
        if (this.image == null && this.template == null && this.iconReference == null) {
            n = 1;
        }
        Rectangle rectangle2 = null;
        block18: while (true) {
            switch (n) {
                case 1: 
                case 7: {
                    if (this.text != null && this.text.length() > 0 && f8 > 0.0f && f9 > 0.0f) {
                        f7 = this.calculateFontSize(f8, f9);
                        f5 = (rectangle.width() - baseFont.getWidthPoint(this.text, f7)) / 2.0f;
                        f6 = (rectangle.height() - baseFont.getFontDescriptor(1, f7)) / 2.0f;
                    }
                }
                case 2: {
                    if (n != 7 && n != 2) break block18;
                    rectangle2 = new Rectangle(rectangle.left() + f10, rectangle.bottom() + f10, rectangle.right() - f10, rectangle.top() - f10);
                    break block18;
                }
                case 3: {
                    if (this.text == null || this.text.length() == 0 || f8 <= 0.0f || f9 <= 0.0f) {
                        n = 2;
                        continue block18;
                    }
                    float f11 = rectangle.height() * 0.35f - f4;
                    f7 = f11 > 0.0f ? this.calculateFontSize(f8, f11) : 4.0f;
                    f5 = (rectangle.width() - baseFont.getWidthPoint(this.text, f7)) / 2.0f;
                    f6 = f4 - baseFont.getFontDescriptor(3, f7);
                    rectangle2 = new Rectangle(rectangle.left() + f10, f6 + f7, rectangle.right() - f10, rectangle.top() - f10);
                    break block18;
                }
                case 4: {
                    if (this.text == null || this.text.length() == 0 || f8 <= 0.0f || f9 <= 0.0f) {
                        n = 2;
                        continue block18;
                    }
                    float f11 = rectangle.height() * 0.35f - f4;
                    f7 = f11 > 0.0f ? this.calculateFontSize(f8, f11) : 4.0f;
                    f5 = (rectangle.width() - baseFont.getWidthPoint(this.text, f7)) / 2.0f;
                    f6 = rectangle.height() - f4 - f7;
                    if (f6 < f4) {
                        f6 = f4;
                    }
                    rectangle2 = new Rectangle(rectangle.left() + f10, rectangle.bottom() + f10, rectangle.right() - f10, f6 + baseFont.getFontDescriptor(3, f7));
                    break block18;
                }
                case 6: {
                    if (this.text == null || this.text.length() == 0 || f8 <= 0.0f || f9 <= 0.0f) {
                        n = 2;
                        continue block18;
                    }
                    f = rectangle.width() * 0.35f - f4;
                    f7 = f > 0.0f ? this.calculateFontSize(f8, f) : 4.0f;
                    if (baseFont.getWidthPoint(this.text, f7) >= f8) {
                        n = 1;
                        f7 = this.fontSize;
                        continue block18;
                    }
                    f5 = f4 + 1.0f;
                    f6 = (rectangle.height() - baseFont.getFontDescriptor(1, f7)) / 2.0f;
                    rectangle2 = new Rectangle(f5 + baseFont.getWidthPoint(this.text, f7), rectangle.bottom() + f10, rectangle.right() - f10, rectangle.top() - f10);
                    break block18;
                }
                case 5: {
                    if (this.text == null || this.text.length() == 0 || f8 <= 0.0f || f9 <= 0.0f) {
                        n = 2;
                        continue block18;
                    }
                    f = rectangle.width() * 0.35f - f4;
                    f7 = f > 0.0f ? this.calculateFontSize(f8, f) : 4.0f;
                    if (baseFont.getWidthPoint(this.text, f7) >= f8) {
                        n = 1;
                        f7 = this.fontSize;
                        continue block18;
                    }
                    f5 = rectangle.width() - baseFont.getWidthPoint(this.text, f7) - f4 - 1.0f;
                    f6 = (rectangle.height() - baseFont.getFontDescriptor(1, f7)) / 2.0f;
                    rectangle2 = new Rectangle(rectangle.left() + f10, rectangle.bottom() + f10, f5 - 1.0f, rectangle.top() - f10);
                }
            }
            break;
        }
        if (f6 < rectangle.bottom() + f4) {
            f6 = rectangle.bottom() + f4;
        }
        if (rectangle2 != null && (rectangle2.width() <= 0.0f || rectangle2.height() <= 0.0f)) {
            rectangle2 = null;
        }
        boolean bl2 = false;
        f = 0.0f;
        float f12 = 0.0f;
        PdfArray pdfArray = null;
        if (rectangle2 != null) {
            PdfDictionary pdfDictionary;
            if (this.image != null) {
                this.tp = new PdfTemplate(this.writer);
                this.tp.setBoundingBox(new Rectangle(this.image));
                this.writer.addDirectTemplateSimple(this.tp, PdfName.FRM);
                this.tp.addImage(this.image, this.image.width(), 0.0f, 0.0f, this.image.height(), 0.0f, 0.0f);
                bl2 = true;
                f = this.tp.getBoundingBox().width();
                f12 = this.tp.getBoundingBox().height();
            } else if (this.template != null) {
                this.tp = new PdfTemplate(this.writer);
                this.tp.setBoundingBox(new Rectangle(this.template.getWidth(), this.template.getHeight()));
                this.writer.addDirectTemplateSimple(this.tp, PdfName.FRM);
                this.tp.addTemplate(this.template, this.template.getBoundingBox().left(), this.template.getBoundingBox().bottom());
                bl2 = true;
                f = this.tp.getBoundingBox().width();
                f12 = this.tp.getBoundingBox().height();
            } else if (this.iconReference != null && (pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.iconReference)) != null) {
                Rectangle rectangle3 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BBOX)));
                pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MATRIX));
                bl2 = true;
                f = rectangle3.width();
                f12 = rectangle3.height();
            }
        }
        if (bl2) {
            float f13 = rectangle2.width() / f;
            float f14 = rectangle2.height() / f12;
            if (this.proportionalIcon) {
                switch (this.scaleIcon) {
                    case 3: {
                        f13 = Math.min(f13, f14);
                        f13 = Math.min(f13, 1.0f);
                        break;
                    }
                    case 4: {
                        f13 = Math.min(f13, f14);
                        f13 = Math.max(f13, 1.0f);
                        break;
                    }
                    case 2: {
                        f13 = 1.0f;
                        break;
                    }
                    default: {
                        f13 = Math.min(f13, f14);
                    }
                }
                f14 = f13;
            } else {
                switch (this.scaleIcon) {
                    case 3: {
                        f13 = Math.min(f13, 1.0f);
                        f14 = Math.min(f14, 1.0f);
                        break;
                    }
                    case 4: {
                        f13 = Math.max(f13, 1.0f);
                        f14 = Math.max(f14, 1.0f);
                        break;
                    }
                    case 2: {
                        f14 = 1.0f;
                        f13 = 1.0f;
                        break;
                    }
                }
            }
            float f15 = rectangle2.left() + (rectangle2.width() - f * f13) * this.iconHorizontalAdjustment;
            float f16 = rectangle2.bottom() + (rectangle2.height() - f12 * f14) * this.iconVerticalAdjustment;
            pdfAppearance.saveState();
            pdfAppearance.rectangle(rectangle2.left(), rectangle2.bottom(), rectangle2.width(), rectangle2.height());
            pdfAppearance.clip();
            pdfAppearance.newPath();
            if (this.tp != null) {
                pdfAppearance.addTemplate(this.tp, f13, 0.0f, 0.0f, f14, f15, f16);
            } else {
                float f17 = 0.0f;
                float f18 = 0.0f;
                if (pdfArray != null && pdfArray.size() == 6) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject((PdfObject)pdfArray.getArrayList().get(4));
                    if (pdfNumber != null) {
                        f17 = pdfNumber.floatValue();
                    }
                    if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject((PdfObject)pdfArray.getArrayList().get(5))) != null) {
                        f18 = pdfNumber.floatValue();
                    }
                }
                pdfAppearance.addTemplateReference(this.iconReference, PdfName.FRM, f13, 0.0f, 0.0f, f14, f15 - f17 * f13, f16 - f18 * f14);
            }
            pdfAppearance.restoreState();
        }
        if (!Float.isNaN(f5)) {
            pdfAppearance.saveState();
            pdfAppearance.rectangle(f4, f4, rectangle.width() - 2.0f * f4, rectangle.height() - 2.0f * f4);
            pdfAppearance.clip();
            pdfAppearance.newPath();
            if (this.textColor == null) {
                pdfAppearance.resetGrayFill();
            } else {
                pdfAppearance.setColorFill(this.textColor);
            }
            pdfAppearance.beginText();
            pdfAppearance.setFontAndSize(baseFont, f7);
            pdfAppearance.setTextMatrix(f5, f6);
            pdfAppearance.showText(this.text);
            pdfAppearance.endText();
            pdfAppearance.restoreState();
        }
        return pdfAppearance;
    }

    public PdfFormField getField() throws IOException, DocumentException {
        PdfFormField pdfFormField = PdfFormField.createPushButton(this.writer);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
        }
        if (this.text != null) {
            pdfFormField.setMKNormalCaption(this.text);
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance pdfAppearance = this.getAppearance();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        if (this.tp != null) {
            pdfFormField.setMKNormalIcon(this.tp);
        }
        pdfFormField.setMKTextPosition(this.layout - 1);
        PdfName pdfName = PdfName.A;
        if (this.scaleIcon == 3) {
            pdfName = PdfName.B;
        } else if (this.scaleIcon == 4) {
            pdfName = PdfName.S;
        } else if (this.scaleIcon == 2) {
            pdfName = PdfName.N;
        }
        pdfFormField.setMKIconFit(pdfName, this.proportionalIcon ? PdfName.P : PdfName.A, this.iconHorizontalAdjustment, this.iconVerticalAdjustment, this.iconFitToBounds);
        return pdfFormField;
    }

    public boolean isIconFitToBounds() {
        return this.iconFitToBounds;
    }

    public void setIconFitToBounds(boolean bl) {
        this.iconFitToBounds = bl;
    }

    public PRIndirectReference getIconReference() {
        return this.iconReference;
    }

    public void setIconReference(PRIndirectReference pRIndirectReference) {
        this.iconReference = pRIndirectReference;
    }
}

