/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public abstract class TypeBinding
extends Binding {
    public int id = Integer.MAX_VALUE;
    public long tagBits = 0L;
    public static final BaseTypeBinding INT = new BaseTypeBinding(10, TypeConstants.INT, new char[]{'I'});
    public static final BaseTypeBinding BYTE = new BaseTypeBinding(3, TypeConstants.BYTE, new char[]{'B'});
    public static final BaseTypeBinding SHORT = new BaseTypeBinding(4, TypeConstants.SHORT, new char[]{'S'});
    public static final BaseTypeBinding CHAR = new BaseTypeBinding(2, TypeConstants.CHAR, new char[]{'C'});
    public static final BaseTypeBinding LONG = new BaseTypeBinding(7, TypeConstants.LONG, new char[]{'J'});
    public static final BaseTypeBinding FLOAT = new BaseTypeBinding(9, TypeConstants.FLOAT, new char[]{'F'});
    public static final BaseTypeBinding DOUBLE = new BaseTypeBinding(8, TypeConstants.DOUBLE, new char[]{'D'});
    public static final BaseTypeBinding BOOLEAN = new BaseTypeBinding(5, TypeConstants.BOOLEAN, new char[]{'Z'});
    public static final BaseTypeBinding NULL = new BaseTypeBinding(12, TypeConstants.NULL, new char[]{'N'});
    public static final BaseTypeBinding VOID = new BaseTypeBinding(6, TypeConstants.VOID, new char[]{'V'});

    public static final TypeBinding wellKnownType(Scope scope, int n) {
        switch (n) {
            case 5: {
                return BOOLEAN;
            }
            case 3: {
                return BYTE;
            }
            case 2: {
                return CHAR;
            }
            case 4: {
                return SHORT;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return FLOAT;
            }
            case 10: {
                return INT;
            }
            case 7: {
                return LONG;
            }
            case 1: {
                return scope.getJavaLangObject();
            }
            case 11: {
                return scope.getJavaLangString();
            }
        }
        return null;
    }

    public boolean canBeInstantiated() {
        return !this.isBaseType();
    }

    public TypeBinding capture(Scope scope, int n) {
        return this;
    }

    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, Map map, int n) {
    }

    public abstract char[] constantPoolName();

    public String debugName() {
        return new String(this.readableName());
    }

    public int dimensions() {
        return 0;
    }

    public ReferenceBinding enclosingType() {
        return null;
    }

    public TypeBinding erasure() {
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public TypeBinding findSuperTypeWithSameErasure(TypeBinding var1_1) {
        if (this == var1_1) {
            return this;
        }
        if (var1_1 == null) {
            return null;
        }
        switch (this.kind()) {
            case 68: {
                var2_2 = (ArrayBinding)this;
                var3_3 = var1_1.dimensions();
                if (var2_2.dimensions != var3_3) {
                    switch (var1_1.id) {
                        case 1: 
                        case 36: 
                        case 37: {
                            return var1_1;
                        }
                    }
                    if (var3_3 < var2_2.dimensions & var1_1.leafComponentType().id == 1) {
                        return var1_1;
                    }
                    return null;
                }
                if (!(var2_2.leafComponentType instanceof ReferenceBinding)) {
                    return null;
                }
                var4_4 = var2_2.leafComponentType.findSuperTypeWithSameErasure(var1_1.leafComponentType());
                if (var4_4 == null) {
                    return null;
                }
                return var2_2.environment().createArrayType(var4_4, var2_2.dimensions);
            }
            case 4100: {
                if (this.isCapture()) {
                    var5_5 = (CaptureBinding)this;
                    var6_6 = var5_5.firstBound;
                    if (var6_6 instanceof ArrayBinding && (var7_7 = var6_6.findSuperTypeWithSameErasure(var1_1)) != null) {
                        return var7_7;
                    }
                }
            }
            case 4: 
            case 260: 
            case 516: 
            case 1028: 
            case 2052: {
                if (!var1_1.isTypeVariable() && !var1_1.isIntersectionType()) {
                    var1_1 = var1_1.erasure();
                }
                if (this == var1_1 || !this.isTypeVariable() && !this.isIntersectionType() && this.erasure() == var1_1) {
                    return this;
                }
                var5_5 = (ReferenceBinding)this;
                if (!var1_1.isInterface()) {
                    while ((var5_5 = var5_5.superclass()) != null) {
                        if (var5_5 != var1_1 && (var5_5.isTypeVariable() || var5_5.isIntersectionType() || var5_5.erasure() != var1_1)) continue;
                        return var5_5;
                    }
                    return null;
                }
                var6_6 = null;
                var7_8 = 0;
                do {
                    if ((var8_9 = var5_5.superInterfaces()) == Binding.NO_SUPERINTERFACES) continue;
                    if (var6_6 == null) {
                        var6_6 = var8_9;
                        var7_8 = var6_6.length;
                        continue;
                    }
                    var9_11 = var8_9.length;
                    if (var7_8 + var9_11 >= var6_6.length) {
                        v0 = var6_6;
                        var6_6 = new ReferenceBinding[var7_8 + var9_11 + 5];
                        System.arraycopy(v0, 0, var6_6, 0, var7_8);
                    }
                    var10_13 = 0;
                    while (var10_13 < var9_11) {
                        var11_14 = var8_9[var10_13];
                        var12_16 = 0;
                        while (var12_16 < var7_8) {
                            if (var11_14 != var6_6[var12_16]) {
                                ++var12_16;
                                continue;
                            }
                            ** GOTO lbl62
                        }
                        var6_6[var7_8++] = var11_14;
lbl62:
                        // 2 sources

                        ++var10_13;
                    }
                } while ((var5_5 = var5_5.superclass()) != null);
                var8_10 = 0;
                while (var8_10 < var7_8) {
                    var5_5 = var6_6[var8_10];
                    if (var5_5 == var1_1 || !var5_5.isTypeVariable() && !var5_5.isIntersectionType() && var5_5.erasure() == var1_1) {
                        return var5_5;
                    }
                    var9_12 = var5_5.superInterfaces();
                    if (var9_12 == Binding.NO_SUPERINTERFACES) ** GOTO lbl89
                    var10_13 = var9_12.length;
                    if (var7_8 + var10_13 >= var6_6.length) {
                        v1 = var6_6;
                        var6_6 = new ReferenceBinding[var7_8 + var10_13 + 5];
                        System.arraycopy(v1, 0, var6_6, 0, var7_8);
                    }
                    var11_15 = 0;
                    while (var11_15 < var10_13) {
                        var12_18 = var9_12[var11_15];
                        var13_19 = 0;
                        while (var13_19 < var7_8) {
                            if (var12_18 != var6_6[var13_19]) {
                                ++var13_19;
                                continue;
                            }
                            ** GOTO lbl87
                        }
                        var6_6[var7_8++] = var12_18;
lbl87:
                        // 2 sources

                        ++var11_15;
                    }
lbl89:
                    // 2 sources

                    ++var8_10;
                }
                break;
            }
        }
        return null;
    }

    public TypeBinding genericCast(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return null;
        }
        TypeBinding typeBinding2 = typeBinding.erasure();
        if (typeBinding2 == this.erasure()) {
            return null;
        }
        return typeBinding2;
    }

    public char[] genericTypeSignature() {
        return this.signature();
    }

    public abstract PackageBinding getPackage();

    public boolean isAnnotationType() {
        return false;
    }

    public final boolean isAnonymousType() {
        return (this.tagBits & 0x20L) != 0L;
    }

    public final boolean isArrayType() {
        return (this.tagBits & 1L) != 0L;
    }

    public final boolean isBaseType() {
        return (this.tagBits & 2L) != 0L;
    }

    public boolean isBoundParameterizedType() {
        return (this.tagBits & 0x800000L) != 0L;
    }

    public boolean isCapture() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public abstract boolean isCompatibleWith(TypeBinding var1);

    public boolean isEnum() {
        return false;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        if (typeBinding.isWildcard()) {
            return ((WildcardBinding)typeBinding).boundCheck(this);
        }
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public final boolean isHierarchyInconsistent() {
        return (this.tagBits & 0x20000L) != 0L;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isIntersectingWith(TypeBinding typeBinding) {
        return this == typeBinding;
    }

    public boolean isIntersectionType() {
        return false;
    }

    public final boolean isLocalType() {
        return (this.tagBits & 0x10L) != 0L;
    }

    public final boolean isMemberType() {
        return (this.tagBits & 8L) != 0L;
    }

    public final boolean isNestedType() {
        return (this.tagBits & 4L) != 0L;
    }

    public final boolean isNumericType() {
        switch (this.id) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isParameterizedWithOwnVariables() {
        if (this.kind() != 260) {
            return false;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this;
        if (parameterizedTypeBinding.arguments == null) {
            return false;
        }
        TypeVariableBinding[] typeVariableBindingArray = this.erasure().typeVariables();
        int n = 0;
        int n2 = typeVariableBindingArray.length;
        while (n < n2) {
            if (typeVariableBindingArray[n] != parameterizedTypeBinding.arguments[n]) {
                return false;
            }
            ++n;
        }
        ReferenceBinding referenceBinding = parameterizedTypeBinding.enclosingType();
        return referenceBinding == null || !referenceBinding.erasure().isGenericType() || referenceBinding.isParameterizedWithOwnVariables();
    }

    public boolean isProvablyDistinctFrom(TypeBinding typeBinding, int n) {
        if (this == typeBinding) {
            return false;
        }
        if (n > 1) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 4100: {
                return false;
            }
        }
        switch (this.kind()) {
            case 516: 
            case 4100: {
                return false;
            }
            case 260: {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this;
                if (parameterizedTypeBinding.type.isProvablyDistinctFrom(typeBinding.erasure(), n)) {
                    return true;
                }
                switch (typeBinding.kind()) {
                    case 1028: 
                    case 2052: {
                        return false;
                    }
                    case 260: {
                        TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
                        if (typeBindingArray == null) {
                            return false;
                        }
                        ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)typeBinding;
                        TypeBinding[] typeBindingArray2 = parameterizedTypeBinding2.arguments;
                        if (typeBindingArray2 == null) {
                            return false;
                        }
                        int n2 = 0;
                        int n3 = typeBindingArray.length;
                        while (n2 < n3) {
                            if (typeBindingArray[n2].isProvablyDistinctFrom(typeBindingArray2[n2], n + 1)) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }
                }
                break;
            }
            case 1028: {
                if (n > 0) {
                    return true;
                }
                return this.erasure().isProvablyDistinctFrom(typeBinding.erasure(), 0);
            }
            case 2052: {
                if (n > 0) {
                    return true;
                }
                return this != typeBinding.erasure();
            }
        }
        return this != typeBinding;
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isReifiable() {
        TypeBinding typeBinding = this.leafComponentType();
        if (!(typeBinding instanceof ReferenceBinding)) {
            return true;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        do {
            switch (referenceBinding.kind()) {
                case 516: 
                case 2052: 
                case 4100: {
                    return false;
                }
                case 260: {
                    if (!referenceBinding.isBoundParameterizedType()) break;
                    return false;
                }
                case 1028: {
                    return true;
                }
            }
            if (referenceBinding.isStatic()) {
                return true;
            }
            if (!referenceBinding.isLocalType()) continue;
            NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)referenceBinding.erasure();
            if (!nestedTypeBinding.scope.methodScope().isStatic) continue;
            return true;
        } while ((referenceBinding = referenceBinding.enclosingType()) != null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public boolean isTypeArgumentContainedBy(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: {
                TypeBinding typeBinding2;
                WildcardBinding wildcardBinding;
                TypeBinding typeBinding3 = this;
                TypeBinding typeBinding4 = this;
                switch (this.kind()) {
                    case 516: {
                        wildcardBinding = (WildcardBinding)this;
                        switch (wildcardBinding.boundKind) {
                            case 1: {
                                if (wildcardBinding.otherBounds != null) break;
                                typeBinding4 = wildcardBinding.bound;
                                typeBinding3 = null;
                                break;
                            }
                            case 2: {
                                typeBinding4 = wildcardBinding;
                                typeBinding3 = wildcardBinding.bound;
                                break;
                            }
                            case 0: {
                                typeBinding4 = wildcardBinding;
                                typeBinding3 = null;
                            }
                        }
                        break;
                    }
                    case 4100: {
                        if (!this.isCapture()) break;
                        typeBinding2 = (CaptureBinding)this;
                        if (((CaptureBinding)typeBinding2).lowerBound == null) break;
                        typeBinding3 = ((CaptureBinding)typeBinding2).lowerBound;
                        break;
                    }
                }
                wildcardBinding = (WildcardBinding)typeBinding;
                if (wildcardBinding.otherBounds != null) {
                    return false;
                }
                typeBinding2 = wildcardBinding.bound;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        if (typeBinding2 == this) {
                            return true;
                        }
                        if (typeBinding4 == null) {
                            return false;
                        }
                        TypeBinding typeBinding5 = typeBinding4.findSuperTypeWithSameErasure(typeBinding2);
                        if (typeBinding5 == null) return typeBinding4.isCompatibleWith(typeBinding2);
                        if (!(typeBinding5 = typeBinding5.leafComponentType()).isRawType()) return typeBinding4.isCompatibleWith(typeBinding2);
                        if (typeBinding5 != typeBinding2.leafComponentType()) return false;
                        return true;
                    }
                    case 2: {
                        if (typeBinding2 == this) {
                            return true;
                        }
                        if (typeBinding3 == null) {
                            return false;
                        }
                        TypeBinding typeBinding6 = typeBinding2.findSuperTypeWithSameErasure(typeBinding3);
                        if (typeBinding6 == null) return typeBinding2.isCompatibleWith(typeBinding3);
                        if (!(typeBinding6 = typeBinding6.leafComponentType()).isRawType()) return typeBinding2.isCompatibleWith(typeBinding3);
                        if (typeBinding6 != typeBinding3.leafComponentType()) return false;
                        return true;
                    }
                }
                return true;
            }
            case 260: {
                int n;
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                if (!this.isParameterizedType()) {
                    return false;
                }
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this;
                ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)typeBinding;
                if (parameterizedTypeBinding.type != parameterizedTypeBinding2.type) {
                    return false;
                }
                if (!parameterizedTypeBinding.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                    typeBindingArray = parameterizedTypeBinding2.enclosingType();
                    if (typeBindingArray == null) {
                        return false;
                    }
                    if ((typeBindingArray.tagBits & 0x40000000L) == 0L ? referenceBinding != typeBindingArray : !referenceBinding.isEquivalentTo(parameterizedTypeBinding2.enclosingType())) {
                        return false;
                    }
                }
                int n2 = parameterizedTypeBinding.arguments == null ? 0 : parameterizedTypeBinding.arguments.length;
                typeBindingArray = parameterizedTypeBinding2.arguments;
                int n3 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
                if (n != n2) {
                    return false;
                }
                int n4 = 0;
                while (n4 < n2) {
                    TypeBinding typeBinding7 = parameterizedTypeBinding.arguments[n4];
                    TypeBinding typeBinding8 = typeBindingArray[n4];
                    if (typeBinding7 != typeBinding8) {
                        int n5 = typeBinding7.kind();
                        if (typeBinding8.kind() != n5) {
                            return false;
                        }
                        block17 : switch (n5) {
                            case 260: {
                                if (!typeBinding7.isTypeArgumentContainedBy(typeBinding8)) return false;
                                break;
                            }
                            case 516: {
                                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding7;
                                WildcardBinding wildcardBinding2 = (WildcardBinding)typeBinding8;
                                switch (wildcardBinding.boundKind) {
                                    case 1: {
                                        if (wildcardBinding2.boundKind != 0) return false;
                                        if (wildcardBinding.bound != wildcardBinding.typeVariable().upperBound()) return false;
                                        break block17;
                                    }
                                    case 2: {
                                        break;
                                    }
                                    case 0: {
                                        if (wildcardBinding2.boundKind != 1) return false;
                                        if (wildcardBinding2.bound != wildcardBinding2.typeVariable().upperBound()) return false;
                                        break block17;
                                    }
                                }
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    ++n4;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isTypeArgumentIntersecting(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        switch (this.kind()) {
            case 4100: {
                return true;
            }
            case 516: {
                switch (typeBinding.kind()) {
                    case 4100: {
                        return true;
                    }
                    case 516: {
                        TypeBinding typeBinding2 = null;
                        TypeBinding typeBinding3 = null;
                        WildcardBinding wildcardBinding = (WildcardBinding)this;
                        switch (wildcardBinding.boundKind) {
                            case 1: {
                                typeBinding3 = wildcardBinding.bound;
                                break;
                            }
                            case 2: {
                                typeBinding2 = wildcardBinding.bound;
                            }
                        }
                        TypeBinding typeBinding4 = null;
                        TypeBinding typeBinding5 = null;
                        WildcardBinding wildcardBinding2 = (WildcardBinding)typeBinding;
                        switch (wildcardBinding2.boundKind) {
                            case 1: {
                                typeBinding5 = wildcardBinding2.bound;
                                break;
                            }
                            case 2: {
                                typeBinding4 = wildcardBinding2.bound;
                            }
                        }
                        if (typeBinding2 != null) {
                            if (typeBinding4 != null) {
                                return true;
                            }
                            if (typeBinding5 != null) {
                                return typeBinding2.isCompatibleWith(typeBinding5);
                            }
                            return true;
                        }
                        if (typeBinding3 != null) {
                            if (typeBinding3.isTypeVariable()) {
                                return true;
                            }
                            if (typeBinding4 != null) {
                                return typeBinding4.isCompatibleWith(typeBinding3);
                            }
                            if (typeBinding5 != null) {
                                if (typeBinding3.isInterface()) {
                                    if (typeBinding5.isInterface()) {
                                        return true;
                                    }
                                    if (typeBinding5.isArrayType() || typeBinding5 instanceof ReferenceBinding && ((ReferenceBinding)typeBinding5).isFinal()) {
                                        return typeBinding5.isCompatibleWith(typeBinding3);
                                    }
                                    return true;
                                }
                                if (typeBinding5.isInterface()) {
                                    if (typeBinding3.isArrayType() || typeBinding3 instanceof ReferenceBinding && ((ReferenceBinding)typeBinding3).isFinal()) {
                                        return typeBinding3.isCompatibleWith(typeBinding5);
                                    }
                                } else {
                                    return typeBinding3.isCompatibleWith(typeBinding5);
                                }
                                return true;
                            }
                            return true;
                        }
                        return true;
                    }
                }
                WildcardBinding wildcardBinding = (WildcardBinding)this;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        return typeBinding.isCompatibleWith(wildcardBinding.bound);
                    }
                    case 2: {
                        return wildcardBinding.bound.isCompatibleWith(typeBinding);
                    }
                }
                return true;
            }
        }
        switch (typeBinding.kind()) {
            case 4100: {
                return true;
            }
            case 516: {
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        return this.isCompatibleWith(wildcardBinding.bound);
                    }
                    case 2: {
                        return wildcardBinding.bound.isCompatibleWith(this);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isUnboundWildcard() {
        return false;
    }

    public boolean isUncheckedException(boolean bl) {
        return false;
    }

    public boolean isWildcard() {
        return false;
    }

    public int kind() {
        return 4;
    }

    public TypeBinding leafComponentType() {
        return this;
    }

    public boolean needsUncheckedConversion(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return false;
        }
        if (!((typeBinding = typeBinding.leafComponentType()) instanceof ReferenceBinding)) {
            return false;
        }
        TypeBinding typeBinding2 = this.leafComponentType();
        TypeBinding typeBinding3 = typeBinding2.findSuperTypeWithSameErasure(typeBinding);
        if (!(typeBinding3 instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding3;
        while (referenceBinding.isRawType()) {
            if (typeBinding.isBoundParameterizedType()) {
                return true;
            }
            if (referenceBinding.isStatic() || (referenceBinding = referenceBinding.enclosingType()) == null || (typeBinding = typeBinding.enclosingType()) == null) break;
        }
        return false;
    }

    public char[] qualifiedPackageName() {
        PackageBinding packageBinding = this.getPackage();
        return packageBinding == null || packageBinding.compoundName == CharOperation.NO_CHAR_CHAR ? CharOperation.NO_CHAR : packageBinding.readableName();
    }

    public abstract char[] qualifiedSourceName();

    public char[] signature() {
        return this.constantPoolName();
    }

    public abstract char[] sourceName();

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
    }

    public TypeVariableBinding[] typeVariables() {
        return Binding.NO_TYPE_VARIABLES;
    }
}

