/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.base;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRBaseCrosstab
extends JRBaseElement
implements JRCrosstab {
    private static final long serialVersionUID = 10200L;
    protected int id;
    protected JRCrosstabParameter[] parameters;
    protected JRVariable[] variables;
    protected JRExpression parametersMapExpression;
    protected JRCrosstabDataset dataset;
    protected JRCrosstabRowGroup[] rowGroups;
    protected JRCrosstabColumnGroup[] columnGroups;
    protected JRCrosstabMeasure[] measures;
    protected int columnBreakOffset;
    protected boolean repeatColumnHeaders = true;
    protected boolean repeatRowHeaders = true;
    protected JRCrosstabCell[][] cells;
    protected JRCellContents whenNoDataCell;
    protected JRCellContents headerCell;

    public JRBaseCrosstab(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory, int n) {
        super(jRCrosstab, jRBaseObjectFactory);
        this.id = n;
        this.columnBreakOffset = jRCrosstab.getColumnBreakOffset();
        this.repeatColumnHeaders = jRCrosstab.isRepeatColumnHeaders();
        this.repeatRowHeaders = jRCrosstab.isRepeatRowHeaders();
        this.dataset = jRBaseObjectFactory.getCrosstabDataset(jRCrosstab.getDataset());
        this.copyParameters(jRCrosstab, jRBaseObjectFactory);
        this.copyVariables(jRCrosstab, jRBaseObjectFactory);
        this.headerCell = jRBaseObjectFactory.getCell(jRCrosstab.getHeaderCell());
        this.copyRowGroups(jRCrosstab, jRBaseObjectFactory);
        this.copyColumnGroups(jRCrosstab, jRBaseObjectFactory);
        this.copyMeasures(jRCrosstab, jRBaseObjectFactory);
        this.copyCells(jRCrosstab, jRBaseObjectFactory);
        this.whenNoDataCell = jRBaseObjectFactory.getCell(jRCrosstab.getWhenNoDataCell());
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    private void copyParameters(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabParameter[] jRCrosstabParameterArray = jRCrosstab.getParameters();
        if (jRCrosstabParameterArray != null) {
            this.parameters = new JRCrosstabParameter[jRCrosstabParameterArray.length];
            int n = 0;
            while (n < this.parameters.length) {
                this.parameters[n] = jRBaseObjectFactory.getCrosstabParameter(jRCrosstabParameterArray[n]);
                ++n;
            }
        }
        this.parametersMapExpression = jRBaseObjectFactory.getExpression(jRCrosstab.getParametersMapExpression());
    }

    private void copyVariables(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRVariable[] jRVariableArray = jRCrosstab.getVariables();
        if (jRVariableArray != null) {
            this.variables = new JRVariable[jRVariableArray.length];
            int n = 0;
            while (n < jRVariableArray.length) {
                this.variables[n] = jRBaseObjectFactory.getVariable(jRVariableArray[n]);
                ++n;
            }
        }
    }

    private void copyRowGroups(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        if (jRCrosstabRowGroupArray != null) {
            this.rowGroups = new JRCrosstabRowGroup[jRCrosstabRowGroupArray.length];
            int n = 0;
            while (n < jRCrosstabRowGroupArray.length) {
                this.rowGroups[n] = jRBaseObjectFactory.getCrosstabRowGroup(jRCrosstabRowGroupArray[n]);
                ++n;
            }
        }
    }

    private void copyColumnGroups(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        if (jRCrosstabColumnGroupArray != null) {
            this.columnGroups = new JRCrosstabColumnGroup[jRCrosstabColumnGroupArray.length];
            int n = 0;
            while (n < jRCrosstabColumnGroupArray.length) {
                this.columnGroups[n] = jRBaseObjectFactory.getCrosstabColumnGroup(jRCrosstabColumnGroupArray[n]);
                ++n;
            }
        }
    }

    private void copyMeasures(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabMeasure[] jRCrosstabMeasureArray = jRCrosstab.getMeasures();
        if (jRCrosstabMeasureArray != null) {
            this.measures = new JRCrosstabMeasure[jRCrosstabMeasureArray.length];
            int n = 0;
            while (n < jRCrosstabMeasureArray.length) {
                this.measures[n] = jRBaseObjectFactory.getCrosstabMeasure(jRCrosstabMeasureArray[n]);
                ++n;
            }
        }
    }

    private void copyCells(JRCrosstab jRCrosstab, JRBaseObjectFactory jRBaseObjectFactory) {
        JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
        if (jRCrosstabCellArray != null) {
            this.cells = new JRCrosstabCell[this.rowGroups.length + 1][this.columnGroups.length + 1];
            int n = 0;
            while (n <= this.rowGroups.length) {
                int n2 = 0;
                while (n2 <= this.columnGroups.length) {
                    this.cells[n][n2] = jRBaseObjectFactory.getCrosstabCell(jRCrosstabCellArray[n][n2]);
                    ++n2;
                }
                ++n;
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    public JRCrosstabRowGroup[] getRowGroups() {
        return this.rowGroups;
    }

    public JRCrosstabColumnGroup[] getColumnGroups() {
        return this.columnGroups;
    }

    public JRCrosstabMeasure[] getMeasures() {
        return this.measures;
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getCrosstab(this);
    }

    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeCrosstab(this);
    }

    public int getColumnBreakOffset() {
        return this.columnBreakOffset;
    }

    public boolean isRepeatColumnHeaders() {
        return this.repeatColumnHeaders;
    }

    public boolean isRepeatRowHeaders() {
        return this.repeatRowHeaders;
    }

    public JRCrosstabCell[][] getCells() {
        return this.cells;
    }

    public JRCrosstabParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public static JRElement getElementByKey(JRCrosstab jRCrosstab, String string) {
        JRElement jRElement = null;
        if (jRCrosstab.getHeaderCell() != null) {
            jRElement = jRCrosstab.getHeaderCell().getElementByKey(string);
        }
        if ((jRElement = JRBaseCrosstab.getHeadersElement(jRCrosstab.getRowGroups(), string)) == null) {
            jRElement = JRBaseCrosstab.getHeadersElement(jRCrosstab.getColumnGroups(), string);
        }
        if (jRElement == null) {
            if (jRCrosstab instanceof JRDesignCrosstab) {
                List list = ((JRDesignCrosstab)jRCrosstab).getCellsList();
                Iterator iterator = list.iterator();
                while (jRElement == null && iterator.hasNext()) {
                    JRCrosstabCell jRCrosstabCell = (JRCrosstabCell)iterator.next();
                    jRElement = jRCrosstabCell.getContents().getElementByKey(string);
                }
            } else {
                JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
                int n = jRCrosstabCellArray.length - 1;
                while (jRElement == null && n >= 0) {
                    int n2 = jRCrosstabCellArray[n].length - 1;
                    while (jRElement == null && n2 >= 0) {
                        JRCrosstabCell jRCrosstabCell = jRCrosstabCellArray[n][n2];
                        if (jRCrosstabCell != null) {
                            jRElement = jRCrosstabCell.getContents().getElementByKey(string);
                        }
                        --n2;
                    }
                    --n;
                }
            }
        }
        if (jRElement == null && jRCrosstab.getWhenNoDataCell() != null) {
            jRElement = jRCrosstab.getWhenNoDataCell().getElementByKey(string);
        }
        return jRElement;
    }

    private static JRElement getHeadersElement(JRCrosstabGroup[] jRCrosstabGroupArray, String string) {
        JRElement jRElement = null;
        if (jRCrosstabGroupArray != null) {
            int n = 0;
            while (jRElement == null && n < jRCrosstabGroupArray.length) {
                JRCellContents jRCellContents = jRCrosstabGroupArray[n].getHeader();
                jRElement = jRCellContents.getElementByKey(string);
                if (jRElement == null) {
                    JRCellContents jRCellContents2 = jRCrosstabGroupArray[n].getTotalHeader();
                    jRElement = jRCellContents2.getElementByKey(string);
                }
                ++n;
            }
        }
        return jRElement;
    }

    public JRElement getElementByKey(String string) {
        return JRBaseCrosstab.getElementByKey(this, string);
    }

    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }
}

