/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import com.jgoodies.forms.factories.ComponentFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class PPGDComponentFactory
implements ComponentFactory {
    private static final PPGDComponentFactory INSTANCE = new PPGDComponentFactory();
    private static final boolean IS_BEFORE_14 = PPGDComponentFactory.isBefore14();
    private static final char MNEMONIC_MARKER = '&';

    private PPGDComponentFactory() {
    }

    public static PPGDComponentFactory getInstance() {
        return INSTANCE;
    }

    public static PPGDComponentFactory getInstancia() {
        return INSTANCE;
    }

    public JLabel createLabel(String string) {
        JLabel jLabel = new JLabel();
        PPGDComponentFactory.setTextAndMnemonic(jLabel, string);
        return jLabel;
    }

    public JLabel createTitle(String string) {
        return this.createTitle(string, 0);
    }

    private JLabel createTitle(String string, int n) {
        TitleLabel titleLabel = new TitleLabel();
        PPGDComponentFactory.setTextAndMnemonic(titleLabel, string);
        titleLabel.setVerticalAlignment(0);
        titleLabel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, n));
        return titleLabel;
    }

    public JComponent createSeparator(String string) {
        return this.createSeparator(string, 2);
    }

    public JComponent createSeparator(String string, int n) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        if (string != null && string.length() > 0) {
            jPanel.add((Component)this.createTitle(string, 4), gridBagConstraints);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        JSeparator jSeparator = new JSeparator();
        jPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jSeparator, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createGlue(), gridBagConstraints);
        return jPanel;
    }

    public static void setTextAndMnemonic(JLabel jLabel, String string) {
        int n = string.indexOf(38);
        if (n == -1) {
            jLabel.setText(string);
        } else {
            int n2;
            int n3 = -1;
            int n4 = 0;
            int n5 = string.length();
            StringBuffer stringBuffer = new StringBuffer();
            do {
                if (n + 1 < n5 && string.charAt(n + 1) == '&') {
                    n2 = n + 1;
                } else {
                    n2 = n;
                    if (n3 == -1) {
                        n3 = n;
                    }
                }
                stringBuffer.append(string.substring(n4, n2));
            } while ((n = (n4 = n2 + 1) < n5 ? string.indexOf(38, n4) : -1) != -1);
            stringBuffer.append(string.substring(n4));
            jLabel.setText(stringBuffer.toString());
            if (n3 != -1 && n3 + 1 < n5) {
                jLabel.setDisplayedMnemonic(string.charAt(n3 + 1));
                PPGDComponentFactory.setDisplayedMnemonicIndex(jLabel, n3);
            }
        }
    }

    private static void setDisplayedMnemonicIndex(JLabel jLabel, int n) {
        Integer n2 = new Integer(n);
        if (IS_BEFORE_14) {
            jLabel.putClientProperty("displayedMnemonicIndex", n2);
        } else {
            try {
                Class<AbstractButton> clazz = AbstractButton.class;
                Method method = clazz.getMethod("setDisplayedMnemonicIndex", new Class[0]);
                method.invoke((Object)jLabel, n2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private static boolean isBefore14() {
        String string = System.getProperty("java.version");
        return string.startsWith("1.2") || string.startsWith("1.3");
    }

    private static class TitleLabel
    extends JLabel {
        TitleLabel() {
        }

        TitleLabel(String string) {
            super(string);
        }

        public void updateUI() {
            super.updateUI();
            Color color = UIManager.getColor("TitledBorder.titleColor");
            if (color != null) {
                this.setForeground(color);
            }
            this.setFont(UIManager.getFont("TitledBorder.font"));
        }
    }
}

