/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;

public class JRSortableDataSource
implements JRRewindableDataSource {
    private List records = new ArrayList();
    private Iterator iterator = null;
    private Object[] currentRecord = null;
    private Map fieldIndexMap = new HashMap();
    protected Collator collator = null;

    public JRSortableDataSource(JRDataSource jRDataSource, JRField[] jRFieldArray, JRSortField[] jRSortFieldArray, Locale locale) throws JRException {
        if (jRFieldArray == null) {
            jRFieldArray = new JRField[]{};
        }
        if (jRSortFieldArray == null) {
            jRSortFieldArray = new JRSortField[]{};
        }
        JRSortableDataSource.verifySortFields(jRFieldArray, jRSortFieldArray);
        this.collator = Collator.getInstance(locale);
        int n = 0;
        while (n < jRFieldArray.length) {
            this.fieldIndexMap.put(jRFieldArray[n].getName(), new Integer(n));
            ++n;
        }
        int[] nArray = new int[jRSortFieldArray.length];
        int[] nArray2 = new int[jRSortFieldArray.length];
        boolean[] blArray = new boolean[jRSortFieldArray.length];
        int n2 = 0;
        while (n2 < jRSortFieldArray.length) {
            JRSortField jRSortField = jRSortFieldArray[n2];
            nArray[n2] = (Integer)this.fieldIndexMap.get(jRSortField.getName());
            nArray2[n2] = jRSortField.getOrder() == 0 ? 1 : -1;
            blArray[n2] = false;
            int n3 = 0;
            while (n3 < jRFieldArray.length) {
                JRField jRField = jRFieldArray[n3];
                if (jRSortField.getName().equals(jRField.getName())) {
                    blArray[n2] = String.class.getName().equals(jRField.getValueClassName());
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        if (jRDataSource != null) {
            while (jRDataSource.next()) {
                Object[] objectArray = new Object[jRFieldArray.length];
                int n4 = 0;
                while (n4 < jRFieldArray.length) {
                    objectArray[n4] = jRDataSource.getFieldValue(jRFieldArray[n4]);
                    ++n4;
                }
                this.records.add(objectArray);
            }
        }
        Collections.sort(this.records, new DataSourceComparator(nArray, nArray2, blArray));
        this.iterator = this.records.iterator();
    }

    public boolean next() {
        boolean bl = false;
        if (this.iterator != null && (bl = this.iterator.hasNext())) {
            this.currentRecord = (Object[])this.iterator.next();
        }
        return bl;
    }

    public Object getFieldValue(JRField jRField) {
        Integer n = (Integer)this.fieldIndexMap.get(jRField.getName());
        if (n == null) {
            throw new JRRuntimeException("Field \"" + jRField.getName() + "\" not found in sortable data source.");
        }
        return this.currentRecord[n];
    }

    public void moveFirst() {
        this.iterator = this.records.iterator();
    }

    public static void verifySortFields(JRField[] jRFieldArray, JRSortField[] jRSortFieldArray) {
        if (jRFieldArray != null && jRSortFieldArray != null) {
            int n = 0;
            while (n < jRSortFieldArray.length) {
                String string = jRSortFieldArray[n].getName();
                boolean bl = false;
                int n2 = 0;
                while (!bl && n2 < jRFieldArray.length) {
                    bl = string.equals(jRFieldArray[n2].getName());
                    ++n2;
                }
                if (!bl) {
                    throw new JRRuntimeException("Sort field \"" + string + "\" not found in the list of data source fields.");
                }
                ++n;
            }
        }
    }

    class DataSourceComparator
    implements Comparator {
        int[] sortIndexes = null;
        int[] sortOrders = null;
        boolean[] collatorFlags = null;

        public DataSourceComparator(int[] nArray, int[] nArray2, boolean[] blArray) {
            this.sortIndexes = nArray;
            this.sortOrders = nArray2;
            this.collatorFlags = blArray;
        }

        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            int n = 0;
            int n2 = 0;
            while (n2 < this.sortIndexes.length) {
                int n3 = this.sortIndexes[n2];
                Comparable comparable = (Comparable)objectArray[n3];
                Comparable comparable2 = (Comparable)objectArray2[n3];
                n = comparable == null ? (comparable2 == null ? 0 : -1) : (comparable2 == null ? 1 : (this.collatorFlags[n2] ? JRSortableDataSource.this.collator.compare(comparable, comparable2) : comparable.compareTo(comparable2)));
                if ((n *= this.sortOrders[n2]) != 0) {
                    return n;
                }
                ++n2;
            }
            return n;
        }
    }
}

