/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.util.Arrays;

public class ArrayUtilities {
    private ArrayUtilities() {
    }

    public static float[][] clone(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        float[][] fArrayArray = new float[fArray.length][];
        System.arraycopy(fArray, 0, fArrayArray, 0, fArray.length);
        int n = 0;
        while (n < fArray.length) {
            float[] fArray2 = fArray[n];
            float[] fArray3 = new float[fArray2.length];
            System.arraycopy(fArray2, 0, fArray3, 0, fArray2.length);
            fArrayArray[n] = fArray3;
            ++n;
        }
        return fArrayArray;
    }

    public static boolean equalReferencesInArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null && objectArray2[n] != null) {
                return false;
            }
            if (objectArray2[n] == null && objectArray[n] != null) {
                return false;
            }
            if (objectArray[n] != objectArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean equal(float[][] fArray, float[][] fArray2) {
        if (fArray == null) {
            return fArray2 == null;
        }
        if (fArray2 == null) {
            return false;
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        int n = 0;
        while (n < fArray.length) {
            if (!Arrays.equals(fArray[n], fArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean hasDuplicateItems(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n];
                Object object2 = objectArray[n2];
                if (object != null && object2 != null && object.equals(object2)) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public static int compareVersionArrays(Comparable[] comparableArray, Comparable[] comparableArray2) {
        int n = Math.min(comparableArray.length, comparableArray2.length);
        int n2 = 0;
        while (n2 < n) {
            Comparable comparable = comparableArray[n2];
            Comparable comparable2 = comparableArray2[n2];
            if (comparable != null || comparable2 != null) {
                if (comparable == null) {
                    return 1;
                }
                if (comparable2 == null) {
                    return -1;
                }
                int n3 = comparable.compareTo(comparable2);
                if (n3 != 0) {
                    return n3;
                }
            }
            ++n2;
        }
        return 0;
    }
}

