/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayTypeReference
extends SingleTypeReference {
    public int dimensions;
    public int originalSourceEnd;

    public ArrayTypeReference(char[] cArray, int n, long l) {
        super(cArray, l);
        this.originalSourceEnd = this.sourceEnd;
        this.dimensions = n;
    }

    public int dimensions() {
        return this.dimensions;
    }

    public char[][] getParameterizedTypeName() {
        int n = this.dimensions;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 * 2;
            cArray[n3] = 91;
            cArray[n3 + 1] = 93;
            ++n2;
        }
        return new char[][]{CharOperation.concat(this.token, cArray)};
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        if (this.dimensions > 255) {
            scope.problemReporter().tooManyDimensions(this);
        }
        TypeBinding typeBinding = scope.getType(this.token);
        return scope.createArrayType(typeBinding, this.dimensions);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        super.printExpression(n, stringBuffer);
        if ((this.bits & 0x4000) != 0) {
            int n2 = 0;
            while (n2 < this.dimensions - 1) {
                stringBuffer.append("[]");
                ++n2;
            }
            stringBuffer.append("...");
        } else {
            int n3 = 0;
            while (n3 < this.dimensions) {
                stringBuffer.append("[]");
                ++n3;
            }
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

