/*
 * Decompiled with CFR 0.152.
 */
package org.swixml;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    private static String SEPARATOR = ",";
    private Locale locale = Locale.getDefault();
    private String bundleName;
    private ResourceBundle bundle;
    private ClassLoader cl = Localizer.class.getClassLoader();

    public static void setSeparator(String string) {
        SEPARATOR = string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString(String string) {
        int n;
        String[] stringArray;
        if (!this.isUsable()) {
            return string;
        }
        String string2 = "";
        try {
            return this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            stringArray = string.split(SEPARATOR);
            if (2 > stringArray.length) return string;
            n = 0;
        }
        while (true) {
            if (n >= stringArray.length) {
                return string2;
            }
            string2 = String.valueOf(string2) + (n == 0 ? this.getString(stringArray[n]) : "," + this.getString(stringArray[n]));
            ++n;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            this.locale = null;
            this.bundle = null;
            this.bundleName = null;
        } else if (this.locale != locale) {
            this.locale = locale;
            this.setResourceBundle(this.bundleName);
        }
    }

    public void setResourceBundle(String string) throws MissingResourceException {
        this.bundleName = string;
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.bundle = string != null ? ResourceBundle.getBundle(string, this.locale, this.cl) : null;
    }

    public boolean isUsable() {
        return this.locale != null && this.bundle != null;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    void setClassLoader(ClassLoader classLoader) {
        this.cl = classLoader;
    }
}

