/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.modules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.jfree.base.modules.DefaultModuleInfo;
import org.jfree.base.modules.Module;
import org.jfree.base.modules.ModuleInfo;
import org.jfree.base.modules.ModuleInitializeException;
import org.jfree.base.modules.ModuleInitializer;
import org.jfree.base.modules.SubSystem;
import org.jfree.util.ObjectUtilities;

public abstract class AbstractModule
extends DefaultModuleInfo
implements Module {
    private ModuleInfo[] requiredModules;
    private ModuleInfo[] optionalModules;
    private String name;
    private String description;
    private String producer;
    private String subsystem;

    public AbstractModule() {
        this.setModuleClass(this.getClass().getName());
    }

    protected void loadModuleInfo() throws ModuleInitializeException {
        InputStream inputStream = ObjectUtilities.getResourceRelativeAsStream("module.properties", this.getClass());
        if (inputStream == null) {
            throw new ModuleInitializeException("File 'module.properties' not found in module package.");
        }
        this.loadModuleInfo(inputStream);
    }

    protected void loadModuleInfo(InputStream inputStream) throws ModuleInitializeException {
        try {
            if (inputStream == null) {
                throw new NullPointerException("Given InputStream is null.");
            }
            ReaderHelper readerHelper = new ReaderHelper(new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1")));
            ArrayList<DefaultModuleInfo> arrayList = new ArrayList<DefaultModuleInfo>();
            ArrayList<DefaultModuleInfo> arrayList2 = new ArrayList<DefaultModuleInfo>();
            while (readerHelper.hasNext()) {
                String string = readerHelper.next();
                if (string.startsWith("module-info:")) {
                    this.readModuleInfo(readerHelper);
                    continue;
                }
                if (string.startsWith("depends:")) {
                    arrayList2.add(this.readExternalModule(readerHelper));
                    continue;
                }
                if (!string.startsWith("optional:")) continue;
                arrayList.add(this.readExternalModule(readerHelper));
            }
            readerHelper.close();
            this.optionalModules = arrayList.toArray(new ModuleInfo[arrayList.size()]);
            this.requiredModules = arrayList2.toArray(new ModuleInfo[arrayList2.size()]);
        }
        catch (IOException iOException) {
            throw new ModuleInitializeException("Failed to load properties", iOException);
        }
    }

    private String readValue(ReaderHelper readerHelper, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        boolean bl = true;
        while (this.isNextLineValueLine(readerHelper)) {
            string = readerHelper.next();
            String string2 = string.trim();
            if (string2.length() == 0 && !bl) {
                stringBuffer.append("\n");
                bl = true;
                continue;
            }
            if (!bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.parseValue(string2));
            bl = false;
        }
        return stringBuffer.toString();
    }

    private boolean isNextLineValueLine(ReaderHelper readerHelper) throws IOException {
        if (!readerHelper.hasNext()) {
            return false;
        }
        String string = readerHelper.next();
        if (string == null) {
            return false;
        }
        if (this.parseKey(string) != null) {
            readerHelper.pushBack(string);
            return false;
        }
        readerHelper.pushBack(string);
        return true;
    }

    private void readModuleInfo(ReaderHelper readerHelper) throws IOException {
        while (readerHelper.hasNext()) {
            String string = readerHelper.next();
            if (!Character.isWhitespace(string.charAt(0))) {
                readerHelper.pushBack(string);
                return;
            }
            String string2 = string.trim();
            String string3 = this.parseKey(string2);
            if (string3 == null) continue;
            String string4 = this.readValue(readerHelper, this.parseValue(string2.trim()));
            if (string3.equals("name")) {
                this.setName(string4);
                continue;
            }
            if (string3.equals("producer")) {
                this.setProducer(string4);
                continue;
            }
            if (string3.equals("description")) {
                this.setDescription(string4);
                continue;
            }
            if (string3.equals("subsystem")) {
                this.setSubSystem(string4);
                continue;
            }
            if (string3.equals("version.major")) {
                this.setMajorVersion(string4);
                continue;
            }
            if (string3.equals("version.minor")) {
                this.setMinorVersion(string4);
                continue;
            }
            if (!string3.equals("version.patchlevel")) continue;
            this.setPatchLevel(string4);
        }
    }

    private String parseKey(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    private String parseValue(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        if (n + 1 == string.length()) {
            return "";
        }
        return string.substring(n + 1);
    }

    private DefaultModuleInfo readExternalModule(ReaderHelper readerHelper) throws IOException {
        DefaultModuleInfo defaultModuleInfo = new DefaultModuleInfo();
        while (readerHelper.hasNext()) {
            String string = readerHelper.next();
            if (!Character.isWhitespace(string.charAt(0))) {
                readerHelper.pushBack(string);
                return defaultModuleInfo;
            }
            String string2 = string.trim();
            String string3 = this.parseKey(string2);
            if (string3 == null) continue;
            String string4 = this.readValue(readerHelper, this.parseValue(string2));
            if (string3.equals("module")) {
                defaultModuleInfo.setModuleClass(string4);
                continue;
            }
            if (string3.equals("version.major")) {
                defaultModuleInfo.setMajorVersion(string4);
                continue;
            }
            if (string3.equals("version.minor")) {
                defaultModuleInfo.setMinorVersion(string4);
                continue;
            }
            if (!string3.equals("version.patchlevel")) continue;
            defaultModuleInfo.setPatchLevel(string4);
        }
        return defaultModuleInfo;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String string) {
        this.description = string;
    }

    public String getProducer() {
        return this.producer;
    }

    protected void setProducer(String string) {
        this.producer = string;
    }

    public ModuleInfo[] getRequiredModules() {
        ModuleInfo[] moduleInfoArray = new ModuleInfo[this.requiredModules.length];
        System.arraycopy(this.requiredModules, 0, moduleInfoArray, 0, this.requiredModules.length);
        return moduleInfoArray;
    }

    public ModuleInfo[] getOptionalModules() {
        ModuleInfo[] moduleInfoArray = new ModuleInfo[this.optionalModules.length];
        System.arraycopy(this.optionalModules, 0, moduleInfoArray, 0, this.optionalModules.length);
        return moduleInfoArray;
    }

    protected void setRequiredModules(ModuleInfo[] moduleInfoArray) {
        this.requiredModules = new ModuleInfo[moduleInfoArray.length];
        System.arraycopy(moduleInfoArray, 0, this.requiredModules, 0, moduleInfoArray.length);
    }

    public void setOptionalModules(ModuleInfo[] moduleInfoArray) {
        this.optionalModules = new ModuleInfo[moduleInfoArray.length];
        System.arraycopy(moduleInfoArray, 0, this.optionalModules, 0, moduleInfoArray.length);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Module : ");
        stringBuffer.append(this.getName());
        stringBuffer.append("\n");
        stringBuffer.append("ModuleClass : ");
        stringBuffer.append(this.getModuleClass());
        stringBuffer.append("\n");
        stringBuffer.append("Version: ");
        stringBuffer.append(this.getMajorVersion());
        stringBuffer.append(".");
        stringBuffer.append(this.getMinorVersion());
        stringBuffer.append(".");
        stringBuffer.append(this.getPatchLevel());
        stringBuffer.append("\n");
        stringBuffer.append("Producer: ");
        stringBuffer.append(this.getProducer());
        stringBuffer.append("\n");
        stringBuffer.append("Description: ");
        stringBuffer.append(this.getDescription());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected static boolean isClassLoadable(String string) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void configure(SubSystem subSystem) {
        InputStream inputStream = ObjectUtilities.getResourceRelativeAsStream("configuration.properties", this.getClass());
        if (inputStream == null) {
            return;
        }
        subSystem.getPackageManager().getPackageConfiguration().load(inputStream);
    }

    protected void performExternalInitialize(String string) throws ModuleInitializeException {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            ModuleInitializer moduleInitializer = (ModuleInitializer)clazz.newInstance();
            moduleInitializer.performInit();
        }
        catch (ModuleInitializeException moduleInitializeException) {
            throw moduleInitializeException;
        }
        catch (Exception exception) {
            throw new ModuleInitializeException("Failed to load specified initializer class.", exception);
        }
    }

    public String getSubSystem() {
        if (this.subsystem == null) {
            return this.getName();
        }
        return this.subsystem;
    }

    protected void setSubSystem(String string) {
        this.subsystem = string;
    }

    private static class ReaderHelper {
        private String buffer;
        private final BufferedReader reader;

        public ReaderHelper(BufferedReader bufferedReader) {
            this.reader = bufferedReader;
        }

        public boolean hasNext() throws IOException {
            if (this.buffer == null) {
                this.buffer = this.readLine();
            }
            return this.buffer != null;
        }

        public String next() {
            String string = this.buffer;
            this.buffer = null;
            return string;
        }

        public void pushBack(String string) {
            this.buffer = string;
        }

        protected String readLine() throws IOException {
            String string = this.reader.readLine();
            while (string != null && (string.length() == 0 || string.startsWith("#"))) {
                string = this.reader.readLine();
            }
            return string;
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

