/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class QualifiedAllocationExpression
extends AllocationExpression {
    public Expression enclosingInstance;
    public TypeDeclaration anonymousType;
    public ReferenceBinding superTypeBinding;

    public QualifiedAllocationExpression() {
    }

    public QualifiedAllocationExpression(TypeDeclaration typeDeclaration) {
        this.anonymousType = typeDeclaration;
        typeDeclaration.allocation = this;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.enclosingInstance != null) {
            flowInfo = this.enclosingInstance.analyseCode(blockScope, flowContext, flowInfo);
        }
        ReferenceBinding referenceBinding = this.superTypeBinding == null ? this.binding.declaringClass : this.superTypeBinding;
        this.checkCapturedLocalInitializationIfNecessary((ReferenceBinding)referenceBinding.erasure(), blockScope, flowInfo);
        if (this.arguments != null) {
            int n = 0;
            int n2 = this.arguments.length;
            while (n < n2) {
                flowInfo = this.arguments[n].analyseCode(blockScope, flowContext, flowInfo);
                ++n;
            }
        }
        if (this.anonymousType != null) {
            flowInfo = this.anonymousType.analyseCode(blockScope, flowContext, flowInfo);
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, (FlowInfo)flowInfo.unconditionalCopy(), blockScope);
        }
        this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        return flowInfo;
    }

    public Expression enclosingInstance() {
        return this.enclosingInstance;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
        codeStream.new_(referenceBinding);
        if (bl) {
            codeStream.dup();
        }
        if (this.type != null) {
            codeStream.recordPositionsFrom(n, this.type.sourceStart);
        } else {
            codeStream.ldc(String.valueOf(this.enumConstant.name));
            codeStream.generateInlinedValue(this.enumConstant.binding.id);
        }
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, this.enclosingInstance(), this);
        }
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invokespecial(this.codegenBinding);
        } else {
            int n2 = 0;
            int n3 = this.syntheticAccessor.parameters.length - this.codegenBinding.parameters.length;
            while (n2 < n3) {
                codeStream.aconst_null();
                ++n2;
            }
            codeStream.invokespecial(this.syntheticAccessor);
        }
        codeStream.generateImplicitConversion(this.implicitConversion);
        codeStream.recordPositionsFrom(n, this.sourceStart);
        if (this.anonymousType != null) {
            this.anonymousType.generateCode(blockScope, codeStream);
        }
    }

    public boolean isSuperAccess() {
        return this.anonymousType != null;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        ReferenceBinding referenceBinding;
        if ((flowInfo.tagBits & 1) == 0 && (referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure()).isNestedType() && blockScope.enclosingSourceType().isLocalType()) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, this.enclosingInstance != null);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, this.enclosingInstance != null);
            }
        }
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        if (this.enclosingInstance != null) {
            this.enclosingInstance.printExpression(0, stringBuffer).append('.');
        }
        super.printExpression(0, stringBuffer);
        if (this.anonymousType != null) {
            this.anonymousType.print(n, stringBuffer);
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        Object object;
        boolean bl;
        boolean bl2;
        TypeBinding typeBinding;
        TypeBinding typeBinding2;
        block43: {
            block41: {
                boolean bl3;
                block45: {
                    block44: {
                        block42: {
                            if (this.anonymousType == null && this.enclosingInstance == null) {
                                return super.resolveType(blockScope);
                            }
                            this.constant = Constant.NotAConstant;
                            typeBinding2 = null;
                            typeBinding = null;
                            bl2 = false;
                            bl3 = false;
                            bl = false;
                            if (this.enclosingInstance == null) break block41;
                            if (this.enclosingInstance instanceof CastExpression) {
                                this.enclosingInstance.bits |= 0x20;
                                bl3 = true;
                            }
                            if ((typeBinding2 = this.enclosingInstance.resolveType(blockScope)) != null) break block42;
                            bl2 = true;
                            break block43;
                        }
                        if (!typeBinding2.isBaseType() && !typeBinding2.isArrayType()) break block44;
                        blockScope.problemReporter().illegalPrimitiveOrArrayTypeForEnclosingInstance(typeBinding2, this.enclosingInstance);
                        bl2 = true;
                        break block43;
                    }
                    if (!(this.type instanceof QualifiedTypeReference)) break block45;
                    blockScope.problemReporter().illegalUsageOfQualifiedTypeReference((QualifiedTypeReference)this.type);
                    bl2 = true;
                    break block43;
                }
                typeBinding = ((SingleTypeReference)this.type).resolveTypeEnclosing(blockScope, (ReferenceBinding)typeBinding2);
                if (typeBinding == null || !bl3) break block43;
                CastExpression.checkNeedForEnclosingInstanceCast(blockScope, this.enclosingInstance, typeBinding2, typeBinding);
                break block43;
            }
            if (this.type == null) {
                typeBinding = blockScope.enclosingSourceType();
            } else {
                typeBinding = this.type.resolveType(blockScope, true);
                if (typeBinding != null && this.type instanceof ParameterizedQualifiedTypeReference) {
                    ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
                    block0: while ((referenceBinding.modifiers & 8) == 0 && !referenceBinding.isRawType()) {
                        if ((referenceBinding = referenceBinding.enclosingType()) != null) continue;
                        object = (ParameterizedQualifiedTypeReference)this.type;
                        int n = ((ParameterizedQualifiedTypeReference)object).typeArguments.length - 2;
                        while (n >= 0) {
                            if (((ParameterizedQualifiedTypeReference)object).typeArguments[n] != null) {
                                blockScope.problemReporter().illegalQualifiedParameterizedTypeAllocation(this.type, typeBinding);
                                break block0;
                            }
                            --n;
                        }
                        break block0;
                    }
                }
            }
        }
        if (typeBinding == null) {
            bl2 = true;
        } else if (((ReferenceBinding)typeBinding).isFinal()) {
            if (this.anonymousType != null) {
                if (!typeBinding.isEnum()) {
                    blockScope.problemReporter().anonymousClassCannotExtendFinalClass(this.type, typeBinding);
                    bl2 = true;
                }
            } else if (!typeBinding.canBeInstantiated()) {
                blockScope.problemReporter().cannotInstantiate(this.type, typeBinding);
                this.resolvedType = typeBinding;
                return this.resolvedType;
            }
        }
        if (this.typeArguments != null) {
            int n = this.typeArguments.length;
            this.genericTypeArguments = new TypeBinding[n];
            int n2 = 0;
            while (n2 < n) {
                TypeBinding typeBinding3 = this.typeArguments[n2].resolveType(blockScope, true);
                if (typeBinding3 == null) {
                    return null;
                }
                this.genericTypeArguments[n2] = typeBinding3;
                ++n2;
            }
        }
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            int n = this.arguments.length;
            typeBindingArray = new TypeBinding[n];
            int n3 = 0;
            while (n3 < n) {
                Expression expression = this.arguments[n3];
                if (expression instanceof CastExpression) {
                    expression.bits |= 0x20;
                    bl = true;
                }
                if ((typeBindingArray[n3] = expression.resolveType(blockScope)) == null) {
                    bl2 = true;
                }
                ++n3;
            }
        }
        if (bl2) {
            this.resolvedType = typeBinding;
            return this.resolvedType;
        }
        if (this.anonymousType == null) {
            if (!typeBinding.canBeInstantiated()) {
                blockScope.problemReporter().cannotInstantiate(this.type, typeBinding);
                this.resolvedType = typeBinding;
                return this.resolvedType;
            }
            object = (ReferenceBinding)typeBinding;
            this.binding = blockScope.getConstructor((ReferenceBinding)object, typeBindingArray, this);
            if (this.binding.isValidBinding()) {
                if (this.isMethodUseDeprecated(this.binding, blockScope, true)) {
                    blockScope.problemReporter().deprecatedMethod(this.binding, this);
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = object;
                }
                blockScope.problemReporter().invalidConstructor(this, this.binding);
                this.resolvedType = typeBinding;
                return this.resolvedType;
            }
            QualifiedAllocationExpression.checkInvocationArguments(blockScope, null, (TypeBinding)object, this.binding, this.arguments, typeBindingArray, bl, this);
            ReferenceBinding referenceBinding = this.binding.declaringClass.enclosingType();
            if (referenceBinding != typeBinding2) {
                blockScope.compilationUnitScope().recordTypeConversion(referenceBinding, typeBinding2);
            }
            if (typeBinding2.isCompatibleWith(referenceBinding) || blockScope.isBoxingCompatibleWith(typeBinding2, referenceBinding)) {
                this.enclosingInstance.computeConversion(blockScope, referenceBinding, typeBinding2);
                this.resolvedType = typeBinding;
                return this.resolvedType;
            }
            blockScope.problemReporter().typeMismatchError(typeBinding2, referenceBinding, this.enclosingInstance);
            this.resolvedType = typeBinding;
            return this.resolvedType;
        }
        if (typeBinding.isTypeVariable()) {
            typeBinding = new ProblemReferenceBinding(typeBinding.sourceName(), (ReferenceBinding)typeBinding, 9);
            blockScope.problemReporter().invalidType(this, typeBinding);
            return null;
        }
        if (this.type != null && typeBinding.isEnum()) {
            blockScope.problemReporter().cannotInstantiate(this.type, typeBinding);
            this.resolvedType = typeBinding;
            return this.resolvedType;
        }
        this.superTypeBinding = typeBinding.isInterface() ? blockScope.getJavaLangObject() : (ReferenceBinding)typeBinding;
        blockScope.addAnonymousType(this.anonymousType, (ReferenceBinding)typeBinding);
        this.anonymousType.resolve(blockScope);
        if (this.superTypeBinding.erasure().id == 41) {
            blockScope.problemReporter().cannotExtendEnum(this.anonymousType.binding, this.type, this.superTypeBinding);
        }
        if ((typeBinding.tagBits & 0x40000000L) != 0L) {
            blockScope.problemReporter().superTypeCannotUseWildcard(this.anonymousType.binding, this.type, typeBinding);
        }
        if (!((Binding)(object = blockScope.getConstructor(this.superTypeBinding, typeBindingArray, this))).isValidBinding()) {
            if (((MethodBinding)object).declaringClass == null) {
                ((MethodBinding)object).declaringClass = this.superTypeBinding;
            }
            blockScope.problemReporter().invalidConstructor(this, (MethodBinding)object);
            this.resolvedType = this.anonymousType.binding;
            return this.resolvedType;
        }
        if (this.enclosingInstance != null) {
            ReferenceBinding referenceBinding = ((MethodBinding)object).declaringClass.enclosingType();
            if (referenceBinding == null) {
                blockScope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.enclosingInstance, (ReferenceBinding)typeBinding);
                this.resolvedType = this.anonymousType.binding;
                return this.resolvedType;
            }
            if (!typeBinding2.isCompatibleWith(referenceBinding) && !blockScope.isBoxingCompatibleWith(typeBinding2, referenceBinding)) {
                blockScope.problemReporter().typeMismatchError(typeBinding2, referenceBinding, this.enclosingInstance);
                this.resolvedType = this.anonymousType.binding;
                return this.resolvedType;
            }
            this.enclosingInstance.computeConversion(blockScope, referenceBinding, typeBinding2);
        }
        if (this.arguments != null) {
            QualifiedAllocationExpression.checkInvocationArguments(blockScope, null, this.superTypeBinding, (MethodBinding)object, this.arguments, typeBindingArray, bl, this);
        }
        this.binding = this.anonymousType.createDefaultConstructorWithBinding((MethodBinding)object);
        this.resolvedType = this.anonymousType.binding;
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.enclosingInstance != null) {
                this.enclosingInstance.traverse(aSTVisitor, blockScope);
            }
            if (this.typeArguments != null) {
                n2 = 0;
                n = this.typeArguments.length;
                while (n2 < n) {
                    this.typeArguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                n = 0;
                while (n < n2) {
                    this.arguments[n].traverse(aSTVisitor, blockScope);
                    ++n;
                }
            }
            if (this.anonymousType != null) {
                this.anonymousType.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

