/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.persistenciagenerica;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.persistenciagenerica.RepositorioGenericoIf;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class RepositorioXMLDefault
implements RepositorioGenericoIf {
    private Map cacheObjetosAbertos = new Hashtable();

    static {
        FabricaUtilitarios.usaCacheParaReflexao = true;
    }

    public ObjetoNegocio getObjeto(String string) throws RepositorioXMLException {
        FabricaUtilitarios.cacheTempToReflection.clear();
        if (this.cacheObjetosAbertos.containsKey(string)) {
            return (ObjetoNegocio)this.cacheObjetosAbertos.get(string);
        }
        Document document = this.leArquivo(string);
        if (document == null) {
            return null;
        }
        String string2 = document.getDocumentElement().getAttribute("classeJava");
        ObjetoNegocio objetoNegocio = this.instanciaObjetoNegocio(string2);
        this.preencheObjetoNegocio(document.getDocumentElement(), null, objetoNegocio);
        this.cacheObjetosAbertos.put(string, objetoNegocio);
        return objetoNegocio;
    }

    public boolean temObjetoNegocioEmCache(String string) {
        return this.cacheObjetosAbertos.containsKey(string);
    }

    public boolean temObjetoPersistido(String string) {
        File file = new File(string);
        return file.exists();
    }

    public ObjetoNegocio preencheObjeto(ObjetoNegocio objetoNegocio, String string, boolean bl) throws RepositorioXMLException {
        FabricaUtilitarios.cacheTempToReflection.clear();
        Document document = this.leArquivo(string);
        if (document == null) {
            return null;
        }
        document.getDocumentElement().getAttribute("classeJava");
        this.preencheObjetoNegocio(document.getDocumentElement(), null, objetoNegocio);
        if (bl) {
            this.cacheObjetosAbertos.put(string, objetoNegocio);
        }
        return objetoNegocio;
    }

    public void salvar(ObjetoNegocio objetoNegocio, String string) throws RepositorioXMLException {
        FabricaUtilitarios.cacheTempToReflection.clear();
        if (!this.cacheObjetosAbertos.containsKey(string)) {
            this.cacheObjetosAbertos.put(string, objetoNegocio);
        }
        try {
            Document document = this.obterDOM(objetoNegocio);
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            DOMSource dOMSource = new DOMSource(document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new RepositorioXMLException(exception);
        }
    }

    public void excluir(String string) throws RepositorioXMLException {
        String string2 = string;
        File file = new File(string2);
        file.delete();
        if (this.cacheObjetosAbertos.containsKey(string)) {
            this.cacheObjetosAbertos.remove(string);
        }
    }

    private void preencheObjetoNegocio(Element element, Element element2, ObjetoNegocio objetoNegocio) throws RepositorioXMLException {
        Node node;
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (Object object : FabricaUtilitarios.getAllFields(objetoNegocio.getClass())) {
            if (Modifier.isTransient(((Field)object).getModifiers())) continue;
            try {
                Informacao informacao = (Informacao)FabricaUtilitarios.getValorFieldGenerico(((Field)object).getName(), objetoNegocio);
                node = namedNodeMap.getNamedItem(((Field)object).getName());
                informacao.setConteudo(node.getNodeValue());
            }
            catch (Exception exception) {}
        }
        if (objetoNegocio instanceof Colecao) {
            this.preencheColecao(element, (Colecao)objetoNegocio);
        } else {
            Object object;
            object = element.getChildNodes();
            int n = 0;
            while (n < object.getLength()) {
                node = object.item(n);
                if (node instanceof Element) {
                    ObjetoNegocio objetoNegocio2 = (ObjetoNegocio)FabricaUtilitarios.getValorFieldGenerico(node.getNodeName(), objetoNegocio);
                    this.preencheObjetoNegocio((Element)node, element, objetoNegocio2);
                }
                ++n;
            }
        }
    }

    private void preencheColecao(Element element, Colecao colecao) throws RepositorioXMLException {
        Node node;
        Object object2;
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (Object object2 : FabricaUtilitarios.getAllFields(colecao.getClass())) {
            if (Modifier.isTransient(((Field)object2).getModifiers())) continue;
            try {
                Informacao informacao = (Informacao)FabricaUtilitarios.getValorFieldGenerico(((Field)object2).getName(), colecao);
                node = namedNodeMap.getNamedItem(((Field)object2).getName());
                informacao.setConteudo(node.getNodeValue());
            }
            catch (Exception exception) {}
        }
        object2 = element.getChildNodes();
        int n = 0;
        while (n < object2.getLength()) {
            node = object2.item(n);
            if (node instanceof Element && node.getNodeName().equals("item")) {
                ObjetoNegocio objetoNegocio = colecao.instanciaNovoObjeto();
                colecao.recuperarLista().add(objetoNegocio);
                this.preencheObjetoNegocio((Element)node, element, objetoNegocio);
            }
            ++n;
        }
    }

    private void preencheElementoXML(Document document, Element element, Element element2, ObjetoNegocio objetoNegocio) {
        if (element2 != null) {
            element2.appendChild(element);
        }
        for (Field field : FabricaUtilitarios.getAllFields(objetoNegocio.getClass())) {
            if (Modifier.isTransient(field.getModifiers())) continue;
            Object object = FabricaUtilitarios.getValorFieldGenerico(field.getName(), objetoNegocio);
            if (object instanceof Informacao) {
                if (!((Informacao)object).isAtributoPersistente() || object == null) continue;
                element.setAttribute(field.getName(), ((Informacao)object).getConteudoFormatado());
                continue;
            }
            if (!(object instanceof ObjetoNegocio) || !((ObjetoNegocio)object).isPersistente()) continue;
            Element element3 = document.createElement(field.getName());
            this.preencheElementoXML(document, element3, element, (ObjetoNegocio)object);
            if (!(object instanceof Colecao)) continue;
            element3.setAttribute("tipoItens", ((Colecao)object).getTipoItens().getName());
            this.preencheElementoXMLColecao(document, element3, element, (Colecao)object);
        }
    }

    private void preencheElementoXMLColecao(Document document, Element element, Element element2, Colecao colecao) {
        Iterator iterator = colecao.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Element element3 = document.createElement("item");
            ObjetoNegocio objetoNegocio = (ObjetoNegocio)iterator.next();
            this.preencheElementoXML(document, element3, element, objetoNegocio);
        }
    }

    private Document obterDOM(ObjetoNegocio objetoNegocio) throws RepositorioXMLException {
        Document document;
        Document document2 = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document2 = documentBuilder.newDocument();
            Element element = document2.createElement("classe");
            document2.appendChild(element);
            element.setAttribute("classeJava", objetoNegocio.getClass().getName());
            element.setAttribute("xmlns", ConstantesGlobais.XMLNS);
            if (objetoNegocio instanceof Colecao) {
                element.setAttribute("tipoItens", ((Colecao)objetoNegocio).getTipoItens().getName());
                this.preencheElementoXMLColecao(document2, element, null, (Colecao)objetoNegocio);
            } else {
                this.preencheElementoXML(document2, element, null, objetoNegocio);
            }
            document2.normalize();
            document = document2;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LogPPGD.erro("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + parserConfigurationException.getMessage());
            throw new RepositorioXMLException(parserConfigurationException);
        }
        return document;
    }

    private ObjetoNegocio instanciaObjetoNegocio(String string) throws RepositorioXMLException {
        ObjetoNegocio objetoNegocio;
        ObjetoNegocio objetoNegocio2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            if (!Class.forName(ObjetoNegocio.class.getName()).isAssignableFrom(clazz)) {
                throw new RepositorioXMLException("A classe n\u00e3o \u00e9 um objeto de neg\u00f3cio");
            }
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            objetoNegocio = objetoNegocio2 = (ObjetoNegocio)constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RepositorioXMLException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RepositorioXMLException(exception);
        }
        return objetoNegocio;
    }

    private Document leArquivo(String string) {
        Document document = null;
        if (string == null) {
            return null;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(string);
        }
        catch (SAXParseException sAXParseException) {
            LogPPGD.erro("Erro de parsing de " + sAXParseException.getSystemId() + ". linha " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            LogPPGD.erro("Erro de parsing: " + exception.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LogPPGD.erro("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            LogPPGD.erro("Erro de I/O: " + iOException.getMessage());
        }
        return document;
    }
}

