/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.util.PublicCloneable;

public class IntervalCategoryToolTipGenerator
extends StandardCategoryToolTipGenerator
implements CategoryToolTipGenerator,
PublicCloneable,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3853824986520333437L;
    public static final String DEFAULT_TOOL_TIP_FORMAT_STRING = "({0}, {1}) = {3} - {4}";

    public IntervalCategoryToolTipGenerator() {
        super(DEFAULT_TOOL_TIP_FORMAT_STRING, NumberFormat.getInstance());
    }

    public IntervalCategoryToolTipGenerator(String string, NumberFormat numberFormat) {
        super(string, numberFormat);
    }

    public IntervalCategoryToolTipGenerator(String string, DateFormat dateFormat) {
        super(string, dateFormat);
    }

    protected Object[] createItemArray(CategoryDataset categoryDataset, int n, int n2) {
        Object[] objectArray = new Object[5];
        objectArray[0] = categoryDataset.getRowKey(n).toString();
        objectArray[1] = categoryDataset.getColumnKey(n2).toString();
        Number number = categoryDataset.getValue(n, n2);
        if (this.getNumberFormat() != null) {
            objectArray[2] = this.getNumberFormat().format(number);
        } else if (this.getDateFormat() != null) {
            objectArray[2] = this.getDateFormat().format(number);
        }
        if (categoryDataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
            Number number2 = intervalCategoryDataset.getStartValue(n, n2);
            Number number3 = intervalCategoryDataset.getEndValue(n, n2);
            if (this.getNumberFormat() != null) {
                objectArray[3] = this.getNumberFormat().format(number2);
                objectArray[4] = this.getNumberFormat().format(number3);
            } else if (this.getDateFormat() != null) {
                objectArray[3] = this.getDateFormat().format(number2);
                objectArray[4] = this.getDateFormat().format(number3);
            }
        }
        return objectArray;
    }
}

