/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.DocumentoTXT;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ConstantesRepositorio;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ConversorRegistros2ObjetosIRPF;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.util.PLong;

public class DocumentoAjusteTXT
extends DocumentoTXT {
    private static final Logger logger = Logger.getLogger("srf.irpf.importacaoGravacao.ImportaGravaAjusteAnua.DocumentoTXT");
    private RegistroTxt regTotal;
    private ConversorRegistros2ObjetosIRPF conversor2ObjetosIRPF = new ConversorRegistros2ObjetosIRPF();

    public DocumentoAjusteTXT(String string, String string2) throws GeracaoTxtException {
        super(string, string2);
        if (string.equals("ARQ_IRPF")) {
            this.regTotal = new RegistroTxt(string, "T9");
            this.regTotal.fieldByName("NR_REG").set("T9");
            this.regTotal.fieldByName("QT_TOTAL").set(1);
            for (String string3 : ConstantesRepositorio.recuperarRegistrosDeclaracao()) {
                this.regTotal.fieldByName(string3).set(0);
            }
        }
    }

    private String calculaCRCDeclaracao(String string, long l) {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        pLong.setValue(l);
        crc32.CalcCrc32(string, string.length(), pLong);
        return crc32.getStrCrc32();
    }

    private void totalizarLinhas(String string, int n) throws GeracaoTxtException {
        String string2 = "QT_R";
        if (!string.equals("IR")) {
            this.regTotal.fieldByName(String.valueOf(string2) + string).set(this.regTotal.fieldByName(String.valueOf(string2) + string).asInteger() + n);
            this.regTotal.fieldByName("QT_TOTAL").set(this.regTotal.fieldByName("QT_TOTAL").asInteger() + n);
        }
    }

    protected Vector transformarRegistroTXTEmObjDaDeclaracao(Vector vector, String string, String string2) throws GeracaoTxtException {
        Vector<RegistroTxt> vector2 = new Vector<RegistroTxt>();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = new RegistroTxt(string, string2);
            registroTxt.setLinha((String)vector.elementAt(n));
            if (registroTxt.getTipo() != "IR" && registroTxt.getTipo() != "IR" && !string.equals("ARQ_IRPFANOANTERIOR") && !string.equals("ARQ_COMPLRECIBO")) {
                registroTxt.validar();
            }
            vector2.addElement(registroTxt);
            ++n;
        }
        return vector2;
    }

    protected Vector transformarObjDaDeclaracaoEmRegistroTXT(Vector vector) throws GeracaoTxtException {
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            RegistroTxt registroTxt = (RegistroTxt)vector.elementAt(n);
            if (registroTxt.getTipo() != "IR") {
                registroTxt.calculaCRCRegistro();
            }
            if (registroTxt.opcional()) {
                if (registroTxt.estaPreenchido()) {
                    vector2.add(registroTxt.getLinha());
                }
            } else {
                vector2.add(registroTxt.getLinha());
            }
            ++n;
        }
        return vector2;
    }

    public void setFicha(Vector vector) throws GeracaoTxtException {
        String string = "";
        int n = 0;
        Vector vector2 = this.transformarObjDaDeclaracaoEmRegistroTXT(vector);
        if (vector2.size() > 0) {
            this.incluirLinhas(vector2);
            int n2 = 0;
            while (n2 < vector2.size()) {
                string = ((String)vector2.elementAt(n2)).substring(0, 2);
                ++n;
                if (n2 >= vector2.size() | string != ((String)vector2.elementAt(n2)).substring(0, 2)) {
                    this.totalizarLinhas(string, n);
                    n = 0;
                }
                ++n2;
            }
        }
    }

    public void atualizarNrReciboTransmitida(String string) throws GeracaoTxtException, IOException {
        RegistroTxt registroTxt = (RegistroTxt)this.getRegistrosTxt("IR").get(0);
        registroTxt.fieldByName("NR_RECIBO_DECLARACAO_TRANSMITIDA").set(string);
        String string2 = this.preparaNomeArquivoParaCrc();
        registroTxt.fieldByName("NR_CONTROLE").set(registroTxt.calculaCRCHeader(string2));
        this.arquivo().set(0, UtilitariosString.retiraCaracteresEspeciais(registroTxt.getLinha()));
        this.salvar();
    }

    public void atualizaHeader(Vector vector, String string) throws GeracaoTxtException {
        RegistroTxt registroTxt = (RegistroTxt)this.getRegistrosTxt("IR").get(0);
        registroTxt.fieldByName("NR_HASH").set(string);
        String string2 = this.preparaNomeArquivoParaCrc();
        registroTxt.fieldByName("NR_CONTROLE").set(registroTxt.calculaCRCHeader(string2));
        this.arquivo().set(0, UtilitariosString.retiraCaracteresEspeciais(registroTxt.getLinha()));
    }

    public void validarHeader(IdentificadorDeclaracao identificadorDeclaracao) throws GeracaoTxtException {
        RegistroTxt registroTxt = new RegistroTxt(this.getTipoArquivo(), "IR");
        registroTxt.setLinha((String)this.arquivo().get(0));
        if (!identificadorDeclaracao.getCpf().asString().equals(registroTxt.fieldByName("NR_CPF").asString())) {
            throw new GeracaoTxtException("Declara\u00e7\u00e3o n\u00e3o pertence ao CPF " + identificadorDeclaracao.getCpf() + ". Opera\u00e7\u00e3o cancelada.");
        }
        String string = registroTxt.fieldByName("NR_CONTROLE").asString();
        String string2 = this.preparaNomeArquivoParaCrc();
        String string3 = registroTxt.calculaCRCHeader(string2);
        if (!string3.equals(string)) {
            throw new GeracaoTxtException("N\u00famero de controle do Header inv\u00e1lido.");
        }
        if (!"IRPF".equals(registroTxt.fieldByName("SISTEMA").asString().trim())) {
            throw new GeracaoTxtException("Arquivo n\u00e3o \u00e9 declara\u00e7\u00e3o IRPF. Opera\u00e7\u00e3o cancelada.");
        }
    }

    public void validarHeaderAnoAnt(IdentificadorDeclaracao identificadorDeclaracao, boolean bl) throws GeracaoTxtException {
        RegistroTxt registroTxt = new RegistroTxt(this.getTipoArquivo(), "IR");
        registroTxt.setLinha((String)this.arquivo().get(0));
        if (!identificadorDeclaracao.getCpf().asString().equals(registroTxt.fieldByName("NR_CPF").asString())) {
            throw new GeracaoTxtException("Declara\u00e7\u00e3o n\u00e3o pertence ao CPF " + identificadorDeclaracao.getCpf() + ". Opera\u00e7\u00e3o cancelada.");
        }
        if (bl) {
            String string = registroTxt.fieldByName("NR_CONTROLE").asString();
            String string2 = this.preparaNomeArquivoParaCrc();
            String string3 = registroTxt.calculaCRCHeader(string2);
            if (!string3.equals(string)) {
                throw new GeracaoTxtException("As informa\u00e7\u00f5es do Header da declara\u00e7\u00e3o foram corrompidas ap\u00f3s sua grava\u00e7\u00e3o.");
            }
        }
        if (!"IRPF".equals(registroTxt.fieldByName("SISTEMA").asString())) {
            throw new GeracaoTxtException("Arquivo n\u00e3o \u00e9 declara\u00e7\u00e3o IRPF.");
        }
    }

    public void validarComplRecibo(IdentificadorDeclaracao identificadorDeclaracao) throws GeracaoTxtException {
        int n = 0;
        RegistroTxt registroTxt = new RegistroTxt(this.getTipoArquivo(), "HC");
        registroTxt.setLinha((String)this.arquivo().elementAt(n));
        if (!identificadorDeclaracao.getCpf().asString().equals(registroTxt.fieldByName("NR_CPF").asString())) {
            throw new GeracaoTxtException("Recibo n\u00e3o pertence ao CPF " + identificadorDeclaracao.getCpf() + ".");
        }
        registroTxt = new RegistroTxt(this.getTipoArquivo(), "RC");
        registroTxt.setLinha((String)this.arquivo().elementAt(++n));
        if (!identificadorDeclaracao.getCpf().asString().equals(registroTxt.fieldByName("NR_CPF").asString())) {
            throw new GeracaoTxtException("Recibo n\u00e3o pertence ao CPF " + identificadorDeclaracao.getCpf() + ".");
        }
        ++n;
        if (this.arquivo().size() > 3) {
            registroTxt = new RegistroTxt(this.getTipoArquivo(), "NC");
            registroTxt.setLinha((String)this.arquivo().elementAt(n));
            ++n;
        }
        registroTxt = new RegistroTxt(this.getTipoArquivo(), "TC");
        registroTxt.setLinha((String)this.arquivo().elementAt(n));
        if (!identificadorDeclaracao.getCpf().asString().equals(registroTxt.fieldByName("NR_CPF").asString())) {
            throw new GeracaoTxtException("Recibo n\u00e3o pertence ao CPF " + identificadorDeclaracao.getCpf() + ".");
        }
    }

    public void validarCRC() throws GeracaoTxtException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        int n = 1;
        while (n < this.arquivo().size() - 1) {
            String string = (String)this.arquivo().elementAt(n);
            String string2 = string.substring(string.length() - 10);
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(UtilitariosString.retiraCaracteresEspeciais(string.substring(0, string.length() - 10)));
            crc32.CalcCrc32(stringBuffer.toString(), stringBuffer.toString().length(), pLong);
            String string3 = crc32.getStrCrc32();
            if (!string2.equals(string3)) {
                throw new GeracaoTxtException("As informa\u00e7\u00f5es da declara\u00e7\u00e3o foram corrompidas ap\u00f3s sua grava\u00e7\u00e3o, no registro " + stringBuffer.toString().substring(0, 2) + ".");
            }
            ++n;
        }
    }

    public void validarCRCAcumulado() throws GeracaoTxtException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        String string = null;
        long l = 0L;
        int n = 0;
        while (n <= this.arquivo().size() - 1) {
            long l2;
            String string2 = (String)this.arquivo().elementAt(n);
            String string3 = string2.substring(string2.length() - 10);
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(string2.substring(0, string2.length() - 10));
            if (l != 0L) {
                pLong.setValue(l);
            }
            l = l2 = crc32.CalcCrc32(stringBuffer.toString(), stringBuffer.toString().length(), pLong);
            string = crc32.getStrCrc32();
            if (!string3.trim().equals(string.trim())) {
                throw new GeracaoTxtException("As informa\u00e7\u00f5es do recibo foram corrompidas ap\u00f3s sua grava\u00e7\u00e3o, no registro " + stringBuffer.toString().substring(0, 2) + ".");
            }
            if (n == this.arquivo().size() - 1 && !string2.startsWith("TC")) {
                throw new GeracaoTxtException("O \u00faltimo registro do complemento de recibo, n\u00e3o \u00e9 o registro Trailler.");
            }
            ++n;
        }
    }

    public void incluirTrailler(String string) throws GeracaoTxtException {
        this.regTotal.fieldByName("NR_CPF").set(string);
        this.regTotal.calculaCRCRegistro();
        this.arquivo().add(this.regTotal.getLinha());
    }

    public void incluirRecibo(Vector vector, String string) throws GeracaoTxtException {
        long l;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        RegistroTxt registroTxt = (RegistroTxt)vector.get(0);
        registroTxt.setLinha(UtilitariosString.retiraCaracteresEspeciais(registroTxt.getLinha()));
        registroTxt.calculaCRCRegistro();
        string = this.calculaCRCDeclaracao(registroTxt.getLinha(), l);
        this.arquivo().add(registroTxt.getLinha());
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        registroTxt = (RegistroTxt)vector.get(1);
        registroTxt.setLinha(UtilitariosString.retiraCaracteresEspeciais(registroTxt.getLinha()));
        registroTxt.calculaCRCRegistro();
        string = this.calculaCRCDeclaracao(registroTxt.getLinha(), l);
        this.arquivo().add(registroTxt.getLinha());
        registroTxt = (RegistroTxt)vector.get(2);
        registroTxt.setLinha(UtilitariosString.retiraCaracteresEspeciais(registroTxt.getLinha()));
        registroTxt.fieldByName("NR_HASH").set(string);
        registroTxt.calculaCRCRegistro();
        this.arquivo().add(registroTxt.getLinha());
    }

    public String calcularHash() {
        String string = "";
        long l = 0L;
        int n = 1;
        while (n < this.arquivo().size()) {
            String string2 = (String)this.arquivo().get(n);
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l = 0L;
            }
            string = this.calculaCRCDeclaracao(string2, l);
            ++n;
        }
        return string;
    }

    private String preparaNomeArquivoParaCrc() {
        String string = UtilitariosArquivo.extraiNomeArquivo(this.getPath()).toUpperCase();
        String string2 = UtilitariosArquivo.extraiNomeAquivoSemExtensao(string);
        if (string2.length() > 8) {
            string2 = string2.substring(0, 8);
        }
        string2 = string2.concat(UtilitariosArquivo.extraiExtensaoAquivo(string));
        return string2;
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("C:/Documents and Settings/messiasl/Desktop/Decs/00000481513-IRPF-2005-2004-ORIGI.REC");
            DocumentoAjusteTXT documentoAjusteTXT = new DocumentoAjusteTXT("ARQ_COMPLRECIBO", file.getPath());
            documentoAjusteTXT.ler();
            documentoAjusteTXT.validarCRCAcumulado();
            System.out.println("OK");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

