/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.util.FloatUtil;

public class FloatLiteral
extends NumberLiteral {
    float value;
    static final float Float_MIN_VALUE = Float.intBitsToFloat(1);

    public FloatLiteral(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
    }

    public void computeConstant() {
        Float f;
        try {
            f = Float.valueOf(String.valueOf(this.source));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                float f2 = FloatUtil.valueOfHexFloatLiteral(this.source);
                if (f2 == Float.POSITIVE_INFINITY) {
                    return;
                }
                if (Float.isNaN(f2)) {
                    return;
                }
                this.value = f2;
                this.constant = FloatConstant.fromValue(f2);
            }
            catch (NumberFormatException numberFormatException2) {}
            return;
        }
        float f3 = f.floatValue();
        if (f3 > Float.MAX_VALUE) {
            return;
        }
        if (f3 < Float.MIN_VALUE) {
            boolean bl = false;
            int n = 0;
            block10: while (n < this.source.length) {
                switch (this.source[n]) {
                    case '.': 
                    case '0': {
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        bl = true;
                        break;
                    }
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        if (!bl) break block10;
                        return;
                    }
                    case 'P': 
                    case 'p': {
                        break block10;
                    }
                    default: {
                        return;
                    }
                }
                ++n;
            }
        }
        this.value = f3;
        this.constant = FloatConstant.fromValue(this.value);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return TypeBinding.FLOAT;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

