/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.util.HashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class SetPropertiesRule
extends Rule {
    private String[] attributeNames;
    private String[] propertyNames;
    private boolean ignoreMissingProperty = true;

    public SetPropertiesRule(Digester digester) {
        this();
    }

    public SetPropertiesRule() {
    }

    public SetPropertiesRule(String string, String string2) {
        this.attributeNames = new String[1];
        this.attributeNames[0] = string;
        this.propertyNames = new String[1];
        this.propertyNames[0] = string2;
    }

    public SetPropertiesRule(String[] stringArray, String[] stringArray2) {
        this.attributeNames = new String[stringArray.length];
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            this.attributeNames[n] = stringArray[n];
            ++n;
        }
        this.propertyNames = new String[stringArray2.length];
        n = 0;
        n2 = stringArray2.length;
        while (n < n2) {
            this.propertyNames[n] = stringArray2[n];
            ++n;
        }
    }

    public void begin(Attributes attributes) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        if (this.attributeNames != null) {
            n = this.attributeNames.length;
        }
        int n2 = 0;
        if (this.propertyNames != null) {
            n2 = this.propertyNames.length;
        }
        int n3 = 0;
        while (n3 < attributes.getLength()) {
            Object object;
            boolean bl;
            String string = attributes.getLocalName(n3);
            if ("".equals(string)) {
                string = attributes.getQName(n3);
            }
            String string2 = attributes.getValue(n3);
            int n4 = 0;
            while (n4 < n) {
                if (string.equals(this.attributeNames[n4])) {
                    if (n4 < n2) {
                        string = this.propertyNames[n4];
                        break;
                    }
                    string = null;
                    break;
                }
                ++n4;
            }
            if (this.digester.log.isDebugEnabled()) {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Setting property '" + string + "' to '" + string2 + "'");
            }
            if (!this.ignoreMissingProperty && string != null && !(bl = PropertyUtils.isWriteable(object = this.digester.peek(), string))) {
                throw new NoSuchMethodException("Property " + string + " can't be set");
            }
            if (string != null) {
                hashMap.put(string, string2);
            }
            ++n3;
        }
        Object object = this.digester.peek();
        if (this.digester.log.isDebugEnabled()) {
            if (object != null) {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set " + object.getClass().getName() + " properties");
            } else {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set NULL properties");
            }
        }
        BeanUtils.populate(object, hashMap);
    }

    public void addAlias(String string, String string2) {
        if (this.attributeNames == null) {
            this.attributeNames = new String[1];
            this.attributeNames[0] = string;
            this.propertyNames = new String[1];
            this.propertyNames[0] = string2;
        } else {
            int n = this.attributeNames.length;
            String[] stringArray = new String[n + 1];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.attributeNames[n2];
                ++n2;
            }
            stringArray[n] = string;
            String[] stringArray2 = new String[n + 1];
            int n3 = 0;
            while (n3 < n && n3 < this.propertyNames.length) {
                stringArray2[n3] = this.propertyNames[n3];
                ++n3;
            }
            stringArray2[n] = string2;
            this.propertyNames = stringArray2;
            this.attributeNames = stringArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SetPropertiesRule[");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean isIgnoreMissingProperty() {
        return this.ignoreMissingProperty;
    }

    public void setIgnoreMissingProperty(boolean bl) {
        this.ignoreMissingProperty = bl;
    }
}

