/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJdbcQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRJdbcQueryExecuter.class);
    private Connection connection = (Connection)this.getParameterValue("REPORT_CONNECTION");
    private PreparedStatement statement;
    private ResultSet resultSet;

    public JRJdbcQueryExecuter(JRDataset jRDataset, Map map) {
        super(jRDataset, map);
        if (this.connection == null && log.isWarnEnabled()) {
            log.warn("The supplied java.sql.Connection object is null.");
        }
        this.parseQuery();
    }

    protected String getParameterReplacement(String string) {
        return "?";
    }

    public JRDataSource createDatasource() throws JRException {
        JRResultSetDataSource jRResultSetDataSource = null;
        this.createStatement();
        if (this.statement != null) {
            try {
                Integer n = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
                if (n != null) {
                    this.statement.setMaxRows(n);
                }
                this.resultSet = this.statement.executeQuery();
                jRResultSetDataSource = new JRResultSetDataSource(this.resultSet);
            }
            catch (SQLException sQLException) {
                throw new JRException("Error executing SQL statement for : " + this.dataset.getName(), sQLException);
            }
        }
        return jRResultSetDataSource;
    }

    private void createStatement() throws JRException {
        String string = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug("SQL query string: " + string);
        }
        if (this.connection != null && string != null && string.trim().length() > 0) {
            try {
                List list;
                this.statement = this.connection.prepareStatement(string);
                int n = JRProperties.getIntegerProperty(this.dataset.getPropertiesMap(), "net.sf.jasperreports.jdbc.fetch.size", 0);
                if (n > 0) {
                    this.statement.setFetchSize(n);
                }
                if (!(list = this.getCollectedParameterNames()).isEmpty()) {
                    int n2 = 0;
                    while (n2 < list.size()) {
                        String string2 = (String)list.get(n2);
                        this.setStatementParameter(n2 + 1, string2);
                        ++n2;
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new JRException("Error preparing statement for executing the report query : \n\n" + string + "\n\n", sQLException);
            }
        }
    }

    protected void setStatementParameter(int n, String string) throws SQLException, JRException {
        JRValueParameter jRValueParameter = this.getValueParameter(string);
        Class clazz = jRValueParameter.getValueClass();
        Object object = jRValueParameter.getValue();
        if (log.isDebugEnabled()) {
            log.debug("Parameter #" + n + " (" + string + " of type " + clazz.getName() + "): " + object);
        }
        if (clazz.equals(Object.class)) {
            if (object == null) {
                this.statement.setNull(n, 2000);
            } else {
                this.statement.setObject(n, object);
            }
        } else if (clazz.equals(Boolean.class)) {
            if (object == null) {
                this.statement.setNull(n, -7);
            } else {
                this.statement.setBoolean(n, (Boolean)object);
            }
        } else if (clazz.equals(Byte.class)) {
            if (object == null) {
                this.statement.setNull(n, -6);
            } else {
                this.statement.setByte(n, (Byte)object);
            }
        } else if (clazz.equals(Double.class)) {
            if (object == null) {
                this.statement.setNull(n, 8);
            } else {
                this.statement.setDouble(n, (Double)object);
            }
        } else if (clazz.equals(Float.class)) {
            if (object == null) {
                this.statement.setNull(n, 6);
            } else {
                this.statement.setFloat(n, ((Float)object).floatValue());
            }
        } else if (clazz.equals(Integer.class)) {
            if (object == null) {
                this.statement.setNull(n, 4);
            } else {
                this.statement.setInt(n, (Integer)object);
            }
        } else if (clazz.equals(Long.class)) {
            if (object == null) {
                this.statement.setNull(n, -5);
            } else {
                this.statement.setLong(n, (Long)object);
            }
        } else if (clazz.equals(Short.class)) {
            if (object == null) {
                this.statement.setNull(n, 5);
            } else {
                this.statement.setShort(n, (Short)object);
            }
        } else if (clazz.equals(BigDecimal.class)) {
            if (object == null) {
                this.statement.setNull(n, 3);
            } else {
                this.statement.setBigDecimal(n, (BigDecimal)object);
            }
        } else if (clazz.equals(String.class)) {
            if (object == null) {
                this.statement.setNull(n, 12);
            } else {
                this.statement.setString(n, object.toString());
            }
        } else if (clazz.equals(java.util.Date.class)) {
            if (object == null) {
                this.statement.setNull(n, 91);
            } else {
                this.statement.setDate(n, new Date(((java.util.Date)object).getTime()));
            }
        } else if (clazz.equals(Timestamp.class)) {
            if (object == null) {
                this.statement.setNull(n, 93);
            } else {
                this.statement.setTimestamp(n, (Timestamp)object);
            }
        } else if (clazz.equals(Time.class)) {
            if (object == null) {
                this.statement.setNull(n, 92);
            } else {
                this.statement.setTime(n, (Time)object);
            }
        } else {
            throw new JRException("Parameter type not supported in query : " + string + " class " + clazz.getName());
        }
    }

    public synchronized void close() {
        block12: {
            if (this.resultSet != null) {
                try {
                    try {
                        this.resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        log.error("Error while closing result set.", sQLException);
                        this.resultSet = null;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.resultSet = null;
                    throw throwable;
                }
                this.resultSet = null;
            }
        }
        if (this.statement != null) {
            try {
                try {
                    this.statement.close();
                }
                catch (SQLException sQLException) {
                    log.error("Error while closing statement.", sQLException);
                    this.statement = null;
                }
            }
            finally {
                this.statement = null;
            }
        }
    }

    public synchronized boolean cancelQuery() throws JRException {
        if (this.statement != null) {
            try {
                this.statement.cancel();
                return true;
            }
            catch (Throwable throwable) {
                throw new JRException("Error cancelling SQL statement", throwable);
            }
        }
        return false;
    }
}

