/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.factories;

import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.util.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class DefaultComponentFactory
implements ComponentFactory {
    private static final DefaultComponentFactory INSTANCE = new DefaultComponentFactory();
    private static final char MNEMONIC_MARKER = '&';

    public static DefaultComponentFactory getInstance() {
        return INSTANCE;
    }

    public JLabel createLabel(String string) {
        JLabel jLabel = new JLabel();
        DefaultComponentFactory.setTextAndMnemonic(jLabel, string);
        return jLabel;
    }

    public JLabel createTitle(String string) {
        TitleLabel titleLabel = new TitleLabel();
        DefaultComponentFactory.setTextAndMnemonic(titleLabel, string);
        titleLabel.setVerticalAlignment(0);
        return titleLabel;
    }

    public JComponent createSeparator(String string) {
        return this.createSeparator(string, 2);
    }

    public JComponent createSeparator(String string, int n) {
        if (string == null || string.length() == 0) {
            return new JSeparator();
        }
        JLabel jLabel = this.createTitle(string);
        jLabel.setHorizontalAlignment(n);
        return this.createSeparator(jLabel);
    }

    public JComponent createSeparator(JLabel jLabel) {
        if (jLabel == null) {
            throw new NullPointerException("The label must not be null.");
        }
        int n = jLabel.getHorizontalAlignment();
        if (n != 2 && n != 0 && n != 4) {
            throw new IllegalArgumentException("The label's horizontal alignment must be one of: LEFT, CENTER, RIGHT.");
        }
        JPanel jPanel = new JPanel(new TitledSeparatorLayout(!Utilities.isLafAqua()));
        jPanel.setOpaque(false);
        jPanel.add(jLabel);
        jPanel.add(new JSeparator());
        if (n == 0) {
            jPanel.add(new JSeparator());
        }
        return jPanel;
    }

    private static void setTextAndMnemonic(JLabel jLabel, String string) {
        int n;
        int n2 = string.indexOf(38);
        if (n2 == -1) {
            jLabel.setText(string);
            return;
        }
        int n3 = -1;
        int n4 = 0;
        int n5 = string.length();
        int n6 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if (n2 + 1 < n5 && string.charAt(n2 + 1) == '&') {
                n = n2 + 1;
                ++n6;
            } else {
                n = n2;
                if (n3 == -1) {
                    n3 = n2 - n6;
                }
            }
            stringBuffer.append(string.substring(n4, n));
        } while ((n2 = (n4 = n + 1) < n5 ? string.indexOf(38, n4) : -1) != -1);
        stringBuffer.append(string.substring(n4));
        String string2 = stringBuffer.toString();
        jLabel.setText(string2);
        if (n3 != -1 && n3 < string2.length()) {
            jLabel.setDisplayedMnemonic(string2.charAt(n3));
            jLabel.setDisplayedMnemonicIndex(n3);
        }
    }

    private static final class TitleLabel
    extends JLabel {
        private TitleLabel() {
        }

        public void updateUI() {
            super.updateUI();
            Color color = this.getTitleColor();
            if (color != null) {
                this.setForeground(color);
            }
            this.setFont(this.getTitleFont());
        }

        private Color getTitleColor() {
            return UIManager.getColor("TitledBorder.titleColor");
        }

        private Font getTitleFont() {
            return Utilities.isLafAqua() ? UIManager.getFont("Label.font").deriveFont(1) : UIManager.getFont("TitledBorder.font");
        }
    }

    private static final class TitledSeparatorLayout
    implements LayoutManager {
        private final boolean centerSeparators;

        private TitledSeparatorLayout(boolean bl) {
            this.centerSeparators = bl;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            JLabel jLabel = this.getLabel(container);
            Dimension dimension = ((Component)jLabel).getPreferredSize();
            Insets insets = container.getInsets();
            int n = dimension.width + insets.left + insets.right;
            int n2 = dimension.height + insets.top + insets.bottom;
            return new Dimension(n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = container.getSize();
                Insets insets = container.getInsets();
                int n = dimension.width - insets.left - insets.right;
                JLabel jLabel = this.getLabel(container);
                Dimension dimension2 = jLabel.getPreferredSize();
                int n2 = dimension2.width;
                int n3 = dimension2.height;
                Component component = container.getComponent(1);
                int n4 = component.getPreferredSize().height;
                FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
                int n5 = fontMetrics.getMaxAscent();
                int n6 = this.centerSeparators ? 3 : 1;
                int n7 = Sizes.dialogUnitXAsPixel(n6, jLabel);
                int n8 = this.centerSeparators ? 1 + (n3 - n4) / 2 : n5 - n4 / 2;
                int n9 = jLabel.getHorizontalAlignment();
                int n10 = insets.top;
                if (n9 == 2) {
                    int n11 = insets.left;
                    jLabel.setBounds(n11, n10, n2, n3);
                    n11 += n2;
                    int n12 = dimension.width - insets.right - (n11 += n7);
                    component.setBounds(n11, n10 + n8, n12, n4);
                } else if (n9 == 4) {
                    int n13 = insets.left + n - n2;
                    jLabel.setBounds(n13, n10, n2, n3);
                    n13 -= n7;
                    int n14 = --n13 - insets.left;
                    component.setBounds(insets.left, n10 + n8, n14, n4);
                } else {
                    int n15 = (n - n2 - 2 * n7) / 2;
                    int n16 = insets.left;
                    component.setBounds(n16, n10 + n8, n15 - 1, n4);
                    n16 += n15;
                    jLabel.setBounds(n16 += n7, n10, n2, n3);
                    n16 += n2;
                    Component component2 = container.getComponent(2);
                    int n17 = dimension.width - insets.right - (n16 += n7);
                    component2.setBounds(n16, n10 + n8, n17, n4);
                }
            }
        }

        private JLabel getLabel(Container container) {
            return (JLabel)container.getComponent(0);
        }
    }
}

