/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import java.util.Hashtable;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.calculos.CalculosDeducoesIncentivos;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosPagamentos
extends Observador {
    private DeclaracaoIRPF declaracaoIRPF = null;

    public CalculosPagamentos(DeclaracaoIRPF declaracaoIRPF) {
        this.declaracaoIRPF = declaracaoIRPF;
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        if (string != null) {
            if (string.equals("ObjetoInserido")) {
                ((Pagamento)object3).getCodigo().addObservador(this);
                ((Pagamento)object3).getValorPago().addObservador(this);
                ((Pagamento)object3).getParcelaNaoDedutivel().addObservador(this);
            } else if (string.equals("ObjetoRemovido")) {
                ((Pagamento)object3).getValorPago().removeObservador(this);
                ((Pagamento)object3).getParcelaNaoDedutivel().removeObservador(this);
                ((Pagamento)object3).getCodigo().removeObservador(this);
            }
        }
        this.calculaTotalDeducoesInstrucao();
        this.calculaTotalContribuicaoFAPI();
        this.calculaTotalDespesasMedicas();
        CalculosDeducoesIncentivos.calculaDeducaoIncentivo(this.declaracaoIRPF);
        this.calculaTotalPensao();
        this.calculaTotalContribEmpregadoDomestico();
    }

    private void calculaTotalContribEmpregadoDomestico() {
        Valor valor = new Valor();
        for (Pagamento pagamento : this.declaracaoIRPF.getPagamentos().recuperarLista()) {
            if (!pagamento.getCodigo().asString().equals("50")) continue;
            valor.append('+', pagamento.getValorPago());
        }
        this.declaracaoIRPF.getPagamentos().getTotalContribEmpregadoDomestico().setConteudo(valor);
    }

    private void calculaTotalPensao() {
        this.declaracaoIRPF.getPagamentos().getTotalPensao().setConteudo(CalculosPagamentos.totalizarPagamentos(this.declaracaoIRPF.getPagamentos(), new String[]{"30"}, true));
    }

    private void calculaTotalDeducoesInstrucao() {
        Valor valor = new Valor();
        Valor valor2 = new Valor();
        valor2.setConteudo(CalculosPagamentos.totalizarPagamentos(this.declaracaoIRPF.getPagamentos(), new String[]{"01", "02"}, true));
        if (valor2.comparacao(">", "2.480,66")) {
            valor2.setConteudo("2.480,66");
        }
        Valor valor3 = new Valor();
        valor3.setConteudo(CalculosPagamentos.totalizarPagamentosPorBeneficiarioComLimite(this.declaracaoIRPF.getPagamentos(), new String[]{"03", "04"}));
        Valor valor4 = new Valor();
        valor4.setConteudo(CalculosPagamentos.totalizarPagamentosPorBeneficiarioComLimite(this.declaracaoIRPF.getPagamentos(), new String[]{"05", "06"}));
        valor.append('+', valor2);
        valor.append('+', valor3);
        valor.append('+', valor4);
        this.declaracaoIRPF.getPagamentos().getTotalDeducoesInstrucao().setConteudo(valor);
    }

    private void calculaTotalContribuicaoFAPI() {
        Valor valor = new Valor();
        valor.setConteudo(CalculosPagamentos.totalizarPagamentos(this.declaracaoIRPF.getPagamentos(), new String[]{"36", "38"}, false));
        if (valor.comparacao(">", this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos().operacao('*', "0,12"))) {
            valor.setConteudo(this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos().operacao('*', "0,12"));
        }
        this.declaracaoIRPF.getPagamentos().getTotalContribuicaoFAPI().setConteudo(valor);
    }

    private void calculaTotalDespesasMedicas() {
        Valor valor = CalculosPagamentos.totalizarPagamentos(this.declaracaoIRPF.getPagamentos(), new String[]{"10", "11", "20", "21", "26"}, true);
        this.declaracaoIRPF.getPagamentos().getTotalDespesasMedicas().setConteudo(valor);
    }

    public static Valor totalizarPagamentosGlosado(Pagamentos pagamentos, String[] stringArray, boolean bl) {
        Valor valor = CalculosPagamentos.totalizarPagamentos(pagamentos, stringArray, bl);
        if (valor.comparacao("<", "0,00")) {
            valor.clear();
        }
        return valor;
    }

    public static Valor totalizarPagamentos(Pagamentos pagamentos, String[] stringArray, boolean bl) {
        Valor valor = new Valor();
        List list = pagamentos.recuperarLista();
        int n = 0;
        while (n <= pagamentos.recuperarLista().size() - 1) {
            Pagamento pagamento = (Pagamento)list.get(n);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (pagamento.getCodigo().toString().equals(stringArray[n2]) && pagamento.getValorPago().comparacao(">=", pagamento.getParcelaNaoDedutivel())) {
                    valor.append('+', pagamento.getValorPago());
                    if (bl) {
                        valor.append('-', pagamento.getParcelaNaoDedutivel());
                    }
                }
                ++n2;
            }
            ++n;
        }
        return valor;
    }

    public static Valor totalizarPagamentosPorBeneficiarioComLimite(Pagamentos pagamentos, String[] stringArray) {
        Valor valor = new Valor();
        class Beneficiario {
            public String nome = null;
            public Valor total = new Valor();

            public Beneficiario(String string) {
                this.nome = string;
            }
        }
        Hashtable<String, Beneficiario> hashtable = new Hashtable<String, Beneficiario>();
        List list = pagamentos.recuperarLista();
        int n = 0;
        while (n <= pagamentos.recuperarLista().size() - 1) {
            Object object = (Pagamento)list.get(n);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (((Pagamento)object).getCodigo().toString().equals(stringArray[n2])) {
                    Beneficiario beneficiario = null;
                    if (!hashtable.containsKey(((Pagamento)object).getDependenteOuAlimentando().asString())) {
                        beneficiario = new Beneficiario(((Pagamento)object).getDependenteOuAlimentando().asString());
                        hashtable.put(beneficiario.nome, beneficiario);
                    } else {
                        beneficiario = (Beneficiario)hashtable.get(((Pagamento)object).getDependenteOuAlimentando().asString());
                    }
                    if (((Pagamento)object).getValorPago().comparacao(">=", ((Pagamento)object).getParcelaNaoDedutivel())) {
                        beneficiario.total.append('+', ((Pagamento)object).getValorPago());
                        beneficiario.total.append('-', ((Pagamento)object).getParcelaNaoDedutivel());
                    }
                }
                ++n2;
            }
            ++n;
        }
        for (Object object : hashtable.values()) {
            if (((Beneficiario)object).total.comparacao(">", "2.480,66")) {
                ((Beneficiario)object).total.setConteudo("2.480,66");
            }
            valor.append('+', ((Beneficiario)object).total);
        }
        return valor;
    }
}

