/*
 * Decompiled with CFR 0.152.
 */
package org.fsfla.irpf;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ConstantesRepositorio;
import serpro.ppgd.irpf.txt.gravacaorestauracao.GravadorTXT;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ImportadorTxt;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.Validador;

public class Main {
    public static void ajuda() {
        System.out.println("IRPF-Livre 2008 r6675\nCopyright 2007, 2008, 2009, 2010 FSFLA\nLicenciado sob GNU LGPLv2.1+ e outras licen\u00e7as, SEM QUALQUER GARANTIA.\nVeja o leiame para maiores detalhes.\n\nleiame: mostra instru\u00e7\u00f5es mais longas de uso\nnova CPF: cria nova declara\u00e7\u00e3o\nremove CPF: remove declara\u00e7\u00e3o\nimporta CPF: importa declara\u00e7\u00e3o do ano anterior\ngrava CPF: faz c\u00f3pia de seguran\u00e7a da declara\u00e7\u00e3o\nrestaura CPF: restaura c\u00f3pia de seguran\u00e7a\nrecalcula CPF: refaz c\u00e1lculos na declara\u00e7\u00e3o\nverifica CPF: verifica pend\u00eancias\nconjuges CPF: atualiza informa\u00e7\u00f5es dos conjuges nas 2 declara\u00e7\u00f5es\ncalculaDV CPF: calcula d\u00edgitos verificadores de recibos\nprepara CPF: prepara declara\u00e7\u00e3o para envio\nresumo CPF: imprime resumo da declara\u00e7\u00e3o\ncompleta CPF: imprime declara\u00e7\u00e3o completa\nrecibo CPF: imprime recibo da declara\u00e7\u00e3o\n");
    }

    public static void leiame() throws Exception {
        int n;
        InputStream inputStream = Main.class.getClassLoader().getResource("LEIAME").openStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) > 0) {
            System.out.write(byArray, 0, n);
        }
    }

    protected static DeclaracaoIRPF leDeclXML(String string) throws Exception {
        if (!IRPFFacade.existeDeclaracao(string)) {
            throw new Exception("Declara\u00e7\u00e3o n\u00e3o encontrada");
        }
        DeclaracaoIRPF declaracaoIRPF = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(string);
        IdentificadorDeclaracao identificadorDeclaracao = IRPFFacade.getInstancia().recuperarIdDeclaracao(string);
        IRPFFacade.abreDeclaracao(identificadorDeclaracao);
        IRPFFacade.getInstancia();
        declaracaoIRPF = IRPFFacade.getDeclaracao();
        Main.recalcula(declaracaoIRPF);
        return declaracaoIRPF;
    }

    public static void nova(String string) throws Exception {
        if (IRPFFacade.existeDeclaracao(string)) {
            System.err.println("declara\u00e7\u00e3o j\u00e1 existe, remova para confirmar");
            return;
        }
        IdentificadorDeclaracao identificadorDeclaracao = new IdentificadorDeclaracao();
        identificadorDeclaracao.getCpf().setConteudo(string);
        IRPFFacade.criarDeclaracao(identificadorDeclaracao);
    }

    public static void remove(String string) throws Exception {
        if (IRPFFacade.existeDeclaracao(string)) {
            IRPFFacade.excluirDeclaracao(string);
        } else {
            System.err.println("declara\u00e7\u00e3o n\u00e3o registrada");
        }
    }

    public static void importa(String string) throws Exception {
        File file = null;
        String string2 = null;
        boolean bl = false;
        Object object = new String[]{"-IRPF-" + ConstantesGlobais.EXERCICIO_ANTERIOR + "-" + ConstantesGlobais.ANO_BASE_ANTERIOR + "-RETIF", "-IRPF-" + ConstantesGlobais.EXERCICIO_ANTERIOR + "-" + ConstantesGlobais.ANO_BASE_ANTERIOR + "-ORIGI"};
        Object object2 = new String[]{".DEC", ".DBK"};
        int n = 0;
        block0: while (n < ((String[])object).length) {
            int n2 = 0;
            while (n2 < ((String[])object2).length) {
                string2 = String.valueOf(string) + object[n] + object2[n2];
                file = new File(string2);
                if (file.exists()) {
                    bl = n2 == 0;
                    break block0;
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            bl = new File(String.valueOf(string2.substring(0, string2.length() - 4)) + ".REC").exists();
        }
        System.out.println("importando de " + string2 + (bl ? " com recibo" : " sem recibo"));
        object = new ImportadorTxt();
        if (IRPFFacade.existeDeclaracao(string)) {
            System.err.println("declara\u00e7\u00e3o j\u00e1 existe, remova para confirmar");
            return;
        }
        object2 = ((ImportadorTxt)object).restaurarIdDeclaracaoNaoPersistidoAnoAnterior(file);
        IRPFFacade.criarDeclaracao((IdentificadorDeclaracao)object2);
        object2 = ((ImportadorTxt)object).importarDeclaracaoAnoAnterior(file, bl);
        if (bl) {
            String string3 = ((ImportadorTxt)object).getRepositorioTxt().recuperarNroRecibo();
            string3 = String.valueOf(string3) + Validador.calcularModulo11(string3, null, 2);
            string3 = String.valueOf(string3) + Validador.calcularModulo11(string3, null, 2);
            ((IdentificadorDeclaracao)object2).getNumeroReciboDecAnterior().setConteudo(string3);
            IRPFFacade.getInstancia().salvarDeclaracao(string);
        }
    }

    public static void grava(String string) throws Exception {
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        String string2 = GravadorTXT.montaNomeArquivoTXT(ConstantesRepositorio.GRAV_COPIA, declaracaoIRPF.getIdentificadorDeclaracao());
        System.out.println("gravando em " + string2);
        RepositorioDeclaracaoCentralTxt repositorioDeclaracaoCentralTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", new File(string2));
        repositorioDeclaracaoCentralTxt.atualizarDeclaracao(declaracaoIRPF, RepositorioDeclaracaoCentralTxt.FINALIDADE_BACKUP);
        String string3 = repositorioDeclaracaoCentralTxt.getArquivo().calcularHash();
        Vector vector = repositorioDeclaracaoCentralTxt.getConversor2Registros().montarRegistroHeader(declaracaoIRPF);
        repositorioDeclaracaoCentralTxt.getArquivo().atualizaHeader(vector, string3);
        repositorioDeclaracaoCentralTxt.getArquivo().salvar();
    }

    public static void restaura(String string) throws Exception {
        File file = null;
        String string2 = null;
        Object object = new String[]{"-IRPF-" + ConstantesGlobais.EXERCICIO + "-" + ConstantesGlobais.ANO_BASE + "-RETIF", "-IRPF-" + ConstantesGlobais.EXERCICIO + "-" + ConstantesGlobais.ANO_BASE + "-ORIGI"};
        String[] stringArray = new String[]{".DEC", ".DBK"};
        int n = 0;
        block0: while (n < ((String[])object).length) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                string2 = String.valueOf(string) + (String)object[n] + stringArray[n2];
                file = new File(string2);
                if (file.exists()) break block0;
                ++n2;
            }
            ++n;
        }
        System.out.println("restaurando de " + string2);
        object = new ImportadorTxt();
        ((ImportadorTxt)object).restaurarDeclaracao(file);
    }

    public static void recalcula(DeclaracaoIRPF declaracaoIRPF) {
        declaracaoIRPF.getRendIsentos().getPoupanca().disparaObservadores();
        declaracaoIRPF.getRendTributacaoExclusiva().getRendAplicacoes().disparaObservadores();
        declaracaoIRPF.getConjuge().getBaseCalculoImposto().disparaObservadores();
    }

    public static void recalcula(String string) throws Exception {
        Main.leDeclXML(string);
        IRPFFacade.salvaDeclaracaoAberta();
    }

    public static boolean verifica(String string) throws Exception {
        Pendencia pendencia;
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        List list = FabricaUtilitarios.verificarPendencias(declaracaoIRPF);
        if (list.isEmpty()) {
            System.out.println("N\u00e3o h\u00e1 pend\u00eancias.");
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                pendencia = (Pendencia)iterator.next();
                if (!pendencia.isErro()) {
                    bl2 = true;
                    continue;
                }
                if (!bl) {
                    System.out.println("Pend\u00eancias graves:\n");
                    bl = true;
                }
                System.out.println(pendencia.getMsg());
                System.out.println("no item " + pendencia.getNumItem());
                if (pendencia.getCampo() != null) {
                    System.out.println("do campo " + pendencia.getCampo());
                }
                if (pendencia.getEntidade() != null) {
                    System.out.println("da entidade " + pendencia.getEntidade());
                }
                System.out.println("");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            return bl;
        }
        System.out.println("Avisos:\n");
        iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                pendencia = (Pendencia)iterator.next();
                if (pendencia.isErro()) continue;
                System.out.println(pendencia.getMsg());
                System.out.println("no item " + pendencia.getNumItem());
                if (pendencia.getCampo() != null) {
                    System.out.println("do campo " + pendencia.getCampo());
                }
                if (pendencia.getEntidade() != null) {
                    System.out.println("da entidade " + pendencia.getEntidade());
                }
                System.out.println("");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private static void conjuge(DeclaracaoIRPF declaracaoIRPF, DeclaracaoIRPF declaracaoIRPF2) {
        String string = declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString();
        System.out.println("Atualizando informa\u00e7\u00f5es do c\u00f4njuge na declara\u00e7\u00e3o de " + string);
        String string2 = declaracaoIRPF2.getResumo().getCalculoImposto().getBaseCalculo().asString();
        declaracaoIRPF.getConjuge().getBaseCalculoImposto().setConteudo(string2);
        System.out.println("Base de C\u00e1lculo: " + string2);
        Valor valor = new Valor();
        if (declaracaoIRPF2.getIdentificadorDeclaracao().getTipoDeclaracao().asString().equals("0")) {
            valor.append('+', declaracaoIRPF2.getModeloCompleta().getImpostoRetidoFonteTitular());
            valor.append('+', declaracaoIRPF2.getModeloCompleta().getImpostoRetidoFonteDependentes());
            valor.append('+', declaracaoIRPF2.getModeloCompleta().getImpostoRetidoFonteLei11033());
        } else {
            valor.append('+', declaracaoIRPF2.getModeloSimplificada().getImpostoRetidoFonteTitular());
            valor.append('+', declaracaoIRPF2.getModeloSimplificada().getImpostoRetidoFonteDependentes());
        }
        string2 = valor.asString();
        declaracaoIRPF.getConjuge().getImpRetidoFonte().setConteudo(string2);
        System.out.println("Imposto Retido na Fonte: " + string2);
        string2 = declaracaoIRPF2.getResumo().getCalculoImposto().getCarneLeaoMaisImpostoComplementar().asString();
        declaracaoIRPF.getConjuge().getCarneComImpComplementar().setConteudo(string2);
        System.out.println("Carn\u00ea Le\u00e3o e Imposto Complementar: " + string2);
        string2 = declaracaoIRPF2.getResumo().getOutrasInformacoes().getRendIsentosNaoTributaveis().asString();
        declaracaoIRPF.getConjuge().getRendIsentoNaoTributaveis().setConteudo(string2);
        System.out.println("Rendimentos Isentos: " + string2);
        string2 = declaracaoIRPF2.getResumo().getOutrasInformacoes().getRendIsentosTributacaoExclusiva().asString();
        declaracaoIRPF.getConjuge().getRendSujeitosTribExcl().setConteudo(string2);
        System.out.println("Rendimentos sujeitos a Tributa\u00e7\u00e3o Exclusiva na Fonte: " + string2);
        System.out.println("Resultado: " + declaracaoIRPF.getConjuge().getResultado().asString());
    }

    public static boolean conjuges(String string) throws Exception {
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        String string2 = declaracaoIRPF.getConjuge().getCpfConjuge().asString();
        if (string2.equals("")) {
            System.err.println("CPF do conjuge n\u00e3o informado na declara\u00e7\u00e3o");
            return false;
        }
        System.out.println("Procurando declara\u00e7\u00e3o de conjuge " + string2);
        DeclaracaoIRPF declaracaoIRPF2 = Main.leDeclXML(string2);
        if (!declaracaoIRPF2.getConjuge().getCpfConjuge().asString().equals(string)) {
            if (declaracaoIRPF2.getConjuge().getCpfConjuge().asString().equals("")) {
                System.out.println("Adicionando CPF do conjuge na declara\u00e7\u00e3o de " + string2);
                declaracaoIRPF2.getConjuge().getCpfConjuge().setConteudo(string);
            } else {
                System.err.println("CPF do conjuge na declara\u00e7\u00e3o de " + string2 + " n\u00e3o \u00e9 " + string);
                return false;
            }
        }
        Main.conjuge(declaracaoIRPF2, declaracaoIRPF);
        IRPFFacade.salvaDeclaracaoAberta();
        System.out.println();
        declaracaoIRPF = Main.leDeclXML(string);
        Main.conjuge(declaracaoIRPF, declaracaoIRPF2);
        IRPFFacade.salvaDeclaracaoAberta();
        return true;
    }

    public static void calculaDV(String string) throws Exception {
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        IdentificadorDeclaracao identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        Alfa alfa = identificadorDeclaracao.getNumeroReciboDecAnterior();
        String string2 = alfa.getConteudoFormatado();
        if (string2.length() == 10) {
            string2 = String.valueOf(string2) + Validador.calcularModulo11(string2, null, 2);
            string2 = String.valueOf(string2) + Validador.calcularModulo11(string2, null, 2);
            alfa.setConteudo(string2);
            IRPFFacade.getInstancia().salvarDeclaracao(string);
        }
        if (identificadorDeclaracao.isRetificadora() && (string2 = (alfa = identificadorDeclaracao.getNumReciboDecRetif()).getConteudoFormatado()).length() == 10) {
            string2 = String.valueOf(string2) + Validador.calcularModulo11(string2, null, 2);
            string2 = String.valueOf(string2) + Validador.calcularModulo11(string2, null, 2);
            alfa.setConteudo(string2);
            IRPFFacade.getInstancia().salvarDeclaracao(string);
        }
    }

    public static void prepara(String string) throws Exception {
        if (Main.verifica(string)) {
            System.out.println("Ignorando pendencias");
        }
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        String string2 = GravadorTXT.montaNomeArquivoTXT(ConstantesRepositorio.GRAV_GERACAO, declaracaoIRPF.getIdentificadorDeclaracao());
        RepositorioDeclaracaoCentralTxt repositorioDeclaracaoCentralTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", new File(string2));
        repositorioDeclaracaoCentralTxt.atualizarDeclaracao(declaracaoIRPF, RepositorioDeclaracaoCentralTxt.FINALIDADE_ENTREGA);
        String string3 = repositorioDeclaracaoCentralTxt.getArquivo().calcularHash();
        Vector vector = repositorioDeclaracaoCentralTxt.getConversor2Registros().montarRegistroHeader(declaracaoIRPF);
        repositorioDeclaracaoCentralTxt.getArquivo().atualizaHeader(vector, string3);
        vector = repositorioDeclaracaoCentralTxt.getConversor2Registros().montarRecibo(declaracaoIRPF);
        repositorioDeclaracaoCentralTxt.getArquivo().incluirRecibo(vector, string3);
        repositorioDeclaracaoCentralTxt.getArquivo().salvar();
        String string4 = string3;
        string4 = String.valueOf(string4) + Validador.calcularModulo11(string4, null, 2);
        string4 = String.valueOf(string4) + Validador.calcularModulo11(string4, null, 2);
        System.out.println("gravada em " + string2 + " com recibo " + string4);
    }

    public static void resumo(String string) throws Exception {
        Main.leDeclXML(string);
        System.out.println("n\u00e3o implementado!");
    }

    public static void completa(String string) throws Exception {
        Main.leDeclXML(string);
        System.out.println("ainda n\u00e3o funciona :-(");
    }

    public static void recibo(String string) throws Exception {
        System.out.println("ainda n\u00e3o funciona :-(");
    }

    public static void main(String[] stringArray) {
        try {
            PlataformaPPGD.setEmDesign(false);
            int n = 0;
            if (stringArray.length >= 1 && "leiame".equals(stringArray[0])) {
                Main.leiame();
            } else if (stringArray.length != 2) {
                Main.ajuda();
            } else if ("nova".equals(stringArray[0])) {
                Main.nova(stringArray[1]);
            } else if ("remove".equals(stringArray[0])) {
                Main.remove(stringArray[1]);
            } else if ("importa".equals(stringArray[0])) {
                Main.importa(stringArray[1]);
            } else if ("grava".equals(stringArray[0])) {
                Main.grava(stringArray[1]);
            } else if ("restaura".equals(stringArray[0])) {
                Main.restaura(stringArray[1]);
            } else if ("recalcula".equals(stringArray[0])) {
                Main.recalcula(stringArray[1]);
            } else if ("verifica".equals(stringArray[0])) {
                n = Main.verifica(stringArray[1]) ? 1 : 0;
            } else if ("conjuges".equals(stringArray[0])) {
                Main.conjuges(stringArray[1]);
            } else if ("calculaDV".equals(stringArray[0])) {
                Main.calculaDV(stringArray[1]);
            } else if ("prepara".equals(stringArray[0])) {
                Main.prepara(stringArray[1]);
            } else if ("resumo".equals(stringArray[0])) {
                Main.resumo(stringArray[1]);
            } else if ("completa".equals(stringArray[0])) {
                Main.completa(stringArray[1]);
            } else if ("recibo".equals(stringArray[0])) {
                Main.recibo(stringArray[1]);
            } else {
                Main.ajuda();
            }
            System.exit(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

