/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.util.List;
import serpro.ppgd.irpf.ColecaoItemQuadroAuxiliar;
import serpro.ppgd.irpf.ColecaoItemQuadroLucrosDividendos;
import serpro.ppgd.irpf.ItemQuadroLucrosDividendos;
import serpro.ppgd.irpf.calculos.CalculosRendIsentos;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.Valor;

public class RendIsentos
extends ObjetoNegocio {
    public static final String LIMITE_ISENCAO_APOSENTADORIA = "17.077,97";
    private Valor bolsaEstudos = new Valor();
    private Valor capitalApolices = new Valor();
    private Valor indenizacoes = new Valor();
    private Valor lucroAlienacao = new Valor();
    private Valor lucroRecebido = new Valor();
    private ColecaoItemQuadroLucrosDividendos lucroRecebidoQuadroAuxiliar = new ColecaoItemQuadroLucrosDividendos();
    private Valor parcIsentaAtivRural = new Valor();
    private Valor parcIsentaAposentadoria = new Valor(this, "Parcela isenta de proventos");
    private Valor pensao = new Valor();
    private Valor poupanca = new Valor();
    private ColecaoItemQuadroAuxiliar poupancaQuadroAuxiliar = new ColecaoItemQuadroAuxiliar();
    private Valor rendSocio = new Valor();
    private Valor transferencias = new Valor();
    private Valor outros = new Valor();
    private ColecaoItemQuadroAuxiliar outrosQuadroAuxiliar = new ColecaoItemQuadroAuxiliar();
    private Valor rendDependentes = new Valor();
    private ColecaoItemQuadroAuxiliar rendDependentesQuadroAuxiliar = new ColecaoItemQuadroAuxiliar();
    private Valor total = new Valor();
    private Alfa descOutros = new Alfa();
    private Valor bensPequenoValorInformado = new Valor(this, "");
    private Valor unicoImovelInformado = new Valor(this, "");
    private Valor outrosBensImoveisInformado = new Valor(this, "");
    private Valor moedaEstrangeiraEspecieInformado = new Valor(this, "");
    private Valor totalInformado = new Valor(this, "");
    private Valor bensPequenoValorTransportado = new Valor(this, "");
    private Valor unicoImovelTransportado = new Valor(this, "");
    private Valor outrosBensImoveisTransportado = new Valor(this, "");
    private Valor moedaEstrangeiraEspecieTransportado = new Valor(this, "");
    private Valor totalTransportado = new Valor(this, "");

    public RendIsentos() {
        this.getTotal().setReadOnly(true);
        this.getParcIsentaAtivRural().setReadOnly(true);
        this.getLucroRecebido().setReadOnly(true);
        this.getBensPequenoValorTransportado().setHabilitado(false);
        this.getUnicoImovelTransportado().setHabilitado(false);
        this.getOutrosBensImoveisTransportado().setHabilitado(false);
        this.getMoedaEstrangeiraEspecieTransportado().setHabilitado(false);
        this.getTotalInformado().setHabilitado(false);
        this.getTotalTransportado().setHabilitado(false);
        this.getParcIsentaAposentadoria().addValidador(new ValidadorImpeditivoDefault(this.tab.msg("rendisentos_aposentadoria_limite", new String[]{LIMITE_ISENCAO_APOSENTADORIA})){

            public RetornoValidacao validarImplementado() {
                Valor valor = new Valor((String)this.getProximoConteudo());
                if (valor.comparacao(">", RendIsentos.LIMITE_ISENCAO_APOSENTADORIA)) {
                    this.setTipoExibicao(0);
                    this.setSeveridade((byte)5);
                    return new RetornoValidacao(tab.msg("rendisentos_aposentadoria_limite", new String[]{RendIsentos.LIMITE_ISENCAO_APOSENTADORIA}));
                }
                return null;
            }

            public void acaoOk() {
            }

            public void acaoCancelar() {
            }

            public String getTituloPopup() {
                return RendIsentos.this.getParcIsentaAposentadoria().getNomeCampo();
            }
        });
        this.lucroRecebido.addValidador(new ValidadorDefault(2){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroLucrosDividendos itemQuadroLucrosDividendos : RendIsentos.this.lucroRecebidoQuadroAuxiliar.recuperarLista()) {
                    if (!itemQuadroLucrosDividendos.getNomeFonte().isVazio()) continue;
                    return new RetornoValidacao(tab.msg("nome_fonte_pagadora_ausente"), 2);
                }
                return null;
            }
        });
        this.setFicha("Rendimentos Isentos e N\u00e3o-Tribut\u00e1veis");
    }

    public void addObservador(CalculosRendIsentos calculosRendIsentos) {
        this.bolsaEstudos.addObservador(calculosRendIsentos);
        this.capitalApolices.addObservador(calculosRendIsentos);
        this.indenizacoes.addObservador(calculosRendIsentos);
        this.bensPequenoValorInformado.addObservador(calculosRendIsentos);
        this.unicoImovelInformado.addObservador(calculosRendIsentos);
        this.outrosBensImoveisInformado.addObservador(calculosRendIsentos);
        this.moedaEstrangeiraEspecieInformado.addObservador(calculosRendIsentos);
        this.bensPequenoValorTransportado.addObservador(calculosRendIsentos);
        this.unicoImovelTransportado.addObservador(calculosRendIsentos);
        this.outrosBensImoveisTransportado.addObservador(calculosRendIsentos);
        this.moedaEstrangeiraEspecieTransportado.addObservador(calculosRendIsentos);
        this.lucroAlienacao.addObservador(calculosRendIsentos);
        this.lucroRecebido.addObservador(calculosRendIsentos);
        this.parcIsentaAtivRural.addObservador(calculosRendIsentos);
        this.parcIsentaAposentadoria.addObservador(calculosRendIsentos);
        this.pensao.addObservador(calculosRendIsentos);
        this.poupanca.addObservador(calculosRendIsentos);
        this.rendSocio.addObservador(calculosRendIsentos);
        this.transferencias.addObservador(calculosRendIsentos);
        this.outros.addObservador(calculosRendIsentos);
        this.rendDependentes.addObservador(calculosRendIsentos);
    }

    public Valor getBolsaEstudos() {
        return this.bolsaEstudos;
    }

    public void setBolsaEstudos(Valor valor) {
        this.bolsaEstudos = valor;
    }

    public Valor getCapitalApolices() {
        return this.capitalApolices;
    }

    public void setCapitalApolices(Valor valor) {
        this.capitalApolices = valor;
    }

    public Alfa getDescOutros() {
        return this.descOutros;
    }

    public void setDescOutros(Alfa alfa) {
        this.descOutros = alfa;
    }

    public Valor getIndenizacoes() {
        return this.indenizacoes;
    }

    public void setIndenizacoes(Valor valor) {
        this.indenizacoes = valor;
    }

    public Valor getLucroAlienacao() {
        return this.lucroAlienacao;
    }

    public void setLucroAlienacao(Valor valor) {
        this.lucroAlienacao = valor;
    }

    public Valor getLucroRecebido() {
        return this.lucroRecebido;
    }

    public void setLucroRecebido(Valor valor) {
        this.lucroRecebido = valor;
    }

    public Valor getOutros() {
        return this.outros;
    }

    public void setOutros(Valor valor) {
        this.outros = valor;
    }

    public Valor getParcIsentaAposentadoria() {
        return this.parcIsentaAposentadoria;
    }

    public void setParcIsentaAposentadoria(Valor valor) {
        this.parcIsentaAposentadoria = valor;
    }

    public Valor getParcIsentaAtivRural() {
        return this.parcIsentaAtivRural;
    }

    public void setParcIsentaAtivRural(Valor valor) {
        this.parcIsentaAtivRural = valor;
    }

    public Valor getPensao() {
        return this.pensao;
    }

    public void setPensao(Valor valor) {
        this.pensao = valor;
    }

    public Valor getPoupanca() {
        return this.poupanca;
    }

    public void setPoupanca(Valor valor) {
        this.poupanca = valor;
    }

    public Valor getRendDependentes() {
        return this.rendDependentes;
    }

    public void setRendDependentes(Valor valor) {
        this.rendDependentes = valor;
    }

    public Valor getRendSocio() {
        return this.rendSocio;
    }

    public void setRendSocio(Valor valor) {
        this.rendSocio = valor;
    }

    public Valor getTotal() {
        return this.total;
    }

    public void setTotal(Valor valor) {
        this.total = valor;
    }

    public Valor getTransferencias() {
        return this.transferencias;
    }

    public void setTransferencias(Valor valor) {
        this.transferencias = valor;
    }

    public ColecaoItemQuadroLucrosDividendos getLucroRecebidoQuadroAuxiliar() {
        return this.lucroRecebidoQuadroAuxiliar;
    }

    public ColecaoItemQuadroAuxiliar getOutrosQuadroAuxiliar() {
        return this.outrosQuadroAuxiliar;
    }

    public ColecaoItemQuadroAuxiliar getPoupancaQuadroAuxiliar() {
        return this.poupancaQuadroAuxiliar;
    }

    public ColecaoItemQuadroAuxiliar getRendDependentesQuadroAuxiliar() {
        return this.rendDependentesQuadroAuxiliar;
    }

    public Valor getBensPequenoValorInformado() {
        return this.bensPequenoValorInformado;
    }

    public Valor getBensPequenoValorTransportado() {
        return this.bensPequenoValorTransportado;
    }

    public Valor getMoedaEstrangeiraEspecieInformado() {
        return this.moedaEstrangeiraEspecieInformado;
    }

    public Valor getMoedaEstrangeiraEspecieTransportado() {
        return this.moedaEstrangeiraEspecieTransportado;
    }

    public Valor getOutrosBensImoveisInformado() {
        return this.outrosBensImoveisInformado;
    }

    public Valor getOutrosBensImoveisTransportado() {
        return this.outrosBensImoveisTransportado;
    }

    public Valor getUnicoImovelInformado() {
        return this.unicoImovelInformado;
    }

    public Valor getUnicoImovelTransportado() {
        return this.unicoImovelTransportado;
    }

    public Valor getTotalInformado() {
        return this.totalInformado;
    }

    public Valor getTotalTransportado() {
        return this.totalTransportado;
    }

    public Valor recuperarTotalTitularExcetoAtividadeRuraleGC() {
        Valor valor = new Valor();
        valor.append('+', this.getIndenizacoes());
        valor.append('+', this.getLucroAlienacao());
        valor.append('+', this.getParcIsentaAposentadoria());
        valor.append('+', this.getCapitalApolices());
        valor.append('+', this.getPoupanca());
        valor.append('+', this.getPensao());
        valor.append('+', this.getTransferencias());
        valor.append('+', this.getOutros());
        valor.append('+', this.getBolsaEstudos());
        valor.append('+', this.getRendSocio());
        return valor;
    }

    public Valor recuperarTotalTitular() {
        Valor valor = new Valor();
        valor.append('+', this.getIndenizacoes());
        valor.append('+', this.getLucroAlienacao());
        valor.append('+', this.recuperarTotalLucrosDividendosTit());
        valor.append('+', this.getParcIsentaAtivRural());
        valor.append('+', this.getParcIsentaAposentadoria());
        valor.append('+', this.getCapitalApolices());
        valor.append('+', this.getPoupanca());
        valor.append('+', this.getPensao());
        valor.append('+', this.getTransferencias());
        valor.append('+', this.getOutros());
        valor.append('+', this.getBolsaEstudos());
        valor.append('+', this.getRendSocio());
        return valor;
    }

    public Valor recuperarSubTotalRendIsentoTransportado() {
        Valor valor = new Valor();
        valor.append('+', this.getParcIsentaAtivRural());
        valor.append('+', this.getLucroAlienacao());
        return valor;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.lucroRecebido);
        return list;
    }

    public Valor recuperarTotalLucrosDividendosTit() {
        Valor valor = new Valor();
        for (ItemQuadroLucrosDividendos itemQuadroLucrosDividendos : this.lucroRecebidoQuadroAuxiliar.recuperarLista()) {
            if (!itemQuadroLucrosDividendos.getTipo().asString().equals("Titular")) continue;
            valor.append('+', itemQuadroLucrosDividendos.getValor());
        }
        return valor;
    }

    public Valor recuperarTotalLucrosDividendosDep() {
        Valor valor = new Valor();
        for (ItemQuadroLucrosDividendos itemQuadroLucrosDividendos : this.lucroRecebidoQuadroAuxiliar.recuperarLista()) {
            if (!itemQuadroLucrosDividendos.getTipo().asString().equals("Dependente")) continue;
            valor.append('+', itemQuadroLucrosDividendos.getValor());
        }
        return valor;
    }
}

