/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathSourceJar;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class FileSystem
implements INameEnvironment,
SuffixConstants {
    Classpath[] classpaths;
    Set knownFileNames;

    public FileSystem(String[] stringArray, String[] stringArray2, String string) {
        int n = stringArray.length;
        this.classpaths = new Classpath[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Classpath classpath = FileSystem.getClasspath(stringArray[n3], string, null);
            try {
                classpath.initialize();
                this.classpaths[n2++] = classpath;
            }
            catch (IOException iOException) {}
            ++n3;
        }
        if (n2 != n) {
            this.classpaths = new Classpath[n2];
            System.arraycopy(this.classpaths, 0, this.classpaths, 0, n2);
        }
        this.initializeKnownFileNames(stringArray2);
    }

    FileSystem(Classpath[] classpathArray, String[] stringArray) {
        int n = classpathArray.length;
        int n2 = 0;
        this.classpaths = new Classpath[n];
        int n3 = 0;
        while (n3 < n) {
            Classpath classpath = classpathArray[n3];
            try {
                classpath.initialize();
                this.classpaths[n2++] = classpath;
            }
            catch (IOException iOException) {}
            ++n3;
        }
        if (n2 != n) {
            this.classpaths = new Classpath[n2];
            System.arraycopy(this.classpaths, 0, this.classpaths, 0, n2);
        }
        this.initializeKnownFileNames(stringArray);
    }

    public static Classpath getClasspath(String string, String string2, AccessRuleSet accessRuleSet) {
        return FileSystem.getClasspath(string, string2, false, accessRuleSet);
    }

    static Classpath getClasspath(String string, String string2, boolean bl, AccessRuleSet accessRuleSet) {
        ClasspathLocation classpathLocation = null;
        File file = new File(FileSystem.convertPathSeparators(string));
        if (file.isDirectory()) {
            if (file.exists()) {
                classpathLocation = new ClasspathDirectory(file, string2, bl ? 1 : 3, accessRuleSet);
            }
        } else {
            String string3 = string.toLowerCase();
            if (string3.endsWith(".jar") || string3.endsWith(".zip")) {
                classpathLocation = bl ? new ClasspathSourceJar(file, true, accessRuleSet, string2) : new ClasspathJar(file, true, accessRuleSet);
            }
        }
        return classpathLocation;
    }

    private void initializeKnownFileNames(String[] stringArray) {
        this.knownFileNames = new HashSet(stringArray.length * 2);
        int n = stringArray.length;
        while (--n >= 0) {
            char[] cArray = stringArray[n].toCharArray();
            char[] cArray2 = null;
            int n2 = CharOperation.lastIndexOf('.', cArray);
            if (n2 != -1) {
                cArray = CharOperation.subarray(cArray, 0, n2);
            }
            CharOperation.replace(cArray, '\\', '/');
            int n3 = 0;
            while (n3 < this.classpaths.length) {
                char[] cArray3 = this.classpaths[n3].normalizedPath();
                if (this.classpaths[n3] instanceof ClasspathDirectory && CharOperation.prefixEquals(cArray3, cArray) && (cArray2 == null || cArray3.length < cArray2.length)) {
                    cArray2 = cArray3;
                }
                ++n3;
            }
            if (cArray2 == null) {
                this.knownFileNames.add(new String(cArray));
            } else {
                this.knownFileNames.add(new String(CharOperation.subarray(cArray, cArray2.length, cArray.length)));
            }
            cArray2 = null;
        }
    }

    public void cleanup() {
        int n = 0;
        int n2 = this.classpaths.length;
        while (n < n2) {
            this.classpaths[n].reset();
            ++n;
        }
    }

    private static String convertPathSeparators(String string) {
        return File.separatorChar == '/' ? string.replace('\\', '/') : string.replace('/', '\\');
    }

    private NameEnvironmentAnswer findClass(String string, char[] cArray) {
        if (this.knownFileNames.contains(string)) {
            return null;
        }
        String string2 = String.valueOf(string) + ".class";
        String string3 = string.length() == cArray.length ? "" : string2.substring(0, string.length() - cArray.length - 1);
        String string4 = File.separatorChar == '/' ? string3 : string3.replace('/', File.separatorChar);
        NameEnvironmentAnswer nameEnvironmentAnswer = null;
        if (string3 == string4) {
            int n = 0;
            int n2 = this.classpaths.length;
            while (n < n2) {
                NameEnvironmentAnswer nameEnvironmentAnswer2 = this.classpaths[n].findClass(cArray, string3, string2);
                if (nameEnvironmentAnswer2 != null) {
                    if (!nameEnvironmentAnswer2.ignoreIfBetter()) {
                        if (nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) {
                            return nameEnvironmentAnswer2;
                        }
                    } else if (nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) {
                        nameEnvironmentAnswer = nameEnvironmentAnswer2;
                    }
                }
                ++n;
            }
        } else {
            String string5 = string2.replace('/', File.separatorChar);
            int n = 0;
            int n3 = this.classpaths.length;
            while (n < n3) {
                NameEnvironmentAnswer nameEnvironmentAnswer3;
                Classpath classpath = this.classpaths[n];
                NameEnvironmentAnswer nameEnvironmentAnswer4 = nameEnvironmentAnswer3 = classpath instanceof ClasspathJar ? classpath.findClass(cArray, string3, string2) : classpath.findClass(cArray, string4, string5);
                if (nameEnvironmentAnswer3 != null) {
                    if (!nameEnvironmentAnswer3.ignoreIfBetter()) {
                        if (nameEnvironmentAnswer3.isBetter(nameEnvironmentAnswer)) {
                            return nameEnvironmentAnswer3;
                        }
                    } else if (nameEnvironmentAnswer3.isBetter(nameEnvironmentAnswer)) {
                        nameEnvironmentAnswer = nameEnvironmentAnswer3;
                    }
                }
                ++n;
            }
        }
        if (nameEnvironmentAnswer != null) {
            return nameEnvironmentAnswer;
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] cArray) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray, '/')), cArray[cArray.length - 1]);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] cArray, char[][] cArray2) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray2, cArray, '/')), cArray);
        }
        return null;
    }

    public boolean isPackage(char[][] cArray, char[] cArray2) {
        String string;
        String string2 = new String(CharOperation.concatWith(cArray, cArray2, '/'));
        String string3 = string = File.separatorChar == '/' ? string2 : string2.replace('/', File.separatorChar);
        if (string2 == string) {
            int n = 0;
            int n2 = this.classpaths.length;
            while (n < n2) {
                if (this.classpaths[n].isPackage(string2)) {
                    return true;
                }
                ++n;
            }
        } else {
            int n = 0;
            int n3 = this.classpaths.length;
            while (n < n3) {
                Classpath classpath = this.classpaths[n];
                if (classpath instanceof ClasspathJar ? classpath.isPackage(string2) : classpath.isPackage(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static interface Classpath {
        public NameEnvironmentAnswer findClass(char[] var1, String var2, String var3);

        public boolean isPackage(String var1);

        public void reset();

        public char[] normalizedPath();

        public String getPath();

        public void initialize() throws IOException;
    }
}

