/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.FdfWriter;
import com.lowagie.text.pdf.FontDetails;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PushbuttonField;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TextField;
import com.lowagie.text.pdf.XfaForm;
import com.lowagie.text.pdf.XfdfReader;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;

public class AcroFields {
    PdfReader reader;
    PdfWriter writer;
    HashMap fields;
    private int topFirst;
    private HashMap sigNames;
    private boolean append;
    public static final int DA_FONT = 0;
    public static final int DA_SIZE = 1;
    public static final int DA_COLOR = 2;
    private HashMap extensionFonts = new HashMap();
    private XfaForm xfa;
    public static final int FIELD_TYPE_NONE = 0;
    public static final int FIELD_TYPE_PUSHBUTTON = 1;
    public static final int FIELD_TYPE_CHECKBOX = 2;
    public static final int FIELD_TYPE_RADIOBUTTON = 3;
    public static final int FIELD_TYPE_TEXT = 4;
    public static final int FIELD_TYPE_LIST = 5;
    public static final int FIELD_TYPE_COMBO = 6;
    public static final int FIELD_TYPE_SIGNATURE = 7;
    private boolean lastWasString;
    private boolean generateAppearances = true;
    private HashMap localFonts = new HashMap();
    private float extraMarginLeft;
    private float extraMarginTop;
    private ArrayList substitutionFonts;
    private static final HashMap stdFieldFontNames = new HashMap();
    private int totalRevisions;
    private HashMap fieldCache;
    private static final PdfName[] buttonRemove;

    static {
        stdFieldFontNames.put("CoBO", new String[]{"Courier-BoldOblique"});
        stdFieldFontNames.put("CoBo", new String[]{"Courier-Bold"});
        stdFieldFontNames.put("CoOb", new String[]{"Courier-Oblique"});
        stdFieldFontNames.put("Cour", new String[]{"Courier"});
        stdFieldFontNames.put("HeBO", new String[]{"Helvetica-BoldOblique"});
        stdFieldFontNames.put("HeBo", new String[]{"Helvetica-Bold"});
        stdFieldFontNames.put("HeOb", new String[]{"Helvetica-Oblique"});
        stdFieldFontNames.put("Helv", new String[]{"Helvetica"});
        stdFieldFontNames.put("Symb", new String[]{"Symbol"});
        stdFieldFontNames.put("TiBI", new String[]{"Times-BoldItalic"});
        stdFieldFontNames.put("TiBo", new String[]{"Times-Bold"});
        stdFieldFontNames.put("TiIt", new String[]{"Times-Italic"});
        stdFieldFontNames.put("TiRo", new String[]{"Times-Roman"});
        stdFieldFontNames.put("ZaDb", new String[]{"ZapfDingbats"});
        stdFieldFontNames.put("HySm", new String[]{"HYSMyeongJo-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("HyGo", new String[]{"HYGoThic-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaGo", new String[]{"HeiseiKakuGo-W5", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaMi", new String[]{"HeiseiMin-W3", "UniJIS-UCS2-H"});
        stdFieldFontNames.put("MHei", new String[]{"MHei-Medium", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("MSun", new String[]{"MSung-Light", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("STSo", new String[]{"STSong-Light", "UniGB-UCS2-H"});
        buttonRemove = new PdfName[]{PdfName.MK, PdfName.F, PdfName.FF, PdfName.Q, PdfName.BS, PdfName.BORDER};
    }

    AcroFields(PdfReader pdfReader, PdfWriter pdfWriter) {
        this.reader = pdfReader;
        this.writer = pdfWriter;
        try {
            this.xfa = new XfaForm(pdfReader);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        if (pdfWriter instanceof PdfStamperImp) {
            this.append = ((PdfStamperImp)pdfWriter).isAppend();
        }
        this.fill();
    }

    void fill() {
        this.fields = new HashMap();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (pdfDictionary == null) {
            return;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.FIELDS));
        if (pdfArray == null || pdfArray.size() == 0) {
            return;
        }
        pdfArray = null;
        int n = 1;
        while (n <= this.reader.getNumberOfPages()) {
            PdfDictionary pdfDictionary2 = this.reader.getPageNRelease(n);
            PdfArray pdfArray2 = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.ANNOTS), pdfDictionary2);
            if (pdfArray2 != null) {
                ArrayList arrayList = pdfArray2.getArrayList();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    PdfObject pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n2), pdfArray2);
                    if (!(pdfObject instanceof PdfDictionary)) {
                        PdfReader.releaseLastXrefPartial((PdfObject)arrayList.get(n2));
                    } else {
                        PdfDictionary pdfDictionary3 = (PdfDictionary)pdfObject;
                        if (!PdfName.WIDGET.equals(pdfDictionary3.get(PdfName.SUBTYPE))) {
                            PdfReader.releaseLastXrefPartial((PdfObject)arrayList.get(n2));
                        } else {
                            Object object;
                            PdfDictionary pdfDictionary4 = pdfDictionary3;
                            PdfDictionary pdfDictionary5 = new PdfDictionary();
                            pdfDictionary5.putAll(pdfDictionary3);
                            String string = "";
                            PdfDictionary pdfDictionary6 = null;
                            PdfObject pdfObject2 = null;
                            while (pdfDictionary3 != null) {
                                pdfDictionary5.mergeDifferent(pdfDictionary3);
                                object = (PdfString)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.T));
                                if (object != null) {
                                    string = String.valueOf(((PdfString)object).toUnicodeString()) + "." + string;
                                }
                                if (pdfObject2 == null && pdfDictionary3.get(PdfName.V) != null) {
                                    pdfObject2 = PdfReader.getPdfObjectRelease(pdfDictionary3.get(PdfName.V));
                                }
                                if (pdfDictionary6 == null && object != null) {
                                    pdfDictionary6 = pdfDictionary3;
                                    if (pdfDictionary3.get(PdfName.V) == null && pdfObject2 != null) {
                                        pdfDictionary6.put(PdfName.V, pdfObject2);
                                    }
                                }
                                pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.PARENT), pdfDictionary3);
                            }
                            if (string.length() > 0) {
                                string = string.substring(0, string.length() - 1);
                            }
                            if ((object = (Item)this.fields.get(string)) == null) {
                                object = new Item();
                                this.fields.put(string, object);
                            }
                            if (pdfDictionary6 == null) {
                                ((Item)object).values.add(pdfDictionary4);
                            } else {
                                ((Item)object).values.add(pdfDictionary6);
                            }
                            ((Item)object).widgets.add(pdfDictionary4);
                            ((Item)object).widget_refs.add(arrayList.get(n2));
                            if (pdfDictionary != null) {
                                pdfDictionary5.mergeDifferent(pdfDictionary);
                            }
                            ((Item)object).merged.add(pdfDictionary5);
                            ((Item)object).page.add(new Integer(n));
                            ((Item)object).tabOrder.add(new Integer(n2));
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public String[] getAppearanceStates(String string) {
        PdfObject pdfObject;
        int n;
        ArrayList arrayList;
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        PdfDictionary pdfDictionary = (PdfDictionary)item.values.get(0);
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.OPT));
        if (pdfObject2 != null) {
            if (pdfObject2.isString()) {
                hashMap.put(((PdfString)pdfObject2).toUnicodeString(), null);
            } else if (pdfObject2.isArray()) {
                arrayList = ((PdfArray)pdfObject2).getArrayList();
                n = 0;
                while (n < arrayList.size()) {
                    pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n));
                    if (pdfObject != null && pdfObject.isString()) {
                        hashMap.put(((PdfString)pdfObject).toUnicodeString(), null);
                    }
                    ++n;
                }
            }
        }
        arrayList = item.widgets;
        n = 0;
        while (n < arrayList.size()) {
            PdfObject pdfObject3;
            pdfObject = (PdfDictionary)arrayList.get(n);
            if ((pdfObject = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.AP))) != null && (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.N))) != null && pdfObject3.isDictionary()) {
                pdfObject = (PdfDictionary)pdfObject3;
                Iterator iterator = ((PdfDictionary)pdfObject).getKeys().iterator();
                while (iterator.hasNext()) {
                    String string2 = PdfName.decodeName(((PdfName)iterator.next()).toString());
                    hashMap.put(string2, null);
                }
            }
            ++n;
        }
        String[] stringArray = new String[hashMap.size()];
        return hashMap.keySet().toArray(stringArray);
    }

    private String[] getListOption(String string, int n) {
        Item item = this.getFieldItem(string);
        if (item == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.OPT));
        if (pdfObject == null || !pdfObject.isArray()) {
            return null;
        }
        PdfArray pdfArray = (PdfArray)pdfObject;
        String[] stringArray = new String[pdfArray.size()];
        ArrayList arrayList = pdfArray.getArrayList();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            pdfObject = PdfReader.getPdfObject((PdfObject)arrayList.get(n2));
            try {
                if (pdfObject.isArray()) {
                    pdfObject = (PdfObject)((PdfArray)pdfObject).getArrayList().get(n);
                }
                stringArray[n2] = pdfObject.isString() ? ((PdfString)pdfObject).toUnicodeString() : pdfObject.toString();
            }
            catch (Exception exception) {
                stringArray[n2] = "";
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getListOptionExport(String string) {
        return this.getListOption(string, 0);
    }

    public String[] getListOptionDisplay(String string) {
        return this.getListOption(string, 1);
    }

    public boolean setListOption(String string, String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray == null && stringArray2 == null) {
            return false;
        }
        if (stringArray != null && stringArray2 != null && stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("The export and the display array must have the same size.");
        }
        int n2 = this.getFieldType(string);
        if (n2 != 6 && n2 != 5) {
            return false;
        }
        Item item = (Item)this.fields.get(string);
        String[] stringArray3 = null;
        if (stringArray == null && stringArray2 != null) {
            stringArray3 = stringArray2;
        } else if (stringArray != null && stringArray2 == null) {
            stringArray3 = stringArray;
        }
        PdfArray pdfArray = new PdfArray();
        if (stringArray3 != null) {
            n = 0;
            while (n < stringArray3.length) {
                pdfArray.add(new PdfString(stringArray3[n], "UnicodeBig"));
                ++n;
            }
        } else {
            n = 0;
            while (n < stringArray.length) {
                PdfArray pdfArray2 = new PdfArray();
                pdfArray2.add(new PdfString(stringArray[n], "UnicodeBig"));
                pdfArray2.add(new PdfString(stringArray2[n], "UnicodeBig"));
                pdfArray.add(pdfArray2);
                ++n;
            }
        }
        ((PdfDictionary)item.values.get(0)).put(PdfName.OPT, pdfArray);
        n = 0;
        while (n < item.merged.size()) {
            ((PdfDictionary)item.merged.get(n)).put(PdfName.OPT, pdfArray);
            ++n;
        }
        return true;
    }

    public int getFieldType(String string) {
        Item item = this.getFieldItem(string);
        if (item == null) {
            return 0;
        }
        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (pdfObject == null) {
            return 0;
        }
        int n = 0;
        PdfObject pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
        if (pdfObject2 != null && pdfObject2.type() == 2) {
            n = ((PdfNumber)pdfObject2).intValue();
        }
        if (PdfName.BTN.equals(pdfObject)) {
            if ((n & 0x10000) != 0) {
                return 1;
            }
            if ((n & 0x8000) != 0) {
                return 3;
            }
            return 2;
        }
        if (PdfName.TX.equals(pdfObject)) {
            return 4;
        }
        if (PdfName.CH.equals(pdfObject)) {
            if ((n & 0x20000) != 0) {
                return 6;
            }
            return 5;
        }
        if (PdfName.SIG.equals(pdfObject)) {
            return 7;
        }
        return 0;
    }

    public void exportAsFdf(FdfWriter fdfWriter) {
        for (Map.Entry entry : this.fields.entrySet()) {
            Item item = (Item)entry.getValue();
            String string = (String)entry.getKey();
            PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
            if (pdfObject == null) continue;
            String string2 = this.getField(string);
            if (this.lastWasString) {
                fdfWriter.setFieldAsString(string, string2);
                continue;
            }
            fdfWriter.setFieldAsName(string, string2);
        }
    }

    public boolean renameField(String string, String string2) {
        int n;
        int n2 = string.lastIndexOf(46) + 1;
        if (n2 != (n = string2.lastIndexOf(46) + 1)) {
            return false;
        }
        if (!string.substring(0, n2).equals(string2.substring(0, n))) {
            return false;
        }
        if (this.fields.containsKey(string2)) {
            return false;
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        string2 = string2.substring(n);
        PdfString pdfString = new PdfString(string2, "UnicodeBig");
        int n3 = 0;
        while (n3 < item.merged.size()) {
            PdfDictionary pdfDictionary = (PdfDictionary)item.values.get(n3);
            pdfDictionary.put(PdfName.T, pdfString);
            this.markUsed(pdfDictionary);
            pdfDictionary = (PdfDictionary)item.merged.get(n3);
            pdfDictionary.put(PdfName.T, pdfString);
            ++n3;
        }
        this.fields.remove(string);
        this.fields.put(string2, item);
        return true;
    }

    public static Object[] splitDAelements(String string) {
        try {
            PRTokeniser pRTokeniser = new PRTokeniser(PdfEncodings.convertToBytes(string, null));
            ArrayList<String> arrayList = new ArrayList<String>();
            Object[] objectArray = new Object[3];
            while (pRTokeniser.nextToken()) {
                if (pRTokeniser.getTokenType() == 4) continue;
                if (pRTokeniser.getTokenType() == 10) {
                    float f;
                    float f2;
                    float f3;
                    String string2 = pRTokeniser.getStringValue();
                    if (string2.equals("Tf")) {
                        if (arrayList.size() >= 2) {
                            objectArray[0] = arrayList.get(arrayList.size() - 2);
                            objectArray[1] = new Float((String)arrayList.get(arrayList.size() - 1));
                        }
                    } else if (string2.equals("g")) {
                        if (arrayList.size() >= 1 && (f3 = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue()) != 0.0f) {
                            objectArray[2] = new GrayColor(f3);
                        }
                    } else if (string2.equals("rg")) {
                        if (arrayList.size() >= 3) {
                            f3 = new Float((String)arrayList.get(arrayList.size() - 3)).floatValue();
                            f2 = new Float((String)arrayList.get(arrayList.size() - 2)).floatValue();
                            f = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue();
                            objectArray[2] = new Color(f3, f2, f);
                        }
                    } else if (string2.equals("k") && arrayList.size() >= 4) {
                        f3 = new Float((String)arrayList.get(arrayList.size() - 4)).floatValue();
                        f2 = new Float((String)arrayList.get(arrayList.size() - 3)).floatValue();
                        f = new Float((String)arrayList.get(arrayList.size() - 2)).floatValue();
                        float f4 = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue();
                        objectArray[2] = new CMYKColor(f3, f2, f, f4);
                    }
                    arrayList.clear();
                    continue;
                }
                arrayList.add(pRTokeniser.getStringValue());
            }
            return objectArray;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void decodeGenericDictionary(PdfDictionary pdfDictionary, BaseField baseField) throws IOException, DocumentException {
        Object object;
        Object object2;
        Object object3;
        PdfObject pdfObject;
        Object object4;
        int n = 0;
        PdfString pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DA));
        if (pdfString != null) {
            object4 = AcroFields.splitDAelements(pdfString.toUnicodeString());
            if (object4[1] != null) {
                baseField.setFontSize(((Float)object4[1]).floatValue());
            }
            if (object4[2] != null) {
                baseField.setTextColor((Color)object4[2]);
            }
            if (object4[0] != null && (pdfObject = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DR))) != null && (pdfObject = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.FONT))) != null) {
                object3 = ((PdfDictionary)pdfObject).get(new PdfName((String)object4[0]));
                if (object3 != null && ((PdfObject)object3).type() == 10) {
                    PdfDictionary pdfDictionary2;
                    PdfDictionary pdfDictionary3;
                    object2 = (PRIndirectReference)object3;
                    object = new DocumentFont((PRIndirectReference)object3);
                    baseField.setFont((BaseFont)object);
                    Integer n2 = new Integer(((PdfIndirectReference)object2).getNumber());
                    BaseFont baseFont = (BaseFont)this.extensionFonts.get(n2);
                    if (baseFont == null && !this.extensionFonts.containsKey(n2) && (pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject((pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)object3)).get(PdfName.FONTDESCRIPTOR))) != null) {
                        PRStream pRStream = (PRStream)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.FONTFILE2));
                        if (pRStream == null) {
                            pRStream = (PRStream)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.FONTFILE3));
                        }
                        if (pRStream == null) {
                            this.extensionFonts.put(n2, null);
                        } else {
                            try {
                                baseFont = BaseFont.createFont("font.ttf", "Identity-H", true, false, PdfReader.getStreamBytes(pRStream), null);
                            }
                            catch (Exception exception) {
                                baseFont = null;
                            }
                            this.extensionFonts.put(n2, baseFont);
                        }
                    }
                    if (baseField instanceof TextField) {
                        ((TextField)baseField).setExtensionFont(baseFont);
                    }
                } else {
                    object2 = (BaseFont)this.localFonts.get(object4[0]);
                    if (object2 == null) {
                        object = (String[])stdFieldFontNames.get(object4[0]);
                        if (object != null) {
                            try {
                                Object object5 = "winansi";
                                if (((Object)object).length > 1) {
                                    object5 = object[1];
                                }
                                object2 = BaseFont.createFont((String)object[0], (String)object5, false);
                                baseField.setFont((BaseFont)object2);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        baseField.setFont((BaseFont)object2);
                    }
                }
            }
        }
        if ((object4 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MK))) != null) {
            pdfObject = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.BC));
            object3 = this.getMKColor((PdfArray)pdfObject);
            baseField.setBorderColor((Color)object3);
            if (object3 != null) {
                baseField.setBorderWidth(1.0f);
            }
            pdfObject = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.BG));
            baseField.setBackgroundColor(this.getMKColor((PdfArray)pdfObject));
            object2 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object4).get(PdfName.R));
            if (object2 != null) {
                baseField.setRotation(((PdfNumber)object2).intValue());
            }
        }
        pdfObject = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.F));
        n = 0;
        if (pdfObject != null) {
            n = ((PdfNumber)pdfObject).intValue();
            if ((n & 4) != 0 && (n & 2) != 0) {
                baseField.setVisibility(1);
            } else if ((n & 4) != 0 && (n & 0x20) != 0) {
                baseField.setVisibility(3);
            } else if ((n & 4) != 0) {
                baseField.setVisibility(0);
            } else {
                baseField.setVisibility(2);
            }
        }
        pdfObject = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FF));
        n = 0;
        if (pdfObject != null) {
            n = ((PdfNumber)pdfObject).intValue();
        }
        baseField.setOptions(n);
        if ((n & 0x1000000) != 0) {
            object3 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MAXLEN));
            int n3 = 0;
            if (object3 != null) {
                n3 = ((PdfNumber)object3).intValue();
            }
            baseField.setMaxCharacterLength(n3);
        }
        if ((pdfObject = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.Q))) != null) {
            if (((PdfNumber)pdfObject).intValue() == 1) {
                baseField.setAlignment(1);
            } else if (((PdfNumber)pdfObject).intValue() == 2) {
                baseField.setAlignment(2);
            }
        }
        if ((object3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BS))) != null) {
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object3).get(PdfName.W));
            if (pdfNumber != null) {
                baseField.setBorderWidth(pdfNumber.floatValue());
            }
            if (PdfName.D.equals(object = (PdfName)PdfReader.getPdfObject(((PdfDictionary)object3).get(PdfName.S)))) {
                baseField.setBorderStyle(1);
            } else if (PdfName.B.equals(object)) {
                baseField.setBorderStyle(2);
            } else if (PdfName.I.equals(object)) {
                baseField.setBorderStyle(3);
            } else if (PdfName.U.equals(object)) {
                baseField.setBorderStyle(4);
            }
        } else {
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BORDER));
            if (pdfArray != null) {
                object = pdfArray.getArrayList();
                if (((ArrayList)object).size() >= 3) {
                    baseField.setBorderWidth(((PdfNumber)((ArrayList)object).get(2)).floatValue());
                }
                if (((ArrayList)object).size() >= 4) {
                    baseField.setBorderStyle(1);
                }
            }
        }
    }

    PdfAppearance getAppearance(PdfDictionary pdfDictionary, String string, String string2) throws IOException, DocumentException {
        Object object;
        Object object2;
        PdfObject pdfObject;
        this.topFirst = 0;
        TextField textField = null;
        if (this.fieldCache == null || !this.fieldCache.containsKey(string2)) {
            textField = new TextField(this.writer, null, null);
            textField.setExtraMargin(this.extraMarginLeft, this.extraMarginTop);
            textField.setBorderWidth(0.0f);
            textField.setSubstitutionFonts(this.substitutionFonts);
            this.decodeGenericDictionary(pdfDictionary, textField);
            pdfObject = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT));
            object2 = PdfReader.getNormalizedRectangle((PdfArray)pdfObject);
            if (textField.getRotation() == 90 || textField.getRotation() == 270) {
                object2 = ((Rectangle)object2).rotate();
            }
            textField.setBox((Rectangle)object2);
            if (this.fieldCache != null) {
                this.fieldCache.put(string2, textField);
            }
        } else {
            textField = (TextField)this.fieldCache.get(string2);
            textField.setWriter(this.writer);
        }
        if (PdfName.TX.equals(pdfObject = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FT)))) {
            textField.setText(string);
            return textField.getAppearance();
        }
        if (!PdfName.CH.equals(pdfObject)) {
            throw new DocumentException("An appearance was requested without a variable text field.");
        }
        object2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.OPT));
        int n = 0;
        PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FF));
        if (pdfNumber != null) {
            n = pdfNumber.intValue();
        }
        if ((n & 0x20000) != 0 && object2 == null) {
            textField.setText(string);
            return textField.getAppearance();
        }
        if (object2 != null) {
            object = ((PdfArray)object2).getArrayList();
            String[] stringArray = new String[((ArrayList)object).size()];
            String[] stringArray2 = new String[((ArrayList)object).size()];
            int n2 = 0;
            while (n2 < ((ArrayList)object).size()) {
                PdfObject pdfObject2 = (PdfObject)((ArrayList)object).get(n2);
                if (pdfObject2.isString()) {
                    stringArray[n2] = stringArray2[n2] = ((PdfString)pdfObject2).toUnicodeString();
                } else {
                    ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
                    stringArray2[n2] = ((PdfString)arrayList.get(0)).toUnicodeString();
                    stringArray[n2] = ((PdfString)arrayList.get(1)).toUnicodeString();
                }
                ++n2;
            }
            if ((n & 0x20000) != 0) {
                n2 = 0;
                while (n2 < stringArray.length) {
                    if (string.equals(stringArray2[n2])) {
                        string = stringArray[n2];
                        break;
                    }
                    ++n2;
                }
                textField.setText(string);
                return textField.getAppearance();
            }
            n2 = 0;
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (string.equals(stringArray2[n3])) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            textField.setChoices(stringArray);
            textField.setChoiceExports(stringArray2);
            textField.setChoiceSelection(n2);
        }
        object = textField.getListAppearance();
        this.topFirst = textField.getTopFirst();
        return object;
    }

    Color getMKColor(PdfArray pdfArray) {
        if (pdfArray == null) {
            return null;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        switch (arrayList.size()) {
            case 1: {
                return new GrayColor(((PdfNumber)arrayList.get(0)).floatValue());
            }
            case 3: {
                return new Color(ExtendedColor.normalize(((PdfNumber)arrayList.get(0)).floatValue()), ExtendedColor.normalize(((PdfNumber)arrayList.get(1)).floatValue()), ExtendedColor.normalize(((PdfNumber)arrayList.get(2)).floatValue()));
            }
            case 4: {
                return new CMYKColor(((PdfNumber)arrayList.get(0)).floatValue(), ((PdfNumber)arrayList.get(1)).floatValue(), ((PdfNumber)arrayList.get(2)).floatValue(), ((PdfNumber)arrayList.get(3)).floatValue());
            }
        }
        return null;
    }

    public String getField(String string) {
        if (this.xfa.isXfaPresent()) {
            if ((string = this.xfa.findFieldName(string, this)) == null) {
                return null;
            }
            string = XfaForm.Xml2Som.getShortName(string);
            return XfaForm.getNodeText(this.xfa.findDatasetsNode(string));
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        this.lastWasString = false;
        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
        if (pdfObject == null) {
            return "";
        }
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.BTN.equals(pdfName)) {
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            int n = 0;
            if (pdfNumber != null) {
                n = pdfNumber.intValue();
            }
            if ((n & 0x10000) != 0) {
                return "";
            }
            String string2 = "";
            if (pdfObject.isName()) {
                string2 = PdfName.decodeName(pdfObject.toString());
            } else if (pdfObject.isString()) {
                string2 = ((PdfString)pdfObject).toUnicodeString();
            }
            PdfObject pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)item.values.get(0)).get(PdfName.OPT));
            if (pdfObject2 != null && pdfObject2.isArray()) {
                ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string2);
                    PdfString pdfString = (PdfString)arrayList.get(n2);
                    string2 = pdfString.toUnicodeString();
                    this.lastWasString = true;
                }
                catch (Exception exception) {}
            }
            return string2;
        }
        if (pdfObject.isString()) {
            this.lastWasString = true;
            return ((PdfString)pdfObject).toUnicodeString();
        }
        return PdfName.decodeName(pdfObject.toString());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean setFieldProperty(String string, String string2, Object object, int[] nArray) {
        if (this.writer == null) {
            throw new RuntimeException("This AcroFields instance is read-only.");
        }
        try {
            Item item = (Item)this.fields.get(string);
            if (item == null) {
                return false;
            }
            InstHit instHit = new InstHit(nArray);
            if (string2.equalsIgnoreCase("textfont")) {
                int n = 0;
                while (n < item.merged.size()) {
                    if (instHit.isHit(n)) {
                        PdfString pdfString = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(n)).get(PdfName.DA));
                        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(n)).get(PdfName.DR));
                        if (pdfString != null && pdfDictionary != null) {
                            Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                            PdfAppearance pdfAppearance = new PdfAppearance();
                            if (objectArray[0] != null) {
                                Object object2;
                                PdfDictionary pdfDictionary2;
                                BaseFont baseFont = (BaseFont)object;
                                PdfName pdfName = (PdfName)PdfAppearance.stdFieldFontNames.get(baseFont.getPostscriptFontName());
                                if (pdfName == null) {
                                    pdfName = new PdfName(baseFont.getPostscriptFontName());
                                }
                                if ((pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONT))) == null) {
                                    pdfDictionary2 = new PdfDictionary();
                                    pdfDictionary.put(PdfName.FONT, pdfDictionary2);
                                }
                                PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)pdfDictionary2.get(pdfName);
                                PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
                                this.markUsed(pdfDictionary3);
                                pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.DR));
                                if (pdfDictionary == null) {
                                    pdfDictionary = new PdfDictionary();
                                    pdfDictionary3.put(PdfName.DR, pdfDictionary);
                                }
                                this.markUsed(pdfDictionary);
                                PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONT));
                                if (pdfDictionary4 == null) {
                                    pdfDictionary4 = new PdfDictionary();
                                    pdfDictionary.put(PdfName.FONT, pdfDictionary4);
                                }
                                this.markUsed(pdfDictionary4);
                                PdfIndirectReference pdfIndirectReference2 = (PdfIndirectReference)pdfDictionary4.get(pdfName);
                                if (pdfIndirectReference2 != null) {
                                    if (pdfIndirectReference == null) {
                                        pdfDictionary2.put(pdfName, pdfIndirectReference2);
                                    }
                                } else if (pdfIndirectReference == null) {
                                    if (baseFont.getFontType() == 4) {
                                        object2 = new FontDetails(null, ((DocumentFont)baseFont).getIndirectReference(), baseFont);
                                    } else {
                                        baseFont.setSubset(false);
                                        object2 = this.writer.addSimple(baseFont);
                                        this.localFonts.put(pdfName.toString().substring(1), baseFont);
                                    }
                                    pdfDictionary4.put(pdfName, ((FontDetails)object2).getIndirectReference());
                                    pdfDictionary2.put(pdfName, ((FontDetails)object2).getIndirectReference());
                                }
                                object2 = pdfAppearance.getInternalBuffer();
                                ((ByteBuffer)object2).append(pdfName.getBytes()).append(' ').append(((Float)objectArray[1]).floatValue()).append(" Tf ");
                                if (objectArray[2] != null) {
                                    pdfAppearance.setColorFill((Color)objectArray[2]);
                                }
                                PdfString pdfString2 = new PdfString(pdfAppearance.toString());
                                ((PdfDictionary)item.merged.get(n)).put(PdfName.DA, pdfString2);
                                ((PdfDictionary)item.widgets.get(n)).put(PdfName.DA, pdfString2);
                                this.markUsed((PdfDictionary)item.widgets.get(n));
                            }
                        }
                    }
                    ++n;
                }
            } else if (string2.equalsIgnoreCase("textcolor")) {
                int n = 0;
                while (n < item.merged.size()) {
                    PdfString pdfString;
                    if (instHit.isHit(n) && (pdfString = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(n)).get(PdfName.DA))) != null) {
                        Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                        PdfAppearance pdfAppearance = new PdfAppearance();
                        if (objectArray[0] != null) {
                            ByteBuffer byteBuffer = pdfAppearance.getInternalBuffer();
                            byteBuffer.append(new PdfName((String)objectArray[0]).getBytes()).append(' ').append(((Float)objectArray[1]).floatValue()).append(" Tf ");
                            pdfAppearance.setColorFill((Color)object);
                            PdfString pdfString3 = new PdfString(pdfAppearance.toString());
                            ((PdfDictionary)item.merged.get(n)).put(PdfName.DA, pdfString3);
                            ((PdfDictionary)item.widgets.get(n)).put(PdfName.DA, pdfString3);
                            this.markUsed((PdfDictionary)item.widgets.get(n));
                        }
                    }
                    ++n;
                }
            } else if (string2.equalsIgnoreCase("textsize")) {
                int n = 0;
                while (n < item.merged.size()) {
                    PdfString pdfString;
                    if (instHit.isHit(n) && (pdfString = (PdfString)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(n)).get(PdfName.DA))) != null) {
                        Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                        PdfAppearance pdfAppearance = new PdfAppearance();
                        if (objectArray[0] != null) {
                            ByteBuffer byteBuffer = pdfAppearance.getInternalBuffer();
                            byteBuffer.append(new PdfName((String)objectArray[0]).getBytes()).append(' ').append(((Float)object).floatValue()).append(" Tf ");
                            if (objectArray[2] != null) {
                                pdfAppearance.setColorFill((Color)objectArray[2]);
                            }
                            PdfString pdfString4 = new PdfString(pdfAppearance.toString());
                            ((PdfDictionary)item.merged.get(n)).put(PdfName.DA, pdfString4);
                            ((PdfDictionary)item.widgets.get(n)).put(PdfName.DA, pdfString4);
                            this.markUsed((PdfDictionary)item.widgets.get(n));
                        }
                    }
                    ++n;
                }
            } else if (string2.equalsIgnoreCase("bgcolor") || string2.equalsIgnoreCase("bordercolor")) {
                PdfName pdfName = string2.equalsIgnoreCase("bgcolor") ? PdfName.BG : PdfName.BC;
                int n = 0;
                while (n < item.merged.size()) {
                    if (instHit.isHit(n)) {
                        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(n)).get(PdfName.MK));
                        this.markUsed(pdfObject);
                        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                        if (pdfDictionary == null) {
                            if (object == null) {
                                return true;
                            }
                            pdfDictionary = new PdfDictionary();
                            ((PdfDictionary)item.merged.get(n)).put(PdfName.MK, pdfDictionary);
                            ((PdfDictionary)item.widgets.get(n)).put(PdfName.MK, pdfDictionary);
                            this.markUsed((PdfDictionary)item.widgets.get(n));
                        }
                        if (object == null) {
                            pdfDictionary.remove(pdfName);
                        } else {
                            pdfDictionary.put(pdfName, PdfFormField.getMKColor((Color)object));
                        }
                    }
                    ++n;
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public boolean setFieldProperty(String string, String string2, int n, int[] nArray) {
        if (this.writer == null) {
            throw new RuntimeException("This AcroFields instance is read-only.");
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        InstHit instHit = new InstHit(nArray);
        if (string2.equalsIgnoreCase("flags")) {
            PdfNumber pdfNumber = new PdfNumber(n);
            int n2 = 0;
            while (n2 < item.merged.size()) {
                if (instHit.isHit(n2)) {
                    ((PdfDictionary)item.merged.get(n2)).put(PdfName.F, pdfNumber);
                    ((PdfDictionary)item.widgets.get(n2)).put(PdfName.F, pdfNumber);
                    this.markUsed((PdfDictionary)item.widgets.get(n2));
                }
                ++n2;
            }
        } else if (string2.equalsIgnoreCase("setflags")) {
            int n3 = 0;
            while (n3 < item.merged.size()) {
                if (instHit.isHit(n3)) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.widgets.get(n3)).get(PdfName.F));
                    int n4 = 0;
                    if (pdfNumber != null) {
                        n4 = pdfNumber.intValue();
                    }
                    pdfNumber = new PdfNumber(n4 | n);
                    ((PdfDictionary)item.merged.get(n3)).put(PdfName.F, pdfNumber);
                    ((PdfDictionary)item.widgets.get(n3)).put(PdfName.F, pdfNumber);
                    this.markUsed((PdfDictionary)item.widgets.get(n3));
                }
                ++n3;
            }
        } else if (string2.equalsIgnoreCase("clrflags")) {
            int n5 = 0;
            while (n5 < item.merged.size()) {
                if (instHit.isHit(n5)) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.widgets.get(n5)).get(PdfName.F));
                    int n6 = 0;
                    if (pdfNumber != null) {
                        n6 = pdfNumber.intValue();
                    }
                    pdfNumber = new PdfNumber(n6 & ~n);
                    ((PdfDictionary)item.merged.get(n5)).put(PdfName.F, pdfNumber);
                    ((PdfDictionary)item.widgets.get(n5)).put(PdfName.F, pdfNumber);
                    this.markUsed((PdfDictionary)item.widgets.get(n5));
                }
                ++n5;
            }
        } else if (string2.equalsIgnoreCase("fflags")) {
            PdfNumber pdfNumber = new PdfNumber(n);
            int n7 = 0;
            while (n7 < item.merged.size()) {
                if (instHit.isHit(n7)) {
                    ((PdfDictionary)item.merged.get(n7)).put(PdfName.FF, pdfNumber);
                    ((PdfDictionary)item.values.get(n7)).put(PdfName.FF, pdfNumber);
                    this.markUsed((PdfDictionary)item.values.get(n7));
                }
                ++n7;
            }
        } else if (string2.equalsIgnoreCase("setfflags")) {
            int n8 = 0;
            while (n8 < item.merged.size()) {
                if (instHit.isHit(n8)) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.values.get(n8)).get(PdfName.FF));
                    int n9 = 0;
                    if (pdfNumber != null) {
                        n9 = pdfNumber.intValue();
                    }
                    pdfNumber = new PdfNumber(n9 | n);
                    ((PdfDictionary)item.merged.get(n8)).put(PdfName.FF, pdfNumber);
                    ((PdfDictionary)item.values.get(n8)).put(PdfName.FF, pdfNumber);
                    this.markUsed((PdfDictionary)item.values.get(n8));
                }
                ++n8;
            }
        } else if (string2.equalsIgnoreCase("clrfflags")) {
            int n10 = 0;
            while (n10 < item.merged.size()) {
                if (instHit.isHit(n10)) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.values.get(n10)).get(PdfName.FF));
                    int n11 = 0;
                    if (pdfNumber != null) {
                        n11 = pdfNumber.intValue();
                    }
                    pdfNumber = new PdfNumber(n11 & ~n);
                    ((PdfDictionary)item.merged.get(n10)).put(PdfName.FF, pdfNumber);
                    ((PdfDictionary)item.values.get(n10)).put(PdfName.FF, pdfNumber);
                    this.markUsed((PdfDictionary)item.values.get(n10));
                }
                ++n10;
            }
        } else {
            return false;
        }
        return true;
    }

    public void mergeXfaData(Node node) throws IOException, DocumentException {
        XfaForm.Xml2SomDatasets xml2SomDatasets = new XfaForm.Xml2SomDatasets(node);
        for (String string : xml2SomDatasets.getOrder()) {
            String string2 = XfaForm.getNodeText((Node)xml2SomDatasets.getName2Node().get(string));
            this.setField(string, string2);
        }
    }

    public void setFields(FdfReader fdfReader) throws IOException, DocumentException {
        HashMap hashMap = fdfReader.getFields();
        for (String string : hashMap.keySet()) {
            String string2 = fdfReader.getFieldValue(string);
            if (string2 == null) continue;
            this.setField(string, string2);
        }
    }

    public void setFields(XfdfReader xfdfReader) throws IOException, DocumentException {
        HashMap hashMap = xfdfReader.getFields();
        for (String string : hashMap.keySet()) {
            String string2 = xfdfReader.getFieldValue(string);
            if (string2 == null) continue;
            this.setField(string, string2);
        }
    }

    public boolean regenerateField(String string) throws IOException, DocumentException {
        String string2 = this.getField(string);
        return this.setField(string, string2, string2);
    }

    public boolean setField(String string, String string2) throws IOException, DocumentException {
        return this.setField(string, string2, null);
    }

    public boolean setField(String string, String string2, String string3) throws IOException, DocumentException {
        int n;
        PdfObject pdfObject;
        Object object;
        Object object2;
        if (this.writer == null) {
            throw new DocumentException("This AcroFields instance is read-only.");
        }
        if (this.xfa.isXfaPresent()) {
            if ((string = this.xfa.findFieldName(string, this)) == null) {
                return false;
            }
            object2 = XfaForm.Xml2Som.getShortName(string);
            object = this.xfa.findDatasetsNode((String)object2);
            if (object == null) {
                object = this.xfa.getDatasetsSom().insertNode(this.xfa.getDatasetsNode(), (String)object2);
            }
            this.xfa.setNodeText((Node)object, string2);
        }
        if ((object2 = (Item)this.fields.get(string)) == null) {
            return false;
        }
        object = (PdfName)PdfReader.getPdfObject(((PdfDictionary)((Item)object2).merged.get(0)).get(PdfName.FT));
        if (PdfName.TX.equals(object)) {
            pdfObject = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)((Item)object2).merged.get(0)).get(PdfName.MAXLEN));
            n = 0;
            if (pdfObject != null) {
                n = ((PdfNumber)pdfObject).intValue();
            }
            if (n > 0) {
                string2 = string2.substring(0, Math.min(n, string2.length()));
            }
        }
        if (string3 == null) {
            string3 = string2;
        }
        if (PdfName.TX.equals(object) || PdfName.CH.equals(object)) {
            pdfObject = new PdfString(string2, "UnicodeBig");
            n = 0;
            while (n < ((Item)object2).values.size()) {
                PdfDictionary pdfDictionary = (PdfDictionary)((Item)object2).values.get(n);
                pdfDictionary.put(PdfName.V, pdfObject);
                pdfDictionary.remove(PdfName.I);
                this.markUsed(pdfDictionary);
                PdfDictionary pdfDictionary2 = (PdfDictionary)((Item)object2).merged.get(n);
                pdfDictionary2.remove(PdfName.I);
                pdfDictionary2.put(PdfName.V, pdfObject);
                PdfDictionary pdfDictionary3 = (PdfDictionary)((Item)object2).widgets.get(n);
                if (this.generateAppearances) {
                    PdfObject pdfObject2;
                    PdfAppearance pdfAppearance = this.getAppearance(pdfDictionary2, string3, string);
                    if (PdfName.CH.equals(object)) {
                        pdfObject2 = new PdfNumber(this.topFirst);
                        pdfDictionary3.put(PdfName.TI, pdfObject2);
                        pdfDictionary2.put(PdfName.TI, pdfObject2);
                    }
                    if ((pdfObject2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.AP))) == null) {
                        pdfObject2 = new PdfDictionary();
                        pdfDictionary3.put(PdfName.AP, pdfObject2);
                        pdfDictionary2.put(PdfName.AP, pdfObject2);
                    }
                    ((PdfDictionary)pdfObject2).put(PdfName.N, pdfAppearance.getIndirectReference());
                    this.writer.releaseTemplate(pdfAppearance);
                } else {
                    pdfDictionary3.remove(PdfName.AP);
                    pdfDictionary2.remove(PdfName.AP);
                }
                this.markUsed(pdfDictionary3);
                ++n;
            }
            return true;
        }
        if (PdfName.BTN.equals(object)) {
            pdfObject = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)((Item)object2).merged.get(0)).get(PdfName.FF));
            n = 0;
            if (pdfObject != null) {
                n = ((PdfNumber)pdfObject).intValue();
            }
            if ((n & 0x10000) != 0) {
                return true;
            }
            PdfName pdfName = new PdfName(string2);
            if ((n & 0x8000) == 0) {
                int n2 = 0;
                while (n2 < ((Item)object2).values.size()) {
                    ((PdfDictionary)((Item)object2).values.get(n2)).put(PdfName.V, pdfName);
                    this.markUsed((PdfDictionary)((Item)object2).values.get(n2));
                    PdfDictionary pdfDictionary = (PdfDictionary)((Item)object2).merged.get(n2);
                    pdfDictionary.put(PdfName.V, pdfName);
                    pdfDictionary.put(PdfName.AS, pdfName);
                    PdfDictionary pdfDictionary4 = (PdfDictionary)((Item)object2).widgets.get(n2);
                    if (this.isInAP(pdfDictionary4, pdfName)) {
                        pdfDictionary4.put(PdfName.AS, pdfName);
                    } else {
                        pdfDictionary4.put(PdfName.AS, PdfName.Off);
                    }
                    this.markUsed(pdfDictionary4);
                    ++n2;
                }
            } else {
                PdfObject pdfObject3;
                ArrayList<String> arrayList = new ArrayList<String>();
                PdfObject pdfObject4 = PdfReader.getPdfObject(((PdfDictionary)((Item)object2).values.get(0)).get(PdfName.OPT));
                if (pdfObject4 != null && pdfObject4.isArray()) {
                    ArrayList arrayList2 = ((PdfArray)pdfObject4).getArrayList();
                    int n3 = 0;
                    while (n3 < arrayList2.size()) {
                        pdfObject3 = PdfReader.getPdfObject((PdfObject)arrayList2.get(n3));
                        if (pdfObject3 != null && pdfObject3.isString()) {
                            arrayList.add(((PdfString)pdfObject3).toUnicodeString());
                        } else {
                            arrayList.add(null);
                        }
                        ++n3;
                    }
                }
                int n4 = arrayList.indexOf(string2);
                PdfName pdfName2 = null;
                if (n4 >= 0) {
                    pdfName2 = new PdfName(String.valueOf(n4));
                    pdfObject3 = pdfName2;
                } else {
                    pdfObject3 = pdfName;
                }
                int n5 = 0;
                while (n5 < ((Item)object2).values.size()) {
                    PdfDictionary pdfDictionary = (PdfDictionary)((Item)object2).merged.get(n5);
                    PdfDictionary pdfDictionary5 = (PdfDictionary)((Item)object2).widgets.get(n5);
                    this.markUsed((PdfDictionary)((Item)object2).values.get(n5));
                    if (pdfName2 != null) {
                        PdfString pdfString = new PdfString(string2, "UnicodeBig");
                        ((PdfDictionary)((Item)object2).values.get(n5)).put(PdfName.V, pdfString);
                        pdfDictionary.put(PdfName.V, pdfString);
                    } else {
                        ((PdfDictionary)((Item)object2).values.get(n5)).put(PdfName.V, pdfName);
                        pdfDictionary.put(PdfName.V, pdfName);
                    }
                    this.markUsed(pdfDictionary5);
                    if (this.isInAP(pdfDictionary5, (PdfName)pdfObject3)) {
                        pdfDictionary.put(PdfName.AS, pdfObject3);
                        pdfDictionary5.put(PdfName.AS, pdfObject3);
                    } else {
                        pdfDictionary.put(PdfName.AS, PdfName.Off);
                        pdfDictionary5.put(PdfName.AS, PdfName.Off);
                    }
                    ++n5;
                }
            }
            return true;
        }
        return false;
    }

    boolean isInAP(PdfDictionary pdfDictionary, PdfName pdfName) {
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AP));
        if (pdfDictionary2 == null) {
            return false;
        }
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.N));
        return pdfDictionary3 != null && pdfDictionary3.get(pdfName) != null;
    }

    public HashMap getFields() {
        return this.fields;
    }

    public Item getFieldItem(String string) {
        if (this.xfa.isXfaPresent() && (string = this.xfa.findFieldName(string, this)) == null) {
            return null;
        }
        return (Item)this.fields.get(string);
    }

    public String getTranslatedFieldName(String string) {
        String string2;
        if (this.xfa.isXfaPresent() && (string2 = this.xfa.findFieldName(string, this)) != null) {
            string = string2;
        }
        return string;
    }

    public float[] getFieldPositions(String string) {
        Item item = this.getFieldItem(string);
        if (item == null) {
            return null;
        }
        float[] fArray = new float[item.page.size() * 5];
        int n = 0;
        int n2 = 0;
        while (n2 < item.page.size()) {
            try {
                PdfDictionary pdfDictionary = (PdfDictionary)item.widgets.get(n2);
                PdfArray pdfArray = (PdfArray)pdfDictionary.get(PdfName.RECT);
                if (pdfArray != null) {
                    Rectangle rectangle = PdfReader.getNormalizedRectangle(pdfArray);
                    int n3 = (Integer)item.page.get(n2);
                    int n4 = this.reader.getPageRotation(n3);
                    fArray[n++] = n3;
                    if (n4 != 0) {
                        Rectangle rectangle2 = this.reader.getPageSize(n3);
                        switch (n4) {
                            case 270: {
                                rectangle = new Rectangle(rectangle2.top() - rectangle.bottom(), rectangle.left(), rectangle2.top() - rectangle.top(), rectangle.right());
                                break;
                            }
                            case 180: {
                                rectangle = new Rectangle(rectangle2.right() - rectangle.left(), rectangle2.top() - rectangle.bottom(), rectangle2.right() - rectangle.right(), rectangle2.top() - rectangle.top());
                                break;
                            }
                            case 90: {
                                rectangle = new Rectangle(rectangle.bottom(), rectangle2.right() - rectangle.left(), rectangle.top(), rectangle2.right() - rectangle.right());
                            }
                        }
                        rectangle.normalize();
                    }
                    fArray[n++] = rectangle.left();
                    fArray[n++] = rectangle.bottom();
                    fArray[n++] = rectangle.right();
                    fArray[n++] = rectangle.top();
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        if (n < fArray.length) {
            float[] fArray2 = new float[n];
            System.arraycopy(fArray, 0, fArray2, 0, n);
            return fArray2;
        }
        return fArray;
    }

    private int removeRefFromArray(PdfArray pdfArray, PdfObject pdfObject) {
        ArrayList arrayList = pdfArray.getArrayList();
        if (pdfObject == null || !pdfObject.isIndirect()) {
            return arrayList.size();
        }
        PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)pdfObject;
        int n = 0;
        while (n < arrayList.size()) {
            PdfObject pdfObject2 = (PdfObject)arrayList.get(n);
            if (pdfObject2.isIndirect() && ((PdfIndirectReference)pdfObject2).getNumber() == pdfIndirectReference.getNumber()) {
                arrayList.remove(n--);
            }
            ++n;
        }
        return arrayList.size();
    }

    public boolean removeFieldsFromPage(int n) {
        if (n < 1) {
            return false;
        }
        String[] stringArray = new String[this.fields.size()];
        this.fields.keySet().toArray(stringArray);
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            boolean bl2 = this.removeField(stringArray[n2], n);
            bl = bl || bl2;
            ++n2;
        }
        return bl;
    }

    public boolean removeField(String string, int n) {
        Item item = this.getFieldItem(string);
        if (item == null) {
            return false;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM), this.reader.getCatalog());
        if (pdfDictionary == null) {
            return false;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FIELDS), pdfDictionary);
        if (pdfArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < item.widget_refs.size()) {
            int n3 = (Integer)item.page.get(n2);
            if (n == -1 || n == n3) {
                PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)item.widget_refs.get(n2);
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference);
                PdfDictionary pdfDictionary3 = this.reader.getPageN(n3);
                PdfArray pdfArray2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.ANNOTS), pdfDictionary3);
                if (pdfArray2 != null) {
                    if (this.removeRefFromArray(pdfArray2, pdfIndirectReference) == 0) {
                        pdfDictionary3.remove(PdfName.ANNOTS);
                        this.markUsed(pdfDictionary3);
                    } else {
                        this.markUsed(pdfArray2);
                    }
                }
                PdfReader.killIndirect(pdfIndirectReference);
                PdfIndirectReference pdfIndirectReference2 = pdfIndirectReference;
                while ((pdfIndirectReference = (PdfIndirectReference)pdfDictionary2.get(PdfName.PARENT)) != null) {
                    pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference);
                    PdfArray pdfArray3 = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.KIDS));
                    if (this.removeRefFromArray(pdfArray3, pdfIndirectReference2) != 0) break;
                    pdfIndirectReference2 = pdfIndirectReference;
                    PdfReader.killIndirect(pdfIndirectReference);
                }
                if (pdfIndirectReference == null) {
                    this.removeRefFromArray(pdfArray, pdfIndirectReference2);
                    this.markUsed(pdfArray);
                }
                if (n != -1) {
                    item.merged.remove(n2);
                    item.page.remove(n2);
                    item.values.remove(n2);
                    item.widget_refs.remove(n2);
                    item.widgets.remove(n2);
                    --n2;
                }
            }
            ++n2;
        }
        if (n == -1 || item.merged.size() == 0) {
            this.fields.remove(string);
        }
        return true;
    }

    public boolean removeField(String string) {
        return this.removeField(string, -1);
    }

    public boolean isGenerateAppearances() {
        return this.generateAppearances;
    }

    public void setGenerateAppearances(boolean bl) {
        this.generateAppearances = bl;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (bl) {
            pdfDictionary.remove(PdfName.NEEDAPPEARANCES);
        } else {
            pdfDictionary.put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
        }
    }

    public ArrayList getSignatureNames() {
        Object object;
        Object object2;
        if (this.sigNames != null) {
            return new ArrayList(this.sigNames.keySet());
        }
        this.sigNames = new HashMap();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (Map.Entry objectArray : this.fields.entrySet()) {
            ArrayList arrayList2;
            PdfObject pdfObject;
            PdfDictionary pdfDictionary;
            PdfObject pdfObject2;
            PdfObject pdfObject3;
            object2 = (Item)objectArray.getValue();
            object = (PdfDictionary)((Item)object2).merged.get(0);
            if (!PdfName.SIG.equals(((PdfDictionary)object).get(PdfName.FT)) || (pdfObject3 = PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.V))) == null || pdfObject3.type() != 6 || (pdfObject2 = (pdfDictionary = (PdfDictionary)pdfObject3).get(PdfName.CONTENTS)) == null || pdfObject2.type() != 3 || (pdfObject = pdfDictionary.get(PdfName.BYTERANGE)) == null || pdfObject.type() != 5 || (arrayList2 = ((PdfArray)pdfObject).getArrayList()).size() < 2) continue;
            int n = ((PdfNumber)arrayList2.get(arrayList2.size() - 1)).intValue() + ((PdfNumber)arrayList2.get(arrayList2.size() - 2)).intValue();
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = objectArray.getKey();
            int[] nArray = new int[2];
            nArray[0] = n;
            objectArray2[1] = nArray;
            arrayList.add(objectArray2);
        }
        Collections.sort(arrayList, new SorterComparator());
        if (!arrayList.isEmpty()) {
            this.totalRevisions = ((int[])((Object[])arrayList.get(arrayList.size() - 1))[1])[0] == this.reader.getFileLength() ? arrayList.size() : arrayList.size() + 1;
            int n = 0;
            while (n < arrayList.size()) {
                Object[] objectArray = (Object[])arrayList.get(n);
                object2 = (String)objectArray[0];
                object = (int[])objectArray[1];
                object[1] = n + 1;
                this.sigNames.put(object2, object);
                ++n;
            }
        }
        return new ArrayList(this.sigNames.keySet());
    }

    public ArrayList getBlankSignatureNames() {
        this.getSignatureNames();
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : this.fields.entrySet()) {
            Item item = (Item)entry.getValue();
            PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(0);
            if (!PdfName.SIG.equals(pdfDictionary.get(PdfName.FT)) || this.sigNames.containsKey(entry.getKey())) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public PdfDictionary getSignatureDictionary(String string) {
        this.getSignatureNames();
        string = this.getTranslatedFieldName(string);
        if (!this.sigNames.containsKey(string)) {
            return null;
        }
        Item item = (Item)this.fields.get(string);
        PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(0);
        return (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.V));
    }

    public boolean signatureCoversWholeDocument(String string) {
        this.getSignatureNames();
        string = this.getTranslatedFieldName(string);
        if (!this.sigNames.containsKey(string)) {
            return false;
        }
        return ((int[])this.sigNames.get(string))[0] == this.reader.getFileLength();
    }

    public PdfPKCS7 verifySignature(String string) {
        return this.verifySignature(string, null);
    }

    public PdfPKCS7 verifySignature(String string, String string2) {
        PdfDictionary pdfDictionary = this.getSignatureDictionary(string);
        if (pdfDictionary == null) {
            return null;
        }
        try {
            PdfObject pdfObject;
            PdfString pdfString;
            PdfName pdfName = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.SUBFILTER));
            PdfString pdfString2 = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS));
            PdfPKCS7 pdfPKCS7 = null;
            if (pdfName.equals(PdfName.ADBE_X509_RSA_SHA1)) {
                pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.CERT));
                pdfPKCS7 = new PdfPKCS7(pdfString2.getOriginalBytes(), pdfString.getBytes(), string2);
            } else {
                pdfPKCS7 = new PdfPKCS7(pdfString2.getOriginalBytes(), string2);
            }
            this.updateByteRange(pdfPKCS7, pdfDictionary);
            pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.M));
            if (pdfString != null) {
                pdfPKCS7.setSignDate(PdfDate.decode(pdfString.toString()));
            }
            if ((pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAME))) != null) {
                if (pdfObject.isString()) {
                    pdfPKCS7.setSignName(((PdfString)pdfObject).toUnicodeString());
                } else if (pdfObject.isName()) {
                    pdfPKCS7.setSignName(PdfName.decodeName(pdfObject.toString()));
                }
            }
            if ((pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.REASON))) != null) {
                pdfPKCS7.setReason(pdfString.toUnicodeString());
            }
            if ((pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.LOCATION))) != null) {
                pdfPKCS7.setLocation(pdfString.toUnicodeString());
            }
            return pdfPKCS7;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private void updateByteRange(PdfPKCS7 pdfPKCS7, PdfDictionary pdfDictionary) {
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BYTERANGE));
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        try {
            try {
                randomAccessFileOrArray.reOpen();
                byte[] byArray = new byte[8192];
                ArrayList arrayList = pdfArray.getArrayList();
                int n = 0;
                while (n < arrayList.size()) {
                    int n2 = ((PdfNumber)arrayList.get(n)).intValue();
                    int n3 = ((PdfNumber)arrayList.get(++n)).intValue();
                    randomAccessFileOrArray.seek(n2);
                    while (n3 > 0) {
                        int n4 = randomAccessFileOrArray.read(byArray, 0, Math.min(n3, byArray.length));
                        if (n4 <= 0) break;
                        n3 -= n4;
                        pdfPKCS7.update(byArray, 0, n4);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
    }

    private void markUsed(PdfObject pdfObject) {
        if (!this.append) {
            return;
        }
        ((PdfStamperImp)this.writer).markUsed(pdfObject);
    }

    public int getTotalRevisions() {
        this.getSignatureNames();
        return this.totalRevisions;
    }

    public int getRevision(String string) {
        this.getSignatureNames();
        string = this.getTranslatedFieldName(string);
        if (!this.sigNames.containsKey(string)) {
            return 0;
        }
        return ((int[])this.sigNames.get(string))[1];
    }

    public InputStream extractRevision(String string) throws IOException {
        this.getSignatureNames();
        string = this.getTranslatedFieldName(string);
        if (!this.sigNames.containsKey(string)) {
            return null;
        }
        int n = ((int[])this.sigNames.get(string))[0];
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        randomAccessFileOrArray.reOpen();
        randomAccessFileOrArray.seek(0);
        return new RevisionStream(randomAccessFileOrArray, n);
    }

    public HashMap getFieldCache() {
        return this.fieldCache;
    }

    public void setFieldCache(HashMap hashMap) {
        this.fieldCache = hashMap;
    }

    public void setExtraMargin(float f, float f2) {
        this.extraMarginLeft = f;
        this.extraMarginTop = f2;
    }

    public void addSubstitutionFont(BaseFont baseFont) {
        if (this.substitutionFonts == null) {
            this.substitutionFonts = new ArrayList();
        }
        this.substitutionFonts.add(baseFont);
    }

    public ArrayList getSubstitutionFonts() {
        return this.substitutionFonts;
    }

    public void setSubstitutionFonts(ArrayList arrayList) {
        this.substitutionFonts = arrayList;
    }

    public XfaForm getXfa() {
        return this.xfa;
    }

    public PushbuttonField getNewPushbuttonFromField(String string) {
        block17: {
            try {
                if (this.getFieldType(string) == 1) break block17;
                return null;
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        float[] fArray = this.getFieldPositions(string);
        Rectangle rectangle = new Rectangle(fArray[1], fArray[2], fArray[3], fArray[4]);
        PushbuttonField pushbuttonField = new PushbuttonField(this.writer, rectangle, null);
        Item item = this.getFieldItem(string);
        PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(0);
        this.decodeGenericDictionary(pdfDictionary, pushbuttonField);
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MK));
        if (pdfDictionary2 != null) {
            PdfObject pdfObject;
            PdfDictionary pdfDictionary3;
            PdfNumber pdfNumber;
            PdfString pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.CA));
            if (pdfString != null) {
                pushbuttonField.setText(pdfString.toUnicodeString());
            }
            if ((pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.TP))) != null) {
                pushbuttonField.setLayout(pdfNumber.intValue() + 1);
            }
            if ((pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.IF))) != null) {
                PdfObject pdfObject2;
                PdfArray pdfArray;
                pdfObject = (PdfName)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.SW));
                if (pdfObject != null) {
                    int n = 1;
                    if (((PdfName)pdfObject).equals(PdfName.B)) {
                        n = 3;
                    } else if (((PdfName)pdfObject).equals(PdfName.S)) {
                        n = 4;
                    } else if (((PdfName)pdfObject).equals(PdfName.N)) {
                        n = 2;
                    }
                    pushbuttonField.setScaleIcon(n);
                }
                if ((pdfObject = (PdfName)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.S))) != null && ((PdfName)pdfObject).equals(PdfName.A)) {
                    pushbuttonField.setProportionalIcon(false);
                }
                if ((pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.A))) != null && pdfArray.size() == 2) {
                    float f = ((PdfNumber)PdfReader.getPdfObject((PdfObject)pdfArray.getArrayList().get(0))).floatValue();
                    float f2 = ((PdfNumber)PdfReader.getPdfObject((PdfObject)pdfArray.getArrayList().get(1))).floatValue();
                    pushbuttonField.setIconHorizontalAdjustment(f);
                    pushbuttonField.setIconVerticalAdjustment(f2);
                }
                if ((pdfObject2 = PdfReader.getPdfObject(pdfDictionary3.get(PdfName.FB))) != null && pdfObject2.toString().equals("true")) {
                    pushbuttonField.setIconFitToBounds(true);
                }
            }
            if ((pdfObject = pdfDictionary2.get(PdfName.I)) != null && pdfObject.isIndirect()) {
                pushbuttonField.setIconReference((PRIndirectReference)pdfObject);
            }
        }
        return pushbuttonField;
    }

    public boolean replacePushbuttonField(String string, PdfFormField pdfFormField) {
        if (this.getFieldType(string) != 1) {
            return false;
        }
        Item item = this.getFieldItem(string);
        PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(0);
        PdfDictionary pdfDictionary2 = (PdfDictionary)item.values.get(0);
        PdfDictionary pdfDictionary3 = (PdfDictionary)item.widgets.get(0);
        int n = 0;
        while (n < buttonRemove.length) {
            pdfDictionary.remove(buttonRemove[n]);
            pdfDictionary2.remove(buttonRemove[n]);
            pdfDictionary3.remove(buttonRemove[n]);
            ++n;
        }
        for (PdfName pdfName : pdfFormField.getKeys()) {
            if (pdfName.equals(PdfName.T) || pdfName.equals(PdfName.RECT)) continue;
            pdfDictionary.put(pdfName, pdfFormField.get(pdfName));
            pdfDictionary3.put(pdfName, pdfFormField.get(pdfName));
        }
        return true;
    }

    private static class InstHit {
        IntHashtable hits;

        public InstHit(int[] nArray) {
            if (nArray == null) {
                return;
            }
            this.hits = new IntHashtable();
            int n = 0;
            while (n < nArray.length) {
                this.hits.put(nArray[n], 1);
                ++n;
            }
        }

        public boolean isHit(int n) {
            if (this.hits == null) {
                return true;
            }
            return this.hits.containsKey(n);
        }
    }

    public static class Item {
        public ArrayList values = new ArrayList();
        public ArrayList widgets = new ArrayList();
        public ArrayList widget_refs = new ArrayList();
        public ArrayList merged = new ArrayList();
        public ArrayList page = new ArrayList();
        public ArrayList tabOrder = new ArrayList();
    }

    private static class RevisionStream
    extends InputStream {
        private byte[] b = new byte[1];
        private RandomAccessFileOrArray raf;
        private int length;
        private int rangePosition = 0;
        private boolean closed;

        private RevisionStream(RandomAccessFileOrArray randomAccessFileOrArray, int n) {
            this.raf = randomAccessFileOrArray;
            this.length = n;
        }

        public int read() throws IOException {
            int n = this.read(this.b);
            if (n != 1) {
                return -1;
            }
            return this.b[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.rangePosition >= this.length) {
                this.close();
                return -1;
            }
            int n3 = Math.min(n2, this.length - this.rangePosition);
            this.raf.readFully(byArray, n, n3);
            this.rangePosition += n3;
            return n3;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.raf.close();
                this.closed = true;
            }
        }
    }

    private static class SorterComparator
    implements Comparator {
        private SorterComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = ((int[])((Object[])object)[1])[0];
            int n2 = ((int[])((Object[])object2)[1])[0];
            return n - n2;
        }
    }
}

