/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FinallyFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.flow.NullInfoRegistry;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class TryStatement
extends SubRoutineStatement {
    private static final char[] SECRET_RETURN_ADDRESS_NAME = " returnAddress".toCharArray();
    private static final char[] SECRET_ANY_HANDLER_NAME = " anyExceptionHandler".toCharArray();
    private static final char[] SECRET_RETURN_VALUE_NAME = " returnValue".toCharArray();
    public Block tryBlock;
    public Block[] catchBlocks;
    public Argument[] catchArguments;
    public Block finallyBlock;
    BlockScope scope;
    public UnconditionalFlowInfo subRoutineInits;
    ReferenceBinding[] caughtExceptionTypes;
    boolean[] catchExits;
    BranchLabel subRoutineStartLabel;
    public LocalVariableBinding anyExceptionVariable;
    public LocalVariableBinding returnAddressVariable;
    public LocalVariableBinding secretReturnValue;
    ExceptionLabel[] declaredExceptionLabels;
    private Object[] reusableJSRTargets;
    private BranchLabel[] reusableJSRSequenceStartLabels;
    private int reusableJSRTargetsCount = 0;
    private static final int NO_FINALLY = 0;
    private static final int FINALLY_SUBROUTINE = 1;
    private static final int FINALLY_DOES_NOT_COMPLETE = 2;
    private static final int FINALLY_INLINE = 3;
    int mergedInitStateIndex = -1;
    int preTryInitStateIndex = -1;
    int postTryInitStateIndex = -1;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo flowInfo2;
        this.preTryInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        if (this.anyExceptionVariable != null) {
            this.anyExceptionVariable.useFlag = 1;
        }
        if (this.returnAddressVariable != null) {
            this.returnAddressVariable.useFlag = 1;
        }
        if (this.subRoutineStartLabel == null) {
            FlowInfo flowInfo3;
            ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(flowContext, this, this.caughtExceptionTypes, this.scope, flowInfo.unconditionalInits());
            exceptionHandlingFlowContext.initsOnFinally = new NullInfoRegistry(flowInfo.unconditionalInits());
            if (this.tryBlock.isEmptyBlock()) {
                flowInfo3 = flowInfo;
                this.postTryInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3);
            } else {
                flowInfo3 = this.tryBlock.analyseCode(blockScope, exceptionHandlingFlowContext, flowInfo.copy());
                if ((flowInfo3.tagBits & 1) != 0) {
                    this.bits |= 0x20000000;
                }
                this.postTryInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3);
            }
            exceptionHandlingFlowContext.complainIfUnusedExceptionHandlers(this.scope, this);
            if (this.catchArguments != null) {
                int n = this.catchBlocks.length;
                this.catchExits = new boolean[n];
                int n2 = 0;
                while (n2 < n) {
                    FlowInfo flowInfo4 = this.caughtExceptionTypes[n2].isUncheckedException(false) ? flowInfo.unconditionalCopy().addPotentialInitializationsFrom(exceptionHandlingFlowContext.initsOnException(this.caughtExceptionTypes[n2])).addPotentialInitializationsFrom(flowInfo3).addPotentialInitializationsFrom(exceptionHandlingFlowContext.initsOnReturn) : flowInfo.unconditionalCopy().addPotentialInitializationsFrom(exceptionHandlingFlowContext.initsOnException(this.caughtExceptionTypes[n2])).addPotentialInitializationsFrom(flowInfo3.nullInfoLessUnconditionalCopy()).addPotentialInitializationsFrom(exceptionHandlingFlowContext.initsOnReturn.nullInfoLessUnconditionalCopy());
                    LocalVariableBinding localVariableBinding = this.catchArguments[n2].binding;
                    flowInfo4.markAsDefinitelyAssigned(localVariableBinding);
                    flowInfo4.markAsDefinitelyNonNull(localVariableBinding);
                    if (this.tryBlock.statements == null) {
                        flowInfo4.setReachMode(1);
                    }
                    flowInfo4 = this.catchBlocks[n2].analyseCode(blockScope, flowContext, flowInfo4);
                    this.catchExits[n2] = (flowInfo4.tagBits & 1) != 0;
                    flowInfo3 = flowInfo3.mergedWith(flowInfo4.unconditionalInits());
                    ++n2;
                }
            }
            this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3);
            if (flowContext.initsOnFinally != null) {
                flowContext.initsOnFinally.add(exceptionHandlingFlowContext.initsOnFinally);
            }
            return flowInfo3;
        }
        InsideSubRoutineFlowContext insideSubRoutineFlowContext = new InsideSubRoutineFlowContext(flowContext, this);
        FinallyFlowContext finallyFlowContext = new FinallyFlowContext(flowContext, this.finallyBlock);
        UnconditionalFlowInfo unconditionalFlowInfo = this.finallyBlock.analyseCode(blockScope, finallyFlowContext, flowInfo.nullInfoLessUnconditionalCopy()).unconditionalInits();
        if (unconditionalFlowInfo == FlowInfo.DEAD_END) {
            this.bits |= 0x4000;
            this.scope.problemReporter().finallyMustCompleteNormally(this.finallyBlock);
        }
        this.subRoutineInits = unconditionalFlowInfo;
        ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(insideSubRoutineFlowContext, this, this.caughtExceptionTypes, this.scope, flowInfo.unconditionalInits());
        exceptionHandlingFlowContext.initsOnFinally = new NullInfoRegistry(flowInfo.unconditionalInits());
        if (this.tryBlock.isEmptyBlock()) {
            flowInfo2 = flowInfo;
            this.postTryInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo2);
        } else {
            flowInfo2 = this.tryBlock.analyseCode(blockScope, exceptionHandlingFlowContext, flowInfo.copy());
            if ((flowInfo2.tagBits & 1) != 0) {
                this.bits |= 0x20000000;
            }
            this.postTryInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo2);
        }
        exceptionHandlingFlowContext.complainIfUnusedExceptionHandlers(this.scope, this);
        if (this.catchArguments != null) {
            int n = this.catchBlocks.length;
            this.catchExits = new boolean[n];
            int n3 = 0;
            while (n3 < n) {
                FlowInfo flowInfo5 = flowInfo.unconditionalCopy().addPotentialInitializationsFrom(exceptionHandlingFlowContext.initsOnException(this.caughtExceptionTypes[n3])).addPotentialInitializationsFrom(flowInfo2.nullInfoLessUnconditionalCopy()).addPotentialInitializationsFrom(exceptionHandlingFlowContext.initsOnReturn.nullInfoLessUnconditionalCopy());
                LocalVariableBinding localVariableBinding = this.catchArguments[n3].binding;
                flowInfo5.markAsDefinitelyAssigned(localVariableBinding);
                flowInfo5.markAsDefinitelyNonNull(localVariableBinding);
                if (this.tryBlock.statements == null) {
                    flowInfo5.setReachMode(1);
                }
                flowInfo5 = this.catchBlocks[n3].analyseCode(blockScope, insideSubRoutineFlowContext, flowInfo5);
                this.catchExits[n3] = (flowInfo5.tagBits & 1) != 0;
                flowInfo2 = flowInfo2.mergedWith(flowInfo5.unconditionalInits());
                ++n3;
            }
        }
        finallyFlowContext.complainOnDeferredChecks(exceptionHandlingFlowContext.initsOnFinally.mitigateNullInfoOf((flowInfo2.tagBits & 1) == 0 ? flowInfo.unconditionalCopy().addPotentialInitializationsFrom(flowInfo2).addPotentialInitializationsFrom(insideSubRoutineFlowContext.initsOnReturn) : insideSubRoutineFlowContext.initsOnReturn), blockScope);
        if (flowContext.initsOnFinally != null) {
            flowContext.initsOnFinally.add(exceptionHandlingFlowContext.initsOnFinally);
        }
        if (unconditionalFlowInfo == FlowInfo.DEAD_END) {
            this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo);
            return unconditionalFlowInfo;
        }
        FlowInfo flowInfo6 = flowInfo2.addInitializationsFrom(unconditionalFlowInfo);
        this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo6);
        return flowInfo6;
    }

    public ExceptionLabel enterAnyExceptionHandler(CodeStream codeStream) {
        if (this.subRoutineStartLabel == null) {
            return null;
        }
        return super.enterAnyExceptionHandler(codeStream);
    }

    public void enterDeclaredExceptionHandlers(CodeStream codeStream) {
        int n = 0;
        int n2 = this.declaredExceptionLabels == null ? 0 : this.declaredExceptionLabels.length;
        while (n < n2) {
            this.declaredExceptionLabels[n].placeStart();
            ++n;
        }
    }

    public void exitAnyExceptionHandler() {
        if (this.subRoutineStartLabel == null) {
            return;
        }
        super.exitAnyExceptionHandler();
    }

    public void exitDeclaredExceptionHandlers(CodeStream codeStream) {
        int n = 0;
        int n2 = this.declaredExceptionLabels == null ? 0 : this.declaredExceptionLabels.length;
        while (n < n2) {
            this.declaredExceptionLabels[n].placeEnd();
            ++n;
        }
    }

    private int finallyMode() {
        if (this.subRoutineStartLabel == null) {
            return 0;
        }
        if (this.isSubRoutineEscaping()) {
            return 2;
        }
        if (this.scope.compilerOptions().inlineJsrBytecode) {
            return 3;
        }
        return 1;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        Label label;
        int n;
        ExceptionLabel[] exceptionLabelArray;
        int n2;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        this.anyExceptionLabel = null;
        this.reusableJSRTargets = null;
        this.reusableJSRSequenceStartLabels = null;
        this.reusableJSRTargetsCount = 0;
        int n3 = codeStream.position;
        int n4 = this.finallyMode();
        boolean bl = false;
        boolean bl2 = false;
        int n5 = n2 = this.catchArguments == null ? 0 : this.catchArguments.length;
        if (n2 > 0) {
            exceptionLabelArray = new ExceptionLabel[n2];
            n = 0;
            while (n < n2) {
                label = new ExceptionLabel(codeStream, this.catchArguments[n].binding.type);
                ((ExceptionLabel)label).placeStart();
                exceptionLabelArray[n] = label;
                ++n;
            }
        } else {
            exceptionLabelArray = null;
        }
        if (this.subRoutineStartLabel != null) {
            this.subRoutineStartLabel.initialize(codeStream);
            this.enterAnyExceptionHandler(codeStream);
        }
        try {
            this.declaredExceptionLabels = exceptionLabelArray;
            this.tryBlock.generateCode(this.scope, codeStream);
        }
        finally {
            this.declaredExceptionLabels = null;
        }
        int n6 = n = codeStream.position != n3 ? 1 : 0;
        if (n != 0) {
            int n7;
            label = new BranchLabel(codeStream);
            BranchLabel branchLabel = null;
            BranchLabel branchLabel2 = null;
            int n8 = 0;
            while (n8 < n2) {
                exceptionLabelArray[n8].placeEnd();
                ++n8;
            }
            if ((this.bits & 0x20000000) == 0) {
                n8 = codeStream.position;
                switch (n4) {
                    case 1: 
                    case 3: {
                        bl = true;
                        if (this.postTryInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.postTryInitStateIndex);
                            codeStream.addDefinitelyAssignedVariables(blockScope, this.postTryInitStateIndex);
                        }
                        codeStream.goto_((BranchLabel)label);
                        break;
                    }
                    case 0: {
                        if (this.postTryInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.postTryInitStateIndex);
                            codeStream.addDefinitelyAssignedVariables(blockScope, this.postTryInitStateIndex);
                        }
                        codeStream.goto_((BranchLabel)label);
                        break;
                    }
                    case 2: {
                        codeStream.goto_(this.subRoutineStartLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(this.tryBlock.scope, n8);
            }
            if (this.catchArguments != null) {
                branchLabel = new BranchLabel(codeStream);
                branchLabel2 = new BranchLabel(codeStream);
                n8 = 0;
                while (n8 < n2) {
                    if (this.preTryInitStateIndex != -1) {
                        codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                        codeStream.addDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                    }
                    codeStream.pushOnStack(exceptionLabelArray[n8].exceptionType);
                    exceptionLabelArray[n8].place();
                    n7 = codeStream.position;
                    LocalVariableBinding localVariableBinding = this.catchArguments[n8].binding;
                    if (localVariableBinding.resolvedPosition != -1) {
                        codeStream.store(localVariableBinding, false);
                        localVariableBinding.recordInitializationStartPC(codeStream.position);
                        codeStream.addVisibleLocalVariable(localVariableBinding);
                    } else {
                        codeStream.pop();
                    }
                    codeStream.recordPositionsFrom(n7, this.catchArguments[n8].sourceStart);
                    this.catchBlocks[n8].generateCode(this.scope, codeStream);
                    if (!this.catchExits[n8]) {
                        switch (n4) {
                            case 3: {
                                bl2 = true;
                                codeStream.goto_(branchLabel);
                                break;
                            }
                            case 1: {
                                bl = true;
                            }
                            case 0: {
                                if (this.postTryInitStateIndex != -1) {
                                    codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.postTryInitStateIndex);
                                    codeStream.addDefinitelyAssignedVariables(blockScope, this.postTryInitStateIndex);
                                }
                                codeStream.goto_((BranchLabel)label);
                                break;
                            }
                            case 2: {
                                codeStream.goto_(this.subRoutineStartLabel);
                            }
                        }
                    }
                    ++n8;
                }
            }
            this.exitAnyExceptionHandler();
            ExceptionLabel exceptionLabel = bl && n4 == 1 ? new ExceptionLabel(codeStream, null) : null;
            int n9 = codeStream.position;
            if (this.subRoutineStartLabel != null) {
                codeStream.pushOnStack(this.scope.getJavaLangThrowable());
                if (this.preTryInitStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                }
                this.placeAllAnyExceptionHandler();
                if (exceptionLabel != null) {
                    exceptionLabel.place();
                }
                switch (n4) {
                    case 1: {
                        codeStream.store(this.anyExceptionVariable, false);
                        codeStream.jsr(this.subRoutineStartLabel);
                        codeStream.recordPositionsFrom(n9, this.finallyBlock.sourceStart);
                        n7 = codeStream.position;
                        codeStream.throwAnyException(this.anyExceptionVariable);
                        codeStream.recordPositionsFrom(n7, this.finallyBlock.sourceEnd);
                        this.subRoutineStartLabel.place();
                        codeStream.pushOnStack(this.scope.getJavaLangThrowable());
                        n7 = codeStream.position;
                        codeStream.store(this.returnAddressVariable, false);
                        codeStream.recordPositionsFrom(n7, this.finallyBlock.sourceStart);
                        this.finallyBlock.generateCode(this.scope, codeStream);
                        n7 = codeStream.position;
                        codeStream.ret(this.returnAddressVariable.resolvedPosition);
                        codeStream.recordPositionsFrom(n7, this.finallyBlock.sourceEnd);
                        break;
                    }
                    case 3: {
                        codeStream.store(this.anyExceptionVariable, false);
                        codeStream.recordPositionsFrom(n9, this.finallyBlock.sourceStart);
                        this.finallyBlock.generateCode(blockScope, codeStream);
                        n7 = codeStream.position;
                        codeStream.throwAnyException(this.anyExceptionVariable);
                        if (this.preTryInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                        }
                        this.subRoutineStartLabel.place();
                        codeStream.recordPositionsFrom(n7, this.finallyBlock.sourceEnd);
                        break;
                    }
                    case 2: {
                        codeStream.pop();
                        this.subRoutineStartLabel.place();
                        codeStream.recordPositionsFrom(n9, this.finallyBlock.sourceStart);
                        this.finallyBlock.generateCode(this.scope, codeStream);
                    }
                }
                if (bl) {
                    switch (n4) {
                        case 1: {
                            ((BranchLabel)label).place();
                            n7 = codeStream.position;
                            exceptionLabel.placeStart();
                            codeStream.jsr(this.subRoutineStartLabel);
                            exceptionLabel.placeEnd();
                            codeStream.recordPositionsFrom(n7, this.finallyBlock.sourceEnd);
                            break;
                        }
                        case 3: {
                            if (this.postTryInitStateIndex != -1) {
                                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.postTryInitStateIndex);
                                codeStream.addDefinitelyAssignedVariables(blockScope, this.postTryInitStateIndex);
                            }
                            ((BranchLabel)label).place();
                            this.finallyBlock.generateCode(this.scope, codeStream);
                            if (branchLabel2 == null || !bl2) break;
                            n7 = codeStream.position;
                            codeStream.goto_(branchLabel2);
                            codeStream.recordPositionsFrom(n7, this.finallyBlock.sourceEnd);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            ((BranchLabel)label).place();
                        }
                    }
                }
                if (bl2) {
                    switch (n4) {
                        case 3: {
                            if (this.preTryInitStateIndex != -1) {
                                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                                codeStream.addDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                            }
                            branchLabel.place();
                            this.finallyBlock.generateCode(this.scope, codeStream);
                            branchLabel2.place();
                        }
                    }
                }
            } else {
                ((BranchLabel)label).place();
                if (branchLabel != null) {
                    branchLabel.place();
                }
            }
        } else if (this.subRoutineStartLabel != null) {
            this.finallyBlock.generateCode(this.scope, codeStream);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(n3, this.sourceStart);
    }

    public boolean generateSubRoutineInvocation(BlockScope blockScope, CodeStream codeStream, Object object) {
        int n = this.finallyMode();
        switch (n) {
            case 2: {
                codeStream.goto_(this.subRoutineStartLabel);
                return true;
            }
            case 0: {
                this.exitDeclaredExceptionHandlers(codeStream);
                return false;
            }
        }
        if (object != null) {
            if (this.reusableJSRTargetsCount > 0) {
                int n2 = 0;
                int n3 = this.reusableJSRTargetsCount;
                while (n2 < n3) {
                    Object object2 = this.reusableJSRTargets[n2];
                    if (object == object2 || object instanceof Constant && object2 instanceof Constant && ((Constant)object).hasSameValue((Constant)object2)) {
                        codeStream.goto_(this.reusableJSRSequenceStartLabels[n2]);
                        return true;
                    }
                    ++n2;
                }
            } else {
                this.reusableJSRTargets = new Object[3];
                this.reusableJSRSequenceStartLabels = new BranchLabel[3];
            }
            if (this.reusableJSRTargetsCount == this.reusableJSRTargets.length) {
                this.reusableJSRTargets = new Object[2 * this.reusableJSRTargetsCount];
                System.arraycopy(this.reusableJSRTargets, 0, this.reusableJSRTargets, 0, this.reusableJSRTargetsCount);
                this.reusableJSRSequenceStartLabels = new BranchLabel[2 * this.reusableJSRTargetsCount];
                System.arraycopy(this.reusableJSRSequenceStartLabels, 0, this.reusableJSRSequenceStartLabels, 0, this.reusableJSRTargetsCount);
            }
            this.reusableJSRTargets[this.reusableJSRTargetsCount] = object;
            BranchLabel branchLabel = new BranchLabel(codeStream);
            branchLabel.place();
            this.reusableJSRSequenceStartLabels[this.reusableJSRTargetsCount++] = branchLabel;
        }
        if (n == 3) {
            if (this.preTryInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
            }
            this.exitAnyExceptionHandler();
            this.exitDeclaredExceptionHandlers(codeStream);
            this.finallyBlock.generateCode(blockScope, codeStream);
        } else {
            codeStream.jsr(this.subRoutineStartLabel);
            this.exitAnyExceptionHandler();
            this.exitDeclaredExceptionHandlers(codeStream);
        }
        return false;
    }

    public boolean isSubRoutineEscaping() {
        return (this.bits & 0x4000) != 0;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        TryStatement.printIndent(n, stringBuffer).append("try \n");
        this.tryBlock.printStatement(n + 1, stringBuffer);
        if (this.catchBlocks != null) {
            int n2 = 0;
            while (n2 < this.catchBlocks.length) {
                stringBuffer.append('\n');
                TryStatement.printIndent(n, stringBuffer).append("catch (");
                this.catchArguments[n2].print(0, stringBuffer).append(") ");
                this.catchBlocks[n2].printStatement(n + 1, stringBuffer);
                ++n2;
            }
        }
        if (this.finallyBlock != null) {
            stringBuffer.append('\n');
            TryStatement.printIndent(n, stringBuffer).append("finally\n");
            this.finallyBlock.printStatement(n + 1, stringBuffer);
        }
        return stringBuffer;
    }

    public void resolve(BlockScope blockScope) {
        Object object;
        this.scope = new BlockScope(blockScope);
        BlockScope blockScope2 = new BlockScope(this.scope);
        BlockScope blockScope3 = null;
        if (this.finallyBlock != null) {
            if (this.finallyBlock.isEmptyBlock()) {
                if ((this.finallyBlock.bits & 8) != 0) {
                    this.scope.problemReporter().undocumentedEmptyBlock(this.finallyBlock.sourceStart, this.finallyBlock.sourceEnd);
                }
            } else {
                blockScope3 = new BlockScope(this.scope, false);
                MethodScope methodScope = this.scope.methodScope();
                if (!blockScope.compilerOptions().inlineJsrBytecode) {
                    this.returnAddressVariable = new LocalVariableBinding(SECRET_RETURN_ADDRESS_NAME, (TypeBinding)blockScope.getJavaLangObject(), 0, false);
                    blockScope3.addLocalVariable(this.returnAddressVariable);
                    this.returnAddressVariable.setConstant(Constant.NotAConstant);
                }
                this.subRoutineStartLabel = new BranchLabel();
                this.anyExceptionVariable = new LocalVariableBinding(SECRET_ANY_HANDLER_NAME, (TypeBinding)this.scope.getJavaLangThrowable(), 0, false);
                blockScope3.addLocalVariable(this.anyExceptionVariable);
                this.anyExceptionVariable.setConstant(Constant.NotAConstant);
                if (!methodScope.isInsideInitializer() && (object = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) != null) {
                    TypeBinding typeBinding = object.returnType;
                    if (typeBinding.id != 6) {
                        this.secretReturnValue = new LocalVariableBinding(SECRET_RETURN_VALUE_NAME, typeBinding, 0, false);
                        blockScope3.addLocalVariable(this.secretReturnValue);
                        this.secretReturnValue.setConstant(Constant.NotAConstant);
                    }
                }
                this.finallyBlock.resolveUsing(blockScope3);
                blockScope3.shiftScopes = new BlockScope[this.catchArguments == null ? 1 : this.catchArguments.length + 1];
                blockScope3.shiftScopes[0] = blockScope2;
            }
        }
        this.tryBlock.resolveUsing(blockScope2);
        if (this.catchBlocks != null) {
            int n = this.catchArguments.length;
            object = new TypeBinding[n];
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                BlockScope blockScope4 = new BlockScope(this.scope);
                if (blockScope3 != null) {
                    blockScope3.shiftScopes[n2 + 1] = blockScope4;
                }
                if ((object[n2] = this.catchArguments[n2].resolveForCatch(blockScope4)) == null) {
                    bl = true;
                }
                this.catchBlocks[n2].resolveUsing(blockScope4);
                ++n2;
            }
            if (bl) {
                return;
            }
            this.caughtExceptionTypes = new ReferenceBinding[n];
            n2 = 0;
            while (n2 < n) {
                this.caughtExceptionTypes[n2] = (ReferenceBinding)object[n2];
                int n3 = 0;
                while (n3 < n2) {
                    if (this.caughtExceptionTypes[n2].isCompatibleWith(object[n3])) {
                        this.scope.problemReporter().wrongSequenceOfExceptionTypesError(this, this.caughtExceptionTypes[n2], n2, object[n3]);
                    }
                    ++n3;
                }
                ++n2;
            }
        } else {
            this.caughtExceptionTypes = new ReferenceBinding[0];
        }
        if (blockScope3 != null) {
            this.scope.addSubscope(blockScope3);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.tryBlock.traverse(aSTVisitor, this.scope);
            if (this.catchArguments != null) {
                int n = 0;
                int n2 = this.catchBlocks.length;
                while (n < n2) {
                    this.catchArguments[n].traverse(aSTVisitor, this.scope);
                    this.catchBlocks[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

