/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class CharacterConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public CharacterConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public CharacterConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (object instanceof Character) {
            return object;
        }
        try {
            return new Character(object.toString().charAt(0));
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(exception);
        }
    }
}

