/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.LZWDecoder;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SequenceList;
import com.lowagie.text.pdf.interfaces.PdfViewerPreferences;
import com.lowagie.text.pdf.internal.PdfViewerPreferencesImp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.InflaterInputStream;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.RecipientInformation;

public class PdfReader
implements PdfViewerPreferences {
    static final PdfName[] pageInhCandidates = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    static final byte[] endstream = PdfEncodings.convertToBytes("endstream", null);
    static final byte[] endobj = PdfEncodings.convertToBytes("endobj", null);
    protected PRTokeniser tokens;
    protected int[] xref;
    protected HashMap objStmMark;
    protected IntHashtable objStmToOffset;
    protected boolean newXrefType;
    private ArrayList xrefObj;
    PdfDictionary rootPages;
    protected PdfDictionary trailer;
    protected PdfDictionary catalog;
    protected PageRefs pageRefs;
    protected PRAcroForm acroForm = null;
    protected boolean acroFormParsed = false;
    protected ArrayList pageInh;
    protected boolean encrypted = false;
    protected boolean rebuilt = false;
    protected int freeXref;
    protected boolean tampered = false;
    protected int lastXref;
    protected int eofPos;
    protected char pdfVersion;
    protected PdfEncryption decrypt;
    protected byte[] password = null;
    protected Key certificateKey = null;
    protected Certificate certificate = null;
    protected String certificateKeyProvider = null;
    protected boolean ownerPasswordUsed;
    protected ArrayList strings = new ArrayList();
    protected boolean sharedStreams = true;
    protected boolean consolidateNamedDestinations = false;
    protected int rValue;
    protected int pValue;
    private int objNum;
    private int objGen;
    private int fileLength;
    private boolean hybridXref;
    private int lastXrefPartial = -1;
    private boolean partial;
    private PRIndirectReference cryptoRef;
    private PdfViewerPreferencesImp viewerPreferences = new PdfViewerPreferencesImp();
    private boolean appendable;

    protected PdfReader() {
    }

    public PdfReader(String string) throws IOException {
        this(string, null);
    }

    public PdfReader(String string, byte[] byArray) throws IOException {
        this.password = byArray;
        this.tokens = new PRTokeniser(string);
        this.readPdf();
    }

    public PdfReader(byte[] byArray) throws IOException {
        this(byArray, null);
    }

    public PdfReader(byte[] byArray, byte[] byArray2) throws IOException {
        this.password = byArray2;
        this.tokens = new PRTokeniser(byArray);
        this.readPdf();
    }

    public PdfReader(String string, Certificate certificate, Key key, String string2) throws IOException {
        this.certificate = certificate;
        this.certificateKey = key;
        this.certificateKeyProvider = string2;
        this.tokens = new PRTokeniser(string);
        this.readPdf();
    }

    public PdfReader(URL uRL) throws IOException {
        this(uRL, null);
    }

    public PdfReader(URL uRL, byte[] byArray) throws IOException {
        this.password = byArray;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(uRL));
        this.readPdf();
    }

    public PdfReader(InputStream inputStream, byte[] byArray) throws IOException {
        this.password = byArray;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(inputStream));
        this.readPdf();
    }

    public PdfReader(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public PdfReader(RandomAccessFileOrArray randomAccessFileOrArray, byte[] byArray) throws IOException {
        this.password = byArray;
        this.partial = true;
        this.tokens = new PRTokeniser(randomAccessFileOrArray);
        this.readPdfPartial();
    }

    public PdfReader(PdfReader pdfReader) {
        this.appendable = pdfReader.appendable;
        this.consolidateNamedDestinations = pdfReader.consolidateNamedDestinations;
        this.encrypted = pdfReader.encrypted;
        this.rebuilt = pdfReader.rebuilt;
        this.sharedStreams = pdfReader.sharedStreams;
        this.tampered = pdfReader.tampered;
        this.password = pdfReader.password;
        this.pdfVersion = pdfReader.pdfVersion;
        this.eofPos = pdfReader.eofPos;
        this.freeXref = pdfReader.freeXref;
        this.lastXref = pdfReader.lastXref;
        this.tokens = new PRTokeniser(pdfReader.tokens.getSafeFile());
        if (pdfReader.decrypt != null) {
            this.decrypt = new PdfEncryption(pdfReader.decrypt);
        }
        this.pValue = pdfReader.pValue;
        this.rValue = pdfReader.rValue;
        this.xrefObj = new ArrayList(pdfReader.xrefObj);
        int n = 0;
        while (n < pdfReader.xrefObj.size()) {
            this.xrefObj.set(n, PdfReader.duplicatePdfObject((PdfObject)pdfReader.xrefObj.get(n), this));
            ++n;
        }
        this.pageRefs = new PageRefs(pdfReader.pageRefs, this);
        this.trailer = (PdfDictionary)PdfReader.duplicatePdfObject(pdfReader.trailer, this);
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        this.rootPages = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PAGES));
        this.fileLength = pdfReader.fileLength;
        this.partial = pdfReader.partial;
        this.hybridXref = pdfReader.hybridXref;
        this.objStmToOffset = pdfReader.objStmToOffset;
        this.xref = pdfReader.xref;
        this.cryptoRef = (PRIndirectReference)PdfReader.duplicatePdfObject(pdfReader.cryptoRef, this);
        this.ownerPasswordUsed = pdfReader.ownerPasswordUsed;
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected PdfReaderInstance getPdfReaderInstance(PdfWriter pdfWriter) {
        return new PdfReaderInstance(this, pdfWriter);
    }

    public int getNumberOfPages() {
        return this.pageRefs.size();
    }

    public PdfDictionary getCatalog() {
        return this.catalog;
    }

    public PRAcroForm getAcroForm() {
        if (!this.acroFormParsed) {
            this.acroFormParsed = true;
            PdfObject pdfObject = this.catalog.get(PdfName.ACROFORM);
            if (pdfObject != null) {
                try {
                    this.acroForm = new PRAcroForm(this);
                    this.acroForm.readAcroForm((PdfDictionary)PdfReader.getPdfObject(pdfObject));
                }
                catch (Exception exception) {
                    this.acroForm = null;
                }
            }
        }
        return this.acroForm;
    }

    public int getPageRotation(int n) {
        return this.getPageRotation(this.pageRefs.getPageNRelease(n));
    }

    int getPageRotation(PdfDictionary pdfDictionary) {
        PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ROTATE));
        if (pdfNumber == null) {
            return 0;
        }
        int n = pdfNumber.intValue();
        return (n %= 360) < 0 ? n + 360 : n;
    }

    public Rectangle getPageSizeWithRotation(int n) {
        return this.getPageSizeWithRotation(this.pageRefs.getPageNRelease(n));
    }

    public Rectangle getPageSizeWithRotation(PdfDictionary pdfDictionary) {
        Rectangle rectangle = this.getPageSize(pdfDictionary);
        int n = this.getPageRotation(pdfDictionary);
        while (n > 0) {
            rectangle = rectangle.rotate();
            n -= 90;
        }
        return rectangle;
    }

    public Rectangle getPageSize(int n) {
        return this.getPageSize(this.pageRefs.getPageNRelease(n));
    }

    public Rectangle getPageSize(PdfDictionary pdfDictionary) {
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MEDIABOX));
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public Rectangle getCropBox(int n) {
        PdfDictionary pdfDictionary = this.pageRefs.getPageNRelease(n);
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.CROPBOX));
        if (pdfArray == null) {
            return this.getPageSize(pdfDictionary);
        }
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public Rectangle getBoxSize(int n, String string) {
        PdfDictionary pdfDictionary = this.pageRefs.getPageNRelease(n);
        PdfArray pdfArray = null;
        if (string.equals("trim")) {
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.TRIMBOX));
        } else if (string.equals("art")) {
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.ARTBOX));
        } else if (string.equals("bleed")) {
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.BLEEDBOX));
        } else if (string.equals("crop")) {
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.CROPBOX));
        } else if (string.equals("media")) {
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.MEDIABOX));
        }
        if (pdfArray == null) {
            return null;
        }
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public HashMap getInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.INFO));
        if (pdfDictionary == null) {
            return hashMap;
        }
        for (PdfName pdfName : pdfDictionary.getKeys()) {
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(pdfName));
            if (pdfObject == null) continue;
            String string = pdfObject.toString();
            switch (pdfObject.type()) {
                case 3: {
                    string = ((PdfString)pdfObject).toUnicodeString();
                    break;
                }
                case 4: {
                    string = PdfName.decodeName(string);
                }
            }
            hashMap.put(PdfName.decodeName(pdfName.toString()), string);
        }
        return hashMap;
    }

    public static Rectangle getNormalizedRectangle(PdfArray pdfArray) {
        ArrayList arrayList = pdfArray.getArrayList();
        float f = ((PdfNumber)arrayList.get(0)).floatValue();
        float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
        float f3 = ((PdfNumber)arrayList.get(2)).floatValue();
        float f4 = ((PdfNumber)arrayList.get(3)).floatValue();
        return new Rectangle(Math.min(f, f3), Math.min(f2, f4), Math.max(f, f3), Math.max(f2, f4));
    }

    protected void readPdf() throws IOException {
        try {
            this.fileLength = this.tokens.getFile().length();
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception exception) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception exception2) {
                    throw new IOException("Rebuild failed: " + exception2.getMessage() + "; Original message: " + exception.getMessage());
                }
            }
            try {
                this.readDocObj();
            }
            catch (Exception exception) {
                if (this.rebuilt) {
                    throw new IOException(exception.getMessage());
                }
                this.rebuilt = true;
                this.encrypted = false;
                this.rebuildXref();
                this.lastXref = -1;
                this.readDocObj();
            }
            this.strings.clear();
            this.readPages();
            this.eliminateSharedStreams();
            this.removeUnusedObjects();
        }
        catch (Throwable throwable) {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            this.tokens.close();
        }
        catch (Exception exception) {}
    }

    protected void readPdfPartial() throws IOException {
        try {
            this.fileLength = this.tokens.getFile().length();
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception exception) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception exception2) {
                    throw new IOException("Rebuild failed: " + exception2.getMessage() + "; Original message: " + exception.getMessage());
                }
            }
            this.readDocObjPartial();
            this.readPages();
        }
        catch (IOException iOException) {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
            throw iOException;
        }
    }

    private boolean equalsArray(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void readDecryptedDocObj() throws IOException {
        Object object;
        String string;
        PdfObject pdfObject;
        if (this.encrypted) {
            return;
        }
        PdfObject pdfObject2 = this.trailer.get(PdfName.ENCRYPT);
        if (pdfObject2 == null || pdfObject2.toString().equals("null")) {
            return;
        }
        byte[] byArray = null;
        this.encrypted = true;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(this.trailer.get(PdfName.ID));
        byte[] byArray2 = null;
        if (pdfArray != null) {
            pdfObject = (PdfObject)pdfArray.getArrayList().get(0);
            this.strings.remove(pdfObject);
            string = pdfObject.toString();
            byArray2 = DocWriter.getISOBytes(string);
            if (pdfArray.size() > 1) {
                this.strings.remove(pdfArray.getArrayList().get(1));
            }
        }
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int n = 0;
        int n2 = 0;
        PdfObject pdfObject3 = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.FILTER));
        if (pdfObject3.equals(PdfName.STANDARD)) {
            string = pdfDictionary.get(PdfName.U).toString();
            this.strings.remove(pdfDictionary.get(PdfName.U));
            byArray3 = DocWriter.getISOBytes(string);
            string = pdfDictionary.get(PdfName.O).toString();
            this.strings.remove(pdfDictionary.get(PdfName.O));
            byArray4 = DocWriter.getISOBytes(string);
            pdfObject = pdfDictionary.get(PdfName.R);
            if (!pdfObject.isNumber()) {
                throw new IOException("Illegal R value.");
            }
            this.rValue = ((PdfNumber)pdfObject).intValue();
            if (this.rValue != 2 && this.rValue != 3 && this.rValue != 4) {
                throw new IOException("Unknown encryption type (" + this.rValue + ")");
            }
            pdfObject = pdfDictionary.get(PdfName.P);
            if (!pdfObject.isNumber()) {
                throw new IOException("Illegal P value.");
            }
            this.pValue = ((PdfNumber)pdfObject).intValue();
            if (this.rValue == 3) {
                pdfObject = pdfDictionary.get(PdfName.LENGTH);
                if (!pdfObject.isNumber()) {
                    throw new IOException("Illegal Length value.");
                }
                n2 = ((PdfNumber)pdfObject).intValue();
                if (n2 > 128 || n2 < 40 || n2 % 8 != 0) {
                    throw new IOException("Illegal Length value.");
                }
                n = 1;
            } else if (this.rValue == 4) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)pdfDictionary.get(PdfName.CF);
                if (pdfDictionary2 == null) {
                    throw new IOException("/CF not found (encryption)");
                }
                if ((pdfDictionary2 = (PdfDictionary)pdfDictionary2.get(PdfName.STDCF)) == null) {
                    throw new IOException("/StdCF not found (encryption)");
                }
                if (PdfName.V2.equals(pdfDictionary2.get(PdfName.CFM))) {
                    n = 1;
                } else if (PdfName.AESV2.equals(pdfDictionary2.get(PdfName.CFM))) {
                    n = 2;
                } else {
                    throw new IOException("No compatible encryption found");
                }
                object = pdfDictionary.get(PdfName.ENCRYPTMETADATA);
                if (object != null && ((PdfObject)object).toString().equals("false")) {
                    n |= 8;
                }
            } else {
                n = 0;
            }
        } else if (pdfObject3.equals(PdfName.PUBSEC)) {
            Object object2;
            PdfObject pdfObject4;
            boolean bl = false;
            object = null;
            PdfArray pdfArray2 = null;
            pdfObject = pdfDictionary.get(PdfName.V);
            if (!pdfObject.isNumber()) {
                throw new IOException("Illegal V value.");
            }
            int n3 = ((PdfNumber)pdfObject).intValue();
            if (n3 != 1 && n3 != 2 && n3 != 4) {
                throw new IOException("Unknown encryption type V = " + this.rValue);
            }
            if (n3 == 2) {
                pdfObject = pdfDictionary.get(PdfName.LENGTH);
                if (!pdfObject.isNumber()) {
                    throw new IOException("Illegal Length value.");
                }
                n2 = ((PdfNumber)pdfObject).intValue();
                if (n2 > 128 || n2 < 40 || n2 % 8 != 0) {
                    throw new IOException("Illegal Length value.");
                }
                n = 1;
                pdfArray2 = (PdfArray)pdfDictionary.get(PdfName.RECIPIENTS);
            } else if (n3 == 4) {
                PdfDictionary pdfDictionary3 = (PdfDictionary)pdfDictionary.get(PdfName.CF);
                if (pdfDictionary3 == null) {
                    throw new IOException("/CF not found (encryption)");
                }
                if ((pdfDictionary3 = (PdfDictionary)pdfDictionary3.get(PdfName.DEFAULTCRYPTFILER)) == null) {
                    throw new IOException("/DefaultCryptFilter not found (encryption)");
                }
                if (PdfName.V2.equals(pdfDictionary3.get(PdfName.CFM))) {
                    n = 1;
                    n2 = 128;
                } else if (PdfName.AESV2.equals(pdfDictionary3.get(PdfName.CFM))) {
                    n = 2;
                    n2 = 128;
                } else {
                    throw new IOException("No compatible encryption found");
                }
                pdfObject4 = pdfDictionary3.get(PdfName.ENCRYPTMETADATA);
                if (pdfObject4 != null && pdfObject4.toString().equals("false")) {
                    n |= 8;
                }
                pdfArray2 = (PdfArray)pdfDictionary3.get(PdfName.RECIPIENTS);
            } else {
                n = 0;
                n2 = 40;
                pdfArray2 = (PdfArray)pdfDictionary.get(PdfName.RECIPIENTS);
            }
            int n4 = 0;
            while (n4 < pdfArray2.size()) {
                pdfObject4 = (PdfObject)pdfArray2.getArrayList().get(n4);
                this.strings.remove(pdfObject4);
                object2 = null;
                try {
                    object2 = new CMSEnvelopedData(pdfObject4.getBytes());
                    for (RecipientInformation recipientInformation : ((CMSEnvelopedData)object2).getRecipientInfos().getRecipients()) {
                        if (!recipientInformation.getRID().match(this.certificate) || bl) continue;
                        object = recipientInformation.getContent(this.certificateKey, this.certificateKeyProvider);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                ++n4;
            }
            if (!bl || object == null) {
                throw new IOException("Bad certificate and key.");
            }
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
                messageDigest.update((byte[])object, 0, 20);
                int n5 = 0;
                while (n5 < pdfArray2.size()) {
                    object2 = ((PdfObject)pdfArray2.getArrayList().get(n5)).getBytes();
                    messageDigest.update((byte[])object2);
                    ++n5;
                }
                if ((n & 8) != 0) {
                    messageDigest.update(new byte[]{-1, -1, -1, -1});
                }
                byArray = messageDigest.digest();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        this.decrypt = new PdfEncryption();
        this.decrypt.setCryptoMode(n, n2);
        if (pdfObject3.equals(PdfName.STANDARD)) {
            this.decrypt.setupByOwnerPassword(byArray2, this.password, byArray3, byArray4, this.pValue);
            if (!this.equalsArray(byArray3, this.decrypt.userKey, this.rValue == 3 || this.rValue == 4 ? 16 : 32)) {
                this.decrypt.setupByUserPassword(byArray2, this.password, byArray4, this.pValue);
                if (!this.equalsArray(byArray3, this.decrypt.userKey, this.rValue == 3 || this.rValue == 4 ? 16 : 32)) {
                    throw new IOException("Bad user password");
                }
            } else {
                this.ownerPasswordUsed = true;
            }
        } else if (pdfObject3.equals(PdfName.PUBSEC)) {
            this.decrypt.setupByEncryptionKey(byArray, n2);
        }
        int n6 = 0;
        while (n6 < this.strings.size()) {
            object = (PdfString)this.strings.get(n6);
            ((PdfString)object).decrypt(this);
            ++n6;
        }
        if (pdfObject2.isIndirect()) {
            this.cryptoRef = (PRIndirectReference)pdfObject2;
            this.xrefObj.set(this.cryptoRef.getNumber(), null);
        }
    }

    public static PdfObject getPdfObjectRelease(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfObject);
        PdfReader.releaseLastXrefPartial(pdfObject);
        return pdfObject2;
    }

    public static PdfObject getPdfObject(PdfObject pdfObject) {
        boolean bl;
        PRIndirectReference pRIndirectReference;
        block11: {
            if (pdfObject == null) {
                return null;
            }
            if (!pdfObject.isIndirect()) {
                return pdfObject;
            }
            try {
                pRIndirectReference = (PRIndirectReference)pdfObject;
                int n = pRIndirectReference.getNumber();
                bl = pRIndirectReference.getReader().appendable;
                pdfObject = pRIndirectReference.getReader().getPdfObject(n);
                if (pdfObject != null) break block11;
                return null;
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        if (bl) {
            switch (pdfObject.type()) {
                case 8: {
                    pdfObject = new PdfNull();
                    break;
                }
                case 1: {
                    pdfObject = new PdfBoolean(((PdfBoolean)pdfObject).booleanValue());
                    break;
                }
                case 4: {
                    pdfObject = new PdfName(pdfObject.getBytes());
                }
            }
            pdfObject.setIndRef(pRIndirectReference);
        }
        return pdfObject;
    }

    public static PdfObject getPdfObjectRelease(PdfObject pdfObject, PdfObject pdfObject2) {
        PdfObject pdfObject3 = PdfReader.getPdfObject(pdfObject, pdfObject2);
        PdfReader.releaseLastXrefPartial(pdfObject);
        return pdfObject3;
    }

    public static PdfObject getPdfObject(PdfObject pdfObject, PdfObject pdfObject2) {
        if (pdfObject == null) {
            return null;
        }
        if (!pdfObject.isIndirect()) {
            PRIndirectReference pRIndirectReference = null;
            if (pdfObject2 != null && (pRIndirectReference = pdfObject2.getIndRef()) != null && pRIndirectReference.getReader().isAppendable()) {
                switch (pdfObject.type()) {
                    case 8: {
                        pdfObject = new PdfNull();
                        break;
                    }
                    case 1: {
                        pdfObject = new PdfBoolean(((PdfBoolean)pdfObject).booleanValue());
                        break;
                    }
                    case 4: {
                        pdfObject = new PdfName(pdfObject.getBytes());
                    }
                }
                pdfObject.setIndRef(pRIndirectReference);
            }
            return pdfObject;
        }
        return PdfReader.getPdfObject(pdfObject);
    }

    public PdfObject getPdfObjectRelease(int n) {
        PdfObject pdfObject = this.getPdfObject(n);
        this.releaseLastXrefPartial();
        return pdfObject;
    }

    public PdfObject getPdfObject(int n) {
        PdfObject pdfObject;
        block7: {
            block6: {
                try {
                    this.lastXrefPartial = -1;
                    if (n >= 0 && n < this.xrefObj.size()) break block6;
                    return null;
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
            }
            pdfObject = (PdfObject)this.xrefObj.get(n);
            if (!this.partial || pdfObject != null) {
                return pdfObject;
            }
            if (n * 2 < this.xref.length) break block7;
            return null;
        }
        pdfObject = this.readSingleObject(n);
        this.lastXrefPartial = -1;
        if (pdfObject != null) {
            this.lastXrefPartial = n;
        }
        return pdfObject;
    }

    public void resetLastXrefPartial() {
        this.lastXrefPartial = -1;
    }

    public void releaseLastXrefPartial() {
        if (this.partial && this.lastXrefPartial != -1) {
            this.xrefObj.set(this.lastXrefPartial, null);
            this.lastXrefPartial = -1;
        }
    }

    public static void releaseLastXrefPartial(PdfObject pdfObject) {
        if (pdfObject == null) {
            return;
        }
        if (!pdfObject.isIndirect()) {
            return;
        }
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
        PdfReader pdfReader = pRIndirectReference.getReader();
        if (pdfReader.partial && pdfReader.lastXrefPartial != -1 && pdfReader.lastXrefPartial == pRIndirectReference.getNumber()) {
            pdfReader.xrefObj.set(pdfReader.lastXrefPartial, null);
        }
        pdfReader.lastXrefPartial = -1;
    }

    private void setXrefPartialObject(int n, PdfObject pdfObject) {
        if (!this.partial || n < 0) {
            return;
        }
        this.xrefObj.set(n, pdfObject);
    }

    public PRIndirectReference addPdfObject(PdfObject pdfObject) {
        this.xrefObj.add(pdfObject);
        return new PRIndirectReference(this, this.xrefObj.size() - 1);
    }

    protected void readPages() throws IOException {
        this.pageInh = new ArrayList();
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        this.rootPages = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PAGES));
        this.pageRefs = new PageRefs(this);
    }

    protected void readDocObjPartial() throws IOException {
        this.xrefObj = new ArrayList(this.xref.length / 2);
        this.xrefObj.addAll((Collection)Collections.nCopies(this.xref.length / 2, null));
        this.readDecryptedDocObj();
        if (this.objStmToOffset != null) {
            int[] nArray = this.objStmToOffset.getKeys();
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                this.objStmToOffset.put(n2, this.xref[n2 * 2]);
                this.xref[n2 * 2] = -1;
                ++n;
            }
        }
    }

    protected PdfObject readSingleObject(int n) throws IOException {
        PdfObject pdfObject;
        this.strings.clear();
        int n2 = n * 2;
        int n3 = this.xref[n2];
        if (n3 < 0) {
            return null;
        }
        if (this.xref[n2 + 1] > 0) {
            n3 = this.objStmToOffset.get(this.xref[n2 + 1]);
        }
        if (n3 == 0) {
            return null;
        }
        this.tokens.seek(n3);
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != 1) {
            this.tokens.throwError("Invalid object number.");
        }
        this.objNum = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != 1) {
            this.tokens.throwError("Invalid generation number.");
        }
        this.objGen = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("obj")) {
            this.tokens.throwError("Token 'obj' expected.");
        }
        try {
            pdfObject = this.readPRObject();
            int n4 = 0;
            while (n4 < this.strings.size()) {
                PdfString pdfString = (PdfString)this.strings.get(n4);
                pdfString.decrypt(this);
                ++n4;
            }
            if (pdfObject.isStream()) {
                this.checkPRStreamLength((PRStream)pdfObject);
            }
        }
        catch (Exception exception) {
            pdfObject = null;
        }
        if (this.xref[n2 + 1] > 0) {
            pdfObject = this.readOneObjStm((PRStream)pdfObject, this.xref[n2]);
        }
        this.xrefObj.set(n, pdfObject);
        return pdfObject;
    }

    protected PdfObject readOneObjStm(PRStream pRStream, int n) throws IOException {
        int n2 = ((PdfNumber)PdfReader.getPdfObject(pRStream.get(PdfName.FIRST))).intValue();
        byte[] byArray = PdfReader.getStreamBytes(pRStream, this.tokens.getFile());
        PRTokeniser pRTokeniser = this.tokens;
        this.tokens = new PRTokeniser(byArray);
        try {
            int n3 = 0;
            boolean bl = true;
            ++n;
            int n4 = 0;
            while (n4 < n) {
                bl = this.tokens.nextToken();
                if (!bl) break;
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                bl = this.tokens.nextToken();
                if (!bl) break;
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                n3 = this.tokens.intValue() + n2;
                ++n4;
            }
            if (!bl) {
                throw new IOException("Error reading ObjStm");
            }
            this.tokens.seek(n3);
            PdfObject pdfObject = this.readPRObject();
            return pdfObject;
        }
        finally {
            this.tokens = pRTokeniser;
        }
    }

    public double dumpPerc() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.xrefObj.size()) {
            if (this.xrefObj.get(n2) != null) {
                ++n;
            }
            ++n2;
        }
        return (double)n * 100.0 / (double)this.xrefObj.size();
    }

    protected void readDocObj() throws IOException {
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        this.xrefObj = new ArrayList(this.xref.length / 2);
        this.xrefObj.addAll((Collection)Collections.nCopies(this.xref.length / 2, null));
        int n = 2;
        while (n < this.xref.length) {
            int n2 = this.xref[n];
            if (n2 > 0 && this.xref[n + 1] <= 0) {
                PdfObject pdfObject;
                this.tokens.seek(n2);
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid object number.");
                }
                this.objNum = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid generation number.");
                }
                this.objGen = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (!this.tokens.getStringValue().equals("obj")) {
                    this.tokens.throwError("Token 'obj' expected.");
                }
                try {
                    pdfObject = this.readPRObject();
                    if (pdfObject.isStream()) {
                        arrayList.add(pdfObject);
                    }
                }
                catch (Exception exception) {
                    pdfObject = null;
                }
                this.xrefObj.set(n / 2, pdfObject);
            }
            n += 2;
        }
        n = 0;
        while (n < arrayList.size()) {
            this.checkPRStreamLength((PRStream)arrayList.get(n));
            ++n;
        }
        this.readDecryptedDocObj();
        if (this.objStmMark != null) {
            for (Map.Entry entry : this.objStmMark.entrySet()) {
                int n3 = (Integer)entry.getKey();
                IntHashtable intHashtable = (IntHashtable)entry.getValue();
                this.readObjStm((PRStream)this.xrefObj.get(n3), intHashtable);
                this.xrefObj.set(n3, null);
            }
            this.objStmMark = null;
        }
        this.xref = null;
    }

    private void checkPRStreamLength(PRStream pRStream) throws IOException {
        int n;
        block8: {
            Object object;
            int n2 = this.tokens.length();
            int n3 = pRStream.getOffset();
            boolean bl = false;
            n = 0;
            PdfObject pdfObject = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.LENGTH));
            if (pdfObject != null && pdfObject.type() == 2) {
                n = ((PdfNumber)pdfObject).intValue();
                if (n + n3 > n2 - 20) {
                    bl = true;
                } else {
                    this.tokens.seek(n3 + n);
                    object = this.tokens.readString(20);
                    if (!(((String)object).startsWith("\nendstream") || ((String)object).startsWith("\r\nendstream") || ((String)object).startsWith("\rendstream") || ((String)object).startsWith("endstream"))) {
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                int n4;
                object = new byte[16];
                this.tokens.seek(n3);
                do {
                    n4 = this.tokens.getFilePointer();
                    if (!this.tokens.readLineSegment((byte[])object)) break block8;
                    if (!PdfReader.equalsn((byte[])object, endstream)) continue;
                    n = n4 - n3;
                    break block8;
                } while (!PdfReader.equalsn((byte[])object, endobj));
                this.tokens.seek(n4 - 16);
                String string = this.tokens.readString(16);
                int n5 = string.indexOf("endstream");
                if (n5 >= 0) {
                    n4 = n4 - 16 + n5;
                }
                n = n4 - n3;
            }
        }
        pRStream.setLength(n);
    }

    protected void readObjStm(PRStream pRStream, IntHashtable intHashtable) throws IOException {
        int n = ((PdfNumber)PdfReader.getPdfObject(pRStream.get(PdfName.FIRST))).intValue();
        int n2 = ((PdfNumber)PdfReader.getPdfObject(pRStream.get(PdfName.N))).intValue();
        byte[] byArray = PdfReader.getStreamBytes(pRStream, this.tokens.getFile());
        PRTokeniser pRTokeniser = this.tokens;
        this.tokens = new PRTokeniser(byArray);
        try {
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            boolean bl = true;
            int n3 = 0;
            while (n3 < n2) {
                bl = this.tokens.nextToken();
                if (!bl) break;
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                nArray2[n3] = this.tokens.intValue();
                bl = this.tokens.nextToken();
                if (!bl) break;
                if (this.tokens.getTokenType() != 1) {
                    bl = false;
                    break;
                }
                nArray[n3] = this.tokens.intValue() + n;
                ++n3;
            }
            if (!bl) {
                throw new IOException("Error reading ObjStm");
            }
            n3 = 0;
            while (n3 < n2) {
                if (intHashtable.containsKey(n3)) {
                    this.tokens.seek(nArray[n3]);
                    PdfObject pdfObject = this.readPRObject();
                    this.xrefObj.set(nArray2[n3], pdfObject);
                }
                ++n3;
            }
        }
        finally {
            this.tokens = pRTokeniser;
        }
    }

    public static PdfObject killIndirect(PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.isNull()) {
            return null;
        }
        PdfObject pdfObject2 = PdfReader.getPdfObjectRelease(pdfObject);
        if (pdfObject.isIndirect()) {
            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
            PdfReader pdfReader = pRIndirectReference.getReader();
            int n = pRIndirectReference.getNumber();
            pdfReader.xrefObj.set(n, null);
            if (pdfReader.partial) {
                pdfReader.xref[n * 2] = -1;
            }
        }
        return pdfObject2;
    }

    private void ensureXrefSize(int n) {
        if (n == 0) {
            return;
        }
        if (this.xref == null) {
            this.xref = new int[n];
        } else if (this.xref.length < n) {
            int[] nArray = new int[n];
            System.arraycopy(this.xref, 0, nArray, 0, this.xref.length);
            this.xref = nArray;
        }
    }

    protected void readXref() throws IOException {
        PdfNumber pdfNumber;
        int n;
        this.hybridXref = false;
        this.newXrefType = false;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.getStringValue().equals("startxref")) {
            throw new IOException("startxref not found.");
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != 1) {
            throw new IOException("startxref is not followed by a number.");
        }
        this.lastXref = n = this.tokens.intValue();
        this.eofPos = this.tokens.getFilePointer();
        try {
            if (this.readXRefStream(n)) {
                this.newXrefType = true;
                return;
            }
        }
        catch (Exception exception) {}
        this.xref = null;
        this.tokens.seek(n);
        PdfDictionary pdfDictionary = this.trailer = this.readXrefSection();
        while ((pdfNumber = (PdfNumber)pdfDictionary.get(PdfName.PREV)) != null) {
            this.tokens.seek(pdfNumber.intValue());
            pdfDictionary = this.readXrefSection();
        }
    }

    protected PdfDictionary readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("xref")) {
            this.tokens.throwError("xref subsection not found");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block2: while (true) {
            int n5;
            this.tokens.nextValidToken();
            if (this.tokens.getStringValue().equals("trailer")) break;
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found");
            }
            n = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Number of entries in this xref subsection not found");
            }
            n2 = this.tokens.intValue() + n;
            if (n == 1) {
                n5 = this.tokens.getFilePointer();
                this.tokens.nextValidToken();
                n3 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                if (n3 == 0 && n4 == 65535) {
                    --n;
                    --n2;
                }
                this.tokens.seek(n5);
            }
            this.ensureXrefSize(n2 * 2);
            n5 = n;
            while (true) {
                if (n5 >= n2) continue block2;
                this.tokens.nextValidToken();
                n3 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                this.tokens.nextValidToken();
                int n6 = n5 * 2;
                if (this.tokens.getStringValue().equals("n")) {
                    if (this.xref[n6] == 0 && this.xref[n6 + 1] == 0) {
                        this.xref[n6] = n3;
                    }
                } else if (this.tokens.getStringValue().equals("f")) {
                    if (this.xref[n6] == 0 && this.xref[n6 + 1] == 0) {
                        this.xref[n6] = -1;
                    }
                } else {
                    this.tokens.throwError("Invalid cross-reference entry in this xref subsection");
                }
                ++n5;
            }
            break;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)this.readPRObject();
        PdfNumber pdfNumber = (PdfNumber)pdfDictionary.get(PdfName.SIZE);
        this.ensureXrefSize(pdfNumber.intValue() * 2);
        PdfObject pdfObject = pdfDictionary.get(PdfName.XREFSTM);
        if (pdfObject != null && pdfObject.isNumber()) {
            int n7 = ((PdfNumber)pdfObject).intValue();
            try {
                this.readXRefStream(n7);
                this.newXrefType = true;
                this.hybridXref = true;
            }
            catch (IOException iOException) {
                this.xref = null;
                throw iOException;
            }
        }
        return pdfDictionary;
    }

    protected boolean readXRefStream(int n) throws IOException {
        PdfArray pdfArray;
        this.tokens.seek(n);
        int n2 = 0;
        if (!this.tokens.nextToken()) {
            return false;
        }
        if (this.tokens.getTokenType() != 1) {
            return false;
        }
        n2 = this.tokens.intValue();
        if (!this.tokens.nextToken() || this.tokens.getTokenType() != 1) {
            return false;
        }
        if (!this.tokens.nextToken() || !this.tokens.getStringValue().equals("obj")) {
            return false;
        }
        PdfObject pdfObject = this.readPRObject();
        PRStream pRStream = null;
        if (pdfObject.isStream()) {
            pRStream = (PRStream)pdfObject;
            if (!PdfName.XREF.equals(pRStream.get(PdfName.TYPE))) {
                return false;
            }
        } else {
            return false;
        }
        if (this.trailer == null) {
            this.trailer = new PdfDictionary();
            this.trailer.putAll(pRStream);
        }
        pRStream.setLength(((PdfNumber)pRStream.get(PdfName.LENGTH)).intValue());
        int n3 = ((PdfNumber)pRStream.get(PdfName.SIZE)).intValue();
        PdfObject pdfObject2 = pRStream.get(PdfName.INDEX);
        if (pdfObject2 == null) {
            pdfArray = new PdfArray();
            int[] nArray = new int[2];
            nArray[1] = n3;
            pdfArray.add(nArray);
        } else {
            pdfArray = (PdfArray)pdfObject2;
        }
        PdfArray pdfArray2 = (PdfArray)pRStream.get(PdfName.W);
        int n4 = -1;
        pdfObject2 = pRStream.get(PdfName.PREV);
        if (pdfObject2 != null) {
            n4 = ((PdfNumber)pdfObject2).intValue();
        }
        this.ensureXrefSize(n3 * 2);
        if (this.objStmMark == null && !this.partial) {
            this.objStmMark = new HashMap();
        }
        if (this.objStmToOffset == null && this.partial) {
            this.objStmToOffset = new IntHashtable();
        }
        byte[] byArray = PdfReader.getStreamBytes(pRStream, this.tokens.getFile());
        int n5 = 0;
        ArrayList arrayList = pdfArray2.getArrayList();
        int[] nArray = new int[3];
        int n6 = 0;
        while (n6 < 3) {
            nArray[n6] = ((PdfNumber)arrayList.get(n6)).intValue();
            ++n6;
        }
        ArrayList arrayList2 = pdfArray.getArrayList();
        int n7 = 0;
        while (n7 < arrayList2.size()) {
            int n8 = ((PdfNumber)arrayList2.get(n7)).intValue();
            int n9 = ((PdfNumber)arrayList2.get(n7 + 1)).intValue();
            this.ensureXrefSize((n8 + n9) * 2);
            while (n9-- > 0) {
                int n10;
                int n11 = 1;
                if (nArray[0] > 0) {
                    n11 = 0;
                    n10 = 0;
                    while (n10 < nArray[0]) {
                        n11 = (n11 << 8) + (byArray[n5++] & 0xFF);
                        ++n10;
                    }
                }
                n10 = 0;
                int n12 = 0;
                while (n12 < nArray[1]) {
                    n10 = (n10 << 8) + (byArray[n5++] & 0xFF);
                    ++n12;
                }
                n12 = 0;
                int n13 = 0;
                while (n13 < nArray[2]) {
                    n12 = (n12 << 8) + (byArray[n5++] & 0xFF);
                    ++n13;
                }
                n13 = n8 * 2;
                if (this.xref[n13] == 0 && this.xref[n13 + 1] == 0) {
                    switch (n11) {
                        case 0: {
                            this.xref[n13] = -1;
                            break;
                        }
                        case 1: {
                            this.xref[n13] = n10;
                            break;
                        }
                        case 2: {
                            this.xref[n13] = n12;
                            this.xref[n13 + 1] = n10;
                            if (this.partial) {
                                this.objStmToOffset.put(n10, 0);
                                break;
                            }
                            Integer n14 = new Integer(n10);
                            IntHashtable intHashtable = (IntHashtable)this.objStmMark.get(n14);
                            if (intHashtable == null) {
                                intHashtable = new IntHashtable();
                                intHashtable.put(n12, 1);
                                this.objStmMark.put(n14, intHashtable);
                                break;
                            }
                            intHashtable.put(n12, 1);
                        }
                    }
                }
                ++n8;
            }
            n7 += 2;
        }
        if ((n2 *= 2) < this.xref.length) {
            this.xref[n2] = -1;
        }
        if (n4 == -1) {
            return true;
        }
        return this.readXRefStream(n4);
    }

    protected void rebuildXref() throws IOException {
        Object object;
        int n;
        this.hybridXref = false;
        this.newXrefType = false;
        this.tokens.seek(0);
        int[][] nArray = new int[1024][];
        int n2 = 0;
        this.trailer = null;
        byte[] byArray = new byte[64];
        while (true) {
            n = this.tokens.getFilePointer();
            if (!this.tokens.readLineSegment(byArray)) break;
            if (byArray[0] == 116) {
                if (!PdfEncodings.convertToString(byArray, null).startsWith("trailer")) continue;
                this.tokens.seek(n);
                this.tokens.nextToken();
                n = this.tokens.getFilePointer();
                try {
                    object = (PdfDictionary)this.readPRObject();
                    if (object.get(PdfName.ROOT) != null) {
                        this.trailer = object;
                        continue;
                    }
                    this.tokens.seek(n);
                }
                catch (Exception exception) {
                    this.tokens.seek(n);
                }
                continue;
            }
            if (byArray[0] < 48 || byArray[0] > 57 || (object = PRTokeniser.checkObjectStart(byArray)) == null) continue;
            int n3 = object[0];
            int n4 = object[1];
            if (n3 >= nArray.length) {
                int n5 = n3 * 2;
                int[][] nArray2 = new int[n5][];
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                nArray = nArray2;
            }
            if (n3 >= n2) {
                n2 = n3 + 1;
            }
            if (nArray[n3] != null && n4 < nArray[n3][1]) continue;
            object[0] = n;
            nArray[n3] = object;
        }
        if (this.trailer == null) {
            throw new IOException("trailer not found.");
        }
        this.xref = new int[n2 * 2];
        n = 0;
        while (n < n2) {
            object = nArray[n];
            if (object != null) {
                this.xref[n * 2] = object[0];
            }
            ++n;
        }
    }

    protected PdfDictionary readDictionary() throws IOException {
        PdfDictionary pdfDictionary = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError("Dictionary key is not a name.");
            }
            PdfName pdfName = new PdfName(this.tokens.getStringValue(), false);
            PdfObject pdfObject = this.readPRObject();
            int n = pdfObject.type();
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            if (-n == 6) {
                this.tokens.throwError("Unexpected ']'");
            }
            pdfDictionary.put(pdfName, pdfObject);
        }
        return pdfDictionary;
    }

    protected PdfArray readArray() throws IOException {
        PdfObject pdfObject;
        int n;
        PdfArray pdfArray = new PdfArray();
        while (-(n = (pdfObject = this.readPRObject()).type()) != 6) {
            if (-n == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            pdfArray.add(pdfObject);
        }
        return pdfArray;
    }

    protected PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        int n = this.tokens.getTokenType();
        switch (n) {
            case 7: {
                PdfDictionary pdfDictionary = this.readDictionary();
                int n2 = this.tokens.getFilePointer();
                if (this.tokens.nextToken() && this.tokens.getStringValue().equals("stream")) {
                    int n3 = this.tokens.read();
                    if (n3 != 10) {
                        n3 = this.tokens.read();
                    }
                    if (n3 != 10) {
                        this.tokens.backOnePosition(n3);
                    }
                    PRStream pRStream = new PRStream(this, this.tokens.getFilePointer());
                    pRStream.putAll(pdfDictionary);
                    pRStream.setObjNum(this.objNum, this.objGen);
                    return pRStream;
                }
                this.tokens.seek(n2);
                return pdfDictionary;
            }
            case 5: {
                return this.readArray();
            }
            case 1: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case 2: {
                PdfString pdfString = new PdfString(this.tokens.getStringValue(), null).setHexWriting(this.tokens.isHexString());
                pdfString.setObjNum(this.objNum, this.objGen);
                if (this.strings != null) {
                    this.strings.add(pdfString);
                }
                return pdfString;
            }
            case 3: {
                return new PdfName(this.tokens.getStringValue(), false);
            }
            case 9: {
                int n4 = this.tokens.getReference();
                PRIndirectReference pRIndirectReference = new PRIndirectReference(this, n4, this.tokens.getGeneration());
                return pRIndirectReference;
            }
        }
        String string = this.tokens.getStringValue();
        if ("null".equals(string)) {
            return PdfNull.PDFNULL;
        }
        if ("true".equals(string)) {
            return PdfBoolean.PDFTRUE;
        }
        if ("false".equals(string)) {
            return PdfBoolean.PDFFALSE;
        }
        return new PdfLiteral(-n, this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] byArray) {
        byte[] byArray2 = PdfReader.FlateDecode(byArray, true);
        if (byArray2 == null) {
            return PdfReader.FlateDecode(byArray, false);
        }
        return byArray2;
    }

    public static byte[] decodePredictor(byte[] byArray, PdfObject pdfObject) {
        if (pdfObject == null || !pdfObject.isDictionary()) {
            return byArray;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.PREDICTOR));
        if (pdfObject2 == null || !pdfObject2.isNumber()) {
            return byArray;
        }
        int n = ((PdfNumber)pdfObject2).intValue();
        if (n < 10) {
            return byArray;
        }
        int n2 = 1;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.COLUMNS));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n2 = ((PdfNumber)pdfObject2).intValue();
        }
        int n3 = 1;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.COLORS));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n3 = ((PdfNumber)pdfObject2).intValue();
        }
        int n4 = 8;
        pdfObject2 = PdfReader.getPdfObject(pdfDictionary.get(PdfName.BITSPERCOMPONENT));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n4 = ((PdfNumber)pdfObject2).intValue();
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n5 = n3 * n4 / 8;
        int n6 = (n3 * n2 * n4 + 7) / 8;
        byte[] byArray2 = new byte[n6];
        byte[] byArray3 = new byte[n6];
        while (true) {
            int n7 = 0;
            try {
                n7 = dataInputStream.read();
                if (n7 < 0) {
                    return byteArrayOutputStream.toByteArray();
                }
                dataInputStream.readFully(byArray2, 0, n6);
            }
            catch (Exception exception) {
                return byteArrayOutputStream.toByteArray();
            }
            switch (n7) {
                case 0: {
                    break;
                }
                case 1: {
                    int n8 = n5;
                    while (n8 < n6) {
                        int n9 = n8;
                        byArray2[n9] = (byte)(byArray2[n9] + byArray2[n8 - n5]);
                        ++n8;
                    }
                    break;
                }
                case 2: {
                    int n10 = 0;
                    while (n10 < n6) {
                        int n11 = n10;
                        byArray2[n11] = (byte)(byArray2[n11] + byArray3[n10]);
                        ++n10;
                    }
                    break;
                }
                case 3: {
                    int n12 = 0;
                    while (n12 < n5) {
                        int n13 = n12;
                        byArray2[n13] = (byte)(byArray2[n13] + byArray3[n12] / 2);
                        ++n12;
                    }
                    n12 = n5;
                    while (n12 < n6) {
                        int n14 = n12;
                        byArray2[n14] = (byte)(byArray2[n14] + ((byArray2[n12 - n5] & 0xFF) + (byArray3[n12] & 0xFF)) / 2);
                        ++n12;
                    }
                    break;
                }
                case 4: {
                    int n15 = 0;
                    while (n15 < n5) {
                        int n16 = n15;
                        byArray2[n16] = (byte)(byArray2[n16] + byArray3[n15]);
                        ++n15;
                    }
                    n15 = n5;
                    while (n15 < n6) {
                        int n17 = byArray2[n15 - n5] & 0xFF;
                        int n18 = byArray3[n15] & 0xFF;
                        int n19 = byArray3[n15 - n5] & 0xFF;
                        int n20 = n17 + n18 - n19;
                        int n21 = Math.abs(n20 - n17);
                        int n22 = Math.abs(n20 - n18);
                        int n23 = Math.abs(n20 - n19);
                        int n24 = n21 <= n22 && n21 <= n23 ? n17 : (n22 <= n23 ? n18 : n19);
                        int n25 = n15++;
                        byArray2[n25] = (byte)(byArray2[n25] + (byte)n24);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("PNG filter unknown.");
                }
            }
            try {
                byteArrayOutputStream.write(byArray2);
            }
            catch (IOException iOException) {}
            byte[] byArray4 = byArray3;
            byArray3 = byArray2;
            byArray2 = byArray4;
        }
    }

    public static byte[] FlateDecode(byte[] byArray, boolean bl) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[bl ? 4092 : 1];
        try {
            int n;
            while ((n = inflaterInputStream.read(byArray2)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (bl) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 == 62) break;
            if (!PRTokeniser.isWhitespace(n3)) {
                int n4 = PRTokeniser.getHex(n3);
                if (n4 == -1) {
                    throw new RuntimeException("Illegal character in ASCIIHexDecode.");
                }
                if (bl) {
                    n = n4;
                } else {
                    byteArrayOutputStream.write((byte)((n << 4) + n4));
                }
                bl = !bl;
            }
            ++n2;
        }
        if (!bl) {
            byteArrayOutputStream.write((byte)(n << 4));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        int[] nArray = new int[5];
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 == 126) break;
            if (!PRTokeniser.isWhitespace(n3)) {
                if (n3 == 122 && n == 0) {
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                } else {
                    if (n3 < 33 || n3 > 117) {
                        throw new RuntimeException("Illegal character in ASCII85Decode.");
                    }
                    nArray[n] = n3 - 33;
                    if (++n == 5) {
                        n = 0;
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < 5) {
                            n4 = n4 * 85 + nArray[n5];
                            ++n5;
                        }
                        byteArrayOutputStream.write((byte)(n4 >> 24));
                        byteArrayOutputStream.write((byte)(n4 >> 16));
                        byteArrayOutputStream.write((byte)(n4 >> 8));
                        byteArrayOutputStream.write((byte)n4);
                    }
                }
            }
            ++n2;
        }
        n2 = 0;
        if (n == 1) {
            throw new RuntimeException("Illegal length in ASCII85Decode.");
        }
        if (n == 2) {
            n2 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85;
            byteArrayOutputStream.write((byte)(n2 >> 24));
        } else if (n == 3) {
            n2 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85;
            byteArrayOutputStream.write((byte)(n2 >> 24));
            byteArrayOutputStream.write((byte)(n2 >> 16));
        } else if (n == 4) {
            n2 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85 + nArray[3] * 85;
            byteArrayOutputStream.write((byte)(n2 >> 24));
            byteArrayOutputStream.write((byte)(n2 >> 16));
            byteArrayOutputStream.write((byte)(n2 >> 8));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] LZWDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZWDecoder lZWDecoder = new LZWDecoder();
        lZWDecoder.decode(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isRebuilt() {
        return this.rebuilt;
    }

    public PdfDictionary getPageN(int n) {
        PdfDictionary pdfDictionary = this.pageRefs.getPageN(n);
        if (pdfDictionary == null) {
            return null;
        }
        if (this.appendable) {
            pdfDictionary.setIndRef(this.pageRefs.getPageOrigRef(n));
        }
        return pdfDictionary;
    }

    public PdfDictionary getPageNRelease(int n) {
        PdfDictionary pdfDictionary = this.getPageN(n);
        this.pageRefs.releasePage(n);
        return pdfDictionary;
    }

    public void releasePage(int n) {
        this.pageRefs.releasePage(n);
    }

    public void resetReleasePage() {
        this.pageRefs.resetReleasePage();
    }

    public PRIndirectReference getPageOrigRef(int n) {
        return this.pageRefs.getPageOrigRef(n);
    }

    public byte[] getPageContent(int n, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        PdfDictionary pdfDictionary = this.getPageNRelease(n);
        if (pdfDictionary == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.CONTENTS));
        if (pdfObject == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (pdfObject.isStream()) {
            return PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
        }
        if (pdfObject.isArray()) {
            PdfArray pdfArray = (PdfArray)pdfObject;
            ArrayList arrayList = pdfArray.getArrayList();
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                PdfObject pdfObject2 = PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(n2));
                if (pdfObject2 != null && pdfObject2.isStream()) {
                    byte[] byArray = PdfReader.getStreamBytes((PRStream)pdfObject2, randomAccessFileOrArray);
                    byteArrayOutputStream.write(byArray);
                    if (n2 != arrayList.size() - 1) {
                        byteArrayOutputStream.write(10);
                    }
                }
                ++n2;
            }
            return byteArrayOutputStream.toByteArray();
        }
        return new byte[0];
    }

    public byte[] getPageContent(int n) throws IOException {
        byte[] byArray;
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byArray = this.getPageContent(n, randomAccessFileOrArray);
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    protected void killXref(PdfObject pdfObject) {
        if (pdfObject == null) {
            return;
        }
        if (pdfObject instanceof PdfIndirectReference && !pdfObject.isIndirect()) {
            return;
        }
        switch (pdfObject.type()) {
            case 10: {
                int n = ((PRIndirectReference)pdfObject).getNumber();
                pdfObject = (PdfObject)this.xrefObj.get(n);
                this.xrefObj.set(n, null);
                this.freeXref = n;
                this.killXref(pdfObject);
                break;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                int n = 0;
                while (n < arrayList.size()) {
                    this.killXref((PdfObject)arrayList.get(n));
                    ++n;
                }
                break;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                Iterator iterator = pdfDictionary.getKeys().iterator();
                while (iterator.hasNext()) {
                    this.killXref(pdfDictionary.get((PdfName)iterator.next()));
                }
                break;
            }
        }
    }

    public void setPageContent(int n, byte[] byArray) {
        PdfDictionary pdfDictionary = this.getPageN(n);
        if (pdfDictionary == null) {
            return;
        }
        PdfObject pdfObject = pdfDictionary.get(PdfName.CONTENTS);
        this.freeXref = -1;
        this.killXref(pdfObject);
        if (this.freeXref == -1) {
            this.xrefObj.add(null);
            this.freeXref = this.xrefObj.size() - 1;
        }
        pdfDictionary.put(PdfName.CONTENTS, new PRIndirectReference(this, this.freeXref));
        this.xrefObj.set(this.freeXref, new PRStream(this, byArray));
    }

    public static byte[] getStreamBytes(PRStream pRStream, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.FILTER));
        byte[] byArray = PdfReader.getStreamBytesRaw(pRStream, randomAccessFileOrArray);
        ArrayList arrayList = new ArrayList();
        if (pdfObject != null) {
            if (pdfObject.isName()) {
                arrayList.add(pdfObject);
            } else if (pdfObject.isArray()) {
                arrayList = ((PdfArray)pdfObject).getArrayList();
            }
        }
        ArrayList arrayList2 = new ArrayList();
        PdfObject pdfObject2 = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.DECODEPARMS));
        if (pdfObject2 == null || !pdfObject2.isDictionary() && !pdfObject2.isArray()) {
            pdfObject2 = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.DP));
        }
        if (pdfObject2 != null) {
            if (pdfObject2.isDictionary()) {
                arrayList2.add(pdfObject2);
            } else if (pdfObject2.isArray()) {
                arrayList2 = ((PdfArray)pdfObject2).getArrayList();
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            PdfObject pdfObject3;
            String string = ((PdfName)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(n))).toString();
            if (string.equals("/FlateDecode") || string.equals("/Fl")) {
                byArray = PdfReader.FlateDecode(byArray);
                pdfObject3 = null;
                if (n < arrayList2.size()) {
                    pdfObject3 = (PdfObject)arrayList2.get(n);
                    byArray = PdfReader.decodePredictor(byArray, pdfObject3);
                }
            } else if (string.equals("/ASCIIHexDecode") || string.equals("/AHx")) {
                byArray = PdfReader.ASCIIHexDecode(byArray);
            } else if (string.equals("/ASCII85Decode") || string.equals("/A85")) {
                byArray = PdfReader.ASCII85Decode(byArray);
            } else if (string.equals("/LZWDecode")) {
                byArray = PdfReader.LZWDecode(byArray);
                pdfObject3 = null;
                if (n < arrayList2.size()) {
                    pdfObject3 = (PdfObject)arrayList2.get(n);
                    byArray = PdfReader.decodePredictor(byArray, pdfObject3);
                }
            } else if (!string.equals("/Crypt")) {
                throw new IOException("The filter " + string + " is not supported.");
            }
            ++n;
        }
        return byArray;
    }

    public static byte[] getStreamBytes(PRStream pRStream) throws IOException {
        byte[] byArray;
        RandomAccessFileOrArray randomAccessFileOrArray = pRStream.getReader().getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byArray = PdfReader.getStreamBytes(pRStream, randomAccessFileOrArray);
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    public static byte[] getStreamBytesRaw(PRStream pRStream, RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        byte[] byArray;
        PdfReader pdfReader = pRStream.getReader();
        if (pRStream.getOffset() < 0) {
            byArray = pRStream.getBytes();
        } else {
            byArray = new byte[pRStream.getLength()];
            randomAccessFileOrArray.seek(pRStream.getOffset());
            randomAccessFileOrArray.readFully(byArray);
            PdfEncryption pdfEncryption = pdfReader.getDecrypt();
            if (pdfEncryption != null) {
                PdfObject pdfObject = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.FILTER));
                ArrayList arrayList = new ArrayList();
                if (pdfObject != null) {
                    if (pdfObject.isName()) {
                        arrayList.add(pdfObject);
                    } else if (pdfObject.isArray()) {
                        arrayList = ((PdfArray)pdfObject).getArrayList();
                    }
                }
                boolean bl = false;
                int n = 0;
                while (n < arrayList.size()) {
                    PdfObject pdfObject2 = PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(n));
                    if (pdfObject2 != null && pdfObject2.toString().equals("/Crypt")) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    pdfEncryption.setHashKey(pRStream.getObjNum(), pRStream.getObjGen());
                    byArray = pdfEncryption.decryptByteArray(byArray);
                }
            }
        }
        return byArray;
    }

    public static byte[] getStreamBytesRaw(PRStream pRStream) throws IOException {
        byte[] byArray;
        RandomAccessFileOrArray randomAccessFileOrArray = pRStream.getReader().getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byArray = PdfReader.getStreamBytesRaw(pRStream, randomAccessFileOrArray);
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    public void eliminateSharedStreams() {
        PdfObject pdfObject;
        if (!this.sharedStreams) {
            return;
        }
        this.sharedStreams = false;
        if (this.pageRefs.size() == 1) {
            return;
        }
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        ArrayList<PRStream> arrayList2 = new ArrayList<PRStream>();
        IntHashtable intHashtable = new IntHashtable();
        int n = 1;
        while (n <= this.pageRefs.size()) {
            PdfObject pdfObject2;
            pdfObject = this.pageRefs.getPageN(n);
            if (pdfObject != null && (pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.CONTENTS))) != null) {
                PdfObject pdfObject3;
                if (pdfObject2.isStream()) {
                    pdfObject3 = (PRIndirectReference)((PdfDictionary)pdfObject).get(PdfName.CONTENTS);
                    if (intHashtable.containsKey(((PdfIndirectReference)pdfObject3).getNumber())) {
                        arrayList.add(pdfObject3);
                        arrayList2.add(new PRStream((PRStream)pdfObject2, null));
                    } else {
                        intHashtable.put(((PdfIndirectReference)pdfObject3).getNumber(), 1);
                    }
                } else if (pdfObject2.isArray()) {
                    pdfObject3 = (PdfArray)pdfObject2;
                    ArrayList arrayList3 = ((PdfArray)pdfObject3).getArrayList();
                    int n2 = 0;
                    while (n2 < arrayList3.size()) {
                        PRIndirectReference pRIndirectReference = (PRIndirectReference)arrayList3.get(n2);
                        if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                            arrayList.add(pRIndirectReference);
                            arrayList2.add(new PRStream((PRStream)PdfReader.getPdfObject(pRIndirectReference), null));
                        } else {
                            intHashtable.put(pRIndirectReference.getNumber(), 1);
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        if (arrayList2.isEmpty()) {
            return;
        }
        n = 0;
        while (n < arrayList2.size()) {
            this.xrefObj.add(arrayList2.get(n));
            pdfObject = (PRIndirectReference)arrayList.get(n);
            ((PRIndirectReference)pdfObject).setNumber(this.xrefObj.size() - 1, 0);
            ++n;
        }
    }

    public boolean isTampered() {
        return this.tampered;
    }

    public void setTampered(boolean bl) {
        this.tampered = bl;
    }

    public byte[] getMetadata() throws IOException {
        PdfObject pdfObject = PdfReader.getPdfObject(this.catalog.get(PdfName.METADATA));
        if (!(pdfObject instanceof PRStream)) {
            return null;
        }
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        byte[] byArray = null;
        try {
            randomAccessFileOrArray.reOpen();
            byArray = PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    public int getLastXref() {
        return this.lastXref;
    }

    public int getXrefSize() {
        return this.xrefObj.size();
    }

    public int getEofPos() {
        return this.eofPos;
    }

    public char getPdfVersion() {
        return this.pdfVersion;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public int getPermissions() {
        return this.pValue;
    }

    public boolean is128Key() {
        return this.rValue == 3;
    }

    public PdfDictionary getTrailer() {
        return this.trailer;
    }

    PdfEncryption getDecrypt() {
        return this.decrypt;
    }

    static boolean equalsn(byte[] byArray, byte[] byArray2) {
        int n = byArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static boolean existsName(PdfDictionary pdfDictionary, PdfName pdfName, PdfName pdfName2) {
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(pdfName));
        if (pdfObject == null || !pdfObject.isName()) {
            return false;
        }
        PdfName pdfName3 = (PdfName)pdfObject;
        return pdfName3.equals(pdfName2);
    }

    static String getFontName(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.BASEFONT));
        if (pdfObject == null || !pdfObject.isName()) {
            return null;
        }
        return PdfName.decodeName(pdfObject.toString());
    }

    static String getSubsetPrefix(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return null;
        }
        String string = PdfReader.getFontName(pdfDictionary);
        if (string == null) {
            return null;
        }
        if (string.length() < 8 || string.charAt(6) != '+') {
            return null;
        }
        int n = 0;
        while (n < 6) {
            char c = string.charAt(n);
            if (c < 'A' || c > 'Z') {
                return null;
            }
            ++n;
        }
        return string;
    }

    public int shuffleSubsetNames() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.xrefObj.size()) {
            PdfDictionary pdfDictionary;
            PdfObject pdfObject = this.getPdfObjectRelease(n2);
            if (pdfObject != null && pdfObject.isDictionary() && PdfReader.existsName(pdfDictionary = (PdfDictionary)pdfObject, PdfName.TYPE, PdfName.FONT)) {
                PdfDictionary pdfDictionary2;
                Object object;
                Object object2;
                String string;
                if (PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TYPE1) || PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.MMTYPE1) || PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TRUETYPE)) {
                    string = PdfReader.getSubsetPrefix(pdfDictionary);
                    if (string != null) {
                        object2 = String.valueOf(BaseFont.createSubsetPrefix()) + string.substring(7);
                        object = new PdfName((String)object2);
                        pdfDictionary.put(PdfName.BASEFONT, (PdfObject)object);
                        this.setXrefPartialObject(n2, pdfDictionary);
                        ++n;
                        pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONTDESCRIPTOR));
                        if (pdfDictionary2 != null) {
                            pdfDictionary2.put(PdfName.FONTNAME, (PdfObject)object);
                        }
                    }
                } else if (PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TYPE0)) {
                    String string2;
                    string = PdfReader.getSubsetPrefix(pdfDictionary);
                    object2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DESCENDANTFONTS));
                    if (object2 != null && !((ArrayList)(object = ((PdfArray)object2).getArrayList())).isEmpty() && (string2 = PdfReader.getSubsetPrefix(pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((ArrayList)object).get(0)))) != null) {
                        String string3 = BaseFont.createSubsetPrefix();
                        if (string != null) {
                            pdfDictionary.put(PdfName.BASEFONT, new PdfName(String.valueOf(string3) + string.substring(7)));
                        }
                        this.setXrefPartialObject(n2, pdfDictionary);
                        PdfName pdfName = new PdfName(String.valueOf(string3) + string2.substring(7));
                        pdfDictionary2.put(PdfName.BASEFONT, pdfName);
                        ++n;
                        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.FONTDESCRIPTOR));
                        if (pdfDictionary3 != null) {
                            pdfDictionary3.put(PdfName.FONTNAME, pdfName);
                        }
                    }
                }
            }
            ++n2;
        }
        return n;
    }

    public int createFakeFontSubsets() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.xrefObj.size()) {
            String string;
            PdfDictionary pdfDictionary;
            PdfObject pdfObject = this.getPdfObjectRelease(n2);
            if (pdfObject != null && pdfObject.isDictionary() && PdfReader.existsName(pdfDictionary = (PdfDictionary)pdfObject, PdfName.TYPE, PdfName.FONT) && (PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TYPE1) || PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.MMTYPE1) || PdfReader.existsName(pdfDictionary, PdfName.SUBTYPE, PdfName.TRUETYPE)) && (string = PdfReader.getSubsetPrefix(pdfDictionary)) == null && (string = PdfReader.getFontName(pdfDictionary)) != null) {
                String string2 = String.valueOf(BaseFont.createSubsetPrefix()) + string;
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.FONTDESCRIPTOR));
                if (pdfDictionary2 != null && (pdfDictionary2.get(PdfName.FONTFILE) != null || pdfDictionary2.get(PdfName.FONTFILE2) != null || pdfDictionary2.get(PdfName.FONTFILE3) != null)) {
                    pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FONTDESCRIPTOR));
                    PdfName pdfName = new PdfName(string2);
                    pdfDictionary.put(PdfName.BASEFONT, pdfName);
                    pdfDictionary2.put(PdfName.FONTNAME, pdfName);
                    this.setXrefPartialObject(n2, pdfDictionary);
                    ++n;
                }
            }
            ++n2;
        }
        return n;
    }

    private static PdfArray getNameArray(PdfObject pdfObject) {
        PdfObject pdfObject2;
        if (pdfObject == null) {
            return null;
        }
        if ((pdfObject = PdfReader.getPdfObjectRelease(pdfObject)) == null) {
            return null;
        }
        if (pdfObject.isArray()) {
            return (PdfArray)pdfObject;
        }
        if (pdfObject.isDictionary() && (pdfObject2 = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.D))) != null && pdfObject2.isArray()) {
            return (PdfArray)pdfObject2;
        }
        return null;
    }

    public HashMap getNamedDestination() {
        HashMap hashMap = this.getNamedDestinationFromNames();
        hashMap.putAll(this.getNamedDestinationFromStrings());
        return hashMap;
    }

    public HashMap getNamedDestinationFromNames() {
        HashMap<String, PdfArray> hashMap = new HashMap<String, PdfArray>();
        if (this.catalog.get(PdfName.DESTS) != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.DESTS));
            if (pdfDictionary == null) {
                return hashMap;
            }
            Set set = pdfDictionary.getKeys();
            for (PdfName pdfName : set) {
                String string = PdfName.decodeName(pdfName.toString());
                PdfArray pdfArray = PdfReader.getNameArray(pdfDictionary.get(pdfName));
                if (pdfArray == null) continue;
                hashMap.put(string, pdfArray);
            }
        }
        return hashMap;
    }

    public HashMap getNamedDestinationFromStrings() {
        PdfDictionary pdfDictionary;
        if (this.catalog.get(PdfName.NAMES) != null && (pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.NAMES))) != null && (pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.DESTS))) != null) {
            HashMap hashMap = PdfNameTree.readTree(pdfDictionary);
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                PdfArray pdfArray = PdfReader.getNameArray((PdfObject)entry.getValue());
                if (pdfArray != null) {
                    entry.setValue(pdfArray);
                    continue;
                }
                iterator.remove();
            }
            return hashMap;
        }
        return new HashMap();
    }

    private boolean replaceNamedDestination(PdfObject pdfObject, HashMap hashMap) {
        pdfObject = PdfReader.getPdfObject(pdfObject);
        int n = this.lastXrefPartial;
        this.releaseLastXrefPartial();
        if (pdfObject != null && pdfObject.isDictionary()) {
            PdfObject pdfObject2 = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.DEST));
            String string = null;
            if (pdfObject2 != null) {
                if (pdfObject2.isName()) {
                    string = PdfName.decodeName(pdfObject2.toString());
                } else if (pdfObject2.isString()) {
                    string = pdfObject2.toString();
                }
                PdfArray pdfArray = (PdfArray)hashMap.get(string);
                if (pdfArray != null) {
                    ((PdfDictionary)pdfObject).put(PdfName.DEST, pdfArray);
                    this.setXrefPartialObject(n, pdfObject);
                    return true;
                }
            } else {
                pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.A));
                if (pdfObject2 != null) {
                    int n2 = this.lastXrefPartial;
                    this.releaseLastXrefPartial();
                    PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
                    PdfName pdfName = (PdfName)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.S));
                    if (PdfName.GOTO.equals(pdfName)) {
                        PdfArray pdfArray;
                        PdfObject pdfObject3 = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.D));
                        if (pdfObject3 != null) {
                            if (pdfObject3.isName()) {
                                string = PdfName.decodeName(pdfObject3.toString());
                            } else if (pdfObject3.isString()) {
                                string = pdfObject3.toString();
                            }
                        }
                        if ((pdfArray = (PdfArray)hashMap.get(string)) != null) {
                            pdfDictionary.put(PdfName.D, pdfArray);
                            this.setXrefPartialObject(n2, pdfObject2);
                            this.setXrefPartialObject(n, pdfObject);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public void removeFields() {
        this.pageRefs.resetReleasePage();
        int n = 1;
        while (n <= this.pageRefs.size()) {
            PdfDictionary pdfDictionary = this.pageRefs.getPageN(n);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
            if (pdfArray == null) {
                this.pageRefs.releasePage(n);
            } else {
                ArrayList arrayList = pdfArray.getArrayList();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(n2));
                    if (PdfName.WIDGET.equals(pdfDictionary2.get(PdfName.SUBTYPE))) {
                        arrayList.remove(n2--);
                    }
                    ++n2;
                }
                if (arrayList.isEmpty()) {
                    pdfDictionary.remove(PdfName.ANNOTS);
                } else {
                    this.pageRefs.releasePage(n);
                }
            }
            ++n;
        }
        this.catalog.remove(PdfName.ACROFORM);
        this.pageRefs.resetReleasePage();
    }

    public void removeAnnotations() {
        this.pageRefs.resetReleasePage();
        int n = 1;
        while (n <= this.pageRefs.size()) {
            PdfDictionary pdfDictionary = this.pageRefs.getPageN(n);
            if (pdfDictionary.get(PdfName.ANNOTS) == null) {
                this.pageRefs.releasePage(n);
            } else {
                pdfDictionary.remove(PdfName.ANNOTS);
            }
            ++n;
        }
        this.catalog.remove(PdfName.ACROFORM);
        this.pageRefs.resetReleasePage();
    }

    private void iterateBookmarks(PdfObject pdfObject, HashMap hashMap) {
        while (pdfObject != null) {
            this.replaceNamedDestination(pdfObject, hashMap);
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfObject);
            PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIRST);
            if (pdfObject2 != null) {
                this.iterateBookmarks(pdfObject2, hashMap);
            }
            pdfObject = pdfDictionary.get(PdfName.NEXT);
        }
    }

    public void consolidateNamedDestinations() {
        if (this.consolidateNamedDestinations) {
            return;
        }
        this.consolidateNamedDestinations = true;
        HashMap hashMap = this.getNamedDestination();
        if (hashMap.isEmpty()) {
            return;
        }
        int n = 1;
        while (n <= this.pageRefs.size()) {
            PdfDictionary pdfDictionary = this.pageRefs.getPageN(n);
            PdfObject pdfObject = pdfDictionary.get(PdfName.ANNOTS);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfObject);
            int n2 = this.lastXrefPartial;
            this.releaseLastXrefPartial();
            if (pdfArray == null) {
                this.pageRefs.releasePage(n);
            } else {
                ArrayList arrayList = pdfArray.getArrayList();
                boolean bl = false;
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    PdfObject pdfObject2 = (PdfObject)arrayList.get(n3);
                    if (this.replaceNamedDestination(pdfObject2, hashMap) && !pdfObject2.isIndirect()) {
                        bl = true;
                    }
                    ++n3;
                }
                if (bl) {
                    this.setXrefPartialObject(n2, pdfArray);
                }
                if (!bl || pdfObject.isIndirect()) {
                    this.pageRefs.releasePage(n);
                }
            }
            ++n;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.OUTLINES));
        if (pdfDictionary == null) {
            return;
        }
        this.iterateBookmarks(pdfDictionary.get(PdfName.FIRST), hashMap);
    }

    protected static PdfDictionary duplicatePdfDictionary(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2, PdfReader pdfReader) {
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
        }
        for (PdfName pdfName : pdfDictionary.getKeys()) {
            pdfDictionary2.put(pdfName, PdfReader.duplicatePdfObject(pdfDictionary.get(pdfName), pdfReader));
        }
        return pdfDictionary2;
    }

    protected static PdfObject duplicatePdfObject(PdfObject pdfObject, PdfReader pdfReader) {
        if (pdfObject == null) {
            return null;
        }
        switch (pdfObject.type()) {
            case 6: {
                return PdfReader.duplicatePdfDictionary((PdfDictionary)pdfObject, null, pdfReader);
            }
            case 7: {
                PRStream pRStream = (PRStream)pdfObject;
                PRStream pRStream2 = new PRStream(pRStream, null, pdfReader);
                PdfReader.duplicatePdfDictionary(pRStream, pRStream2, pdfReader);
                return pRStream2;
            }
            case 5: {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                PdfArray pdfArray = new PdfArray();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    pdfArray.add(PdfReader.duplicatePdfObject((PdfObject)iterator.next(), pdfReader));
                }
                return pdfArray;
            }
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                return new PRIndirectReference(pdfReader, pRIndirectReference.getNumber(), pRIndirectReference.getGeneration());
            }
        }
        return pdfObject;
    }

    public void close() {
        if (!this.partial) {
            return;
        }
        try {
            this.tokens.close();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    protected void removeUnusedNode(PdfObject pdfObject, boolean[] blArray) {
        Stack<Object> stack = new Stack<Object>();
        stack.push(pdfObject);
        block5: while (!stack.empty()) {
            int n;
            Object[] objectArray;
            PdfName[] pdfNameArray;
            PdfDictionary pdfDictionary;
            ArrayList arrayList;
            block18: {
                Object e;
                block17: {
                    e = stack.pop();
                    if (e == null) continue;
                    arrayList = null;
                    pdfDictionary = null;
                    pdfNameArray = null;
                    objectArray = null;
                    n = 0;
                    if (!(e instanceof PdfObject)) break block17;
                    pdfObject = (PdfObject)e;
                    switch (pdfObject.type()) {
                        case 6: 
                        case 7: {
                            pdfDictionary = (PdfDictionary)pdfObject;
                            pdfNameArray = new PdfName[pdfDictionary.size()];
                            pdfDictionary.getKeys().toArray(pdfNameArray);
                            break block18;
                        }
                        case 5: {
                            arrayList = ((PdfArray)pdfObject).getArrayList();
                            break block18;
                        }
                        case 10: {
                            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                            int n2 = pRIndirectReference.getNumber();
                            if (blArray[n2]) continue block5;
                            blArray[n2] = true;
                            stack.push(PdfReader.getPdfObjectRelease(pRIndirectReference));
                            break;
                        }
                    }
                    continue;
                }
                objectArray = (Object[])e;
                if (objectArray[0] instanceof ArrayList) {
                    arrayList = (ArrayList)objectArray[0];
                    n = (Integer)objectArray[1];
                } else {
                    pdfNameArray = (PdfName[])objectArray[0];
                    pdfDictionary = (PdfDictionary)objectArray[1];
                    n = (Integer)objectArray[2];
                }
            }
            if (arrayList != null) {
                int n3 = n;
                while (n3 < arrayList.size()) {
                    int n4;
                    PdfObject pdfObject2 = (PdfObject)arrayList.get(n3);
                    if (!pdfObject2.isIndirect() || (n4 = ((PRIndirectReference)pdfObject2).getNumber()) < this.xrefObj.size() && (this.partial || this.xrefObj.get(n4) != null)) {
                        if (objectArray == null) {
                            stack.push(new Object[]{arrayList, new Integer(n3 + 1)});
                        } else {
                            objectArray[1] = new Integer(n3 + 1);
                            stack.push(objectArray);
                        }
                        stack.push(pdfObject2);
                        continue block5;
                    }
                    arrayList.set(n3, PdfNull.PDFNULL);
                    ++n3;
                }
                continue;
            }
            int n5 = n;
            while (n5 < pdfNameArray.length) {
                int n6;
                PdfName pdfName = pdfNameArray[n5];
                PdfObject pdfObject3 = pdfDictionary.get(pdfName);
                if (!pdfObject3.isIndirect() || (n6 = ((PRIndirectReference)pdfObject3).getNumber()) < this.xrefObj.size() && (this.partial || this.xrefObj.get(n6) != null)) {
                    if (objectArray == null) {
                        stack.push(new Object[]{pdfNameArray, pdfDictionary, new Integer(n5 + 1)});
                    } else {
                        objectArray[2] = new Integer(n5 + 1);
                        stack.push(objectArray);
                    }
                    stack.push(pdfObject3);
                    continue block5;
                }
                pdfDictionary.put(pdfName, PdfNull.PDFNULL);
                ++n5;
            }
        }
    }

    public int removeUnusedObjects() {
        boolean[] blArray = new boolean[this.xrefObj.size()];
        this.removeUnusedNode(this.trailer, blArray);
        int n = 0;
        if (this.partial) {
            int n2 = 1;
            while (n2 < blArray.length) {
                if (!blArray[n2]) {
                    this.xref[n2 * 2] = -1;
                    this.xref[n2 * 2 + 1] = 0;
                    this.xrefObj.set(n2, null);
                    ++n;
                }
                ++n2;
            }
        } else {
            int n3 = 1;
            while (n3 < blArray.length) {
                if (!blArray[n3]) {
                    this.xrefObj.set(n3, null);
                    ++n;
                }
                ++n3;
            }
        }
        return n;
    }

    public AcroFields getAcroFields() {
        return new AcroFields(this, null);
    }

    public String getJavaScript(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.NAMES));
        if (pdfDictionary == null) {
            return null;
        }
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.JAVASCRIPT));
        if (pdfDictionary2 == null) {
            return null;
        }
        HashMap hashMap = PdfNameTree.readTree(pdfDictionary2);
        Object[] objectArray = new String[hashMap.size()];
        objectArray = hashMap.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            PdfObject pdfObject;
            PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfIndirectReference)hashMap.get(objectArray[n]));
            if (pdfDictionary3 != null && (pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary3.get(PdfName.JS))) != null) {
                if (pdfObject.isString()) {
                    stringBuffer.append(((PdfString)pdfObject).toUnicodeString()).append('\n');
                } else if (pdfObject.isStream()) {
                    byte[] byArray = PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
                    if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
                        stringBuffer.append(PdfEncodings.convertToString(byArray, "UnicodeBig"));
                    } else {
                        stringBuffer.append(PdfEncodings.convertToString(byArray, "PDF"));
                    }
                    stringBuffer.append('\n');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getJavaScript() throws IOException {
        String string;
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            string = this.getJavaScript(randomAccessFileOrArray);
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return string;
    }

    public void selectPages(String string) {
        this.selectPages(SequenceList.expand(string, this.getNumberOfPages()));
    }

    public void selectPages(List list) {
        this.pageRefs.selectPages(list);
        this.removeUnusedObjects();
    }

    public void setViewerPreferences(int n) {
        this.viewerPreferences.setViewerPreferences(n);
        this.setViewerPreferences(this.viewerPreferences);
    }

    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        this.viewerPreferences.addViewerPreference(pdfName, pdfObject);
        this.setViewerPreferences(this.viewerPreferences);
    }

    void setViewerPreferences(PdfViewerPreferencesImp pdfViewerPreferencesImp) {
        pdfViewerPreferencesImp.addToCatalog(this.catalog);
    }

    public int getSimpleViewerPreferences() {
        return PdfViewerPreferencesImp.getViewerPreferences(this.catalog).getPageLayoutAndMode();
    }

    public boolean isAppendable() {
        return this.appendable;
    }

    public void setAppendable(boolean bl) {
        this.appendable = bl;
        if (bl) {
            PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        }
    }

    public boolean isNewXrefType() {
        return this.newXrefType;
    }

    public int getFileLength() {
        return this.fileLength;
    }

    public boolean isHybridXref() {
        return this.hybridXref;
    }

    PdfIndirectReference getCryptoRef() {
        if (this.cryptoRef == null) {
            return null;
        }
        return new PdfIndirectReference(0, this.cryptoRef.getNumber(), this.cryptoRef.getGeneration());
    }

    public void removeUsageRights() {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PERMS));
        if (pdfDictionary == null) {
            return;
        }
        pdfDictionary.remove(PdfName.UR);
        pdfDictionary.remove(PdfName.UR3);
        if (pdfDictionary.size() == 0) {
            this.catalog.remove(PdfName.PERMS);
        }
    }

    public int getCertificationLevel() {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.PERMS));
        if (pdfDictionary == null) {
            return 0;
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DOCMDP))) == null) {
            return 0;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.REFERENCE));
        if (pdfArray == null || pdfArray.size() == 0) {
            return 0;
        }
        pdfDictionary = (PdfDictionary)PdfReader.getPdfObject((PdfObject)pdfArray.getArrayList().get(0));
        if (pdfDictionary == null) {
            return 0;
        }
        if ((pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.TRANSFORMPARAMS))) == null) {
            return 0;
        }
        PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.P));
        if (pdfNumber == null) {
            return 0;
        }
        return pdfNumber.intValue();
    }

    public boolean isOpenedWithFullPermissions() {
        return !this.encrypted || this.ownerPasswordUsed;
    }

    public int getCryptoMode() {
        if (this.decrypt == null) {
            return -1;
        }
        return this.decrypt.getCryptoMode();
    }

    public boolean isMetadataEncrypted() {
        if (this.decrypt == null) {
            return false;
        }
        return this.decrypt.isMetadataEncrypted();
    }

    public byte[] computeUserPassword() {
        if (!this.encrypted || !this.ownerPasswordUsed) {
            return null;
        }
        return this.decrypt.computeUserPassword(this.password);
    }

    static class PageRefs {
        private PdfReader reader;
        private IntHashtable refsp;
        private ArrayList refsn;
        private ArrayList pageInh;
        private int lastPageRead = -1;
        private int sizep;

        private PageRefs(PdfReader pdfReader) throws IOException {
            this.reader = pdfReader;
            if (pdfReader.partial) {
                this.refsp = new IntHashtable();
                PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObjectRelease(pdfReader.rootPages.get(PdfName.COUNT));
                this.sizep = pdfNumber.intValue();
            } else {
                this.readPages();
            }
        }

        PageRefs(PageRefs pageRefs, PdfReader pdfReader) {
            this.reader = pdfReader;
            this.sizep = pageRefs.sizep;
            if (pageRefs.refsn != null) {
                this.refsn = new ArrayList(pageRefs.refsn);
                int n = 0;
                while (n < this.refsn.size()) {
                    this.refsn.set(n, PdfReader.duplicatePdfObject((PdfObject)this.refsn.get(n), pdfReader));
                    ++n;
                }
            } else {
                this.refsp = (IntHashtable)pageRefs.refsp.clone();
            }
        }

        int size() {
            if (this.refsn != null) {
                return this.refsn.size();
            }
            return this.sizep;
        }

        void readPages() throws IOException {
            if (this.refsn != null) {
                return;
            }
            this.refsp = null;
            this.refsn = new ArrayList();
            this.pageInh = new ArrayList();
            this.iteratePages((PRIndirectReference)this.reader.catalog.get(PdfName.PAGES));
            this.pageInh = null;
            this.reader.rootPages.put(PdfName.COUNT, new PdfNumber(this.refsn.size()));
        }

        void reReadPages() throws IOException {
            this.refsn = null;
            this.readPages();
        }

        public PdfDictionary getPageN(int n) {
            PRIndirectReference pRIndirectReference = this.getPageOrigRef(n);
            return (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
        }

        public PdfDictionary getPageNRelease(int n) {
            PdfDictionary pdfDictionary = this.getPageN(n);
            this.releasePage(n);
            return pdfDictionary;
        }

        public PRIndirectReference getPageOrigRefRelease(int n) {
            PRIndirectReference pRIndirectReference = this.getPageOrigRef(n);
            this.releasePage(n);
            return pRIndirectReference;
        }

        public PRIndirectReference getPageOrigRef(int n) {
            block6: {
                try {
                    if (--n >= 0 && n < this.size()) break block6;
                    return null;
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
            }
            if (this.refsn != null) {
                return (PRIndirectReference)this.refsn.get(n);
            }
            int n2 = this.refsp.get(n);
            if (n2 == 0) {
                PRIndirectReference pRIndirectReference = this.getSinglePage(n);
                this.lastPageRead = this.reader.lastXrefPartial == -1 ? -1 : n;
                this.reader.lastXrefPartial = -1;
                this.refsp.put(n, pRIndirectReference.getNumber());
                return pRIndirectReference;
            }
            if (this.lastPageRead != n) {
                this.lastPageRead = -1;
            }
            return new PRIndirectReference(this.reader, n2);
        }

        public void releasePage(int n) {
            if (this.refsp == null) {
                return;
            }
            if (--n < 0 || n >= this.size()) {
                return;
            }
            if (n != this.lastPageRead) {
                return;
            }
            this.lastPageRead = -1;
            this.reader.lastXrefPartial = this.refsp.get(n);
            this.reader.releaseLastXrefPartial();
            this.refsp.remove(n);
        }

        public void resetReleasePage() {
            if (this.refsp == null) {
                return;
            }
            this.lastPageRead = -1;
        }

        void insertPage(int n, PRIndirectReference pRIndirectReference) {
            --n;
            if (this.refsn != null) {
                if (n >= this.refsn.size()) {
                    this.refsn.add(pRIndirectReference);
                } else {
                    this.refsn.add(n, pRIndirectReference);
                }
            } else {
                ++this.sizep;
                this.lastPageRead = -1;
                if (n >= this.size()) {
                    this.refsp.put(this.size(), pRIndirectReference.getNumber());
                } else {
                    IntHashtable intHashtable = new IntHashtable((this.refsp.size() + 1) * 2);
                    Iterator iterator = this.refsp.getEntryIterator();
                    while (iterator.hasNext()) {
                        IntHashtable.Entry entry = (IntHashtable.Entry)iterator.next();
                        int n2 = entry.getKey();
                        intHashtable.put(n2 >= n ? n2 + 1 : n2, entry.getValue());
                    }
                    intHashtable.put(n, pRIndirectReference.getNumber());
                    this.refsp = intHashtable;
                }
            }
        }

        private void pushPageAttributes(PdfDictionary pdfDictionary) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            if (!this.pageInh.isEmpty()) {
                pdfDictionary2.putAll((PdfDictionary)this.pageInh.get(this.pageInh.size() - 1));
            }
            int n = 0;
            while (n < pageInhCandidates.length) {
                PdfObject pdfObject = pdfDictionary.get(pageInhCandidates[n]);
                if (pdfObject != null) {
                    pdfDictionary2.put(pageInhCandidates[n], pdfObject);
                }
                ++n;
            }
            this.pageInh.add(pdfDictionary2);
        }

        private void popPageAttributes() {
            this.pageInh.remove(this.pageInh.size() - 1);
        }

        private void iteratePages(PRIndirectReference pRIndirectReference) throws IOException {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS));
            if (pdfArray == null) {
                pdfDictionary.put(PdfName.TYPE, PdfName.PAGE);
                PdfDictionary pdfDictionary2 = (PdfDictionary)this.pageInh.get(this.pageInh.size() - 1);
                for (PdfName pdfName : pdfDictionary2.getKeys()) {
                    if (pdfDictionary.get(pdfName) != null) continue;
                    pdfDictionary.put(pdfName, pdfDictionary2.get(pdfName));
                }
                if (pdfDictionary.get(PdfName.MEDIABOX) == null) {
                    PdfArray pdfArray2 = new PdfArray(new float[]{0.0f, 0.0f, PageSize.LETTER.right(), PageSize.LETTER.top()});
                    pdfDictionary.put(PdfName.MEDIABOX, pdfArray2);
                }
                this.refsn.add(pRIndirectReference);
            } else {
                pdfDictionary.put(PdfName.TYPE, PdfName.PAGES);
                this.pushPageAttributes(pdfDictionary);
                ArrayList arrayList = pdfArray.getArrayList();
                int n = 0;
                while (n < arrayList.size()) {
                    PdfObject pdfObject = (PdfObject)arrayList.get(n);
                    if (!pdfObject.isIndirect()) {
                        while (n < arrayList.size()) {
                            arrayList.remove(n);
                        }
                        break;
                    }
                    this.iteratePages((PRIndirectReference)pdfObject);
                    ++n;
                }
                this.popPageAttributes();
            }
        }

        protected PRIndirectReference getSinglePage(int n) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfDictionary pdfDictionary2 = this.reader.rootPages;
            int n2 = 0;
            block0: while (true) {
                Object object;
                int n3 = 0;
                while (n3 < pageInhCandidates.length) {
                    object = pdfDictionary2.get(pageInhCandidates[n3]);
                    if (object != null) {
                        pdfDictionary.put(pageInhCandidates[n3], (PdfObject)object);
                    }
                    ++n3;
                }
                PdfArray pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.KIDS));
                object = pdfArray.listIterator();
                while (true) {
                    if (!object.hasNext()) continue block0;
                    PRIndirectReference pRIndirectReference = (PRIndirectReference)object.next();
                    PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
                    int n4 = this.reader.lastXrefPartial;
                    PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary3.get(PdfName.COUNT));
                    this.reader.lastXrefPartial = n4;
                    int n5 = 1;
                    if (pdfObject != null && pdfObject.type() == 2) {
                        n5 = ((PdfNumber)pdfObject).intValue();
                    }
                    if (n < n2 + n5) {
                        if (pdfObject == null) {
                            pdfDictionary3.mergeDifferent(pdfDictionary);
                            return pRIndirectReference;
                        }
                        this.reader.releaseLastXrefPartial();
                        pdfDictionary2 = pdfDictionary3;
                        continue block0;
                    }
                    this.reader.releaseLastXrefPartial();
                    n2 += n5;
                }
                break;
            }
        }

        private void selectPages(List list) {
            int n;
            Object object2;
            IntHashtable intHashtable = new IntHashtable();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n2 = this.size();
            for (Object object2 : list) {
                int n3 = (Integer)object2;
                if (n3 < 1 || n3 > n2 || intHashtable.put(n3, 1) != 0) continue;
                arrayList.add(object2);
            }
            if (this.reader.partial) {
                int n4 = 1;
                while (n4 <= n2) {
                    this.getPageOrigRef(n4);
                    this.resetReleasePage();
                    ++n4;
                }
            }
            PRIndirectReference pRIndirectReference = (PRIndirectReference)this.reader.catalog.get(PdfName.PAGES);
            object2 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            ArrayList<PRIndirectReference> arrayList2 = new ArrayList<PRIndirectReference>(arrayList.size());
            PdfArray pdfArray = new PdfArray();
            int n5 = 0;
            while (n5 < arrayList.size()) {
                n = (Integer)arrayList.get(n5);
                PRIndirectReference pRIndirectReference2 = this.getPageOrigRef(n);
                this.resetReleasePage();
                pdfArray.add(pRIndirectReference2);
                arrayList2.add(pRIndirectReference2);
                this.getPageN(n).put(PdfName.PARENT, pRIndirectReference);
                ++n5;
            }
            AcroFields acroFields = this.reader.getAcroFields();
            n = acroFields.getFields().size() > 0 ? 1 : 0;
            int n6 = 1;
            while (n6 <= n2) {
                if (!intHashtable.containsKey(n6)) {
                    if (n != 0) {
                        acroFields.removeFieldsFromPage(n6);
                    }
                    PRIndirectReference pRIndirectReference3 = this.getPageOrigRef(n6);
                    int n7 = pRIndirectReference3.getNumber();
                    this.reader.xrefObj.set(n7, null);
                    if (this.reader.partial) {
                        this.reader.xref[n7 * 2] = -1;
                        this.reader.xref[n7 * 2 + 1] = 0;
                    }
                }
                ++n6;
            }
            ((PdfDictionary)object2).put(PdfName.COUNT, new PdfNumber(arrayList.size()));
            ((PdfDictionary)object2).put(PdfName.KIDS, pdfArray);
            this.refsp = null;
            this.refsn = arrayList2;
        }
    }
}

