dnl File editing macros.
dnl This file is part of GNU Ad HoC.
dnl Copyright (C) 1998, 1999 Alexandre Oliva
dnl Copyright (C) 1999 Free Software Foundation, Inc.
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
dnl 02111-1307, USA.
dnl
dnl As a special exception, the Free Software Foundation gives unlimited
dnl permission to copy, distribute and modify the configure scripts that
dnl are the output of Ad HoC.  You need not follow the terms of the GNU
dnl General Public License when using or distributing such scripts, even
dnl though portions of the text of Ad HoC appear in them.  The GNU
dnl General Public License (GPL) does govern all other use of the material
dnl that constitutes the Ad HoC program.
dnl
dnl Certain portions of the Ad HoC source text are designed to be copied
dnl (in certain cases, depending on the input) into the output of
dnl Ad HoC.  We call these the "data" portions.  The rest of the Ad HoC
dnl source text consists of comments plus executable code that decides which
dnl of the data portions to output in any given case.  We call these
dnl comments and executable code the "non-data" portions.  Ad HoC never
dnl copies any of the non-data portions into its output.
dnl
dnl This special exception to the GPL applies to versions of Ad HoC
dnl released by the Free Software Foundation.  When you make and
dnl distribute a modified version of Ad HoC, you may extend this special
dnl exception to the GPL to apply to your modified version as well, *unless*
dnl your modified version has the potential to copy into its output some
dnl of the text that was the non-data portion of the version that you started
dnl with.  (In other words, unless your change moves or copies text from
dnl the non-data portions to the data portions.)  If your modification has
dnl such potential, you must delete any notice of this special exception
dnl to the GPL from your modified version.

AH_INCLUDE(file.m4)dnl for AH_IF_GREP_FILE

dnl AH_UPDATE_OR_APPEND(FROMFILE, TOFILE[, LOCALFILE, [INSERT_ACTION]])
dnl looks for the AH_BEGIN timestamp in TOFILE and checks whether it is
dnl up-to-date.  If it is not, the tags @AH_BEGIN@ and @AH_END@, that must
dnl exist in the first and in the last line of FROMFILE, are replaced with
dnl @AH_BEGIN:FROMFILE:`ls -l FROMFILE`@ and @AH_END:FROMFILE@, and the
dnl modified FROMFILE is saved in a file named LOCALFILE, or in a filename
dnl generated by the macro AH_TEMP_FILENAME.  
dnl In any case, $localfile will refer to the temporary file name.
dnl If the AH_BEGIN tag exists in TOFILE, but is out-of-date, the region
dnl between @AH_BEGIN:FROMFILE: and @AH_END:FROMFILE@ is replaced with the
dnl contents of the temporary file.  However, if the AH_BEGIN tag does not
dnl exist in TOFILE, FROMFILE will be appended, unless INSERT_ACTION is
dnl provided.  In the latter case, INSERT_ACTION is assumed to insert
dnl $localfile in TOFILE.
AH_DEFUN(AH_UPDATE_OR_APPEND, [dnl
fromfile=$1
tofile=$2
[timestamp="@AH_BEGIN:$fromfile:`ls -l "$fromfile"`"]
AH_IF_FGREP_FILE(["$timestamp"], ["$tofile"], :, [
    localfile=ifelse($#, 3, $3, $#, 4, $3, AH_TEMP_FILENAME)[
    rm -f "$localfile"
    sed < "$fromfile" > "$localfile" \
	-e 's@\@AH_BEGIN\@@\@AH_BEGIN:'"$fromfile:`ls -l "$fromfile"`"'\@@;' \
	-e 's@\@AH_END\@@\@AH_END:'"$fromfile"'\@@']
    AH_IF_FGREP_FILE(["@AH_BEGIN:$fromfile:"], ["$tofile"], [
	cp "$tofile" "$tofile".orig &&
        [quoted_filename=`echo "$fromfile" | sed 's%\([]\\[/.*+]\)%\\\\\1%g'`] &&
	sed -e "/@AH_BEGIN:$quoted_filename:/ r $localfile" \
	    -e "/@AH_BEGIN:$quoted_filename:/,/@AH_END:$quoted_filename@/ d" \
	  < "$tofile".orig > "$tofile"
    ], [ifelse($#, 4, [$4], [cat "$localfile" >> "$tofile"])])
    rm -f "$localfile"])])

dnl AH_REMOVE_UPDATE_OR_APPEND(FROMFILE, TOFILE)
dnl Undo the effecs of AH_UPDATE_OR_APPEND.
dnl Useful after renaming or removing a file.
AH_DEFUN([AH_REMOVE_UPDATE_OR_APPEND], [dnl
fromfile=$1
tofile=$2
AH_IF_FGREP_FILE(["@AH_BEGIN:$fromfile:"], ["$tofile"], [
  cp "$tofile" "$tofile".orig &&
  [quoted_filename=`echo "$fromfile" | sed 's%\([]\\[/.*+]\)%\\\\\1%g'`] &&
  sed -e "/@AH_BEGIN:$quoted_filename:/,/@AH_END:$quoted_filename@/ d" \
  < "$tofile".orig > "$tofile"
])])
