#! /bin/sh
# adhoc -- expand macros in Ad HoC scripts to produce shell-scripts
# based on GNU autoconf
# Copyright (C) 1992, 1993, 1994, 1996 Free Software Foundation, Inc.
# Copyright (C) 1998, 1999 Alexandre Oliva
# Copyright (C) 1999 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# If given no args, create `configure' from template file `configure.in'.
# With one arg, create a configure script on standard output from
# the given template file.

usage="\
Usage: adhoc [-h] [--help] [-m dir] [--macrodir=dir]
       [--version] < [AdHoC-script] > [shell-script]"

# NLS nuisances.
# Only set these to C if already set.  These must not be set unconditionally
# because not all systems understand e.g. LANG=C (notably SCO).
# Fixing LC_MESSAGES prevents Solaris sh from translating var values in `set'!
# Non-C LC_CTYPE values break the ctype check.
if test "${LANG+set}"   = set; then LANG=C;   export LANG;   fi
if test "${LC_ALL+set}" = set; then LC_ALL=C; export LC_ALL; fi
if test "${LC_MESSAGES+set}" = set; then LC_MESSAGES=C; export LC_MESSAGES; fi
if test "${LC_CTYPE+set}"    = set; then LC_CTYPE=C;    export LC_CTYPE;    fi

: ${prefix=@prefix@}
: ${datadir=@datadir@}
: ${AH_MACRODIR=@macrodir@}
: ${M4=@M4@}
case "${M4}" in
/*) # Handle the case that m4 has moved since we were configured.
    # It may have been found originally in a build directory.
    test -f "${M4}" || M4=m4 ;;
esac

show_version=no

while test $# -gt 0 ; do
   case "${1}" in
      -h | --help | --h* )
         echo "${usage}" 1>&2; exit 0 ;;
      --macrodir=* | --m*=* )
         AH_MACRODIR="`echo \"${1}\" | sed -e 's/^[^=]*=//'`"
         shift ;;
      -m | --macrodir | --m* )
         shift
         test $# -eq 0 && { echo "${usage}" 1>&2; exit 1; }
         AH_MACRODIR="${1}"
         shift ;;
      --version | --v* )
         show_version=yes; shift ;;
      -- )     # Stop option processing
        shift; break ;;
      - )	# Use stdin as input.
        break ;;
      -* )
        echo "${usage}" 1>&2; exit 1 ;;
      * )
        break ;;
   esac
done

if test $show_version = yes; then
  version=`sed -n 's/define.ADHOC_VERSION.[ 	]*\([0-9.]*\).*/\1/p' \
    $AH_MACRODIR/adhoc-version.m4`
  echo "GNU Ad HoC version $version"
  exit 0
fi

$M4 -I$AH_MACRODIR adhoc.m4$f -

exit $status
