/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class InflaterInputStream
extends FilterInputStream {
    private static final int DEFAULT = 512;
    protected Inflater inf;
    protected byte[] buf;
    protected int len;

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater(), 512);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 512);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream);
        this.inf = inflater;
        this.buf = new byte[n];
        this.len = 0;
    }

    protected void fill() throws IOException {
        this.len = super.read(this.buf, 0, this.buf.length);
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        return byArray[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.inf.finished()) {
            return -1;
        }
        if (this.inf.needsInput()) {
            this.fill();
            if (this.len == -1) {
                return -1;
            }
            this.inf.setInput(this.buf, 0, this.len);
        }
        try {
            return this.inf.inflate(byArray, n, n2);
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("bad data format");
        }
    }

    public long skip(long l) throws IOException {
        int n;
        long l2;
        for (l2 = 0L; l2 < l && (n = this.read()) != -1; ++l2) {
        }
        return l2;
    }
}

