/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.TableEntry;

public class StreamTokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    public int ttype;
    public String sval;
    public double nval;
    private PushbackReader pushIn;
    private LineNumberReader lineIn;
    private Reader rawIn;
    private TableEntry[] lookup = new TableEntry[257];
    private boolean pushBack = false;
    private boolean EOLSignificant;
    private boolean CComments;
    private boolean CPlusPlusComments;
    private boolean toLower;
    private StringBuffer buffer = new StringBuffer();

    public StreamTokenizer(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public StreamTokenizer(Reader reader) {
        this.rawIn = reader;
        this.lineIn = new LineNumberReader(this.rawIn);
        this.pushIn = new PushbackReader(this.lineIn);
        for (int i = 0; i < this.lookup.length; ++i) {
            this.lookup[i] = new TableEntry();
        }
        this.reset();
    }

    private int chrRead() throws IOException {
        int n = this.pushIn.read();
        if (n == -1) {
            n = 256;
        }
        return n;
    }

    public void commentChar(int n) {
        this.lookup[n].isComment = true;
    }

    public void eolIsSignificant(boolean bl) {
        this.EOLSignificant = bl;
    }

    public int lineno() {
        return this.lineIn.getLineNumber();
    }

    public void lowerCaseMode(boolean bl) {
        this.toLower = bl;
    }

    public int nextToken() throws IOException {
        if (this.pushBack) {
            this.pushBack = false;
            return this.ttype;
        }
        return this.nextTokenType();
    }

    private int nextTokenType() throws IOException {
        int n = this.chrRead();
        if (this.EOLSignificant && n == 10) {
            this.ttype = 10;
        } else if (n == 47 && (this.CComments || this.CPlusPlusComments)) {
            int n2 = this.chrRead();
            if (n2 == 47 && this.CPlusPlusComments) {
                this.skipLine();
                this.ttype = this.nextTokenType();
            } else if (n2 == 42 && this.CComments) {
                this.skipCComment();
                this.ttype = this.nextTokenType();
            } else {
                this.pushIn.unread(n2);
            }
        } else if (this.lookup[n].isWhitespace) {
            while (this.lookup[n].isWhitespace) {
                n = this.chrRead();
            }
            this.pushIn.unread(n);
            this.ttype = this.nextTokenType();
        } else if (this.lookup[n].isNumeric) {
            this.buffer.setLength(0);
            while (this.lookup[n].isNumeric) {
                this.buffer.append((char)(n & 0xFF));
                n = this.chrRead();
            }
            this.pushIn.unread(n);
            try {
                this.nval = new Double(this.buffer.toString());
                this.ttype = -2;
            }
            catch (NumberFormatException numberFormatException) {
                this.ttype = -3;
                this.sval = this.buffer.toString();
                if (this.toLower) {
                    this.sval = this.sval.toLowerCase();
                }
            }
        } else if (this.lookup[n].isAlphabetic) {
            this.buffer.setLength(0);
            while (this.lookup[n].isAlphabetic || this.lookup[n].isNumeric) {
                this.buffer.append((char)(n & 0xFF));
                n = this.chrRead();
            }
            this.pushIn.unread(n);
            this.ttype = -3;
            this.sval = this.buffer.toString();
            if (this.toLower) {
                this.sval = this.sval.toLowerCase();
            }
        } else if (this.lookup[n].isStringQuote) {
            int n3 = n;
            this.buffer.setLength(0);
            n = this.chrRead();
            while (n != n3) {
                if (n == 92) {
                    n = this.chrRead();
                    switch (n) {
                        case 97: {
                            n = 7;
                            break;
                        }
                        case 98: {
                            n = 8;
                            break;
                        }
                        case 102: {
                            n = 12;
                            break;
                        }
                        case 110: {
                            n = 10;
                            break;
                        }
                        case 114: {
                            n = 13;
                            break;
                        }
                        case 116: {
                            n = 9;
                            break;
                        }
                        case 118: {
                            n = 11;
                        }
                    }
                }
                this.buffer.append((char)(n & 0xFF));
                n = this.chrRead();
                if (n != 256) continue;
                break;
            }
            this.ttype = n;
            this.sval = this.buffer.toString();
        } else if (this.lookup[n].isComment) {
            this.skipLine();
            this.ttype = this.nextTokenType();
        } else {
            this.sval = null;
            this.ttype = n == 256 ? -1 : n & 0xFF;
        }
        return this.ttype;
    }

    public void ordinaryChar(int n) {
        this.lookup[n].isAlphabetic = false;
        this.lookup[n].isStringQuote = false;
        this.lookup[n].isNumeric = false;
        this.lookup[n].isComment = false;
        this.lookup[n].isWhitespace = false;
    }

    public void ordinaryChars(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.ordinaryChar(i);
        }
    }

    public void parseNumbers() {
        for (int i = 48; i <= 57; ++i) {
            this.lookup[i].isNumeric = true;
        }
        this.lookup[46].isNumeric = true;
        this.lookup[45].isNumeric = true;
    }

    public void pushBack() {
        this.pushBack = true;
    }

    public void quoteChar(int n) {
        this.lookup[n].isStringQuote = true;
    }

    public void reset() {
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.ordinaryChar(256);
        this.parseNumbers();
        this.commentChar(47);
        this.quoteChar(39);
        this.quoteChar(34);
        this.EOLSignificant = false;
        this.CComments = false;
        this.CPlusPlusComments = false;
        this.toLower = false;
    }

    public void resetSyntax() {
        this.ordinaryChars(0, 255);
    }

    private void skipCComment() throws IOException {
        boolean bl = false;
        while (!bl) {
            int n = this.chrRead();
            if (n == 42) {
                int n2 = this.chrRead();
                if (n2 == 47) {
                    bl = true;
                    continue;
                }
                this.pushIn.unread(n2);
                continue;
            }
            if (n != 256) continue;
            bl = true;
        }
    }

    private void skipLine() throws IOException {
        int n;
        while ((n = this.chrRead()) != 10) {
        }
    }

    public void slashSlashComments(boolean bl) {
        this.CPlusPlusComments = bl;
    }

    public void slashStarComments(boolean bl) {
        this.CComments = bl;
    }

    public String toString() {
        if (this.ttype == -1) {
            return "EOF";
        }
        if (this.ttype == 10) {
            return "EOL";
        }
        if (this.ttype == -2) {
            return String.valueOf(String.valueOf(String.valueOf("Token[n=").concat(String.valueOf(this.nval))).concat(String.valueOf("], line "))).concat(String.valueOf(this.lineno()));
        }
        return String.valueOf(String.valueOf(String.valueOf("Token[s=").concat(String.valueOf(this.sval))).concat(String.valueOf("], line "))).concat(String.valueOf(this.lineno()));
    }

    public void whitespaceChars(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.lookup[i].isWhitespace = true;
        }
    }

    public void wordChars(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.lookup[i].isAlphabetic = true;
        }
    }
}

