/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import kaffe.io.CharToByteConverter;

public class OutputStreamWriter
extends Writer {
    private static final int BUFDEFAULT = 1024;
    private OutputStream strm;
    private CharToByteConverter encoding;
    private byte[] outbuf = new byte[1024];

    public OutputStreamWriter(OutputStream outputStream) {
        this.strm = outputStream;
        this.encoding = CharToByteConverter.getDefault();
    }

    public OutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.strm = outputStream;
        this.encoding = CharToByteConverter.getConverter(string);
    }

    public void close() throws IOException {
        this.flush();
        this.strm.close();
    }

    public void flush() throws IOException {
        this.strm.flush();
    }

    public String getEncoding() {
        return this.encoding.toString();
    }

    public void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                while (n2 > 0) {
                    int n3 = this.encoding.convert(cArray, n, n2, this.outbuf, 0, this.outbuf.length);
                    this.strm.write(this.outbuf, 0, n3);
                    n += n3;
                    n2 -= n3;
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }
}

