/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HotKeyHandler;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.RepaintEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.awt.event.TextEvent;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.util.EventListener;
import java.util.Locale;
import java.util.Vector;

public abstract class Component
implements ImageObserver {
    Container parent;
    int x;
    int y;
    int width;
    int height;
    Color fgClr;
    Color bgClr;
    Font font;
    Cursor cursor = Cursor.defaultCursor;
    ComponentListener cmpListener;
    KeyListener keyListener;
    FocusListener focusListener;
    MouseListener mouseListener;
    MouseMotionListener motionListener;
    String name;
    Vector popups;
    int eventMask;
    boolean isVisible = true;
    Dimension dim;
    Rectangle bounds;
    ComponentPeer peer;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    static final int BORDER_WIDTH = 2;

    protected Component() {
    }

    public void add(PopupMenu popupMenu) {
        if (this.popups == null) {
            this.popups = new Vector(2);
        }
        this.popups.addElement(popupMenu);
    }

    public void addComponentListener(ComponentListener componentListener) {
        this.cmpListener = AWTEventMulticaster.add(this.cmpListener, componentListener);
        this.eventMask |= 1;
    }

    public void addFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
        this.eventMask |= 4;
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        this.eventMask |= 8;
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.eventMask |= 0x10;
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.motionListener = AWTEventMulticaster.add(this.motionListener, mouseMotionListener);
        this.eventMask |= 0x20;
    }

    public void addNotify() {
        this.peer = this.createPeer();
    }

    public Rectangle bounds() {
        return this.getBounds();
    }

    public int checkImage(Image image, ImageObserver imageObserver) {
        return Image.checkImage(image, -1, -1, imageObserver, false);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return Image.checkImage(image, n, n2, imageObserver, false);
    }

    public boolean inside(int n, int n2) {
        return this.contains(n, n2);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        if (!this.isVisible) {
            return false;
        }
        if (n < 0 || n2 < 0 || n > this.width || n2 > this.height) {
            return false;
        }
        n += this.x;
        n2 += this.y;
        Container container = this.parent;
        while (container != null) {
            if (!container.isVisible) {
                return false;
            }
            if (n < 0 || n2 < 0 || n > container.width || n2 > container.height) {
                return false;
            }
            n += container.x;
            n2 += container.y;
            container = container.parent;
        }
        return true;
    }

    public Image createImage(ImageProducer imageProducer) {
        return new Image(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return new Image(n, n2);
    }

    ComponentPeer createPeer() {
        return Toolkit.singleton.createLightweight(this);
    }

    public void disableEvents(long l) {
        this.eventMask = (int)((long)this.eventMask & (l ^ 0L - 1L));
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        this.processEvent(aWTEvent);
    }

    public void doLayout() {
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void enable(boolean bl) {
        this.setEnabled(bl);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void enableEvents(long l) {
        this.eventMask = (int)((long)this.eventMask | l);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public Color getBackground() {
        if (this.bgClr != null) {
            return this.bgClr;
        }
        Container container = this.parent;
        while (container != null) {
            if (container.bgClr != null) {
                return container.bgClr;
            }
            container = container.parent;
        }
        return Color.white;
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = new Rectangle(this.x, this.y, this.width, this.height);
        } else {
            this.bounds.x = this.x;
            this.bounds.y = this.y;
            this.bounds.width = this.width;
            this.bounds.height = this.height;
        }
        return this.bounds;
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public Component getComponentAt(int n, int n2) {
        return this.contains(n, n2) ? this : null;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        Container container = this.parent;
        while (container != null) {
            if (container.font != null) {
                return container.font;
            }
            container = container.parent;
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        return FontMetrics.getFontMetrics(font);
    }

    public Color getForeground() {
        if (this.fgClr != null) {
            return this.fgClr;
        }
        Container container = this.parent;
        while (container != null) {
            if (container.fgClr != null) {
                return container.fgClr;
            }
            container = container.parent;
        }
        return Color.black;
    }

    public Graphics getGraphics() {
        return Graphics.getClippedGraphics(this, 0, 0, this.width, this.height, false);
    }

    public Locale getLocale() {
        return null;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Point getLocationOnScreen() {
        int n = 0;
        int n2 = 0;
        Component component = this;
        while (component != null) {
            n += component.x;
            n2 += component.y;
            component = component.parent;
        }
        return new Point(n, n2);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getName() {
        return this.name == null ? this.getClass().getName() : this.name;
    }

    public Container getParent() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public Dimension getPreferredSize() {
        return new Dimension(50, 50);
    }

    public Dimension getSize() {
        if (this.dim == null) {
            this.dim = new Dimension(this.width, this.height);
        } else {
            this.dim.width = this.width;
            this.dim.height = this.height;
        }
        return this.dim;
    }

    public Toolkit getToolkit() {
        return Toolkit.singleton;
    }

    Component getToplevel() {
        Component component = this;
        while (!(component instanceof Window) && component != null) {
            component = component.parent;
        }
        return component;
    }

    boolean hasToNotify(int n, EventListener eventListener) {
        return (this.eventMask & n) != 0 && eventListener != null;
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) > 0) {
            this.repaint();
        }
        return (n & 0xA0) == 0;
    }

    boolean intersects(Component component) {
        return this.intersects(component.x, component.y, component.width, component.height);
    }

    boolean intersects(Rectangle rectangle) {
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    boolean intersects(int n, int n2, int n3, int n4) {
        return this.x <= n + n3 && this.y <= n2 + n4 && n <= this.x + this.width && n2 <= this.y + this.height;
    }

    public void invalidate() {
    }

    public boolean isEnabled() {
        return (this.eventMask & Integer.MIN_VALUE) == 0;
    }

    public boolean isFocusTraversable() {
        return this.isShowing() && this.isEnabled();
    }

    public boolean isShowing() {
        Component component = this;
        while (component != null) {
            if (!component.isVisible) {
                return false;
            }
            component = component.parent;
        }
        return this.parent != null;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void move(int n, int n2) {
        this.setLocation(n, n2);
    }

    public void paint(Graphics graphics) {
    }

    public void paintAll(Graphics graphics) {
        this.paint(graphics);
    }

    void paintBorder() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintBorder(graphics);
            graphics.dispose();
        }
    }

    void paintBorder(Graphics graphics) {
        this.paintBorder(graphics, 0, 0, 0, 0);
    }

    void paintBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.width - (n + n3);
        int n6 = this.height - (n2 + n4);
        if (this == AWTEvent.keyTgt) {
            graphics.setColor(Defaults.FocusClr);
        } else {
            graphics.setColor(Defaults.BorderClr);
        }
        graphics.draw3DRect(n, n2, n5 - 1, n6 - 1, true);
        graphics.draw3DRect(n + 1, n2 + 1, n5 - 3, n6 - 3, false);
    }

    protected String paramString() {
        String string = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("").concat(String.valueOf(this.name))).concat(String.valueOf(','))).concat(String.valueOf(' '))).concat(String.valueOf(this.x))).concat(String.valueOf(','))).concat(String.valueOf(this.y))).concat(String.valueOf(','))).concat(String.valueOf(this.width))).concat(String.valueOf(','))).concat(String.valueOf(this.height));
        if (!this.isVisible()) {
            string = String.valueOf(string).concat(String.valueOf(", hidden"));
        }
        if (!this.isEnabled()) {
            string = String.valueOf(string).concat(String.valueOf(", disabled"));
        }
        return string;
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public boolean prepareImage(Image image, ImageObserver imageObserver) {
        return Image.checkImage(image, -1, -1, imageObserver, true) > 0;
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return Image.checkImage(image, n, n2, imageObserver, true) > 0;
    }

    public void print(Graphics graphics) {
    }

    public void printAll(Graphics graphics) {
    }

    protected void processActionEvent(ActionEvent actionEvent) {
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (this.hasToNotify(1, this.cmpListener)) {
            switch (componentEvent.getID()) {
                case 101: {
                    this.cmpListener.componentResized(componentEvent);
                    break;
                }
                case 100: {
                    this.cmpListener.componentMoved(componentEvent);
                    break;
                }
                case 102: {
                    this.cmpListener.componentShown(componentEvent);
                    break;
                }
                case 103: {
                    this.cmpListener.componentHidden(componentEvent);
                }
            }
        }
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            switch (aWTEvent.getID()) {
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)aWTEvent);
                    break;
                }
                default: {
                    this.processMouseEvent((MouseEvent)aWTEvent);
                    break;
                }
            }
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof PaintEvent) {
            this.processPaintEvent((PaintEvent)aWTEvent);
        } else if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent);
        } else if (aWTEvent instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)aWTEvent);
        } else if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
        } else if (aWTEvent instanceof WindowEvent) {
            this.processWindowEvent((WindowEvent)aWTEvent);
        } else if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
        } else if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.hasToNotify(4, this.focusListener)) {
            switch (focusEvent.getID()) {
                case 1004: {
                    this.focusListener.focusGained(focusEvent);
                    break;
                }
                case 1005: {
                    this.focusListener.focusLost(focusEvent);
                }
            }
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.hasToNotify(8, this.keyListener)) {
            switch (keyEvent.getID()) {
                case 400: {
                    this.keyListener.keyTyped(keyEvent);
                    break;
                }
                case 401: {
                    this.keyListener.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    this.keyListener.keyReleased(keyEvent);
                }
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.hasToNotify(16, this.mouseListener)) {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this.mouseListener.mouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    this.mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                case 505: {
                    this.mouseListener.mouseExited(mouseEvent);
                    break;
                }
                case 504: {
                    this.mouseListener.mouseEntered(mouseEvent);
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.hasToNotify(32, this.motionListener)) {
            switch (mouseEvent.getID()) {
                case 503: {
                    this.motionListener.mouseMoved(mouseEvent);
                    return;
                }
                case 506: {
                    this.motionListener.mouseDragged(mouseEvent);
                    return;
                }
            }
        }
    }

    void processPaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        Graphics graphics = Graphics.getClippedGraphics(this, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.parent == null);
        if (graphics != null) {
            this.paint(graphics);
            graphics.dispose();
        }
    }

    protected void processTextEvent(TextEvent textEvent) {
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
    }

    public void removeComponentListener(ComponentListener componentListener) {
        this.cmpListener = AWTEventMulticaster.remove(this.cmpListener, componentListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.motionListener = AWTEventMulticaster.remove(this.motionListener, mouseMotionListener);
    }

    public void removeNotify() {
        HotKeyHandler.removeHotKeys(this);
        this.peer = null;
    }

    public void repaint() {
        this.repaint(0, 0, this.width, this.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        Graphics graphics = Graphics.getClippedGraphics(this, n, n2, n3, n4, false);
        if (graphics != null) {
            this.update(graphics);
            graphics.dispose();
        }
    }

    public void repaint(long l) {
        Toolkit.eventQueue.postEvent(new RepaintEvent(this, l, this.x, this.y, this.width, this.height));
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        Toolkit.eventQueue.postEvent(new RepaintEvent(this, l, n, n2, n3, n4));
    }

    public void requestFocus() {
        Component component = null;
        if (AWTEvent.keyTgt == this) {
            return;
        }
        Component component2 = this.getToplevel();
        if (component2 == null) {
            AWTEvent.keyTgtRequest = this;
        } else {
            if (AWTEvent.keyTgt != null) {
                component = AWTEvent.keyTgt.getToplevel();
            }
            if (component2 != component) {
                AWTEvent.keyTgtRequest = this;
                component2.requestFocus();
            } else {
                AWTEvent.sendFocusEvent(this, true, false);
            }
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public void resize(Dimension dimension) {
        this.setSize(dimension);
    }

    public void resize(int n, int n2) {
        this.setSize(n, n2);
    }

    public void setBackground(Color color) {
        this.bgClr = color;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = this.isShowing();
        boolean bl3 = this.parent != null;
        boolean bl4 = this.width != n3 || this.height != n4;
        boolean bl5 = bl = !bl4 && (this.x != n || this.y != n2);
        if (bl3) {
            if (this.parent.isLayouting) {
                bl2 = false;
            }
            if (bl2) {
                n5 = n < this.x ? n : this.x;
                n7 = n2 < this.y ? n2 : this.y;
                int n9 = n + n3;
                int n10 = this.x + this.width;
                n6 = n9 > n10 ? n9 : n10;
                n9 = n2 + n4;
                n10 = this.y + this.height;
                n8 = n9 > n10 ? n9 : n10;
            }
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.dim = null;
        this.doLayout();
        if (bl2) {
            if (bl3) {
                this.parent.repaint(n5, n7, n6 - n5, n8 - n7);
            } else {
                this.repaint();
            }
        }
        if ((bl4 || bl) && (this.eventMask & 1) != 0 && this.cmpListener != null) {
            int n11 = bl4 ? 101 : 100;
            Toolkit.eventQueue.postEvent(AWTEvent.getComponentEvent(this, n11));
        }
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        Component component = this;
        while (component.parent != null) {
            component = component.parent;
        }
        component.setNativeCursor(this.cursor);
    }

    public void setEnabled(boolean bl) {
        this.eventMask = bl ? (this.eventMask &= Integer.MAX_VALUE) : (this.eventMask |= Integer.MIN_VALUE);
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setForeground(Color color) {
        this.fgClr = color;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setLocation(Point point) {
        this.setBounds(point.x, point.y, this.width, this.height);
    }

    public void setLocation(int n, int n2) {
        this.setBounds(n, n2, this.width, this.height);
    }

    public void setName(String string) {
        this.name = string;
    }

    void setNativeCursor(Cursor cursor) {
    }

    public void setSize(Dimension dimension) {
        this.setBounds(this.x, this.y, dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.setBounds(this.x, this.y, n, n2);
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible) {
            this.isVisible = bl;
            if (this.parent != null && this.parent.isShowing() && !this.parent.isLayouting) {
                this.parent.repaint(this.x, this.y, this.width, this.height);
            }
            if ((this.eventMask & 1) != 0 && this.cmpListener != null) {
                int n = bl ? 102 : 103;
                Toolkit.eventQueue.postEvent(new ComponentEvent(this, n));
            }
        }
    }

    public void show() {
        this.setVisible(true);
    }

    public Dimension size() {
        return this.getSize();
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf('['))).concat(String.valueOf(this.paramString()))).concat(String.valueOf(']'));
    }

    PopupMenu triggerPopup(int n, int n2, int n3) {
        if (this.popups != null && this.popups.size() > n) {
            PopupMenu popupMenu = (PopupMenu)this.popups.elementAt(n);
            popupMenu.show(this, n2, n3);
            return popupMenu;
        }
        return null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void validate() {
    }
}

