/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Checkbox
extends Component
implements ItemSelectable,
MouseListener,
FocusListener,
KeyListener {
    CheckboxGroup group;
    boolean state;
    String label;
    ItemListener iListener;
    boolean hilight;

    public Checkbox() {
        this("", false, null);
    }

    public Checkbox(String string) {
        this(string, false, null);
    }

    public Checkbox(String string, CheckboxGroup checkboxGroup, boolean bl) {
        this(string, bl, checkboxGroup);
    }

    public Checkbox(String string, boolean bl) {
        this(string, bl, null);
    }

    public Checkbox(String string, boolean bl, CheckboxGroup checkboxGroup) {
        this.label = string;
        this.setCheckboxGroup(checkboxGroup);
        this.setState(bl);
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.setFont(Defaults.TextFont);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.add(this.iListener, itemListener);
        this.eventMask |= 0x200;
    }

    void drawButton(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.hilight ? Defaults.BtnPointClr : Defaults.BtnClr);
        graphics.fill3DRect(n2, n3, n, n, true);
        if (this.label.endsWith(" ")) {
            this.paintBorder(graphics);
        } else {
            int n4 = 2;
            this.paintBorder(graphics, n2 - n4, n3 - n4, this.width - (n2 + n + n4), this.height - (n3 + n + n4));
        }
    }

    void drawCheckMark(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(Color.black);
        graphics.drawLine(n2 + 3, n3 + 4, n2 + n - 5, n3 + n - 4);
        graphics.drawLine(n2 + 2, n3 + n - 4, n2 + n - 5, n3 + 3);
        graphics.setColor(Color.white);
        graphics.drawLine(n2 + 3, n3 + 3, n2 + n - 4, n3 + n - 4);
        graphics.drawLine(n2 + 3, n3 + n - 4, n2 + n - 4, n3 + 3);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hilight = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hilight = false;
        this.repaint();
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    public String getLabel() {
        return this.label;
    }

    public Dimension getPreferredSize() {
        int n = 50;
        int n2 = 20;
        if (this.font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            n = Math.max(n, fontMetrics.stringWidth(this.label) + 2 * fontMetrics.getHeight());
            n2 = Math.max(n2, 3 * fontMetrics.getHeight() / 2);
        }
        return new Dimension(n, n2);
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = this.state ? new Object[]{this} : new Object[]{};
        return objectArray;
    }

    public boolean getState() {
        return this.state;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '\n': 
            case ' ': {
                if (this.state && this.group != null) {
                    return;
                }
                this.setState(!this.state);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.hilight = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.hilight = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        if (this.state && this.group != null) {
            return;
        }
        this.setState(!this.state);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void notifyItem() {
        if (this.hasToNotify(512, this.iListener)) {
            ItemEvent itemEvent = AWTEvent.getItemEvent(this, 0);
            ((AWTEvent)itemEvent).setItemEvent(this.label, this.state ? 1 : 2);
            Toolkit.eventQueue.postEvent(itemEvent);
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        int n3 = n2 = fontMetrics.getHeight();
        int n4 = fontMetrics.getDescent();
        int n5 = n = fontMetrics.charWidth('x');
        int n6 = (this.height - n3) / 2;
        graphics.setColor(this.bgClr);
        graphics.fillRect(0, 0, this.width, this.height);
        this.drawButton(graphics, n3, n5, n6);
        if (this.state) {
            this.drawCheckMark(graphics, n3, n5, n6);
        }
        Color color = this.hilight ? Defaults.FocusClr : this.getForeground();
        Color color2 = Color.white;
        graphics.setColor(color2);
        graphics.drawString(this.label, (n5 += n3 + n) + 1, (n6 += n3 / 2 + n2 / 2 - n4) + 1);
        graphics.setColor(color);
        graphics.drawString(this.label, n5, n6);
    }

    protected String paramString() {
        return super.paramString();
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        this.iListener.itemStateChanged(itemEvent);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.iListener = AWTEventMulticaster.remove(this.iListener, itemListener);
    }

    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        if (this.group == checkboxGroup) {
            return;
        }
        if (this.group != null) {
            this.group.boxes.removeElement(this);
        }
        this.group = checkboxGroup;
        if (this.group != null) {
            this.group.boxes.addElement(this);
        }
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setState(boolean bl) {
        if (this.state == bl) {
            return;
        }
        if (bl && this.group != null) {
            this.group.setSelectedCheckbox(this);
        } else {
            this.state = bl;
            if (this.isShowing()) {
                this.repaint();
            }
            this.notifyItem();
        }
    }
}

