/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class GZIPInputStream
extends InflaterInputStream {
    public static final int GZIP_MAGIC = 35615;
    protected CRC32 crc;
    protected boolean eos;
    private InputStream strm;

    public GZIPInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 512);
    }

    public GZIPInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream, new Inflater(true), n);
        this.strm = inputStream;
        this.crc = new CRC32();
        this.eos = false;
        this.checkByte(31);
        this.checkByte(139);
        this.checkByte(8);
        int n2 = this.strm.read();
        if ((n2 & 4) != 0) {
            int n3 = this.strm.read();
            this.ignoreBytes(n3 |= this.strm.read() << 8);
        }
        if ((n2 & 8) != 0) {
            this.ignoreString();
        }
        if ((n2 & 0x10) != 0) {
            this.ignoreString();
        }
        if ((n2 & 2) != 0) {
            this.ignoreBytes(2);
        }
        this.ignoreBytes(6);
    }

    private void checkByte(int n) throws IOException {
        if (this.strm.read() != n) {
            throw new IOException("bad GZIP stream");
        }
    }

    private void ignoreBytes(int n) throws IOException {
        while (n > 0) {
            this.strm.read();
            --n;
        }
    }

    private void ignoreString() throws IOException {
        while (this.strm.read() != 0) {
        }
    }

    public void close() throws IOException {
        super.close();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.crc.update(byArray, n, n3);
        } else if (n3 == -1 && !this.eos) {
            this.eos = true;
            this.ignoreBytes(8);
        }
        return n3;
    }
}

