/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.PropertyEnumeration;
import java.util.Vector;

public class Properties
extends Hashtable {
    protected Properties defaults;

    public Properties() {
        this(null);
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }

    private String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block5;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block5;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getProperty(String string) {
        Object object = this.get(string);
        if (object == null) {
            if (this.defaults != null) {
                return this.defaults.getProperty(string);
            }
            return null;
        }
        return (String)object;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public void list(PrintStream printStream) {
        this.list(new PrintWriter(printStream));
    }

    public void list(PrintWriter printWriter) {
        this.save(printWriter, "Properties list");
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        String string;
        while ((string = this.readLine(inputStream)) != null) {
            int n = string.length();
            if (n == 0 || string.charAt(0) == '#') continue;
            int n2 = string.indexOf(61);
            if (n2 > 0) {
                String string2 = string.substring(0, n2);
                ++n2;
                while (n2 < n && Character.isSpace(string.charAt(n2))) {
                    ++n2;
                }
                String string3 = string.substring(n2);
                this.put(string2, string3);
                continue;
            }
            System.err.println(String.valueOf("malformed property: ").concat(String.valueOf(string)));
        }
    }

    public Enumeration propertyNames() {
        Vector vector = new Vector();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        if (this.defaults != null) {
            Enumeration enumeration2 = this.defaults.keys();
            while (enumeration2.hasMoreElements()) {
                Object object = enumeration2.nextElement();
                if (vector.contains(object)) continue;
                vector.addElement(object);
            }
        }
        return new PropertyEnumeration(vector);
    }

    private String readLine(InputStream inputStream) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl2) {
            int n = inputStream.read();
            block0 : switch (n) {
                case 10: 
                case 13: {
                    bl2 = true;
                    break;
                }
                case 92: {
                    n = inputStream.read();
                    switch (n) {
                        case 110: {
                            stringBuffer.append('\n');
                            break block0;
                        }
                        case 114: {
                            stringBuffer.append('\r');
                            break block0;
                        }
                        case 92: {
                            stringBuffer.append('\\');
                            break block0;
                        }
                        case 10: 
                        case 13: {
                            break block0;
                        }
                    }
                    stringBuffer.append('\\');
                    stringBuffer.append(n);
                    break;
                }
                case -1: {
                    bl2 = true;
                    bl = true;
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        if (stringBuffer.length() == 0 && bl) {
            return null;
        }
        return stringBuffer.toString().trim();
    }

    public synchronized void save(OutputStream outputStream, String string) {
        this.save(new PrintWriter(outputStream), string);
    }

    private synchronized void save(Writer writer, String string) {
        try {
            writer.write("# ");
            writer.write(this.escape(string));
            writer.write("\n");
            Enumeration enumeration = this.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                writer.write(this.escape(string2));
                writer.write("=");
                writer.write(this.escape(this.getProperty(string2)));
                writer.write("\n");
            }
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf("Unable to save properties: ").concat(String.valueOf(string)));
        }
    }
}

