/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number {
    private int value;
    public static final Class TYPE = Class.getPrimitiveClass("int");
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    private static final long serialVersionUID = 1360826667806852920L;

    public Integer(String string) throws NumberFormatException {
        this(Integer.parseInt(string));
    }

    public Integer(int n) {
        this.value = n;
    }

    public static Integer decode(String string) throws NumberFormatException {
        int n = 1;
        if (string.startsWith("-")) {
            n = -1;
            string = string.substring(1);
        }
        int n2 = 10;
        if (string.startsWith("0x")) {
            n2 = 16;
            string = string.substring(2);
        } else if (string.startsWith("#")) {
            n2 = 16;
            string = string.substring(1);
        } else if (string.startsWith("0")) {
            n2 = 8;
            string = string.substring(1);
        }
        if (string.startsWith("-")) {
            throw new NumberFormatException();
        }
        return new Integer(n * Integer.parseInt(string, n2));
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Integer) {
            return this.intValue() == ((Integer)object).intValue();
        }
        return false;
    }

    public float floatValue() {
        return this.value;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, Integer n) {
        String string2 = n == null ? null : n.toString();
        String string3 = System.getProperty(string, string2);
        if (string3 == null) {
            return n;
        }
        try {
            return Integer.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static Integer getInteger(String string, int n) {
        return Integer.getInteger(string, new Integer(n));
    }

    public int hashCode() {
        return this;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        if (string.length() <= 0) {
            throw new NumberFormatException();
        }
        if (string.charAt(0) == '-') {
            return Integer.parseInt(string.substring(1), n) * -1;
        }
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n3 = Character.digit(string.charAt(i), n);
            if (n3 == -1) {
                throw new NumberFormatException();
            }
            n2 = n2 * n + n3;
        }
        return n2;
    }

    private static String toUnsignedString(int n, int n2) {
        if (n == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 1 << n2;
        int n4 = n3 - 1;
        while (n != 0) {
            char c = Character.forDigit(n & n4, n3);
            n >>>= n2;
            stringBuffer.append(c);
        }
        stringBuffer.reverse();
        return stringBuffer.toString();
    }

    public static String toBinaryString(int n) {
        return Integer.toUnsignedString(n, 1);
    }

    public static String toHexString(int n) {
        return Integer.toUnsignedString(n, 4);
    }

    public static String toOctalString(int n) {
        return Integer.toUnsignedString(n, 3);
    }

    public String toString() {
        return Integer.toString(this);
    }

    public static String toString(int n) {
        return Integer.toString(n, 10);
    }

    public static String toString(int n, int n2) {
        if (n == 0) {
            return "0";
        }
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 1;
        if (n < 0) {
            n3 = -1;
        }
        while (n != 0) {
            char c = Character.forDigit(Math.abs(n % n2), n2);
            n /= n2;
            stringBuffer.append(c);
        }
        if (n3 == -1) {
            stringBuffer.append('-');
        }
        stringBuffer.reverse();
        return stringBuffer.toString();
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        return Integer.valueOf(string, 10);
    }

    public static Integer valueOf(String string, int n) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, n));
    }
}

