/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;

public class IndexColorModel
extends ColorModel {
    public int[] rgbs;
    public int trans = -1;

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this(n, n2, byArray, byArray2, byArray3, null);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(n);
        this.rgbs = new int[n2];
        if (byArray4 == null) {
            for (int i = 0; i < n2; ++i) {
                this.rgbs[i] = 0xFF000000 | (byArray[i] & 0xFF) << 16 | (byArray2[i] & 0xFF) << 8 | byArray3[i] & 0xFF;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                this.rgbs[i] = (byArray4[i] & 0xFF) << 24 | (byArray[i] & 0xFF) << 16 | (byArray2[i] & 0xFF) << 8 | byArray3[i] & 0xFF;
            }
        }
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        this(n, n2, byArray, byArray2, byArray3, null);
        this.trans = n3;
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl) {
        this(n, n2, byArray, n3, bl, -1);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl, int n4) {
        super(n);
        int n5 = bl ? 4 : 3;
        int n6 = (n2 - n3) / n5;
        this.trans = n4;
        this.rgbs = new int[n6];
        if (bl) {
            int n7 = 0;
            for (int i = 0; i < n6; ++i) {
                this.rgbs[i] = (byArray[n7++] & 0xFF) << 24 | (byArray[n7++] & 0xFF) << 16 | (byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF;
            }
        } else {
            int n8 = 0;
            for (int i = 0; i < n6; ++i) {
                this.rgbs[i] = 0xFF000000 | (byArray[n8++] & 0xFF) << 16 | (byArray[n8++] & 0xFF) << 8 | byArray[n8++] & 0xFF;
            }
        }
    }

    IndexColorModel(int n, int[] nArray, int n2) {
        super(n);
        this.rgbs = nArray;
        this.trans = n2;
    }

    public final int getAlpha(int n) {
        return this.rgbs[n] >> 24 & 0xFF;
    }

    public final void getAlphas(byte[] byArray) {
        for (int i = 0; i < this.rgbs.length; ++i) {
            byArray[i] = (byte)(this.rgbs[i] >> 24);
        }
    }

    public final int getBlue(int n) {
        return this.rgbs[n] & 0xFF;
    }

    public final void getBlues(byte[] byArray) {
        for (int i = 0; i < this.rgbs.length; ++i) {
            byArray[i] = (byte)this.rgbs[i];
        }
    }

    public final int getGreen(int n) {
        return this.rgbs[n] >> 8 & 0xFF;
    }

    public final void getGreens(byte[] byArray) {
        for (int i = 0; i < this.rgbs.length; ++i) {
            byArray[i] = (byte)(this.rgbs[i] >> 8);
        }
    }

    public final int getMapSize() {
        return this.rgbs.length;
    }

    public final int getRGB(int n) {
        return this.rgbs[n];
    }

    public final void getRGBs(int[] nArray) {
        for (int i = 0; i < this.rgbs.length; ++i) {
            nArray[i] = this.rgbs[i];
        }
    }

    public final int getRed(int n) {
        return this.rgbs[n] >> 16 & 0xFF;
    }

    public final void getReds(byte[] byArray) {
        for (int i = 0; i < this.rgbs.length; ++i) {
            byArray[i] = (byte)(this.rgbs[i] >> 16);
        }
    }

    public final int getTransparentPixel() {
        return this.trans;
    }
}

