/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class ScrollPane
extends Container
implements AdjustmentListener,
FocusListener {
    int policy;
    Adjustable hScroll;
    Adjustable vScroll;
    Point pos;
    Component child;
    ChildWrapper wrapper;
    static final int SCROLLBARS_AS_NEEDED = 0;
    static final int SCROLLBARS_ALWAYS = 1;
    static final int SCROLLBARS_NEVER = 2;

    public ScrollPane() {
        this(0);
    }

    public ScrollPane(int n) {
        int n2 = 2;
        this.layout = null;
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("illegal ScrollPane policy");
        }
        this.policy = n;
        this.pos = new Point();
        this.hScroll = new Adjustable(0);
        this.vScroll = new Adjustable(1);
        this.add(this.hScroll);
        this.add(this.vScroll);
        this.hScroll.addAdjustmentListener(this);
        this.vScroll.addAdjustmentListener(this);
        this.insets = new Insets(n2, n2, n2, n2);
        if (n == 1) {
            this.insets.right += Scrollbar.SCROLLBAR_WIDTH;
            this.insets.bottom += Scrollbar.SCROLLBAR_WIDTH;
        } else {
            this.hScroll.isVisible = false;
            this.vScroll.isVisible = false;
        }
    }

    protected final void addImpl(Component component, Object object, int n) {
        if (component != this.hScroll && component != this.vScroll) {
            if (this.child != null) {
                this.remove(this.child);
            }
            this.child = component;
            this.wrapper = new ChildWrapper();
            this.wrapper.add(component);
            super.addImpl(this.wrapper, object, n);
            component.addFocusListener(this);
        } else {
            super.addImpl(component, object, n);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n;
        if (this.child == null) {
            return;
        }
        Object object = adjustmentEvent.getSource();
        int n2 = adjustmentEvent.getValue();
        int n3 = this.width - (this.insets.left + this.insets.right);
        int n4 = this.height - (this.insets.top + this.insets.bottom);
        Graphics graphics = Graphics.getClippedGraphics(this, this.insets.left, this.insets.top, n3, n4, false);
        if (object == this.vScroll) {
            n = n2 - this.pos.y;
            this.pos.y = n2;
        } else {
            n = n2 - this.pos.x;
            this.pos.x = n2;
        }
        this.child.isVisible = false;
        this.child.setLocation(this.insets.left - this.pos.x, this.insets.top - this.pos.y);
        this.child.isVisible = true;
        if (graphics != null) {
            if (object == this.vScroll) {
                if (n > 0) {
                    graphics.copyArea(this.insets.left, this.insets.top + n, n3, n4 - n, 0, -n);
                    graphics.setClip(this.insets.left, this.insets.top + n4 - n, n3, n);
                } else {
                    graphics.copyArea(this.insets.left, this.insets.top, n3, n4 + n, 0, -n);
                    graphics.setClip(this.insets.left, this.insets.top, n3, -n);
                }
            } else if (n > 0) {
                graphics.copyArea(this.insets.left + n, this.insets.top, n3 - n, n4, -n, 0);
                graphics.setClip(this.insets.left + n3 - n, this.insets.top, n, n4);
            } else {
                graphics.copyArea(this.insets.left, this.insets.top, n3 + n, n4, -n, 0);
                graphics.setClip(this.insets.left, this.insets.top, -n, n4);
            }
            graphics.translate(this.child.x, this.child.y);
            this.child.paint(graphics);
            graphics.dispose();
        }
    }

    void checkScrollbarVisibility(Dimension dimension) {
        int n = 2;
        int n2 = this.width - 2 * n;
        int n3 = this.height - 2 * n;
        if (this.hScroll.isVisible) {
            if (dimension.width <= n2) {
                this.hScroll.setVisible(false);
                this.insets.bottom -= Scrollbar.SCROLLBAR_WIDTH;
            }
        } else if (dimension.width > n2) {
            this.hScroll.setVisible(true);
            this.insets.bottom += Scrollbar.SCROLLBAR_WIDTH;
        }
        if (this.vScroll.isVisible) {
            if (dimension.height <= n3) {
                this.vScroll.setVisible(false);
                this.insets.right -= Scrollbar.SCROLLBAR_WIDTH;
            }
        } else if (dimension.height > n3) {
            this.vScroll.setVisible(true);
            this.insets.right += Scrollbar.SCROLLBAR_WIDTH;
        }
    }

    public void doLayout() {
        if (this.child == null) {
            return;
        }
        int n = Scrollbar.SCROLLBAR_WIDTH;
        Dimension dimension = this.child.getPreferredSize();
        this.isLayouting = true;
        if (this.policy == 0) {
            this.checkScrollbarVisibility(dimension);
        }
        int n2 = this.width - (this.insets.left + this.insets.right);
        int n3 = this.height - (this.insets.top + this.insets.bottom);
        this.hScroll.setBounds(0, this.height - n, this.vScroll.isVisible ? this.width - n : this.width, n);
        this.vScroll.setBounds(this.width - n, 0, n, this.hScroll.isVisible ? this.height - n : this.height);
        this.hScroll.setValues(0, n2, 0, dimension.width - n2);
        this.vScroll.setValues(0, n3, 0, dimension.height - n3);
        this.wrapper.setBounds(this.insets.left, this.insets.top, n2, n3);
        this.child.setBounds(0, 0, dimension.width, dimension.height);
        this.isLayouting = false;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.hScroll.isVisible) {
            this.hScroll.setBackground(Defaults.FocusClr);
        }
        if (this.vScroll.isVisible) {
            this.vScroll.setBackground(Defaults.FocusClr);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.hScroll.isVisible) {
            this.hScroll.setBackground(Defaults.BtnClr);
        }
        if (this.vScroll.isVisible) {
            this.vScroll.setBackground(Defaults.BtnClr);
        }
    }

    public Adjustable getHAdjustable() {
        return this.hScroll;
    }

    public int getHSrollbarHeight() {
        return this.hScroll == null ? 0 : Scrollbar.SCROLLBAR_WIDTH;
    }

    public Point getScrollPosition() {
        return this.pos;
    }

    public int getScrollbarDisplayPolicy() {
        return this.policy;
    }

    public Adjustable getVAdjustable() {
        return this.vScroll;
    }

    public int getVScrollbarWidth() {
        return this.vScroll == null ? 0 : Scrollbar.SCROLLBAR_WIDTH;
    }

    public Dimension getViewportSize() {
        return new Dimension(this.width - (this.insets.left + this.insets.right), this.height - (this.insets.top + this.insets.bottom));
    }

    public void paint(Graphics graphics) {
        boolean bl;
        Rectangle rectangle = graphics.clip;
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = n + rectangle.width;
        int n4 = n2 + rectangle.height;
        boolean bl2 = n3 > this.width - this.insets.right;
        boolean bl3 = bl = n4 > this.height - this.insets.bottom;
        if (n < this.insets.left || n2 < this.insets.top || bl2 || bl) {
            this.paintBorder(graphics, 0, 0, this.vScroll.isVisible ? Scrollbar.SCROLLBAR_WIDTH : 0, this.hScroll.isVisible ? Scrollbar.SCROLLBAR_WIDTH : 0);
            if (this.hScroll.isVisible && bl) {
                graphics.translate(this.hScroll.x, this.hScroll.y);
                this.hScroll.paint(graphics);
                graphics.translate(-this.hScroll.x, -this.hScroll.y);
            }
            if (this.vScroll.isVisible && bl) {
                graphics.translate(this.vScroll.x, this.vScroll.y);
                this.vScroll.paint(graphics);
                graphics.translate(-this.vScroll.x, -this.vScroll.y);
            }
        }
        if (this.child != null) {
            graphics.translate(this.insets.left, this.insets.top);
            graphics.setClip(0, 0, this.width - (this.insets.left + this.insets.right), this.height - (this.insets.top + this.insets.bottom));
            this.child.paint(graphics);
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
        throw new AWTError("ScrollPane can't have LayoutManagers");
    }

    public void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    public void setScrollPosition(int n, int n2) {
        this.pos.x = n;
        this.pos.y = n2;
        this.hScroll.setValue(n);
        this.vScroll.setValue(n2);
    }

    class Adjustable
    extends Scrollbar {
        Adjustable(int n) {
            super(n);
        }

        public void setMaximum(int n) {
            throw new AWTError("can't set scroll maximum for ScrollPane");
        }

        public void setMinimum(int n) {
            throw new AWTError("can't set scroll minimum for ScrollPane");
        }

        public void setVisibleAmount(int n) {
            throw new AWTError("can't set visible amount for ScrollPane");
        }
    }

    class ChildWrapper
    extends Container {
        ChildWrapper() {
            this.layout = null;
        }

        public void doLayout() {
        }
    }
}

