/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class PopupWindow
extends Window {
    MenuItem selection;
    static int xOffs = 8;
    Vector items;
    Component client;
    PopupWindow sub;
    static boolean disposeOnLost;

    public PopupWindow(Component component, Frame frame, Vector vector) {
        super(frame);
        this.client = component;
        this.items = vector;
        new PopupListener();
        if (!(component instanceof PopupWindow)) {
            AWTEvent.setPopup(this);
        }
    }

    public void dispose() {
        if (!(this.client instanceof PopupWindow)) {
            AWTEvent.resetPopup(this);
        }
        this.disposeSubMenus();
        super.dispose();
    }

    void disposeAll() {
        Component component = AWTEvent.keyTgt;
        PopupWindow popupWindow = this.rootWnd();
        popupWindow.dispose();
        if (component instanceof PopupWindow) {
            popupWindow.client.requestFocus();
        }
    }

    void disposeSubMenus() {
        PopupWindow popupWindow = this.sub;
        while (popupWindow != null) {
            popupWindow.dispose();
            popupWindow = popupWindow.sub;
        }
        this.sub = null;
    }

    public Dimension getPreferredSize() {
        int n = this.items != null ? this.items.size() : 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 2;
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(i);
            if (menuItem instanceof Menu) {
                n4 = 3;
            }
            n3 = Math.max(n3, menuItem.getWidth());
            n2 += menuItem.getHeight();
        }
        return new Dimension(n3 + n4 * xOffs + 4, n2 + 4);
    }

    int getY(MenuItem menuItem) {
        int n = this.items.size();
        int n2 = 2;
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem2 = (MenuItem)this.items.elementAt(i);
            if (menuItem2 == menuItem) {
                return n2;
            }
            n2 += menuItem2.getHeight();
        }
        return -1;
    }

    MenuItem itemAt(int n) {
        int n2 = this.items.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(i);
            if ((n3 += menuItem.getHeight()) <= n) continue;
            return menuItem;
        }
        return null;
    }

    public void notifyLost(Component component) {
        if (!(component instanceof PopupWindow)) {
            this.disposeAll();
        }
    }

    boolean openSubMenu() {
        if (this.sub != null) {
            return false;
        }
        if (this.selection == null || !(this.selection instanceof Menu)) {
            return false;
        }
        Vector vector = ((Menu)this.selection).items;
        if (vector == null || vector.size() == 0) {
            return false;
        }
        this.sub = new PopupWindow(this, this.owner, vector);
        this.sub.popupAt(this.x + this.width, this.y + this.getY(this.selection));
        return true;
    }

    public void paint(Graphics graphics) {
        int n = this.items.size();
        int n2 = xOffs;
        int n3 = 2;
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        graphics.setColor(this.bgClr);
        graphics.fill3DRect(1, 1, this.width - 2, this.height - 2, true);
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(i);
            n3 += this.paintItem(menuItem, graphics, n3);
        }
    }

    int paintItem(MenuItem menuItem, Graphics graphics, int n) {
        int n2 = menuItem.paint(graphics, xOffs, n + 2, this.width, this.bgClr, this.fgClr, menuItem == this.selection);
        if (menuItem instanceof Menu) {
            int n3 = n + n2 / 2;
            int n4 = this.width - 4;
            for (int i = 0; i < 4; ++i) {
                graphics.drawLine(n4 - 2 * i, n3 - i, n4 - 2 * i, n3 + i);
            }
        }
        return n2;
    }

    public void popupAt(int n, int n2) {
        Dimension dimension = Toolkit.singleton.getScreenSize();
        Dimension dimension2 = this.getPreferredSize();
        if (n + dimension2.width > dimension.width) {
            n = dimension.width - dimension2.width;
        }
        if (n2 + dimension2.height > dimension.height) {
            n2 = dimension.height - dimension2.height;
        }
        this.setBounds(n, n2, dimension2.width, dimension2.height);
        this.setVisible(true);
        AWTEvent.grabMouseDrag(this);
    }

    void processSelection() {
        if (this.selection == null) {
            return;
        }
        if (this.selection instanceof Menu) {
            this.disposeSubMenus();
            this.openSubMenu();
        } else {
            this.disposeAll();
            this.selection.process();
        }
    }

    PopupWindow rootWnd() {
        Component component = this;
        while (component != null) {
            if (!(component instanceof PopupWindow)) continue;
            PopupWindow popupWindow = component;
            if (!(popupWindow.client instanceof PopupWindow)) {
                return popupWindow;
            }
            component = popupWindow.client;
        }
        return null;
    }

    boolean selectItem(MenuItem menuItem) {
        if (menuItem == null || menuItem.isSeparator() || menuItem == this.selection) {
            return false;
        }
        Graphics graphics = this.getGraphics();
        if (this.selection != null) {
            MenuItem menuItem2 = this.selection;
            this.selection = null;
            this.paintItem(menuItem2, graphics, this.getY(menuItem2));
        }
        this.selection = menuItem;
        this.paintItem(this.selection, graphics, this.getY(this.selection));
        graphics.dispose();
        return true;
    }

    void selectLower() {
        if (this.sub != null) {
            this.sub.requestFocus();
            Vector vector = this.sub.items;
            if (vector != null && vector.size() > 0) {
                this.sub.selectItem((MenuItem)vector.firstElement());
            }
        }
    }

    void selectNext() {
        try {
            if (this.selection == null) {
                this.selectItem((MenuItem)this.items.firstElement());
            } else {
                for (int i = this.items.indexOf(this.selection) + 1; i < this.items.size(); ++i) {
                    MenuItem menuItem = (MenuItem)this.items.elementAt(i);
                    if (menuItem.isSeparator()) continue;
                    this.selectItem(menuItem);
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void selectPrev() {
        try {
            if (this.selection == null) {
                this.selectItem((MenuItem)this.items.lastElement());
            } else {
                for (int i = this.items.indexOf(this.selection) - 1; i >= 0; --i) {
                    MenuItem menuItem = (MenuItem)this.items.elementAt(i);
                    if (menuItem.isSeparator()) continue;
                    this.selectItem(menuItem);
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void selectUpper() {
        if (this.client instanceof PopupWindow) {
            PopupWindow popupWindow = (PopupWindow)this.client;
            this.dispose();
            popupWindow.requestFocus();
            popupWindow.sub = null;
        }
    }

    class PopupListener
    implements MouseListener,
    MouseMotionListener,
    KeyListener,
    FocusListener {
        boolean firstEvent = true;

        public PopupListener() {
            PopupWindow.this.addMouseListener(this);
            PopupWindow.this.addMouseMotionListener(this);
            PopupWindow.this.addKeyListener(this);
            PopupWindow.this.addFocusListener(this);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 10: {
                    PopupWindow.this.processSelection();
                    break;
                }
                case 38: {
                    PopupWindow.this.selectPrev();
                    break;
                }
                case 40: {
                    PopupWindow.this.selectNext();
                    break;
                }
                case 27: {
                    PopupWindow.this.disposeAll();
                    break;
                }
                case 37: {
                    PopupWindow.this.selectUpper();
                    break;
                }
                case 39: {
                    PopupWindow.this.selectLower();
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            PopupWindow popupWindow;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.firstEvent = false;
            if (PopupWindow.this.contains(n, n2)) {
                PopupWindow.this.selectItem(PopupWindow.this.itemAt(n2));
                if (PopupWindow.this.selection != null && PopupWindow.this.selection instanceof Menu) {
                    PopupWindow.this.openSubMenu();
                }
            } else if (PopupWindow.this.client instanceof PopupWindow && (popupWindow = (PopupWindow)PopupWindow.this.client).contains(n -= popupWindow.x - PopupWindow.this.x, n2 -= popupWindow.y - PopupWindow.this.y) && popupWindow.itemAt(n2) != popupWindow.selection) {
                popupWindow.disposeSubMenus();
                AWTEvent.revertDragGrab(popupWindow);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            disposeOnLost = false;
            PopupWindow.this.requestFocus();
            PopupWindow.this.selectItem(PopupWindow.this.itemAt(mouseEvent.getY()));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            disposeOnLost = true;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.firstEvent = false;
            PopupWindow.this.selectItem(PopupWindow.this.itemAt(mouseEvent.getY()));
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.firstEvent = false;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PopupWindow.this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                PopupWindow.this.processSelection();
            } else if (!this.firstEvent) {
                PopupWindow.this.disposeAll();
            }
        }
    }
}

