/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.BarMenu;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Dimension;
import java.awt.HotKeyHandler;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.Window;
import kaffe.util.Ptr;

public class Frame
extends Window {
    String title;
    Image icon;
    boolean isResizable = true;
    BarMenu bMenu;

    public Frame() {
        this("");
    }

    Frame(Frame frame, String string) {
        super(frame);
        this.title = string;
    }

    public Frame(String string) {
        this.title = string;
    }

    Ptr createNativeWindow() {
        return Toolkit.wndCreateFrame(this.title, this.x, this.y, this.width, this.height, this.cursor.type, this.bgClr.nativeValue, this.isResizable);
    }

    public void doLayout() {
        super.doLayout();
        if (this.bMenu != null) {
            this.bMenu.setBounds(0, 0, this.width - this.insets.right - this.insets.left, this.insets.top);
        }
    }

    public Component getComponent(int n) {
        if (this.children == null) {
            return null;
        }
        if (this.bMenu == null) {
            return this.children[n];
        }
        return this.children[n + 1];
    }

    public int getComponentCount() {
        if (this.bMenu == null) {
            return this.nChildren;
        }
        return this.nChildren - 1;
    }

    public Component[] getComponents() {
        if (this.bMenu == null) {
            return super.getComponents();
        }
        Component[] componentArray = new Component[this.nChildren - 1];
        if (componentArray.length > 0) {
            System.arraycopy(this.children, 1, componentArray, 0, this.nChildren - 1);
        }
        return componentArray;
    }

    public Image getIconImage() {
        return this.icon;
    }

    public MenuBar getMenuBar() {
        return this.bMenu != null ? this.bMenu.mb : null;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += 2 * Defaults.FrameBorderWidth;
        dimension.height += Defaults.TitleBarHeight + Defaults.BottomBarHeight;
        if (this.bMenu != null) {
            dimension.height += Defaults.MenuBarHeight;
        }
        return dimension;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isResizable() {
        return this.isResizable;
    }

    public void remove(MenuComponent menuComponent) {
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (this.nativeData != null) {
            Toolkit.wndSetFrameBounds(this.nativeData, n, n2, n3, n4);
        } else {
            this.doLayout();
        }
    }

    public void setIconImage(Image image) {
        this.icon = image;
        if (this.nativeData != null) {
            Toolkit.wndSetIcon(this.nativeData, image.nativeData);
        }
    }

    public void setMenuBar(MenuBar menuBar) {
        Object object;
        this.bMenu = new BarMenu(menuBar);
        if (this.children == null) {
            this.children = new Component[3];
        } else if (this.nChildren == this.children.length) {
            object = this.children;
            this.children = new Component[this.nChildren * 2];
            System.arraycopy(object, 0, this.children, 1, this.nChildren);
        } else {
            System.arraycopy(this.children, 0, this.children, 1, this.nChildren);
        }
        this.children[0] = this.bMenu;
        ++this.nChildren;
        this.bMenu.parent = this;
        this.insets = new Insets(Defaults.MenuBarHeight, 0, 0, 0);
        if (this.nativeData != null) {
            this.doLayout();
        }
        object = menuBar.shortcuts();
        while (object.hasMoreElements()) {
            MenuShortcut menuShortcut = (MenuShortcut)object.nextElement();
            MenuItem menuItem = menuBar.getShortcutMenuItem(menuShortcut);
            int n = 2;
            if (menuShortcut.usesShiftMod) {
                n |= 1;
            }
            HotKeyHandler.addHotKey(this.bMenu, menuItem, menuShortcut.key, n, menuItem.getActionCommand());
        }
    }

    public void setResizable(boolean bl) {
        this.isResizable = bl;
        if (this.nativeData != null) {
            Toolkit.wndSetResizable(this.nativeData, bl, this.x, this.y, this.width, this.height);
        }
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.nativeData != null) {
            Toolkit.wndSetTitle(this.nativeData, string);
        }
    }
}

