/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Defaults;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.PopupMenu;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class BarMenu
extends Component {
    static int Dx = 5;
    Menu selection;
    MenuBar mb;
    PopupMenu current;

    public BarMenu() {
        this(null);
    }

    public BarMenu(MenuBar menuBar) {
        this.mb = menuBar;
        this.fgClr = Defaults.MenuTxtClr;
        this.bgClr = Defaults.MenuBgClr;
        this.font = Defaults.MenuFont;
        new BarMenuListener();
    }

    void disposeCurrent() {
        if (this.current != null) {
            this.current.dispose();
            this.current = null;
        }
    }

    int getX(Menu menu) {
        int n = this.mb.menus.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Menu menu2 = (Menu)this.mb.menus.elementAt(i);
            if (menu2 == menu) {
                return n2;
            }
            n2 += menu2.getWidth() + 2 * Dx;
        }
        return -1;
    }

    Menu menuAt(int n) {
        int n2 = this.mb.menus.size();
        int n3 = Dx;
        for (int i = 0; i < n2; ++i) {
            Menu menu = (Menu)this.mb.menus.elementAt(i);
            int n4 = menu.getWidth();
            if ((n3 += n4 + Dx) > n) {
                return menu;
            }
            n3 += Dx;
        }
        return null;
    }

    public void paint(Graphics graphics) {
        int n = this.mb.menus.size();
        int n2 = Dx;
        graphics.setColor(this.getBackground());
        graphics.fill3DRect(0, 0, this.width, this.height, true);
        for (int i = 0; i < n; ++i) {
            Menu menu = (Menu)this.mb.menus.elementAt(i);
            int n3 = menu.getWidth();
            int n4 = (this.height - menu.fm.getHeight()) / 2;
            menu.paint(graphics, n2, n4, n3 + 2 * Dx, this.bgClr, this.fgClr, this.selection == menu);
            n2 += n3 + 2 * Dx;
        }
    }

    void paintMenu(Graphics graphics, Menu menu) {
        int n = this.mb.menus.size();
        int n2 = Dx;
        for (int i = 0; i < n; ++i) {
            Menu menu2 = (Menu)this.mb.menus.elementAt(i);
            int n3 = menu2.getWidth();
            int n4 = (this.height - menu2.fm.getHeight()) / 2;
            if (menu == menu2) {
                menu2.paint(graphics, n2, n4, n3 + 2 * Dx, this.bgClr, this.fgClr, this.selection == menu2);
                return;
            }
            n2 += n3 + 2 * Dx;
        }
    }

    void processSelection() {
        if (this.selection != null) {
            this.disposeCurrent();
            if (this.selection.getItemCount() > 0) {
                this.current = new PopupMenu(this.selection);
                int n = this.getX(this.selection) + 1;
                int n2 = this.height + 1;
                this.current.show(this, n, n2);
                this.current.requestFocus();
            } else {
                this.selection.process();
            }
        }
    }

    void selectMenu(Menu menu) {
        Graphics graphics = this.getGraphics();
        if (menu == null) {
            if (this.selection != null) {
                Menu menu2 = this.selection;
                this.selection = null;
                this.paintMenu(graphics, menu2);
            }
        } else if (menu != this.selection) {
            Menu menu3 = this.selection;
            this.selection = menu;
            this.paintMenu(graphics, menu3);
            this.paintMenu(graphics, this.selection);
        }
        graphics.dispose();
    }

    void selectNext() {
        try {
            if (this.selection == null) {
                this.selectMenu((Menu)this.mb.menus.firstElement());
            } else {
                int n = this.mb.menus.indexOf(this.selection) + 1;
                this.selectMenu((Menu)this.mb.menus.elementAt(n));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void selectPrev() {
        try {
            if (this.selection == null) {
                this.selectMenu((Menu)this.mb.menus.lastElement());
            } else {
                int n = this.mb.menus.indexOf(this.selection) - 1;
                this.selectMenu((Menu)this.mb.menus.elementAt(n));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setMenus(MenuBar menuBar) {
        this.mb = menuBar;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    class BarMenuListener
    implements KeyListener,
    MouseListener,
    MouseMotionListener {
        public BarMenuListener() {
            BarMenu.this.addMouseListener(this);
            BarMenu.this.addMouseMotionListener(this);
            BarMenu.this.addKeyListener(this);
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 10: {
                    BarMenu.this.processSelection();
                    break;
                }
                case 37: {
                    BarMenu.this.selectPrev();
                    break;
                }
                case 39: {
                    BarMenu.this.selectNext();
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            BarMenu.this.selectMenu(BarMenu.this.menuAt(mouseEvent.getX()));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BarMenu.this.selectMenu(null);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            BarMenu.this.selectMenu(BarMenu.this.menuAt(mouseEvent.getX()));
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BarMenu.this.processSelection();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

