/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashtableEnumeration;
import java.util.Vector;

public class Hashtable
extends Dictionary
implements Cloneable,
Serializable {
    private transient Object[] keys;
    private transient Object[] elements;
    private transient float loadFactor;
    private int numberOfKeys;
    private transient int rehashLimit;
    private static final int DEFAULTCAPACITY = 101;
    private static final float DEFAULTLOADFACTOR = 0.75f;
    private static final long serialVersionUID = 1421746759512286392L;

    public Hashtable() {
        this(101, 0.75f);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable(int n, float f) {
        if (n <= 0) {
            throw new Error("Initial capacity is <= 0");
        }
        if ((double)f <= 0.0) {
            throw new Error("Load Factor is <= 0");
        }
        this.loadFactor = f;
        this.keys = new Object[n];
        this.elements = new Object[n];
        this.numberOfKeys = 0;
        this.rehashLimit = (int)(f * (float)n);
    }

    public int size() {
        return this.numberOfKeys;
    }

    public boolean isEmpty() {
        return this.numberOfKeys == 0;
    }

    public synchronized Enumeration keys() {
        Vector vector = new Vector(this.numberOfKeys);
        for (int i = this.keys.length - 1; i >= 0; --i) {
            if (this.keys[i] == null) continue;
            vector.addElement(this.keys[i]);
        }
        return new HashtableEnumeration(vector);
    }

    public synchronized Enumeration elements() {
        Vector vector = new Vector(this.numberOfKeys);
        for (int i = this.elements.length - 1; i >= 0; --i) {
            if (this.keys[i] == null) continue;
            vector.addElement(this.elements[i]);
        }
        return new HashtableEnumeration(vector);
    }

    public synchronized boolean contains(Object object) {
        for (int i = this.elements.length - 1; i >= 0; --i) {
            if (!object.equals(this.elements[i])) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    private int calculateBucket(Object object) {
        return (object.hashCode() & Integer.MAX_VALUE) % this.keys.length;
    }

    public synchronized Object get(Object object) {
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        for (int i = n; i < n2; ++i) {
            Object object2 = this.keys[i];
            if (object.equals(object2)) {
                return this.elements[i];
            }
            if (object2 != null) continue;
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Object object3 = this.keys[i];
            if (object.equals(object3)) {
                return this.elements[i];
            }
            if (object3 != null) continue;
            return null;
        }
        return null;
    }

    protected synchronized void rehash() {
        int n = this.keys.length * 2;
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.elements;
        this.keys = new Object[n];
        this.elements = new Object[n];
        this.rehashLimit = (int)(this.loadFactor * (float)n);
        this.numberOfKeys = 0;
        for (int i = objectArray.length - 1; i >= 0; --i) {
            if (this.keys[i] == null) continue;
            this.put(this.keys[i], this.elements[i]);
        }
    }

    public synchronized Object put(Object object, Object object2) {
        if (this.numberOfKeys >= this.rehashLimit) {
            this.rehash();
        }
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        for (int i = n; i < n2; ++i) {
            Object object3 = this.keys[i];
            if (object.equals(object3)) {
                Object object4 = this.elements[i];
                this.elements[i] = object2;
                return object4;
            }
            if (object3 != null) continue;
            this.keys[i] = object;
            this.elements[i] = object2;
            ++this.numberOfKeys;
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Object object5 = this.keys[i];
            if (object.equals(object5)) {
                Object object6 = this.elements[i];
                this.elements[i] = object2;
                return object6;
            }
            if (object5 != null) continue;
            this.keys[i] = object;
            this.elements[i] = object2;
            ++this.numberOfKeys;
            return null;
        }
        throw new Error("Inconsistent Hashtable");
    }

    public synchronized Object remove(Object object) {
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        for (int i = n; i < n2; ++i) {
            Object object2 = this.keys[i];
            if (object.equals(object2)) {
                Object object3 = this.elements[i];
                this.elements[i] = null;
                this.keys[i] = null;
                --this.numberOfKeys;
                return object3;
            }
            if (object2 != null) continue;
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Object object4 = this.keys[i];
            if (object.equals(object4)) {
                Object object5 = this.elements[i];
                this.elements[i] = null;
                this.keys[i] = null;
                --this.numberOfKeys;
                return object5;
            }
            if (object4 != null) continue;
            return null;
        }
        return null;
    }

    public synchronized void clear() {
        for (int i = this.keys.length; i >= 0; --i) {
            this.keys[i] = null;
            this.elements[i] = null;
        }
        this.numberOfKeys = 0;
    }

    public synchronized Object clone() {
        Hashtable hashtable;
        try {
            hashtable = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        hashtable.numberOfKeys = 0;
        hashtable.loadFactor = this.loadFactor;
        hashtable.keys = new Object[this.keys.length];
        hashtable.elements = new Object[this.elements.length];
        for (int i = this.keys.length - 1; i >= 0; --i) {
            if (this.keys[i] == null) continue;
            hashtable.put(this.keys[i], this.elements[i]);
        }
        return hashtable;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.loadFactor = objectInputStream.readFloat();
        int n = objectInputStream.readInt();
        this.keys = new Object[n];
        this.elements = new Object[n];
        this.rehashLimit = (int)(this.loadFactor * (float)n);
        int n2 = this.numberOfKeys;
        this.numberOfKeys = 0;
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            objectOutputStream.writeObject(this.keys[i]);
            objectOutputStream.writeObject(this.elements[i]);
        }
    }

    public synchronized String toString() {
        int n;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (n = 0; n < this.keys.length; ++n) {
            if (this.keys[n] == null) continue;
            stringBuffer.append(this.keys[n]);
            stringBuffer.append("=");
            stringBuffer.append(this.elements[n]);
        }
        while (n < this.keys.length) {
            if (this.keys[n] != null) {
                stringBuffer.append(", ");
                stringBuffer.append(this.keys[n]);
                stringBuffer.append("=");
                stringBuffer.append(this.elements[n]);
            }
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

