/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketOutputStream;
import java.net.UnknownHostException;

class PlainSocketImpl
extends SocketImpl {
    protected synchronized void accept(SocketImpl socketImpl) throws IOException {
        this.socketAccept(socketImpl);
    }

    protected synchronized int available() throws IOException {
        return this.socketAvailable();
    }

    protected synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        this.address = inetAddress;
        this.localport = n;
        this.socketBind(inetAddress, n);
    }

    protected synchronized void close() throws IOException {
        this.socketClose();
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.address = inetAddress;
        this.port = n;
        this.socketConnect(inetAddress, n);
    }

    protected void connect(String string, int n) throws IOException {
        this.connect(InetAddress.getByName(string), n);
    }

    protected synchronized void create(boolean bl) throws IOException {
        this.fd = new FileDescriptor();
        this.address = new InetAddress();
        this.socketCreate(bl);
    }

    protected synchronized void finalize() throws IOException {
        this.close();
    }

    protected synchronized InputStream getInputStream() throws IOException {
        return new SocketInputStream(this);
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        return new SocketOutputStream(this);
    }

    protected synchronized void listen(int n) throws IOException {
        this.socketListen(n);
    }

    public void setOption(int n, Object object) throws SocketException {
        boolean bl;
        boolean bl2 = bl = object instanceof Boolean && (Boolean)object == false;
        if (bl) {
            object = new Integer(0);
        }
        switch (n) {
            case 4: 
            case 128: 
            case 4097: 
            case 4098: {
                break;
            }
            case 1: {
                object = new Integer(bl ? 0 : 1);
                break;
            }
            case 4102: {
                throw new SocketException("Unimplemented socket option");
            }
            case 15: {
                throw new SocketException("Read-only socket option");
            }
            default: {
                throw new SocketException("Unknown socket option");
            }
        }
        this.socketSetOption(n, object);
    }

    public Object getOption(int n) throws SocketException {
        switch (n) {
            case 4: 
            case 128: 
            case 4097: 
            case 4098: {
                return new Integer(this.socketGetOption(n));
            }
            case 1: {
                return new Boolean(this.socketGetOption(n) != 0);
            }
            case 4102: {
                throw new SocketException("Unimplemented socket option");
            }
            case 15: {
                int n2 = this.socketGetOption(n);
                try {
                    return InetAddress.getByName(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(n2 >> 24 & 0xFF).concat(String.valueOf("."))).concat(String.valueOf(n2 >> 16 & 0xFF))).concat(String.valueOf("."))).concat(String.valueOf(n2 >> 8 & 0xFF))).concat(String.valueOf("."))).concat(String.valueOf(n2 & 0xFF)));
                }
                catch (UnknownHostException unknownHostException) {
                    throw new Error("impossible result");
                }
            }
        }
        throw new SocketException("Unknown socket option");
    }

    public native void socketSetOption(int var1, Object var2) throws SocketException;

    public native int socketGetOption(int var1) throws SocketException;

    private native void socketAccept(SocketImpl var1);

    private native int socketAvailable();

    private native void socketBind(InetAddress var1, int var2);

    private native void socketClose();

    private native void socketConnect(InetAddress var1, int var2);

    private native void socketCreate(boolean var1);

    private native void socketListen(int var1);

    PlainSocketImpl() {
    }

    static {
        System.loadLibrary("net");
    }
}

