/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import kaffe.io.ByteToCharConverter;
import kaffe.io.CharToByteConverter;

public final class String
implements Serializable {
    char[] value;
    int offset;
    int count;
    int hash;
    static final long serialVersionUID = -6849794470754667710L;

    public String() {
        this.value = new char[0];
    }

    public String(String string) {
        this(string.toCharArray());
    }

    public String(StringBuffer stringBuffer) {
        this.count = stringBuffer.length();
        this.value = new char[this.count];
        if (this.count > 0) {
            stringBuffer.getChars(0, this.count, this.value, 0);
        }
    }

    public String(byte[] byArray) {
        this.initString(byArray, 0, byArray.length, ByteToCharConverter.getDefault());
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this.initString(byArray, 0, byArray.length, ByteToCharConverter.getConverter(string));
    }

    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    public String(byte[] byArray, int n, int n2) {
        this.initString(byArray, n, n2, ByteToCharConverter.getDefault());
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        this.initString(byArray, n, n2, ByteToCharConverter.getConverter(string));
    }

    public String(byte[] byArray, int n, int n2, int n3) {
        this.value = new char[n3];
        this.count = n3;
        for (int i = 0; i < n3; ++i) {
            this.value[i] = (char)((n & 0xFF) << 8 | byArray[i + n2] & 0xFF);
        }
    }

    public String(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public String(char[] cArray, int n, int n2) {
        this.value = new char[n2];
        this.count = n2;
        if (n2 > 0) {
            System.arraycopy(cArray, n, this.value, 0, n2);
        }
    }

    private String(int n, int n2, char[] cArray) {
        this.value = cArray;
        this.offset = n;
        this.count = n2 - n;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        return this.value[this.offset + n];
    }

    public int compareTo(String string) {
        int n = Math.min(this.count, string.count);
        for (int i = 0; i < n; ++i) {
            char c = this.value[this.offset + i];
            char c2 = string.value[string.offset + i];
            if (c == c2) continue;
            return c - c2;
        }
        return this.count - string.count;
    }

    public String concat(String string) {
        if (string == null || string.count == 0) {
            return this;
        }
        char[] cArray = new char[this.count + string.count];
        this.getChars(0, this.count, cArray, 0);
        string.getChars(0, string.count, cArray, this.count);
        return new String(0, cArray.length, cArray);
    }

    public static String copyValueOf(char[] cArray) {
        return String.copyValueOf(cArray, 0, cArray.length);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        if (n2 > 0) {
            System.arraycopy(cArray, n, cArray2, 0, n2);
        }
        return new String(0, n2, cArray2);
    }

    public boolean endsWith(String string) {
        return this.regionMatches(false, this.count - string.count, string, 0, string.count);
    }

    public boolean equals(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        if (this.count != string.count) {
            return false;
        }
        int n = this.offset;
        int n2 = string.offset;
        int n3 = this.offset + this.count;
        while (n < n3) {
            if (this.value[n] != string.value[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        if (string == null || this.count != string.count) {
            return false;
        }
        int n = this.offset;
        int n2 = string.offset;
        int n3 = this.offset + this.count;
        while (n < n3) {
            if (this.value[n] != string.value[n2] && Character.toUpperCase(this.value[n]) != Character.toUpperCase(string.value[n2])) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    protected void finalize() {
        this.unintern();
    }

    public byte[] getBytes() {
        return this.getBytes(CharToByteConverter.getDefault());
    }

    private byte[] getBytes(CharToByteConverter charToByteConverter) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.value.length);
        byte[] byArray = new byte[512];
        int n = charToByteConverter.convert(this.value, this.offset, this.count, byArray, 0, byArray.length);
        while (n > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = charToByteConverter.flush(byArray, 0, byArray.length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        return this.getBytes(CharToByteConverter.getConverter(string));
    }

    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        int n4 = n2 - n;
        for (int i = 0; i < n4; ++i) {
            byArray[n3 + i] = (byte)this.value[this.offset + n + i];
        }
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        System.arraycopy(this.value, this.offset + n, cArray, n3, n2 - n);
    }

    public int hashCode() {
        if (this.hash == 0 && this.count > 0) {
            int n = this.offset + this.count;
            for (int i = this.offset; i < n; ++i) {
                this.hash = 31 * this.hash + this.value[i];
            }
        }
        return this.hash;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        int n2 = string.offset;
        int n3 = 0;
        if (string.count > this.count - n) {
            return -1;
        }
        for (int i = this.offset + n; i < this.value.length; ++i) {
            if (this.value[i] == string.value[n2]) {
                if (++n3 == string.count) {
                    return i - n3 - this.offset + 1;
                }
                ++n2;
                continue;
            }
            if (n3 <= 0) continue;
            --i;
            n3 = 0;
            n2 = string.offset;
        }
        return -1;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        char c = (char)n;
        for (int i = n2; i < this.count; ++i) {
            if (this.value[this.offset + i] != c) continue;
            return i;
        }
        return -1;
    }

    private void initString(byte[] byArray, int n, int n2, ByteToCharConverter byteToCharConverter) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        char[] cArray = new char[512];
        int n3 = byteToCharConverter.convert(byArray, n, n2, cArray, 0, cArray.length);
        while (n3 > 0) {
            stringBuffer.append(cArray, 0, n3);
            n3 = byteToCharConverter.flush(cArray, 0, cArray.length);
        }
        String string = stringBuffer.toString();
        this.value = string.value;
        n = string.offset;
        this.count = string.count;
    }

    public final native String intern();

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        int n2 = string.value.length - 1;
        int n3 = 0;
        for (int i = this.offset + n - 1; i >= this.offset; --i) {
            if (this.value[i] == string.value[n2]) {
                --n2;
                if (++n3 != string.count) continue;
                return i - this.offset;
            }
            if (n3 <= false) continue;
            ++i;
            n3 = 0;
            n2 = string.value.length - 1;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        char c = (char)n;
        if (n2 >= this.count) {
            n2 = this.count - 1;
        }
        for (int i = n2; i >= 0; --i) {
            if (this.value[this.offset + i] != c) continue;
            return i;
        }
        return -1;
    }

    public int length() {
        return this.count;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        if (n < 0 || n2 < 0) {
            return false;
        }
        if (n + n3 > this.count || n2 + n3 > string.count) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            char c = this.value[this.offset + n + i];
            char c2 = string.value[string.offset + n2 + i];
            if (c != c2 && bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c == c2) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        return this.regionMatches(false, n, string, n2, n3);
    }

    public String replace(char c, char c2) {
        char[] cArray = new char[this.count];
        for (int i = 0; i < this.count; ++i) {
            char c3 = this.value[this.offset + i];
            cArray[i] = c3 == c ? c2 : c3;
        }
        return new String(0, this.count, cArray);
    }

    public boolean startsWith(String string) {
        return this.regionMatches(false, 0, string, 0, string.count);
    }

    public boolean startsWith(String string, int n) {
        return this.regionMatches(false, n, string, 0, string.count);
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        if (n == 0 && n2 == this.count) {
            return this;
        }
        return new String(this.offset + n, this.offset + n2, this.value);
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        if (this.count > 0) {
            this.getChars(0, this.count, cArray, 0);
        }
        return cArray;
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toLowerCase(Locale locale2) {
        char[] cArray = new char[this.count];
        for (int i = 0; i < this.count; ++i) {
            cArray[i] = Character.toLowerCase(this.value[this.offset + i]);
        }
        return new String(0, this.count, cArray);
    }

    public String toString() {
        return this;
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale2) {
        char[] cArray = new char[this.count];
        for (int i = 0; i < this.count; ++i) {
            cArray[i] = Character.toUpperCase(this.value[this.offset + i]);
        }
        return new String(0, this.count, cArray);
    }

    public String trim() {
        int n;
        int n2 = this.offset + this.count - 1;
        for (n = this.offset; n <= n2 && this.value[n] <= ' '; ++n) {
        }
        if (n > n2) {
            return "";
        }
        while (n2 > n && this.value[n2] <= ' ') {
            --n2;
        }
        return this.substring(n - this.offset, n2 + 1 - this.offset);
    }

    private final native void unintern();

    public static String valueOf(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public static String valueOf(boolean bl) {
        return new Boolean(bl).toString();
    }

    public static String valueOf(char c) {
        char[] cArray = new char[]{c};
        return new String(cArray);
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String valueOf(double d) {
        return new Double(d).toString();
    }

    public static String valueOf(float f) {
        return new Float(f).toString();
    }

    public static String valueOf(int n) {
        return new Integer(n).toString();
    }

    public static String valueOf(long l) {
        return new Long(l).toString();
    }
}

