/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Character {
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final int UNASSIGNED = 0;
    public static final int UPPERCASE_LETTER = 1;
    public static final int LOWERCASE_LETTER = 2;
    public static final int TITLECASE_LETTER = 3;
    public static final int MODIFIER_LETTER = 4;
    public static final int OTHER_LETTER = 5;
    public static final int NON_SPACING_MARK = 6;
    public static final int ENCLOSING_MARK = 7;
    public static final int COMBINING_SPACING_MARK = 8;
    public static final int DECIMAL_DIGIT_NUMBER = 9;
    public static final int LETTER_NUMBER = 10;
    public static final int OTHER_NUMBER = 11;
    public static final int SPACE_SEPARATOR = 12;
    public static final int LINE_SEPARATOR = 13;
    public static final int PARAGRAPH_SEPARATOR = 14;
    public static final int CONTROL = 15;
    public static final int FORMAT = 16;
    public static final int PRIVATE_USE = 18;
    public static final int SURROGATE = 19;
    public static final int DASH_PUNCTUATION = 20;
    public static final int START_PUNCTUATION = 21;
    public static final int END_PUNCTUATION = 22;
    public static final int CONNECTOR_PUNCTUATION = 23;
    public static final int OTHER_PUNCTUATION = 24;
    public static final int MATH_SYMBOL = 25;
    public static final int CURRENCY_SYMBOL = 26;
    public static final int MODIFIER_SYMBOL = 27;
    public static final int OTHER_SYMBOL = 28;
    public static final Class TYPE = Class.getPrimitiveClass("char");
    private char value;

    public Character(char c) {
        this.value = c;
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Character) {
            return this.charValue() == ((Character)object).charValue();
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static boolean isSpace(char c) {
        return Character.isWhitespace(c);
    }

    public static boolean isLetterOrDigit(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean isJavaLetter(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static boolean isJavaLetterOrDigit(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean isTitleCase(char c) {
        return c == '\u01c5' || c == '\u01c8' || c == '\u01cb' || c == '\u01f2';
    }

    public static char toTitleCase(char c) {
        if (c == '\u01c6') {
            return '\u01c6';
        }
        if (c == '\u01c9') {
            return '\u01c8';
        }
        if (c == '\u01cc') {
            return '\u01cb';
        }
        if (c == '\u01f3') {
            return '\u01f2';
        }
        return c;
    }

    public static boolean isIdentiferIgnored(char c) {
        return c >= '\u0000' && c <= '\b' || c >= '\u000e' && c <= '\u001b' || c >= '\u007f' && c <= '\u009f' || c >= '\u200c' && c <= '\u200f' || c >= '\u200a' && c <= '\u200e' || c >= '\u206a' && c <= '\u206f' || c == '\ufeff';
    }

    public static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static char toLowerCase(char c) {
        char c2 = c;
        if (Character.isUpperCase(c)) {
            c2 = (char)(c + 32);
        }
        return c2;
    }

    public static char toUpperCase(char c) {
        char c2 = c;
        if (Character.isLowerCase(c)) {
            c2 = (char)(c - 32);
        }
        return c2;
    }

    public static int digit(char c, int n) {
        if (n < 2 || n > 36) {
            return -1;
        }
        int n2 = n;
        if (Character.isDigit(c)) {
            n2 = c - 48;
        } else if (Character.isLetter(c)) {
            n2 = Character.toLowerCase(c) - 97 + 10;
        }
        if (n2 < n) {
            return n2;
        }
        return -1;
    }

    public static char forDigit(int n, int n2) {
        if (n2 < 2 || n2 > 36) {
            return '\u0000';
        }
        if (n > n2) {
            return '\u0000';
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(97 + (n - 10));
    }

    public static int getNumericValue(char c) {
        return Character.digit(c, 10);
    }

    public static int getType(char c) {
        return 0;
    }

    public static boolean isISOControl(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f';
    }

    public static boolean isJavaIdentifierPart(char c) {
        return Character.isLetter(c) || c == '$' || c == '_' || Character.isDigit(c);
    }

    public static boolean isJavaIdentifierStart(char c) {
        return Character.isLetter(c) || c == '$' || c == '_';
    }

    public static boolean isSpaceChar(char c) {
        return c == '\t' || c == '\n' || c == '\f' || c == '\r' || c == ' ';
    }

    public static boolean isUnicodeIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean isUnicodeIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static boolean isWhitespace(char c) {
        if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == '\u001c' || c == '\u001d' || c == '\u001f') {
            return true;
        }
        return c == ' ';
    }
}

